Vue.component("step-navigation-step", {
    template: "#step-navigation-step-template",

    props: ["step", "currentstep"],

    computed: {
        indicatorclass() {
            return {
                active: this.step.id == this.currentstep,
                complete: this.currentstep > this.step.id
            };
        }
    }
});

Vue.component("step-navigation", {
    template: "#step-navigation-template",

    props: ["steps", "currentstep"]
});

Vue.component("step", {
    template: "#step-template",

    props: ["step", "stepcount", "currentstep"],

    computed: {
        active() {
            return this.step.id == this.currentstep;
        },

        firststep() {
            return this.currentstep == 1;
        },

        laststep() {
            return this.currentstep == this.stepcount;
        },

        stepWrapperClass() {
            return {
                active: this.active
            };
        }
    },
     mounted(){
        this.firstLoading();
    },
    methods: {
        nextStep() {
            var rfc = $("#rfc_agencia").val();
            this.numCaracteres = rfc.length;
            if ((parseInt(this.numCaracteres) === 13 || parseInt(this.numCaracteres) === 12) && $("#razon_social_agencia").val()!='') {
                if (this.currentstep==1) {
                    $(".btn_continuar").css('display', 'none');
                    $(".btnReset").css('display', 'none');
                    $(".btn_anterior").css('display', 'initial');
                    $(".btnFacturacion").css('display', 'initial');
                }else{
                    $(".btn_continuar").css('display', 'initial');
                }
                this.$emit("step-change", this.currentstep + 1);
            }else{
                alert('La estructura del RFC es inválido (Personas Morales: 12 caracteres; Personas Físicas: 13 caracteres) y/o Razón Social es inválido.');
            }
        },

        lastStep() {
            if (this.currentstep==2) {
                $(".btn_anterior").css('display', 'none');
                $(".btnFacturacion").css('display', 'none');
                $(".btn_continuar").css('display', 'initial');
                $(".btnReset").css('display', 'initial');
            }
            this.$emit("step-change", this.currentstep - 1);
        },

        firstLoading() {
            // console.log('aqui');
            $(".btn_anterior").css('display', 'none');

        }
    }
});

new Vue({
    el: "#app",

    data: {
        currentstep: 1,

        numCaracteres: 0,

        steps: [
            {
                id: 1,
                title: "FISCAL",
                icon_class: "far fa-file"
            },
            {
                id: 2,
                title: "FACTURACIÓN",
                icon_class: "far fa-file-alt"
            },
            {
                id: 3,
                title: "DESCARGAR",
                icon_class: "fas fa-download"
            }
        ]
    },

    methods: {
        stepChanged(step) {
            // console.log(this.currentstep-1);
            this.currentstep = step;
        }
    }
});
