//PRODUCCION
if (typeof admin == "undefined") {
    var admin = "";
} else {
    var admin = "?admin=1";
}
var app = new Vue({
    el: '#apppromociones',
    data: {
        array_promociones: [],
        nombre_hotel: '',
        vista: false,
        price_sort: 'lower',
        estrellas_cant: '0',
        NUM_RESULTS: 3, // Numero de resultados por página
        pag: 1, // Página inicial

        categorias: [],
        api_url: rmt_url + "/api/",
        selected_estrellas: [],
        items: ['Item One', 'Item Two', 'Item Three', 'Item Four', 'Item Five', 'Item Six', 'Item Seven', 'Item Eight', 'Item Nine', 'Item Ten', 'Item Eleven', 'Item Twelve', 'Item Thirteen'],
        paginate: ['items'],
        vencidos: 0,
        diasValidos: ['Lunes', 'Martes', 'Miercoles', 'Jueves', 'Viernes', 'Sábado', 'Domingo'],
        date_sort: 'lower',
        busquedaDestinos: '',
        label_destino: '',
        array_promociones_todo: [],
        destinos: []
    },
    created: function () {
    },
    mounted: function () {
        this.loadCategorias();
        this.loadPromociones();
    },
    methods: {
        orderBy: function (sorKey) {
            this.sortKey = sorKey
            this.sortSettings[sorKey] = !this.sortSettings[sorKey]
            this.desc = this.sortSettings[sorKey]
        },
        formatPrice(value) {
            //redondea siempre para arriba
            var redondear = Math.ceil(value);
            let val = (redondear / 1).toFixed(2).replace(',', '.')
            return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        },
        loadPromociones: function () {
            this.$http.get(encodeURI(rmt_url + '/tarifasFlyers/getListaActivados' + admin)).then(function (response) {
                this.array_promociones = response.body;
                this.array_promociones_todo = response.body;
                // $('input').iCheck({
                //     checkboxClass: 'icheckbox_square-grey',
                //     radioClass: 'iradio_square-grey'
                // }).on('ifChecked ifUnchecked', function(){
                //     $(this)[0].dispatchEvent(new Event("change"));
                // });
                // console.log(this.array_promociones);
            }, function () {
                console.log('Error');
            });
        },
        cambiarVistaCuadros() {
            this.vista = true;
        },
        cambiarVistaLista() {
            this.vista = false;
        },
        loadCategorias: function () {
            this.$http.get(this.api_url + 'categorias?limit=5').then(function (response) {
                var response_categorias = response.body;
                this.categorias = response_categorias.data.categorias;
            }, function () {
                console.log('Error');
            });
        },
        validaTipoPromocion: function (item, element) {
            if (element == "url") {
                if (item.conectividad) {
                    return item.url;
                } else {
                    var url = rmt_url + '/site/tarifas.html?filtro_disponibilidad=1&destino=h_' + item.id_hotel + '&fecha_entrada=' + item.fecha_busqueda + '&fecha_salida=' + item.fecha_mas_3_dias + '&habs=1&habitacion_1[adultos]=2&habitacion_1[num_ninios]=0';
                    return url;
                }
            } else if (element == "precio") {
                if (item.conectividad) {
                    return item.precio_normal;
                } else {
                    return this.formatPrice(item.precio_normal);
                }
            }
        },
        validateDay: function (item) {
            if (item.diasValidos) {
                if (item.diasValidos.length < 7)
                    return true;
            }
            return false;
        },
        tooltipDias: function (item) {
            var that = this;
            var tooltipT = "| ";
            $.each(item.diasValidos, function (index, val) {
                tooltipT += that.diasValidos[(val - 1)] + " | ";
            });

            return tooltipT;
        },
        botonOpcion: function (item) {

            if (item.conectividad) {
                Swal.fire({
                    title: '¿Seguro que quieres eliminar?',
                    text: "Los cambios no podran recuperarse.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Eliminar!',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    this.$http.get(encodeURI(rmt_url + '/admin/tarifasFlyers/delete/id/' + item.id_promocion_conectividad)).then(function (response) {
                        if (result.value) {
                            Swal.fire(
                                'Eliminado!',
                                'Promoción eliminada',
                                'success'
                            )
                        }
                        this.loadPromociones();
                    }, function () {
                        if (result.value) {
                            Swal.fire(
                                'Error!',
                                'Elemento no eliminado',
                                'error'
                            )
                        }
                    });

                });


            } else {
                window.open(rmt_url + '/admin/tarifa/tarifashotel/id/' + item.id_hotel + "?tarifa=" + item.id_tarifa, '_blank');

            }
        },
        loadSearch: function (destino) {
            this.busquedaDestinos = '';
            if (destino != 'All') {
                switch (destino) {
                    case "CUN":
                        this.label_destino = "CANCÚN";
                        break;
                    case "HUA":
                        this.label_destino = "HUATULCO";
                        break;
                    case "PCM":
                        this.label_destino = "RIVIERA MAYA";
                        break;
                    case "PVR":
                        this.label_destino = "PUERTO VALLARTA";
                        break;
                    default:
                        break;
                }
                this.array_promociones = this.filtros(destino)
                console.log(this.destinos);
            } else {
                this.label_destino = "TODOS";
                this.array_promociones = this.array_promociones_todo;
            }

        },
        filtros: function (code) {
            var self = this;
            return this.array_promociones_todo.filter(function (promo) {
                return promo.destino.code.toLowerCase().includes(code.toLowerCase());
            });
        },
    },
    computed: {
        //icon_search
        buscar_promociones: function () {
            var self = this;
            if (admin == "") {

                if (this.price_sort == "lower") {
                    this.array_promociones.sort(function (a, b) {
                        return parseFloat(a.precio_normal) > parseFloat(b.precio_normal) ? 1 : parseFloat(a.precio_normal) < parseFloat(b.precio_normal) ? -1 : 0;
                    })
                } else {
                    this.array_promociones.sort(function (a, b) {
                        return parseFloat(a.precio_normal) > parseFloat(b.precio_normal) ? -1 : parseFloat(a.precio_normal) < parseFloat(b.precio_normal) ? 1 : 0;
                    })
                }
            }
            if (this.date_sort = "lower") {
                this.array_promociones.sort(function (a, b) {

                    return (new Date(a.fecha_promo_inicio) > new Date(b.fecha_promo_inicio) ? -1 : new Date(a.fecha_promo_inicio) > new Date(b.fecha_promo_inicio) ? 1 : 0);
                });
            } else {
                this.array_promociones.sort(function (a, b) {
                    return (new Date(a.fecha_promo_inicio) > new Date(b.fecha_promo_inicio) ? 1 : new Date(a.fecha_promo_inicio) > new Date(b.fecha_promo_inicio) ? -1 : 0);
                });
            }



            return this.array_promociones.filter(function (tarifa) {
                self.pag = 1;


                if (self.selected_estrellas.length > 0) {
                    return self.selected_estrellas.includes(parseInt(tarifa.estrellas_hotel)) && tarifa.nombre_hotel.toLowerCase().includes(self.nombre_hotel.toLowerCase());
                } else {
                    return tarifa.nombre_hotel.toLowerCase().includes(self.nombre_hotel.toLowerCase());

                }


                /*if(self.estrellas_cant > 0){
                    this.pag = 1;
                    return tarifa.estrellas_hotel.toLowerCase().includes(self.estrellas_cant.toLowerCase()) &&
                    tarifa.nombre_hotel.toLowerCase().includes(self.nombre_hotel.toLowerCase())
                    ;
                } else {
                    this.pag = 1;
                    return tarifa.nombre_hotel.toLowerCase().includes(self.nombre_hotel.toLowerCase());
                }*/

            }).filter(function (date) {
                if (admin != "") {

                    if (self.vencidos == 0) {
                        console.log(typeof self.vencidos);
                        return new Date(date.fecha_promo) > new Date();
                    } else {
                        return true;
                    }
                } else {
                    return true;
                }
            });

        },
    }
})