var app = new Vue({
    el: '#vueprecomprada',
    data: {
        rmt_url: rmt_url,
        sur4_url: "https://www.rutamayatravel.com/sur4",
        datosPrecomprada: [],
        array_cadenas: [],
        loading: true,

        //Variables para filtros
        nombre_hotel: '',
        id_cadena: 0,
        price_sort:'default',
        //filtro estancia
        model_rango_estancia: moment().format("DD/MM/YYYY") +  " - " + moment().add(3, "days").format("DD/MM/YYYY"),
        rango_estancia: {
            entrada: moment().format("DD/MM/YYYY"),
            salida: moment().add(3, "days").format("DD/MM/YYYY")
        },
        estancia_changed: false,
        moment_start: "",
        moment_end: "",
        moment_test: "",
        //filtro precio
        started_range: false,
        my_range: {},
        rango_precio: {
            min: 0,
            max: 0
        },
        min_range: 0,
        max_range: 100,

        //Variables para infinite scroll
        show   : false, // display content after API request
        offset : 5,     // items to display after scroll
        display: 5,     // initial items
        trigger: 355,   // how far from the bottom to trigger infinite scroll
        items  : [],    // server response data
        end    : false, // no more resources

        NUM_RESULTS: 4,
        pag: 1,
        cant_datos: '',
    },
    created: function () {
    },
    mounted: function () {
        this.loadPrecompradas();

        $("#range").ionRangeSlider({
            hide_min_max: true,
            keyboard: true,
            type: "double",
            step: 1,
            prefix: "$ ",
            min: 0,
            max: 0,
            from: 0,
            to: 0,
            //postfix: " MXN",
            grid: true,
        });

        this.my_range = $("#range").data("ionRangeSlider");

        this.scroll();
    },
    methods: {
        getHotelsChains: function() {
            var that = this;
            this.datosPrecomprada.forEach(function(element){
                var filter = that.array_cadenas.filter(cadena => {
                    return cadena.id_cadena == element.id_cadena_hotel;
                });

                if(filter.length == 0) {
                    that.array_cadenas.push({
                        id_cadena: element.id_cadena_hotel,
                        nombre: element.cadena_hotel
                    })
                }
            });
        },
        loadPrecompradas: function () {
            this.$http.get(encodeURI(rmt_url + '/paquetesBoda/getPrecompraList')).then(function (response) {
                this.datosPrecomprada = response.body;
                this.cant_datos = this.datosPrecomprada.length;
                this.initRangePrice();
                this.getHotelsChains();
                Vue.nextTick(function () {
                   $.getScript("https://www.rutamayatravel.com/sur4/template/ansonika/assets/js/jquery.sliderPro.min.js", function (script, textStatus, jqXHR) {
                       
                   });
                   $('#Img_carousel').sliderPro({
                    width: 960,
                    height: 500,
                    fade: true,
                    arrows: true,
                    buttons: false,
                    fullScreen: false,
                    smallSize: 500,
                    startSlide: 0,
                    mediumSize: 1000,
                    largeSize: 3000,
                    thumbnailArrows: true,
                    autoplay: false
                    });
                });                
            }, function () {
                console.log('Error');
            });
        },
        scroll() {
            // this.trigger = 300;
            var capa = document.getElementById('packs_weddings');
            window.onscroll = ev => {
                /*console.log(document.documentElement.scrollTop + window.innerHeight);
                console.log(document.documentElement.offsetHeight - this.trigger);*/
                bottomOfWindow = (document.documentElement.scrollTop + window.innerHeight) >= (document.documentElement.offsetHeight - this.trigger);
                //console.log(bottomOfWindow)
                //if ($('#packs_weddings').innerHeight() + $('#packs_weddings').scrollTop() >= ($('#items')[0].offsetHeight - this.trigger)) {
                if (bottomOfWindow) {
                    if (this.display < this.datosPrecomprada.length) {
                        this.display = this.display + this.offset;
                    } else {
                        this.end = true;
                    }
                }
            };
        },
        initRangePrice: function() {
            if(this.started_range == false) {
                this.started_range = true;
                var last = this.datosPrecomprada.length;
                // console.log(last);
                var min_range = 0; var max_range = 0;
                min_range = parseFloat(this.datosPrecomprada[0].precio_doble);
                max_range = parseFloat(this.datosPrecomprada[last - 1].precio_doble);

                // min_range = Math.round(min_range);
                min_range = Math.floor(min_range);
                max_range = Math.ceil(max_range);
                var that = this;
                this.rango_precio = {};
                this.rango_precio = {
                    min: min_range,
                    max: max_range
                }

                this.min_range = this.rango_precio.min;
                this.max_range = this.rango_precio.max;

                that.my_range.update({
                    min: min_range,
                    max: max_range,
                    from: min_range,
                    to: max_range,
                }); 
            }
        },
        formatPrice(value) {
            var redondear = Math.ceil(value);
            let val = (redondear / 1).toFixed(2).replace(',', '.')
            return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        },
    },
    computed: {
        //icon_search
        buscar_bloqueo: function () {
            this.pag = 1;
            var self = this;
            if (this.price_sort == "lower") {
                this.datosPrecomprada.sort(function (a, b) {
                    return parseFloat(a.precio_doble) > parseFloat(b.precio_doble) ? 1 : parseFloat(a.precio_doble) < parseFloat(b.precio_doble) ? -1 : 0;
                })
            } else {
                this.datosPrecomprada.sort(function (a, b) {
                    return parseFloat(a.precio_doble) > parseFloat(b.precio_doble) ? -1 : parseFloat(a.precio_doble) < parseFloat(b.precio_doble) ? 1 : 0;
                })
            }

            return this.datosPrecomprada.filter(function (tarifa) {
                return tarifa;
            }).filter(cadena => {
                if(this.id_cadena != 0) {
                    return cadena.id_cadena_hotel == this.id_cadena;
                } else {
                    return cadena;
                }
            }).filter(estancia => {
                if(self.estancia_changed) {
                    parseStartDate = ((self.rango_estancia.entrada.split("/")).reverse()).join();
                    self.moment_start = moment(parseStartDate);
                    
                    parseEndDate = ((self.rango_estancia.salida.split("/")).reverse()).join();
                    self.moment_end = moment(parseEndDate);

                    var between = false;
                    var days = self.moment_end.diff(self.moment_start, 'days');
                    for(var i = 0; i <= days; i++) {
                        self.moment_test = self.moment_start.add(i, 'days');
                        //console.log(self.moment_test.format("DD/MM/YYYY"));
                        between = self.moment_test.isSameOrAfter(estancia.fecha_inicio) && self.moment_test.isSameOrBefore(estancia.fecha_final);
                        if (between) { break; }
                    }

                    if(between) {
                        return estancia;
                    }
                } else {
                    return estancia;
                }
            }).filter(precio => {
                var parse_precio = parseFloat(precio.precio_doble);
                if(parse_precio >= this.rango_precio.min && parse_precio <= this.rango_precio.max) {
                    return precio;
                }
            }).slice(0, this.display);
        },
    }
})

$('#range').on("change", function () {
    var $inp = $(this);
    app.rango_precio = {
        min: $inp.data("from"),
        max: $inp.data("to")
    }
 });

var dp_filtro = document.getElementById('dp_estancia_filtro'); //$(".dp_estancia")[0];
var settings_dp = {
    format: 'DD/MM/YYYY',
    startOfWeek: 'sunday',
    i18n: {
        night: 'Noche',
        nights: 'Noches',
        button: 'Cerrar',
        'day-names-short': ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab'],
        'day-names': ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        'month-names-short': ['Ene', 'Feb', 'Mar', 'Abr', 'Mar', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        'month-names': ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        'info-more': 'Por favor seleccione la fecha de estancia'
    },
    moveBothMonths: true,
    onSelectRange: function() {
        app.model_rango_estancia = $("#dp_estancia_filtro").val();
        var rango = app.model_rango_estancia.split(" - ");
        app.rango_estancia.entrada = rango[0];
        app.rango_estancia.salida = rango[1];
        app.estancia_changed = true;
    }
};
var datepicker_web = new HotelDatepicker(dp_filtro, settings_dp);
//var datepicker_mobile = new HotelDatepicker(dp_mobile, settings_dp);

/*dp_filtro.addEventListener('afterClose', function () {
    app.model_rango_estancia = $("#dp_estancia_filtro").val();
    var rango = app.model_rango_estancia.split(" - ");
    app.rango_estancia.entrada = rango[0];
    app.rango_estancia.salida = rango[1];
    app.estancia_changed = true;
}, false);*/