var app = new Vue({
    el: '#vueprecomprada',
    data: {
        rmt_url: rmt_url,
        datosPrecomprada: [],
        cant_datos: '',
        id_bloqueo: id_bloqueo
    },
    created: function() {

    },
    mounted: function() {
        this.loadPrecomprada();
    },
    methods: {
        formatPrice(value) {
            var redondear = Math.ceil(value);
            let val = (redondear / 1).toFixed(2).replace(',', '.')
            return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        },
        loadPrecomprada: function() {

            this.$http.get(encodeURI(rmt_url + '/paquetesBoda/getPrecompra/' + this.id_bloqueo)).then(function(response) {
                this.datosPrecomprada = response.body;
                this.cant_datos = this.datosPrecomprada.length;
                // console.log(this.datosPrecomprada);
                Vue.nextTick(function() {
                    $('#my-slider').sliderPro({
                        width: 960,
                        height: 500,
                        arrows: true,
                        buttons: false,
                        touchSwipe: false,
                        waitForLayers: true,
                        thumbnailWidth: 100,
                        thumbnailHeight: 100,
                        thumbnailPointer: true,
                        autoplay: false,
                        autoScaleLayers: false,
                        breakpoints: {
                            500: {
                                thumbnailWidth: 120,
                                thumbnailHeight: 50
                            }
                        }
                    });
                });
            }, function() {
                console.log('Error');

            });

        },
        requestRoomWedding: function() {
            Swal.fire({
                title: "Comentarios para la solicitud",
                input: "textarea",
                inputAttributes: {
                    autocapitalize: 'off'
                },
                showCancelButton: true,
                confirmButtonText: "Aceptar",
                cancelButtonText: "Cancelar",
            }).then((result) => {
                if (typeof result.value != "undefined") {
                    this.sendRequest(result.value);
                    Swal.fire({
                        title: "Espere un momento, por favor",
                        onBeforeOpen: () => {
                            Swal.showLoading()
                        }
                    });
                }
                /* if (result.value) {
                    Swal.fire({
                        title: "Espere un momento, por favor",
                        onBeforeOpen: () => {
                            Swal.showLoading()
                        }
                    }); 
                } */
            });
        },
        sendRequest: function(comentarios) {
            fd = new FormData();
            fd.append("id_paquete", this.datosPrecomprada.info_bloqueo.id_paquete);
            fd.append("nom_hotel", this.datosPrecomprada.info_adicional.nombre_hotel);
            fd.append("emai_agencia", JSON.parse(localStorage.info_agencia).email_agencia);
            fd.append("tel_agencia", JSON.parse(localStorage.info_agencia).tel_agencia);
            fd.append("mensaje_soli", comentarios);

            this.$http.post(rmt_url + "/paquetesBoda/solicitar/", fd).then(function(response) {
                Swal.hideLoading();
                if (response.body.estatus == 1) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Correcto',
                        text: 'La solicitud ha sido enviada, en breve nuestro personal se pondrá en contacto contigo.',
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: '¡Oops!',
                        text: 'Algo salió mal, intente recargar la página e intente de nuevo, si el problema persiste, contactese con soporte.',
                    });
                }
                console.log(response.body);
            }, function(ex) {
                Swal.hideLoading();
                Swal.fire({
                    icon: 'error',
                    title: '¡¡Ops!!',
                    text: 'Algo salió mal, intente recargar la página e intente de nuevo, si el problema persiste, contactese con soporte.',
                });
                console.log(ex);
            });
        }
    }

})