var app = new Vue({
    el: '#vuebloqueo',
    data: {
  
         datosBloqueos: [],
         nombre_hotel: '',
         vista: false,
        price_sort: 'lower',
        estrellas_cant: 0,
        ordenFecha: 'newest',
        NUM_RESULTS: 4,
        pag: 1,
        loaded: false,

    },
    created: function () {
        
    },
    mounted: function () {
    
        this.loadBloqueos();
    },
    methods: {

       formatPrice(value) {
            //redondea siempre para arriba
            var redondear = Math.ceil(value);
            let val = (redondear / 1).toFixed(2).replace(',', '.')
            return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
       },     
       loadBloqueos: function () {
            this.$http.get(encodeURI(rmt_url+'/bloqueos/getLista')).then(function (response) {
                this.datosBloqueos = response.data.item;
                // console.log(this.datosBloqueos);
                this.loaded = true;
                $.getScript(rmt_url+"/template/homey/js/listing-carousel.js?ver=1.1.0", function(data){});
                  
            }, function () {
                console.log('Error');
            });
       },
       cambiarVistaCuadros() {
   
        this.vista = true;
      
       },
       cambiarVistaLista() {
    
         this.vista = false;
       
       },
    
  },
  computed: {
    //icon_search
        buscar_bloqueo: function () {
            this.pag = 1;
            var self = this;
            if(this.price_sort == "lower") {
                this.datosBloqueos.sort(function(a,b) {
                    return parseFloat(a.precio_doble) > parseFloat(b.precio_doble) ? 1 : parseFloat(a.precio_doble) < parseFloat(b.precio_doble) ? -1 : 0;
                })
            } else {
                this.datosBloqueos.sort(function(a,b) {
                    
                    return parseFloat(a.precio_doble) > parseFloat(b.precio_doble) ? -1 : parseFloat(a.precio_doble) < parseFloat(b.precio_doble) ? 1 : 0;
                })
            }

            return this.datosBloqueos.filter(function (tarifa) {
                this.pag = 1;
                if(self.estrellas_cant > 0){
                   
                    return tarifa.Estrellas.toLowerCase().includes(self.estrellas_cant.toLowerCase())  &&
                     tarifa.hotel_nombre.toLowerCase().includes(self.nombre_hotel.toLowerCase()) ;
                }
                else{
                    
                    return tarifa.hotel_nombre.toLowerCase().includes(self.nombre_hotel.toLowerCase());
                }
                
            });
    
        },
       
    }
    
})
