Vue.component('v-multiselect', window.VueMultiselect.default);
Vue.http.options.emulateJSON = true;

var appTours = new Vue({
	el: '#tours_vue',
	data: {
		//variables url
		rmt_url: rmt_url,
		api_url: rmt_url + '/api/',
		url_tours: '',

		//variables loading
		loading: true,
		loading_fotos: false,
		show: false,

		//variables arreglos
		array_params: JSON.parse(array_params),
		cotiz_params: JSON.parse(array_params),
		array_tours: [],
		fotos_tour: [],
		options_tours: [],
		categorias_tours: [],
		toursCerrados:['55'],
		fechasCerradas:['05/10/2020'],

		//variables mapa
		map_data: {},

		//variables select cotizador
		model_destino: '',
		model_code_destino: '',
		isLoading: false,

		//submit form
		model_tour: "",
		model_index: 0,
		model_rooming: "",

		//variables generales
		id_tour_mapa: 0,
		min_date: moment().format("DD/MM/YYYY"),
		fecha_tour: "",
		options_edad_menores: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17],

		//filter
		search: '',
		tipo_filter: 'all',

		//xcaret descuento
		porc_descuento: 0,
		es_descuento: false,
		tipo_categoria: 0,
		//solicitarCotizacion
		model_agencia_usuario: '',
		model_id_usuario: '',
		params_menores: [],
		params_cotizacion: {
			edades: []
		}
	},
	created: function () {
		this.loadTours();
		this.loadDestinations();
		this.loadInfoCotiz();
	},
	methods: {
		loadTours: function () {
			this.url_tours = rmt_url + '/tour/tarifas?destino=' + this.array_params.destino;
			this.url_tours += '&fecha_entrada=' + this.array_params.fecha_entrada;
			this.url_tours += '&num_adultos=' + this.array_params.num_adultos;
			this.url_tours += '&num_ninios=' + this.array_params.num_ninios;
			if (this.array_params.num_ninios > 0) {
				this.params_cotizacion.edades = Object.values(this.array_params.num_edad);
			}
			// console.log(this.params_cotizacion.edades);
			if (this.array_params.num_ninios > 0) {
				var that = this;
				for (var i = 1; i <= parseInt(this.array_params.num_ninios); i++) {
					that.url_tours += '&num_edad[edad_' + i + ']=' + that.array_params.num_edad["edad_" + i];
				}
			}
			this.$http.get(encodeURI(this.url_tours)).then(function (response) {
				var response_tours = response.body;

				this.array_tours = Object.values(response_tours);
				this.loading = false;
				// console.log(this.array_tours);
				var that = this;
				this.array_tours.forEach(function (element, index) {
					that.fotos_tour.push(index);
	            	/*var array_ubicacion = element.map_markers.split(",");
                	that.mapas_tour.push({ lat: parseFloat(array_ubicacion[0]), long: parseFloat(array_ubicacion[1]) });*/
					if (element.idTipoCategoria != 2 || element.idTipoCategoria != 7) {
						element.tarifas.sort(this.orderTarifas);
					}

					var array_ubicacion = element.map_markers.split(",");
					if (typeof that.map_data[element.tipo] == "undefined") {
						that.map_data[element.tipo] = [];
						that.map_data[element.tipo].push({
							name: element.nombre,
							location_latitude: array_ubicacion[0],
							location_longitude: array_ubicacion[1],
							map_image_url: "https://www.rutamayatravel.com/imagenes/tours/" + element.imagen,
							name_point: element.nombre,
							description_point: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.',
							get_directions_start_address: '',
							phone: '+3934245255',
							url_point: 'single_hotel.html'
						});
					} else {
						that.map_data[element.tipo].push({
							name: element.nombre,
							location_latitude: array_ubicacion[0],
							location_longitude: array_ubicacion[1],
							map_image_url: "https://www.rutamayatravel.com/imagenes/tours/" + element.imagen,
							name_point: element.nombre,
							description_point: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.',
							get_directions_start_address: '',
							phone: '+3934245255',
							url_point: 'single_hotel.html'
						});
					}
				});

				this.array_tours.sort(function (a, b) {
					var that = this;
					var total_a = 0; var total_b = 0;

					a.tarifas[0].desglose.forEach(function (element) {
						if (element.Tipo == "Adulto") {
							total_a += that.array_params.num_adultos * (element.precio * a.tasa_cambio);
						} else {
							total_a += that.array_params.num_ninios * (element.precio * a.tasa_cambio);
						}
					});

					b.tarifas[0].desglose.forEach(function (element) {
						if (element.Tipo == "Adulto") {
							total_b += that.array_params.num_adultos * (element.precio * a.tasa_cambio);
						} else {
							total_b += that.array_params.num_ninios * (element.precio * a.tasa_cambio);
						}
					});

					if (total_a > total_b) {
						return -1;
					}

					if (total_a < total_b) {
						return 1;
					}
					return 0;
				});
				if (this.array_tours.length > 0) {
					this.tipo_categoria = parseInt(this.array_tours[0].idTipoCategoria);
				}
				this.show = true;

				setTimeout(function () {
					$('input').iCheck({
						checkboxClass: 'icheckbox_square-grey',
						radioClass: 'iradio_square-grey'
					}).on('ifChecked ifUnchecked', function () {
						$(this)[0].dispatchEvent(new Event("change"));
					});
				}, 1000);

			}, function () {
				console.log('Error');
			});
		},
		loadTourFotos: function (id_tour, index) {
			if (typeof this.fotos_tour[index].length == "undefined") {
				this.loading_fotos = true;
				var url_hotel_fotos = this.api_url + 'tourFotosRest?filter=[{"property":"id_tour","value":' + id_tour + ',"operator":=}]';
				this.$http.get(encodeURI(url_hotel_fotos)).then(function (response) {
					this.fotos_tour[index] = response.body.data.tourFotosRest;
					this.loading_fotos = false;
				}, function () {
					console.log('Error');
				});
			}
		},
		loadMapaTour: function (id_tour) {
			if (this.id_tour_mapa != id_tour) {
				this.id_tour = id_tour;
				var info_ubicacion = this.array_tours.filter(function (i) {
					return i.id_tour === id_tour;
				});
				var array_ubicacion = info_ubicacion[0].map_markers.split(",");
				var uluru = { lat: parseFloat(array_ubicacion[0]), lng: parseFloat(array_ubicacion[1]) };
				var map = new google.maps.Map(
					document.getElementById('map_' + id_tour), {
					zoom: 13,
					center: uluru
				});
				this.marker = new google.maps.Marker({ position: uluru, map: map, draggable: false, animation: google.maps.Animation.DROP });
			}
		},
		enviarCotizacion: function () {
			console.log(this.params_cotizacion);
			console.log(this.params_array);
		},
		loadInfoCotiz: function () {
			if (typeof this.cotiz_params.num_edad != "undefined") {
				var that = this;
				var cont = 1;
				this.cotiz_params.edad_menores = [];
				Object.values(this.array_params.num_edad).forEach(function (element) {
					that.cotiz_params.edad_menores.push({ no_menor: cont, edad: parseInt(element) });
					cont++;
				});
			} else {
				this.cotiz_params.edad_menores = [];
			}

			this.fecha_tour = this.cotiz_params.fecha_entrada;

			this.model_destino = JSON.parse(localStorage.getItem("selected_option_tour"));
			this.model_code_destino = this.model_destino.code;
			switch (this.model_destino.tipo) {
				case "tour":
					this.model_code_destino = "t_" + this.model_destino.codigo;
					break;

				case "tipo":
					this.model_code_destino = "c_" + this.model_destino.codigo;
					break;
			}
		},
		editPax: function (pax, op) {
			if (pax == "adulto") {
				if (op == "add") {
					this.cotiz_params.num_adultos++;
				} else {
					this.cotiz_params.num_adultos--;
				}
			} else {
				if (op == "add") {
					this.cotiz_params.num_ninios++;
					this.cotiz_params.edad_menores.push({
						no_menor: this.cotiz_params.num_ninios,
						edad: 0,
					});
				} else {
					this.cotiz_params.num_ninios--;
					this.cotiz_params.edad_menores.pop();
				}
			}
		},
		loadDestinations: function () {
			var that = this;
			this.options_tours.push({
				tipo_destino: "Tours",
				opciones: [],
			});

			this.options_tours.push({
				tipo_destino: "Categoría",
				opciones: [],
			});
			this.$http.get(rmt_url + '/busqueda/busquedaDestinosTours').then(function (response) {
				var response_tours = response.body;
				response_tours.forEach(function (element) {
					switch (element.tipo) {
						case "tour":
							that.options_tours[0].opciones.push(element);
							break;

						case "tipo":
							that.options_tours[1].opciones.push(element);
							that.categorias_tours.push(element);
							break;
					}
				});
			}, function () {
				console.log('Error');
			});
		},
		addItemCarrito: function (tour, desglose) {
			var arreglo = {
				item: tour,
				desglose: desglose,
				tipo: "tour"
			};

			this.$http.post(this.rmt_url + "/carrito/addCarrito", { info: JSON.stringify(arreglo) }).then(function (response) {
				appCarritoHeader.array_carrito = response.body;
				const Toast = Swal.mixin({
					toast: true,
					position: 'bottom-end',
					showConfirmButton: false,
					timer: 2000
				});

				Toast.fire({
					type: 'success',
					title: 'Se ha agregado al carrito'
				});
			}, function () {
				console.log('Error');
			});
		},
		submitForm: function (index_tour, index_tarifa) {
			console.log(index_tour + " - " + index_tarifa);
			this.model_tour = JSON.stringify(this.array_tours[index_tour]);
			this.model_index = index_tarifa;
			this.model_rooming = JSON.stringify(this.array_params);
			//$("#form_booking").submit();
		},
		setDestino: function (selectedOption, id) {
			var destino;
			switch (selectedOption.tipo) {
				case "tour":
					this.model_code_destino = "t_" + selectedOption.codigo;
					break;

				case "tipo":
					this.model_code_destino = "c_" + selectedOption.codigo;
					break;
			}

			localStorage.setItem("options_tours", JSON.stringify(this.options_tours));
			localStorage.setItem("selected_option_tour", JSON.stringify(selectedOption));
		},
		setFechaEntrada: function () {
			this.min_date = $("#bookingdate").val();
		},
		changeTipoTour: function (tipo) {
			this.array_params.destino = "c_" + tipo;
			this.loadTours();
		},
		countToursByType: function (tipo) {
			var count = this.array_tours.filter(tour => {
				return tour.tipo.toLowerCase().includes(tipo.toLowerCase());
			});
			return count.length;
		},
		test_method: function () {
			console.log("test");
		},
		printMenorTarifa: function (tarifas, discount) {
			if (discount == true) {
				return this.printTotalReserva(tarifas[0], false, true);
			} else {
				return this.printTotalReserva(tarifas[0]);
			}
		},
		printMonedaMenorTarifa: function (tarifas) {
			var moneda = tarifas.moneda
			if (tarifas.moneda == "USD" && parseInt(tarifas.tasa_cambio) > 1) {
				moneda = "MXN";
			}
			return moneda;
		},
		orderTarifas: function (a, b) {
			var that = this;
			var total_a = 0; var total_b = 0;
			a.desglose.forEach(function (element) {
				if (element.Tipo == "Adulto") {
					total_a += that.array_params.num_adultos * (element.precio * a.tasa_cambio);
				} else {
					total_a += that.array_params.num_ninios * (element.precio * a.tasa_cambio);
				}
			});

			b.desglose.forEach(function (element) {
				if (element.Tipo == "Adulto") {
					total_a += that.array_params.num_adultos * (element.precio * b.tasa_cambio);
				} else {
					total_a += that.array_params.num_ninios * (element.precio * b.tasa_cambio);
				}
			});

			if (total_a > total_b) {
				return -1;
			}

			if (total_a < total_b) {
				return 1;
			}
			return 0;
		},
		printTotalReserva: function (item, form = false, discount = false) {
			var adults_price, children_price;
			var item_array = Object.values(item);
			var adults_price = item.desglose.filter(function (i) {
				return i.tipo === "Adulto";
			});
			var adult_price = adults_price[0];

			var total = (adult_price.precio * item.tasa_cambio) * this.array_params.num_adultos;

			if (this.array_params.num_ninios > 0) {
				var that = this;
				var array_menores = Object.values(this.array_params.num_edad);
				var children_price = item.desglose.filter(function (i) {
					return i.tipo === "Menor";
				});
				if (children_price.length > 0) {
					children_price.forEach(function (element, index) {
						array_menores.forEach(function (element_edad, index_edad) {
							if (element_edad >= parseInt(element.edad_min) && element_edad <= parseInt(element.edad_max)) {
								total += (element.precio * item.tasa_cambio);
							} else if (element_edad > parseInt(element.edad_max)) {
								total += (adult_price.precio * item.tasa_cambio);
							}
						});
					});
				} else {
					array_menores.forEach(function (element) {
						if (element >= parseInt(adult_price.edad_min) && element <= parseInt(adult_price.edad_max)) {
							total += (adult_price.precio * item.tasa_cambio);
						}
					});
				}
			}

			var total_discount = total * this.porc_descuento;
			var total_net = total - total_discount;
			if (form == true) {
				if (discount == true) {
					return total_net;
				} else {
					return total;
				}
			} else {
				if (discount == true) {
					return this.round(total_net, 2);
				} else {
					return this.round(total, 2);
				}
			}
		},
		printTotalPasajero: function (item, index, discount = false) {
			var total = item.desglose[index].precio * item.tasa_cambio;
			if (discount == false) {
				return this.round(total, 2);
			} else {
				var total_discount = total * this.porc_descuento;
				var total_net = total - total_discount;
				return this.round(total_net, 2);
			}
		},
		addDiscount: function () {
			if (this.es_descuento == false) {
				this.porc_descuento = 0.10;
				this.es_descuento = true;
			} else {
				this.porc_descuento = 0;
				this.es_descuento = false;
			}
		},
		round: function (value, decimals) {
			return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
		},
		setadults: function () {
			element = event.currentTarget;
			op = element.getAttribute('data-op');
			pax = element.getAttribute('data-pax');
			if (pax == "adulto") {
				if (op == "add") {
					if (this.array_params.num_adultos < 13) {
						this.array_params.num_adultos++;
					}
				} else {
					if (this.array_params.num_adultos > 1) {
						this.array_params.num_adultos--;
					}
				}
			} else {
				this.setMenor(op);
			}
		},
		setMenor: function (op) {
			element = event.currentTarget;
			var edad_menores = [];
			if (op == "add") {
				if (this.array_params.num_ninios < 10) {
					this.array_params.num_ninios++;
					this.params_cotizacion.edades.push(0);
				}
			} else {
				if (this.array_params.num_ninios > 0) {
					this.array_params.num_ninios--;
					this.params_cotizacion.edades.pop();
				}
			}
		},
		abrirAlerta: function (tipo, tarifa) {
			
			if(tipo == "Descripción"){
				Swal.fire({
					title: tipo,
					
					html: tarifa.descripcion,
					showCloseButton: true,
					showCancelButton: false,
					// cancelButtonColor: '#d33',
					showConfirmButton: false,
				
				})
			}else if("Restricciones"){
				Swal.fire({
					title: tipo,
					
					html: tarifa.restricciones,
					showCloseButton: true,
					showCancelButton: false,
					// cancelButtonColor: '#d33',
					showConfirmButton: false,
				
				})
			}
			
		}
	},
	computed: {
		filteredTours() {
			return this.array_tours.filter(tour => {
				return tour.nombre.toLowerCase().includes(this.search.toLowerCase());
			});
		}
	}
});

$('body').on('change', '#bookingdate', function () {
	appTours.min_date = $("#bookingdate").val();
});

$('#collapseMap').on('shown.bs.collapse', function (e) {
	(function (A) {
		if (!Array.prototype.forEach)
			A.forEach = A.forEach || function (action, that) {
				for (var i = 0, l = this.length; i < l; i++)
					if (i in this)
						action.call(that, this[i], i, this);
			};
	})(Array.prototype);

	var
		mapObject,
		markers = [],
		markersData = appTours.map_data;
	var latlngbounds = new google.maps.LatLngBounds();

	var mapOptions = {
		zoom: 5,
		center: new google.maps.LatLng(23.625269, -99.9478396),
		mapTypeId: google.maps.MapTypeId.ROADMAP,

		mapTypeControl: false,
		mapTypeControlOptions: {
			style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
			position: google.maps.ControlPosition.LEFT_CENTER
		},
		panControl: false,
		panControlOptions: {
			position: google.maps.ControlPosition.TOP_RIGHT
		},
		zoomControl: true,
		zoomControlOptions: {
			style: google.maps.ZoomControlStyle.LARGE,
			position: google.maps.ControlPosition.TOP_LEFT
		},
		scrollwheel: false,
		scaleControl: false,
		scaleControlOptions: {
			position: google.maps.ControlPosition.TOP_LEFT
		},
		streetViewControl: true,
		streetViewControlOptions: {
			position: google.maps.ControlPosition.LEFT_TOP
		},
		styles: [
			{
				"featureType": "administrative.country",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "administrative.province",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "administrative.locality",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "administrative.neighborhood",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "administrative.land_parcel",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "landscape.man_made",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "simplified"
					}
				]
			},
			{
				"featureType": "landscape.natural.landcover",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "on"
					}
				]
			},
			{
				"featureType": "landscape.natural.terrain",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "poi.attraction",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "poi.business",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "poi.government",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "poi.medical",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "poi.park",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "on"
					}
				]
			},
			{
				"featureType": "poi.park",
				"elementType": "labels",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "poi.place_of_worship",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "poi.school",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "poi.sports_complex",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "road.highway",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "road.highway",
				"elementType": "labels",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "road.highway.controlled_access",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "road.arterial",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "simplified"
					}
				]
			},
			{
				"featureType": "road.local",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "simplified"
					}
				]
			},
			{
				"featureType": "transit.line",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "transit.station.airport",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "transit.station.bus",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "transit.station.rail",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			},
			{
				"featureType": "water",
				"elementType": "all",
				"stylers": [
					{
						"visibility": "on"
					}
				]
			},
			{
				"featureType": "water",
				"elementType": "labels",
				"stylers": [
					{
						"visibility": "off"
					}
				]
			}
		]
	};
	var
		marker;
	mapObject = new google.maps.Map(document.getElementById('map'), mapOptions);
	for (var key in markersData)
		markersData[key].forEach(function (item) {
			marker = new google.maps.Marker({
				position: new google.maps.LatLng(item.location_latitude, item.location_longitude),
				map: mapObject,
				//icon: 'img/pins/' + key + '.png',
			});
			latlngbounds.extend(marker.position);

			if ('undefined' === typeof markers[key])
				markers[key] = [];
			markers[key].push(marker);
			google.maps.event.addListener(marker, 'click', (function () {
				closeInfoBox();
				getInfoBox(item).open(mapObject, this);
				mapObject.setCenter(new google.maps.LatLng(item.location_latitude, item.location_longitude));
			}));
		});

	function hideAllMarkers() {
		for (var key in markers)
			markers[key].forEach(function (marker) {
				marker.setMap(null);
			});
	};

	function closeInfoBox() {
		$('div.infoBox').remove();
	};

	function getInfoBox(item) {
		return new InfoBox({
			content:
				'<div class="marker_info" id="marker_info">' +
				'<img style="width: 280px; height: 140px;" src="' + item.map_image_url + '" alt="Image"/>' +
				'<h3>' + item.name_point + '</h3>' +
				'<span>' + item.description_point + '</span>' +
				'<div class="marker_tools">' +
				'<form action="http://maps.google.com/maps" method="get" target="_blank" style="display:inline-block""><input name="saddr" value="' + item.get_directions_start_address + '" type="hidden"><input type="hidden" name="daddr" value="' + item.location_latitude + ',' + item.location_longitude + '"><button type="submit" value="Get directions" class="btn_infobox_get_directions">Directions</button></form>' +
				'<a href="tel://' + item.phone + '" class="btn_infobox_phone">' + item.phone + '</a>' +
				'</div>' +
				'<a href="' + item.url_point + '" class="btn_infobox">Detalles</a>' +
				'</div>',
			disableAutoPan: false,
			maxWidth: 0,
			pixelOffset: new google.maps.Size(10, 125),
			closeBoxMargin: '5px -20px 2px 2px',
			closeBoxURL: "http://www.google.com/intl/en_us/mapfiles/close.gif",
			isHidden: false,
			alignBottom: true,
			pane: 'floatPane',
			enableEventPropagation: true
		});
	};


	mapObject.setCenter(latlngbounds.getCenter());
	mapObject.fitBounds(latlngbounds);
});