// var baseUrl = "/sur4";
var path = window.location.pathname;
var url = path.split('/');
var baseUrl = '/'+url[1];

const Toast = Swal.mixin({
    toast: true,
    position: 'bottom-end',
    showConfirmButton: false,
    timer: 3000
});

/*var mapOptions = {
        zoom: 13,
        center: new google.maps.LatLng(23.625269,-99.9478396),
        mapTypeId: google.maps.MapTypeId.ROADMAP,
        mapTypeControl: false,
        mapTypeControlOptions: {
            style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
            position: google.maps.ControlPosition.LEFT_CENTER
        },
        panControl: false,
        panControlOptions: {
            position: google.maps.ControlPosition.TOP_RIGHT
        },
        zoomControl: true,
        zoomControlOptions: {
            style: google.maps.ZoomControlStyle.LARGE,
            position: google.maps.ControlPosition.TOP_LEFT
        },
        scrollwheel: false,
        scaleControl: false,
        scaleControlOptions: {
            position: google.maps.ControlPosition.TOP_LEFT
        },
        streetViewControl: true,
        streetViewControlOptions: {
            position: google.maps.ControlPosition.LEFT_TOP
        },
        styles: [
            {
                "featureType": "administrative.country",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "administrative.province",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "administrative.locality",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "administrative.neighborhood",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "administrative.land_parcel",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "landscape.man_made",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "simplified"
                    }
                ]
            },
            {
                "featureType": "landscape.natural.landcover",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "on"
                    }
                ]
            },
            {
                "featureType": "landscape.natural.terrain",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "poi.attraction",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "poi.business",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "poi.government",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "poi.medical",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "poi.park",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "on"
                    }
                ]
            },
            {
                "featureType": "poi.park",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "poi.place_of_worship",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "poi.school",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "poi.sports_complex",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "road.highway.controlled_access",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "road.arterial",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "simplified"
                    }
                ]
            },
            {
                "featureType": "road.local",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "simplified"
                    }
                ]
            },
            {
                "featureType": "transit.line",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "transit.station.airport",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "transit.station.bus",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "transit.station.rail",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "water",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "on"
                    }
                ]
            },
            {
                "featureType": "water",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            }
        ]
    }; cambiado al ocultar mapa1*/
Vue.http.options.emulateJSON = true;

var app = new Vue({
    el: "#tarifasVue",
    data: {
        //Variables para v-for's
        api_url: rmt_url + '/api/',
        rmt_url: rmt_url,
        parameters_url: window.location.search,
        categorias: [],
        planes: [],
        tarifas: [],
        fotos_hotel: [],
        servicios_hotel: [],
        no_result: false,
        primeraRespuesta: true,
        finRespuesta: true,
        loading_all_hotels: false,

        //variables para tarifas base
        model_id_hotel: 0,
        model_id_tipo_habitacion: 0,
        model_combinar: false,
        model_response_tarifas_base: null,

        //Variables para consultar webservice
        hotelesRQ:[],
        hotelesRQAux:[],
        habs:[],
        habsAux:[],
        frontformVue:[],
        frontformVueAux:[],

        // variables para usar en el interfaz
        resultadoBusquedaHoteles:[],
        frontForm:[],

        //variables a enviar a reservacion
        proveedor: '',
        datos_generales: '',
        datos_api: '',
        id_hotel: '',
        nombrehotel: '',
        input_front_form:[],
        input_resultado_busqueda:[],
        roomRates:'',

        //Variables para infinite scroll
        show   : false, // display content after API request
        offset : 5,     // items to display after scroll
        display: 5,     // initial items
        trigger: 300,   // how far from the bottom to trigger infinite scroll
        items  : [],    // server response data
        end    : false, // no more resources
        
        //Variables para filtros
        selected_plan:'0',
        search: '',
        price_filter:'1',
        selected_estrellas: [],
        selected_proveedor: [],
        selected_outlet: '',
        filtro_disponibilidad: "0",
        selected_other_filters: [],
        selected_zonas:[],
        selected_maps:0,
        tarifasFilter:[],
        totalFilter: 0,
        rango_precio: {
        	min: 0,
        	max: 0
        },
        min_range: 0,
        max_range: 100,
        started_range: false,

        //Variables para mapa
        marker: [],
        uluru: '',
        map: '',
        map_data: {},

        //loaders
        loading: true, //tarifas
        loading_fotos: false, //Fotos de los hoteles
        loading_servicios: false, //Servicios de los hoteles
        loading_tarifas_base: false, //Tarifas base del hotel
        loading_hoteles_do: false, //Tarifas base del hotel
        loading_mismoHotel: false,
        loading_mismoDestino: false,


        //habiliar formulario
        habilitarForm: false,
        sinDisponibilidad: false,

        //habilitar tarifas de hotel do si existen
        existHotelDo: false,

        //para ejecutar una sola vez la function
        existIdHotelDo: [],

        //array para tarifas hotel do
        tarifasHDo: [],

        //habilitar tarifas sin disponibilidad en rmt
        mostrarTodasCheck: '',

        //habilitar sugerencias
        mismoHotelesSugerencias: false,
        mismoDestinoSugerencias: false,
        tarifasSamesHotels:[], // tarifas mismo hotel
        tarifasSamesDestination:[], // tarifas destino
        no_result_hotel_sugerencias:'', //mensaje si no hay tarifas
        no_result_destino_sugerencias:'', // mensaje si no hay tarifas
        exist_other_hotels: false,

        array_brokers:[1,3],
        array_propios:[0,2,4,5,6],
        array_conectividad:[2,4,5,6],

        ubicacion_maps:'',
        dragMapaResult: false,
        dragMapaNotResult: false,
        mapObject:[],
        marker:[],
        markers:[],
        hotelMark:{id_hotel:0,arrow:'greenarrow',inner:'greener'},
        contarHotel: 0,

        my_range: {},
        tipoBusqueda: tipoBusqueda,
        agregaUsuario:'',
        contador_total_hoteles: 0,
        outlet_tipo:'',
        hoteles_destacados: 0,
        contDestacados: [],
    },
    created() {
        // this.hotelesRQ = hotelesRQ;
        // this.habs = habitacionesRQ;
        // this.frontformVue = front_form;
        this.tarifasHDo = new Array();
        this.loadCategorias();
        this.loadPlanes();
         if (this.tipoBusqueda=='hotel') {
            sinProveedor = [];
            this.loadTarifas(sinProveedor);
        }else{
            this.loadTarifas([0,1,3,4,5]);
            var proovedores;
            if (this.outlet_tipo=="") {
                this.rmt_url = 'https://tripulanteweb.com/sur4espejo';
                this.agregaUsuario = '&keyU='+id_usuario;

                 proveedores=[0,1,3,5];
            }
              
            switch (this.outlet_tipo) {
                case "grupos":
                    proveedores=[0];
                    break;
                case "bodas":
                    proveedores=[0];
                    break;
                 case "outlet":
                 
                    proveedores=[0,4];
                    break;
            }
           proveedores=[2];
            this.loadTarifas(proveedores);
            this.agregaUsuario = '';
            this.rmt_url = rmt_url;
            // this.loadTarifas([0,1,2,3,4,5]);
        }
    },
    methods:{
        loadCategorias: function() {
            this.$http.get(this.api_url + 'categorias?limit=5').then(function(response) {
                var response_categorias = response.body;
                this.categorias = response_categorias.data.categorias;
            }, function() {
                console.log('Error');
            });
        },
        loadPlanes: function() {
            var url_plan = this.api_url + 'plan' + '?filter=[{"property":"estatus","value":1,"operator":"="}]';
            this.$http.get(encodeURI(url_plan)).then(function(response) {
                var response_planes = response.body;
                this.planes = response_planes.data.plan;
            }, function() {
                console.log('Error');
            });
        },
        loadListadoTarifas: function(){

            element = event.currentTarget;
            this.model_id_hotel = element.getAttribute('data-id_hotel');
            var id_hotel = this.model_id_hotel;
            $("#tarifas_base_"+this.model_id_hotel).html("<div align='center' style='margin-top:20px'><img src='"+baseUrl+"/images/loader.gif'></div>");
            // var 
            $.ajax({
                url: baseUrl+'/tarifa/listadoTarifas',
                type: 'POST',
                data: {resultadoBusqueda: this.habs, hotel: this.model_id_hotel},
            })
            .done(function(html) {
                // console.log(html);
                // console.log(id_hotel);
                $("#tarifas_base_"+id_hotel).empty();
                $("#tarifas_base_"+id_hotel).html(html);
            })
            .fail(function(error) {
                console.log(error);
            });

        },
        loadTarifas: function(proveedores) {
            var filtro_disponibilidad = 1;
            if (this.filtro_disponibilidad==false) {
                filtro_disponibilidad = 0;
            }
              var outlet_tipo=this.parameters_url.split('?');
            
                outlet_tipo= outlet_tipo[1];
                outlet_tipo= outlet_tipo.split('&');
                outlet_tipo= outlet_tipo[0];
                outlet_tipo= outlet_tipo.split('=');

                if (outlet_tipo[0]=="outlet" && outlet_tipo[1]!="" && proveedores.length>0) {
                    this.outlet_tipo=outlet_tipo[1];
                }else{
                    var outlet_tipo=this.parameters_url.split('&');
                    var ultimo= (outlet_tipo.length-1);
                    outlet_tipo= outlet_tipo[ultimo];
                    outlet_tipo=outlet_tipo.split('=');
                    if (outlet_tipo[0]=="outlet" && outlet_tipo[1]!="" && proveedores.length>0) {
                        this.outlet_tipo=outlet_tipo[1];
                    }
                }
            var params = { hotelesRQ: this.hotelesRQ, habitacionesRQ: this.habs, front_form: this.frontformVue, disponibilidad: filtro_disponibilidad };
            this.$http.get(this.rmt_url + "/site/getTarifas/"+this.parameters_url+'&proveedores='+proveedores+this.agregaUsuario).then(function(response){

                this.contador_total_hoteles = response.body.count;
                if (this.finRespuesta==false) {
                    this.loading_all_hotels = false;
                }

                if (this.primeraRespuesta==true) {
                    this.finRespuesta = false;
                    if (this.contador_total_hoteles>0) {
                        this.loading_all_hotels = true;
                    }
                    this.habs = JSON.stringify(response.body.habitacionesRQ);
                    this.frontformVue = JSON.stringify(response.body.front_form);
                }

                // this.tarifas = Object.values(response.body.tarifa);
                if (response.body.count>0) {
                	//this.tarifas=[];

                    // this.tarifas = Object.values(response.body.row);
                    var that = this;
                    var responseTarifas = Object.values(response.body.row);
                    this.tarifas = that.tarifas.concat(responseTarifas);
                    // console.log(this.tarifas.length);
                    // this.cargarMapa(this.tarifas)no descomentar;
                    this.show = true;
                    this.loading = false;
                    $('input').iCheck({
                        checkboxClass: 'icheckbox_square-grey',
                        radioClass: 'iradio_square-grey'
                    }).on('ifChecked ifUnchecked', function(){
                        $(this)[0].dispatchEvent(new Event("change"));
                    });

                    //$('#chk_outlet').iCheck('uncheck');
                    $('.diasValidos').iCheck('check');
                    $('#chk_rmt').iCheck('check');
                    $('#chk_so').iCheck('check');
                    $('.selectedZonas').iCheck('check');
                    this.resultadoBusquedaHoteles=JSON.parse(this.habs);
                    this.frontForm=JSON.parse(this.frontformVue);

                    if (this.resultadoBusquedaHoteles.totalHoteles==1) {
                        this.loading_all_hotels = false;
                        // llamamos a sugerencias con el mismo nombre
                        var destiny=this.frontForm.destino.split('_');
                        this.loadSamesHotels();
                        this.exist_other_hotels=true;
                        var hotel = [];
                        tarifas = this.tarifas;
                        if (destiny[0]=="h") {
                            this.hotelMark.id_hotel=tarifas[0].id_hotel;
                            
                        }
                       
                        disponibilidadPropio = true; disponibilidadApis = false; disponibilidadOB = false;
                        if (tarifas[0].proveedor==0) {disponibilidadPropio = tarifas[0].Desglose.disponibilidad_hotel;}
                        if (tarifas[0].proveedor!=0 || tarifas[0].proveedor==2) {
                            if (typeof (tarifas[0].Warning) !== 'undefined') {
                                disponibilidadApis = tarifas[0].Warning.warning;
                            }
                        }
                        if (tarifas[0].proveedor==2) {disponibilidadOB = tarifas[0].Desglose.NoDisponible;}

                        if (disponibilidadPropio == false || disponibilidadApis == true || disponibilidadOB == true) {
                            this.loadSamesDestination();
                        }
                    }
                }else{
                	if (this.ubicacion_maps=='') {
                		this.show = true;
                    	if (this.primeraRespuesta==true && this.loading_all_hotels==true) {
                            this.loading = false;
                        }
                        if (this.primeraRespuesta==false && this.finRespuesta==true) {
                           this.no_result = true;
                        }
                        if (JSON.parse(this.habs).totalHoteles==0) {
                        // console.log(JSON.parse(this.habs).totalHoteles);
                            this.loading = false;
                    	   this.no_result = true;
                        }
                	}
                	$(".range_price").toggle();
                }
                this.primeraRespuesta = false;
            });
        },
        loadSamesHotels: function(){
            var filtro_disponibilidad = 1;
            if (this.filtro_disponibilidad==false) {
                filtro_disponibilidad = 0;
            }
            this.loading_mismoHotel = true;
            var params = {destinoRQ: this.frontForm.destino, habitacionesRQ: this.habs, front_form: this.frontformVue, disponibilidad: filtro_disponibilidad };
            this.$http.post(baseUrl + "/site/getSamesHotels", params).then(function(response){
                if (response.body!=null) {
                    this.tarifasSamesHotels = Object.values(response.body);
                }else{
                    this.no_result_hotel_sugerencias = "<div style='margin-top: 30px;font-size:14px;' class='alert alert-danger '><p><b>No se encontraron hoteles disponibles con las mismas similitudes</b></p></div>";
                }
                    this.mismoHotelesSugerencias = true;
                    this.loading_mismoHotel = false;
            });
        },
        loadSamesDestination: function(){
            this.loading_mismoDestino = true;
            var params = {destinoRQ: this.frontForm.destino, habitacionesRQ: this.habs, front_form: this.frontformVue };
            this.$http.post(baseUrl + "/site/getSamesDestinations", params).then(function(response){
                if (response.body!=null) {
                    this.tarifasSamesDestination = Object.values(response.body);
                }else{
                    this.no_result_destino_sugerencias = "<div style='margin-top: 30px;font-size:14px;' class='alert alert-danger '><p><b>No se encontraron otros hoteles disponibles con el mismo destino solicitado.</b></p></div>";
                }
                    this.mismoDestinoSugerencias = true;
                    this.loading_mismoDestino = false;
            });
        },
       /* loadMapaHoteles: function(){
            if (this.ubicacion_maps!='') {
                var params = {ubicacion: this.ubicacion_maps, habitacionesRQ: this.habs, front_form: this.frontformVue };
                this.$http.post(baseUrl + "/site/dragMaps", params).then(function(response){
                	
                	if (response.body.count>0) {

                        this.hotelesRQAux = this.hotelesRQ; 
                        this.habsAux = this.habs;

                        this.resultadoBusquedaHoteles.totalHoteles = parseInt(response.body.count);
                        this.habs = JSON.stringify(this.resultadoBusquedaHoteles);
                        this.hotelesRQ = JSON.stringify(response.body.row);

                       // this.tarifasSamesHotels = [];
                       // this.tarifasSamesDestination = [];
                      //  this.tarifas = [];

                      //  hideAllMarkers();

                        this.started_range = false;
                        //this.loading = true;
                        this.dragMapaResult = true;
                        this.dragMapaNotResult = false;


                    	this.loadTarifas();
                	}else{
                        $("#alert-dragMapa").css('display','block');
                        $("#alert-dragMapa").css('opacity','1');
                        $("#alert-dragMapa").show();
                        $("#alert-dragMapa").delay(300).addClass("in").fadeOut(3000);
                    }

                });
            }
        }, cambiado al ocultar el mapa2*/
        recuperarBusqueda(){
            this.hotelesRQ = this.hotelesRQAux;
            this.loadTarifas();
        },
        cargarMapa: function(tarifas,searchforzona){
            var that = this;
            if (searchforzona==true) {
                that.map_data = {};
            }
            tarifas.forEach(function(element, index) {

                // if(element.ubicacion != null || element.ubicacion != "" || (typeof element.ubicacion === "undefined")) {
                if(element.ubicacion !== '' ) {
                    var proveedor = '';
                    var nombre_proveedor = '';
                    var array_ubicacion = element.ubicacion.split("/");
                    var menorPrecio = ''; var mejorHabitacion = ''; var mejorPlan = '';var proveedor='';
                    if (element.Desglose) {
                        menorPrecio = '$ ' + element.Desglose.menorPrecio + ' ' + element.Desglose.moneda;
                        mejorHabitacion = element.Desglose.mejorHabitacion;
                        mejorPlan = element.Desglose.mejorPlan;
                    }

                    proveedor = element.proveedor;
                    nombre_proveedor = element.foto.prov;
                    if(typeof that.map_data["hotel"] == "undefined"){
                        that.map_data["hotel"] = [];
                        that.map_data["hotel"].push({
                            id_hotel: element.id_hotel,
                            name: element.nombre_hotel,
                            location_latitude: array_ubicacion[1], 
                            location_longitude: array_ubicacion[0],
                            map_image_url: element.foto.rutaImage,
                            name_point: element.nombre_hotel,
                            best_room: mejorHabitacion,
                            lower_price: menorPrecio,
                            best_plan: mejorPlan,
                            get_directions_start_address: '',
                            url_point: 'single_hotel.html',
                            proveedor: proveedor,
                            nombre_proveedor: nombre_proveedor
                        });
                    } else {
                        that.map_data["hotel"].push({
                            id_hotel: element.id_hotel,
                            name: element.nombre_hotel,
                            location_latitude: array_ubicacion[1], 
                            location_longitude: array_ubicacion[0],
                            map_image_url: element.foto.rutaImage,
                            name_point: element.nombre_hotel,
                            best_room: mejorHabitacion,
                            lower_price: menorPrecio,
                            best_plan: mejorPlan,
                            get_directions_start_address: '',
                            url_point: 'single_hotel.html',
                            proveedor: proveedor,
                            nombre_proveedor: nombre_proveedor
                        });
                    }
                }
            });
            $.getScript((rmt_url + "/vue/mapas_cotizador_hoteles.js"), function( data, textStatus, jqxhr ) {
                    // console.log(JSON.stringify(that.map_data));
                    // console.log( textStatus ); // Success
                    // console.log( jqxhr.status ); // 200
                    if ($("#chk_maps").is(":checked")){
                        $("#dv_desplazar").removeClass('d-none');
                        $("#load_desplazar").addClass('d-none');
                    }
                });
        },
        getRatesHD: function(event){
            var btn_send = event.currentTarget;
            var proveedor = btn_send.getAttribute('data-proveedor');
            var codigo_hotel = btn_send.getAttribute('data-codigoHotel');
            var id_hotel = btn_send.getAttribute('data-idHotel');
            var interfaceInfo = btn_send.getAttribute('data-interfaceInfo');
            var dataHDo = { codigoHotel: codigo_hotel, idHotel: id_hotel, front_form: this.frontformVue, fecha_inicial: this.resultadoBusquedaHoteles.fecha_inicial, interfaceInfo: interfaceInfo };

            var tarifasHDo_aux = new Array();

            $("#hotelDo_"+id_hotel).html("<div align='center'><i class='fa fa-spinner fa-pulse fa-3x fa-fw'></i> Cargando...</div>");

            $.ajax({
                'url':baseUrl + "/travelSolution/getRatesHD",
                'type':'POST',
                'data': dataHDo,
                async: true,
            })
            .done(function(html){

                $("#hotelDo_"+id_hotel).html("");
                    $("#hotelDo_"+id_hotel).append(html); //imprimo el html
                    
                });

            if (this.existIdHotelDo.includes(id_hotel)===false) {

            }else{

                var html = this.tarifasHDo[id_hotel].html;
                // console.log(html);
            }
        },
        loadFotosHotel: function() {
            element = event.currentTarget;
            var id_hotel = element.getAttribute('data-id_hotel');
            var proveedor = element.getAttribute('data-nuevo');
            $("#tab_hotel_"+id_hotel).html("<div align='center' style='margin-top:10px'><img src='/reservaciones/sur3/images/loader.gif'></div>");
            // var url_hotel_fotos = this.api_url + 'hotelesFotos?filter=[{"property":"id_hotel","value":' + id_hotel + ',"operator":=}]';
            var url_hotel_fotos = baseUrl + '/hotelesFotos/hotelesFotos';
            this.$http.post(url_hotel_fotos,{id_hotel:id_hotel,proveedor:proveedor}).then(function(response) {
                // console.log(response.body);
                if (response.body !== 'undefined' || response.body !== null) {
                    var html = "";
                    this.fotos_hotel = response.body.data.hotelesFotos;
                    this.loading_fotos = false;
                    var valueFoto="";
                    if(proveedor==1)
                    {
                        var urlfoto = "https://photos.hotelbeds.com/giata/";
                        var medium ="medium/";
                        var bigger ="bigger/";
                    }
                    else if(proveedor==3 || proveedor==5 || proveedor == 2)
                    {
                        var urlfoto="";
                        var medium="";
                        var bigger="";                
                    }
                    else 
                    {
                        var urlfoto = "https://rutamayatravel.com/imagenes/";
                        var medium ="";
                        var bigger ="";                
                    }

                    $.each(this.fotos_hotel,function(index,value){
                        valueFoto=value.foto
                        if (proveedor==3 || proveedor==5 || proveedor == 2) {
                            valueFoto = value.foto.replace('http:','');
                        }
                        html += "<div class=\"col-3\"><a href=\""+urlfoto+bigger+valueFoto+"\" data-toggle='lightbox' data-gallery='example-gallery' data-max-height='500'><img src=\""+urlfoto+medium+valueFoto+"\" width='100%' /> </a> </div>";
                    });
                    $("#tab_hotel_"+id_hotel).html(html);
                }else{
                    $("#tab_hotel_"+id_hotel).html('');
                }

            }, function() {
                $("#tab_hotel_"+id_hotel).html('');
            });
        },
        loadServiciosHotel: function() {
            element = event.currentTarget;
            var id_hotel = element.getAttribute('data-id_hotel');
            var proveedor = element.getAttribute('data-nuevo');
            $("#tab_servicio_"+id_hotel).html("<div align='center' style='margin-top:10px'><img src='/reservaciones/sur3/images/loader.gif'></div>");
            // var url_hotel_servicio = this.api_url + 'hotelServDef?filter=[{"property":"id_hotel","value":' + id_hotel + ',"operator":=}]';
            var url_hotel_servicio = baseUrl + '/site/hotelServDef';
            this.$http.post(url_hotel_servicio,{id_hotel:id_hotel,proveedor:proveedor}).then(function(response) {
                $("#tab_servicio_"+id_hotel).html(response.body);
            }, function() {
                console.log('Error');
            });
        },
        loadMapaHotel: function() {
            element = event.currentTarget;
            var id_hotel = element.getAttribute('data-id_hotel');
            var info_ubicacion = [];
            info_ubicacion = this.tarifas.filter(function(i) {
                return i.id_hotel === id_hotel;
            });
            // console.log(info_ubicacion);
           /* if (info_ubicacion.length === 0) {
                info_ubicacion = this.tarifasSamesHotels.filter(function(i) {
                    return i.id_hotel === id_hotel;
                });
            }
            if (info_ubicacion.length === 0) {
                info_ubicacion = this.tarifasSamesDestination.filter(function(i) {
                    return i.id_hotel === id_hotel;
                });
            }*/

            if (info_ubicacion[0].ubicacion !== '') { 
                var array_ubicacion = info_ubicacion[0].ubicacion.split("/");
                this.uluru = { lat: parseFloat(array_ubicacion[1]), lng: parseFloat(array_ubicacion[0]) };
                this.map = new google.maps.Map(
                    document.getElementById('map_' + id_hotel), {
                        zoom: 10,
                        center: this.uluru
                    });
                this.marker = new google.maps.Marker({position: this.uluru, map: this.map, draggable: false, animation: google.maps.Animation.DROP});
            }
        },
        setIdHotel: function() {
        	element = event.currentTarget;
            this.model_id_hotel = element.getAttribute('data-id_hotel');
        },
        setIdTipoHabitacion: function(event) {
            element = event.currentTarget;
            this.model_id_tipo_habitacion = element.getAttribute('data-id_tipo_habitacion');
            this.model_response_tarifas_base = null;

            var id_hotel = element.getAttribute('data-hotel');
            var tarifa = element.getAttribute('data-tarifa');
            var plan = element.getAttribute('data-plan');
            var ORDER_PRECIO = JSON.parse(this.habs).ORDER_PRECIO;
            $("#v-pills-tabContent_"+id_hotel).html("<div align='center' style='margin-top:20px'><img src='"+baseUrl+"/images/loader.gif'></div>");
            $.ajax({
                url: baseUrl+'/tarifa/cargarHabitaciones',
                type: 'POST',
                data: {id_hotel:id_hotel,id_tarifa:tarifa,id_plan:plan,ORDER_PRECIO: ORDER_PRECIO},
            })
            .done(function(html) {
                $("#v-pills-tabContent_"+id_hotel).empty();
                $("#v-pills-tabContent_"+id_hotel).html(html);
            })
            .fail(function(error) {
                console.log(error);
            });
            
        },
        loadTarifasBaseHotel(event) {
       //          this.loading_tarifas_base = true;
       //          var id_tarifa = element.getAttribute('data-id_tarifa');
       //          var fecha_inicial = JSON.parse(app.habs).fecha_inicial;
       //          var noches = JSON.parse(app.habs).noches;
                // var postData = { "id_hotel": this.model_id_hotel, "id_tarifa": id_tarifa, "id_hab": this.model_id_tipo_habitacion, "fecha_inicio": fecha_inicial, "noches": noches, "combinar": false };
       //          this.$http.post('tarifasBase', postData).then(function(response) {
       //           this.model_response_tarifas_base = response.body;
       //           $("a").tooltip();
       //              this.loading_tarifas_base = false;
       //          }, function() {
       //              console.log('Error');
       //          });
                element = event.currentTarget;
                var hotel = element.getAttribute('data-id');
                var tarifa = element.getAttribute('data-tarifa');
                var hab = element.getAttribute('data-hab');
                var fecha_inicio = JSON.parse(this.habs).fecha_inicial;
                var noches = JSON.parse(this.habs).noches;

                var ORDER_PRECIO = JSON.parse(this.habs).ORDER_PRECIO;
                var combinar = true;
                $("#cotizacionRapida"+hotel).html("<div align='center' style='margin-top:20px'><img src='"+baseUrl+"/images/loader.gif'></div>");
                $.ajax({
                    url: baseUrl+'/tarifa/Tarifasbase',
                    type: 'POST',
                    data: {id_hotel: hotel, id_tarifa: tarifa, id_hab:hab, fecha_inicio: fecha_inicio, noches: noches, ORDER_PRECIO: ORDER_PRECIO, combinar:combinar},
                })
                .done(function(html) {
                    $("#cotizacionRapida"+hotel).empty();
                    $("#cotizacionRapida"+hotel).html(html);
                })
                .fail(function(error) {
                    console.log(error);
                });
                
        },
        ocultarBoton(id_hotel){
            $("#click_"+id_hotel).toggleClass('d-none');
        },
        activandoTarifas: function(id_hotel){
            $("#click_"+id_hotel).toggleClass('d-none');
            $("#collapseMostrarTarifas_" + id_hotel).trigger("click");
            // console.log('moviendo');
        },
        convertToBase64Decode: function(data){
           var result = atob(data);
           return result;
        },
        convertToBase64Encode: function(data){
           var result = Base64.encode(data);
           return result;
        },
        convertToNumber: function(numero){
           
            if (typeof numero.replace(',','')==undefined) {
                var number = numero;
            }else{
                var number = numero.replace(',','');
            }
            return parseFloat(number);
        },
        buildJson: function(id_hotel,nombre_hotel,id_plan,tipo_plan,code_hotel,id_habitacion,precio,moneda,tarifa,markup){
            var data_general = new Array();

            data_general = {
                "id_hotel" : id_hotel,
                "nombre_hotel" : nombre_hotel,
                "id_plan" : id_plan,
                "tipo_plan" : tipo_plan,
                "code_hotel" : code_hotel,
                "id_habitacion" : id_habitacion,
                "precio" : this.convertToNumber(precio),
                "moneda" : moneda,
                "id_tarifa" : tarifa,
                "markup": markup
            }

            return Base64.encode(JSON.stringify(data_general));
        },
        convertToJsonApi: function(api){

            // return this.convertToBase64Encode(api);
            return Base64.encode(JSON.stringify(api));
        },
        sendReservacion: function(event){

            // console.log(event.currentTarget.getAttribute('data-id_hotel'));
            var btn = event.currentTarget;
            var id_hotel = btn.getAttribute('data-id_hotel');

            this.proveedor = btn.getAttribute('data-proveedor');

            if (this.proveedor==2 || this.proveedor==3) {
            	this.roomRates = $("#roomRates_"+id_hotel).val();
            }
            this.datos_generales = btn.getAttribute('data-general');
            this.datos_api = btn.getAttribute('data-api');
            this.input_front_form = this.convertToBase64Encode(this.frontformVue);
            this.input_resultado_busqueda = this.convertToBase64Encode(this.habs);

            this.sendForm();
        },
        sendForm: function(){
            
            setTimeout(function(){
            
            if (this.input_resultado_busqueda != '') {
                $("#formReservacion").submit();
            }

            },2100);
        },
        convertToJsonDecode: function(texto){
            return JSON.parse(texto);
        },
        convertToJsonEncode: function(texto){
            return JSON.stringify(texto);
        },
        mostrarTodas: function(id_hotel){
        	$(".ocultarTarifa_"+id_hotel).toggleClass('d-none');
        },
        filterMapaGoogle: function(nombre_hotel){
            // console.log(nombre_hotel);
            this.search = nombre_hotel;
        },
        restricted: function(id_hotel, key, tipo_boton, nota){
            // console.log('.planesTarifa_'+id_hotel+key+'_'+tipo_boton);
            $('.planesTarifa_'+id_hotel+key+'_'+tipo_boton).addClass('d-none');
            // return this.frontForm.habs==1 ? nota : '';
            return nota;
        },
        initRangePrice: function(tarifas) {
        	if(this.started_range == false) {
                if (this.loading_all_hotels==false) {
                    this.started_range = true;
                }
                var last = tarifas.length;
                // console.log(last);
                var min_range = 0; var max_range = 0;

                if(tarifas[0].Desglose.moneda == "USD") {
                    min_range = parseFloat(tarifas[0].Desglose.menorPrecio_mxn.replace(',',''));
                } else {
                    min_range = parseFloat(tarifas[0].Desglose.menorPrecio.replace(',',''));
                }

                if(tarifas[last - 1].Desglose.moneda == "USD") {
                    max_range = parseFloat(tarifas[last - 1].Desglose.menorPrecio_mxn.replace(',',''));
                } else {
                    max_range = parseFloat(tarifas[last - 1].Desglose.menorPrecio.replace(',',''));
                }

                // min_range = Math.round(min_range);
                min_range = Math.floor(min_range);
                max_range = Math.ceil(max_range);
                var that = this;
                this.rango_precio = {};
                this.rango_precio = {
                	min: min_range,
                	max: max_range
                }

                this.min_range = this.rango_precio.min;
        		this.max_range = this.rango_precio.max;

                that.my_range.update({
                    min: min_range,
                    max: max_range,
                    from: min_range,
                    to: max_range,
                }); 
            }
        },
        filtros: function(tarifas, rowscount,searchforzona){
            var vm = this;
            var tarifasFilter = [];

            if (rowscount == 1) {
                // vm.tarifas.Warning && 
                //this.cargarMapa(tarifas,searchforzona) mapa3;
                return tarifas.slice(0, this.display);
            } else {
                // FILTRO PRECIO
                if (vm.price_filter == 2 || vm.price_filter == 1) {

                    var orderPrecio_a = 0; 
                    var orderPrecio_b = 0; 
                    tarifas.sort(function(a, b) {

                        if (typeof a.Desglose !== 'undefined' || typeof b.Desglose !== 'undefined') {

                            // console.log('Hotel: '+a.id_hotel + ' id ' + a.nombre_hotel);
                            // console.log('moneda: '+a.Desglose.moneda);
                            // console.log('Hotel: '+b.id_hotel + ' id ' + b.nombre_hotel);
                            // console.log('moneda: '+b.Desglose.moneda);
                            
                            if (a.Desglose.moneda=='USD') {
                                orderPrecio_a = a.Desglose.menorPrecio_mxn;
                            }else{
                                orderPrecio_a = a.Desglose.menorPrecio;
                            }

                            if (b.Desglose.moneda=='USD') {
                                orderPrecio_b = b.Desglose.menorPrecio_mxn;
                            }else{
                                orderPrecio_b = b.Desglose.menorPrecio;
                            }
                            
                            // console.log(a.id_hotel);
                            return vm.convertToNumber(orderPrecio_a) - vm.convertToNumber(orderPrecio_b);
                        }
                    });
                    if(vm.loading == false) {
                    	vm.initRangePrice(tarifas);
                    }
                } else if (vm.price_filter == 3) {
                    tarifas.sort(function(a, b) {
                        if (typeof a.Desglose !== 'undefined' || typeof b.Desglose !== 'undefined') {
                            if (a.Desglose.moneda=='USD') {
                                orderPrecio_a = a.Desglose.menorPrecio_mxn;
                            }else{
                                orderPrecio_a = a.Desglose.menorPrecio;
                            }

                            if (b.Desglose.moneda=='USD') {
                                orderPrecio_b = b.Desglose.menorPrecio_mxn;
                            }else{
                                orderPrecio_b = b.Desglose.menorPrecio;
                            }
                            return vm.convertToNumber(orderPrecio_b) - vm.convertToNumber(orderPrecio_a);
                        }
                    });
                }

                //this.initRangePrice();

                tarifasFilter = tarifas.filter((tarifa) => { 
                    if (tarifa.proveedor == 3) {
                        $("#hotelDo_"+tarifa.id_hotel).html("");
                    }

                    if (tarifa.proveedor == 0) {

                    }
                    //FILTRO BUSQUEDA
                    return tarifa.nombre_hotel.toLowerCase().includes(vm.search.toLowerCase());
                }).filter((stars) => {
                    // FILTRO ESTRELLAS
                    if (vm.selected_estrellas.length > 0) {
                        return vm.selected_estrellas.includes(parseInt(stars.estrellas));
                    } else {
                        return stars;
                    }
                }).filter((zonas) => {
                    // FILTRO Zonas
                    if (vm.selected_zonas.length > 0) {
                        if(zonas.destino.zonasCode == '3640' && this.frontForm.destino == 'd_PCM'){
                            return zonas;
                        }else{
                            return vm.selected_zonas.includes(zonas.destino.zonasCode);
                        }
                    } else {
                        return zonas;
                    }
                }).filter((proveedor) => {
                    var rmt = [0, 2, 4, 5, 6];
                    var broker = [1, 3];
                    // console.log(vm.selected_proveedor);
                    // FILTRO PROVEEDOR
                    if(vm.selected_proveedor.length == 1) {
                        if(vm.selected_proveedor[0] == "rmt" || vm.selected_outlet == true) {
                            return rmt.includes(parseInt(proveedor.proveedor));
                        }
                        return broker.includes(parseInt(proveedor.proveedor));
                    }else if(vm.selected_outlet == true){
                         return rmt.includes(parseInt(proveedor.proveedor));
                    }else {
                        return proveedor;
                    }
                }).filter((other) => {
                    if(vm.selected_other_filters.length > 0) {

                        var temas = Object.values(other.Filtro.temas);
                        var filterTema = false;
                        end_loop:
                        for (i=0; i < vm.selected_other_filters.length ; i++) {
                            filterTema = temas.includes(vm.selected_other_filters[i]);
                            if (filterTema === true) {break end_loop};
                        }
                        if (filterTema === true) {
                            return other;
                        }
                    }else{
                        return other;
                    }
                }).filter((plan) => {
                    // FILTRO PLANES
                    if (vm.selected_plan!=0) {
                        if (typeof plan.Filtro.planes.codigos!='undefined') {
                            planes = Object.values(plan.Filtro.planes.codigos);
                            return planes.includes(parseInt(vm.selected_plan));
                        }
                    } else {
                        return plan;
                    }
                }).filter((precio) => {
                	if(precio.Desglose.moneda == "USD") {
                		if(vm.convertToNumber(precio.Desglose.menorPrecio_mxn) >= vm.rango_precio.min && vm.convertToNumber(precio.Desglose.menorPrecio_mxn) <= vm.rango_precio.max) {
                			return precio;
                		}
                	} else {
                		if(vm.convertToNumber(precio.Desglose.menorPrecio) >= vm.rango_precio.min && vm.convertToNumber(precio.Desglose.menorPrecio) <= vm.rango_precio.max) {
                			return precio;
                		}
                	}
                	/*if(vm.min_range != vm.rango_precio.min || vm.max_range != vm.rango_precio.max) {
                	}*/
                });

                // console.log(tarifasFilter);
                tarifasFilter.sort(function(a, b) {

                    // if (typeof b.destacado == 'undefined') {
                    //     return -1;
                    // }

                    // if (typeof a.destacado == 'undefined') {
                    //     return -1;
                    // }else{
                        var destacado = b.destacado - a.destacado;
                        return destacado;
                    // }
                });

                this.contDestacados = tarifasFilter.filter((item) => {
                    return item.destacado === 1;
                });

                // var searchDestacados = [];
                
                // console.log(this.contDestacados)

                this.totalFilter = tarifasFilter.length;
                
                tarifasFilter = tarifasFilter.slice(0, this.display);
                
                if (this.loading_all_hotels==false) {
                   // this.cargarMapa(tarifasFilter,searchforzona) mapa4;
                }
                return tarifasFilter;
            }
        },
        // check to see if we're at the bottom of the page
        scroll() {
            if( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
                // console.log("mobile");
                // this.trigger = 2200;
                document.addEventListener("scroll", (evt) => {
                    // console.log("event wheel");
                    if(window.innerHeight + $(window).scrollTop() >= $("#resultadoTarifas").innerHeight()) {
                        if (this.display < this.tarifas.length) {
                            this.display = this.display + this.offset;
                        } else {
                            this.end = true;
                        }
                    }
                }, { capture: false, passive: true});
            } else {
                // this.trigger = 300;
                var capa = document.getElementById('resultadoTarifas');
                capa.onscroll = ev => {
                    if (
                    	$('#resultadoTarifas').innerHeight() + $('#resultadoTarifas').scrollTop() >= 
                    	($('#div_tarifas')[0].offsetHeight - this.trigger)
                    ) {
                        if (this.display < this.tarifas.length) {
                            this.display = this.display + this.offset;
                        } else {
                            this.end = true;
                        }
                    }
                };
            }
        },
        onHtmlClick: function(location_type,key){
               var searchforzona, rowscount = this.tarifas.length;
            if (rowscount==1) {searchforzona=false;}else{searchforzona=true;}
            
            this.hotelMark.id_hotel=key;
            //this.cargarMapa(this.tarifas,searchforzona) mapa5;
            var i_ubicacion = this.countHotels(key);
            // console.log(i_ubicacion);
            if (i_ubicacion !== "") {
                onHtmlClick(location_type,i_ubicacion);
            }
        },
        addItemCarrito: function(tarifa, hab, plan_tarifa, plan, proveedor) {
            /*var array_carrito = JSON.parse(localStorage.getItem("shoopping_cart"));
            if(array_carrito == null) {
                array_carrito = [];
            }*/

          /*  if (plan==0) {
                plan=plan_tarifa;
            }*/

            var arreglo = { 
                item: tarifa,
                hab: hab,
                plan_tarifa: plan_tarifa,
                plan: plan,
                prov: proveedor,
                num_habs: JSON.parse(this.frontformVue).habs,
                tipo: "reserva",
            
            };

            this.$http.post(this.rmt_url + "/carrito/addCarrito", { info: JSON.stringify(arreglo) }).then(function(response) {
                appCarritoHeader.array_carrito = response.body;
                Toast.fire({
                    type: 'success',
                    title: 'Se ha agregado al carrito'
                });
            }, function() {
                console.log('Error');
            });
        },
         crearPromocion: function(tarifa, hab, proveedor,plan) {
      
           /* var tar={
                "tarifa":tarifa,
                "hab":hab,
                "plan":plan,
                "proveedor":proveedor,
            }*/
            var nombrePlan;
            nombrePlan=plan.nombrePlan;
            if (proveedor=="2") {
                 nombrePlan=plan.tipo_plan;
            }
       
            var promocion={
                "conectividad":1,
                "num_menores_gratis":0,
                "fecha_limite_h":plan.fecha_limiteH,
                "fecha_limite":plan.fecha_limite,
                "id_promocion_conectividad": 0,
                "id_base_habitacion": plan.calendario.habitacion[1].resumen.adultos,
                "precio_normal": plan.calendario.habitacion[1].Fechas[1].Adultos,
                "nombre_hotel": tarifa.nombre_hotel,
                "id_hotel": tarifa.id_hotel,
                "code_hotel": tarifa.code_hotel,
                "foto_principal_hotel": tarifa.foto.rutaImage,
                "tipo_habitacion": tarifa.Habitaciones[hab].nombre_hab,
                "tipo_plan": nombrePlan,
                "url":window.location.href,
                "estatus_tarifa": "1",
                "tipo_precio": "PROMO",
                "tipo_moneda": plan.moneda,
                "proveedor":proveedor
            };

            appPromocion.array_promocion=promocion;

           $("#fechas_promocion").modal('show');

        },
        test_method: function() {
            // console.log("change");
        },
        countHotels: function(id_hotel){
           var i;
           this.map_data.hotel.forEach(function(x, index) {
                if (x.id_hotel === id_hotel) {
                    i = index;
                }
            });
           return i;

       }
    },
    computed: {
        // slice the array of data to display
        sliced() {
            var vm = this;
            // var rowscount = vm.resultadoBusquedaHoteles.totalHoteles;
            var rowscount = vm.tarifas.length;
            if (rowscount==1) {searchforzona=false;}else{searchforzona=true;}
            if (this.contador_total_hoteles>0) {
                vm.tarifasFilter = this.filtros(this.tarifas, rowscount,searchforzona);
            }

            return vm.tarifasFilter;
        },
        suggestions() {
            var vm = this;
            var rowscount = vm.tarifasSamesHotels.length;
            if (rowscount>0) {
                tarifasHotelFilter = this.filtros(this.tarifasSamesHotels, rowscount,false);
            }

            return tarifasHotelFilter;
        },
        suggestionsDestination() {
            var vm = this;
            var rowscount = vm.tarifasSamesDestination.length;
            if (rowscount>0) {
             tarifasDestinoFilter = this.filtros(this.tarifasSamesDestination, rowscount,false);
            }

            return tarifasDestinoFilter;  
        },
        
    },
    mounted() {
    	//this.mapObject = new google.maps.Map(document.getElementById('map'), mapOptions); mapa6
        // track scroll event
        this.scroll();
        $('[data-toggle="tooltip"]').tooltip({
            container: 'body'
        });
        $(".range").ionRangeSlider({
            hide_min_max: true,
            keyboard: true,
            type: "double",
            step: 1,
            prefix: "$ ",
            min: 0,
            max: 0,
            from: 0,
            to: 0,
            //postfix: " MXN",
            grid: true,
        });

        this.my_range = $(".range").data("ionRangeSlider");
        var that=this;
      
    },
});


$('.range').on("change", function () {
    var $inp = $(this);
    app.rango_precio = {
        min: $inp.data("from"),
        max: $inp.data("to")
    }
 });

$('body').on('click','.calendario',function(){
    var hotel = $(this).attr("data-id");
    var tarifa = $(this).attr("data-tarifa");
    var tipohab = $(this).attr("data-hab");
    var allotment = $(this).attr("data-allotment");
    var rate = $(this).attr("data-rate");
    var fecha_inicial = $(this).attr("data-fecha_inicial");
    var noches = $(this).attr("data-noches");
    var btnColor = $(this).attr("data-btnColor");
    var tarifa_rmt = app.tarifas.filter(function(e) {
        return e.id_hotel == hotel;
    });
    if (tarifa_rmt.length==0) {
        tarifa_rmt = app.tarifasSamesHotels.filter(function(e) {
            return e.id_hotel == hotel;
        });
    }
    if (tarifa_rmt.length==0) {
        tarifa_rmt = app.tarifasSamesDestination.filter(function(e) {
            return e.id_hotel == hotel;
        });
    }
  
    var habitacion_tarifa = tarifa_rmt[0].Habitaciones.filter(function(hab) {
        return hab.tipo_hab == tipohab;
    });


    // console.log(habitacion_tarifa);

    $("#calendario_fechas").empty();
    $("#calendario_fechas").html("<div align='center' style='margin-top:20px'><img src='"+baseUrl+"/images/loader.gif'></div>");
    if(allotment == 0){
        $("#modal-disponibilidad .accept").attr('data-dismiss','modal');
        $("#modal-disponibilidad .accept").removeAttr('href');
        $("#modal-disponibilidad").modal('show');
    }else{
        $("#modal-calendario").modal('show');
    }
    jQuery.ajax({'type':'POST','data':{'id_hotel':hotel,'id_tarifa':tarifa,'id_tipohab':tipohab,'rate':rate,'fecha_inicio':fecha_inicial,'noches':noches, 'habitacion':Base64.encode(JSON.stringify(habitacion_tarifa)), 'btnColor':btnColor},'success':function(html){
        $("#calendario_fechas").html(html);
    },'url':baseUrl + '/site/consultarfechas.html','cache':false});return false;
});


$('#modal-disponibilidad').on('hidden.bs.modal', function () {
    $("#modal-calendario").modal('show');
});


/*app.mapObject.addListener('dragend', function() {
     if ($("#chk_maps").is(":checked")){
        hideAllMarkers();
        $("#dv_desplazar").addClass('d-none');
        $("#load_desplazar").removeClass('d-none');
    }
});
app.mapObject.addListener('dragstart', function() {
   
    
    var latlg = app.mapObject.getCenter();
    app.ubicacion_maps = latlg.lat() + '/' + latlg.lng();

    var pos = {
        lat: parseFloat(latlg.lat()),
        lng: parseFloat(latlg.lng())
    };

    var norte = pos['lat'] + 0.025;
    var sur = pos['lat'] - 0.025;

    var este = pos['lng']+ 0.015;
    var oeste = pos['lng'] - 0.015;

    var bounds = {
        north: norte,
        south: sur,
        east: este,
        west: oeste
    };


    rectangle = new google.maps.Rectangle({
        bounds: bounds,
        editable: false,
        draggable: false,
    })

    //rectangle.setMap(app.mapObject);
    if (app.selected_maps!=0) {
        // console.log(app.selected_maps);
        app.loadMapaHoteles();
    }
});
mapa7
*/
function sendReservacionAux(event){
    app.sendReservacion(event);
}

function hideAllMarkers() {
    for (var key in app.markers)
        app.markers[key].forEach(function (marker) {
      
            if(validateMark(marker)===false)
            {

                marker.setMap(null);
            }
        });
};



$("body").on("click", ".shopping-cart", function(){
    var tarifa = $(this).attr("data-item");
    var hab = $(this).attr("data-hab");
    var plan_tarifa = $(this).attr("data-plan-tarifa");
    var plan = $(this).attr("data-plan");

    /*var array_carrito = JSON.parse(localStorage.getItem("shoopping_cart"));
    if(array_carrito == null) {
        array_carrito = [];
    }*/
    var arreglo = { 
        item: JSON.parse(atob(tarifa)),
        hab: parseInt(hab),
        plan_tarifa: parseInt(plan_tarifa),
        plan: parseInt(plan),
        prov: 3,
        num_habs: JSON.parse(app.frontformVue).habs,
        tipo: "reserva"
    }
   
    /*array_carrito.push(arreglo);
    localStorage.setItem("shoopping_cart", { info: arreglo });*/

    $.ajax({
        url: app.rmt_url + "/carrito/addCarrito",
        type: 'POST',
        dataType: 'JSON',
        data: { info: JSON.stringify(arreglo) },
    })
    .done(function(response) {
        // console.log(response);
        appCarritoHeader.array_carrito = response;
        Toast.fire({
            type: 'success',
            title: 'Se ha agregado al carrito'
        });
        // console.log("success");
    })
    .fail(function() {
        console.log("error");
    });
});

$('[data-toggle="tooltip"]').tooltip();
