Vue.http.options.emulateJSON = true;
var solicitud = new Vue({
    el: '#solicitudCancelacion',
    data: {
        rmt_url: baseUrl,
        reservas: [],
        full:0,
        sur4url:'',
        reserva:[],
        options:{0:'No atendido',1:'En espera',2:'Resuelto'}
    },
    created: function(){
       // this.loadVariables();
        this.loadSolicitud();
        
    },
    methods: {
        loadSolicitud: function() {
            this.sur4url=this.rmt_url.replace('admin','');
           var urlapi=this.sur4url + '/solicitudCancelacion/loadSolicitudes';
           this.$http.get(encodeURI(urlapi)).then(function(response){
                var response = response.body;
                this.reservas = response;
              
                if (this.full) {
                 this.getFull(this.reservas);   
                }else{
                 this.getResumen(this.reservas);
                }
            }, function(){
                console.log('Error');
            });
        },

       
        getResumen: function(reservas) {
                table_resumen = $('#tbl_resumen_solicitud').DataTable({
                    destroy:true,
                    paging: true,
                    responsive:true,
                    //scrollX:true,
                    lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
                    sDom:"<'dt_colVis_buttons'B><'dt-uikit-header'<'uk-grid'<'uk-width-medium-2-3'l><'uk-width-medium-1-3'f>>>tipr",
                    buttons: [
                        {
                            extend: 'excel',
                            text:'<i class="uk-icon-file-excel-o" style="color: #FFFFFF"></i> Exportar a Excel',
                            className: 'md-btn md-btn-success md-btn-wave-light'
                        },
                    ],
                   "order": [[ 2, "asc" ]], 


                });
                table_resumen.clear();
                var that=this;
                
                reservas.forEach(function(element){
                   

                    var estatus,ukbadge,fecha,tipo,id_reservacion;
              
                        
                      
                     id_reservacion=element.id_reserva;
                        fecha = moment(element.log).format('DD/MM/YY');
        
                     
                        switch(element.idReserva.estatus)
                        {
                            case "PC":
                                estatus = "En espera";
                                ukbadge="warning";
                            break;
                            case "C":
                                estatus = "Resuelto";
                                ukbadge="success";
                            break;
                            
                            default:
                                 estatus = "No atendido";
                                ukbadge="danger";
                            break;
                            
                        }
                        switch (element.tipo) {
                            case "0":
                                tipo = "Hotel";
                                ukbadges="";
                                dir='/reservacion/view/id/';

                                break;
                            case "1":
                                tipo = "Actividad";
                                ukbadges="";
                                dir='/Activities/view/id/';
                            break;
                            case "2":
                                tipo = "Tour";
                                ukbadges="";
                                dir='/tourReservacion/view/id/';

                            break;
                            
                        }
                           
                          
                    table_resumen.row.add([
                        "<a href='"+that.rmt_url + dir + id_reservacion+"' target='_blank'>"+id_reservacion+"</a>",
                        "<span class='uk-badge uk-badge-"+ukbadge+"'>"+estatus+"<span>",
                        element.idMotivo.motivo,
                        tipo,
                        element.agente,
                        fecha,             
                    ]).draw(false);
                });
           
        },
         getFull: function(reservas) {
          
                table_resumen = $('#tbl_full_solicitud').DataTable({
                    destroy:true,
                    paging: true,
                    responsive:true,
                    //scrollX:true,
                    lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
                    sDom:"<'dt_colVis_buttons'B><'dt-uikit-header'<'uk-grid'<'uk-width-medium-2-3'l><'uk-width-medium-1-3'f>>>tipr",
                    buttons: [
                        {
                            extend: 'excel',
                            text:'<i class="uk-icon-file-excel-o" style="color: #FFFFFF"></i> Exportar a Excel',
                            className: 'md-btn md-btn-success md-btn-wave-light'
                        },
                    ],
                  
                     "order": [[ 2, "asc" ]], 

                });
                table_resumen.clear();
                var that=this;
                
                reservas.forEach(function(element,index){
                   
                   
               

                      var estatus,ukbadge,fecha,tipo,id_reservacion,fechaL;
              
                        
                      
                     id_reservacion=element.id_reserva;
                        fecha = moment(element.log).format('DD/MM/YY');
                        fechaL = moment(element.idReserva.fecha_limite).format('DD/MM/YY');
         
                        switch(element.idReserva.estatus)
                        {
                            case "PC":
                                estatus = "En espera";
                                ukbadge="warning";
                            break;
                            case "C":
                                estatus = "Resuelto";
                                ukbadge="success";
                            break;
                            
                            default:
                                 estatus = "No atendido";
                                ukbadge="danger";
                            break;
                            
                        }
                        switch (element.tipo) {
                            case "0":
                                tipo = "Habitación";
                                ukbadges="";
                                dir='/reservacion/view/id/';

                                break;
                            case "1":
                                tipo = "Actividad";
                                ukbadges="";
                                dir='/Activities/view/id/';
                            break;
                            case "2":
                                tipo = "Tour";
                                ukbadges="";
                                dir='/tourReservacion/view/id/';

                            break;
                            
                        }
                       
                        
                   table_resumen.row.add([
                        element.id_solicitud_cancelacion,
                        "<a href='"+that.rmt_url + dir + id_reservacion+"' target='_blank'>"+id_reservacion+"</a>",
                        "<span class='uk-badge uk-badge-"+ukbadge+"'>"+estatus+"<span>",
                        element.idMotivo.motivo,
                        tipo,
                        fecha, 
                        fechaL,
                        element.agente,
                        element.comentario,
                        " "
                    ]).draw(false);
                });
          
        },
        
        round: function (value, decimals) {
            return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
        
        parseDate: function(date, format) {
            return moment(date).format(format);
        },
        dias:function(dia){
            this.dia+=dia;
            this.loadReservas(this.dia);
        },
        modalEstatus:function(idx){
            this.reserva=this.reservas[idx];
          
            switch (this.reserva.estatus){             
                case 0:
                console.log(this.reserva.estatus)
                     $('.select::after').css('background', '#d32f2f');
                     $('.select').css('background', '#d24848');
                     break;
                case 1:
                      $('.select::after').css('background', '#e53935');
                     break;
                case 2:
                      $('.select::after').css('background', '#7cb342');
                     break;
            }  

            
            
            UIkit.modal("#modal_opciones").show();
        },
         changeStatus:function(){ 
            var urlapi=this.rmt_url + '/solicitudCancelacion/cambiarEstatus/id/'+this.reserva.id_solicitud_cancelacion+'/estatus/'+this.reserva.estatus;
            this.$http.get(encodeURI(urlapi)).then(function(response){
                
               this.loadSolicitud();
        
            }, function(){
                console.log('Error');
            });
        }
    },
});

function modalOpciones(idx)
{
    solicitud.modalEstatus(idx);
}