<nav class="navbar navbar-dark bg-dark navbar-expand-lg bg-light">
  	<a class="navbar-brand" href="#">S.U.R. 4</a>
  	<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarText" aria-controls="navbarText" aria-expanded="false" aria-label="Toggle navigation">
    	<span class="navbar-toggler-icon"></span>
  	</button>
  	<div class="collapse navbar-collapse" id="navbarText">
    	<ul class="navbar-nav mr-auto">
      		<li class="nav-item active">
        		<a class="nav-link" href="#">Home <span class="sr-only">(current)</span></a>
      		</li>
      		<li class="nav-item">
        		<a class="nav-link" href="#">Features</a>
      		</li>
      		<li class="nav-item">
    			<a class="nav-link" href="#">Pricing</a>
  			</li>
    	</ul>
    	<span class="navbar-text">
      		Navbar text with an inline element
		</span>
  	</div>
</nav>
<div class="container-fluid" id="tarifasVue">
	<div class="row">
		<div class="col-3">
            <div class="row">
                <div class="col-12">
                    <div class="form-group">
                        <label class="text-primary"><i class="fa fa-utensils"></i> Tipo Planes:</label><br />
                        <?php $planes = Plan::model()->findAll('estatus=1'); ?>
                        <select name="planes" id="" v-model="selectedPlan">
                            <option value="0">Todos los planes</option>
                            <?php foreach ($planes as $key => $plan): ?>
                                <option value="<?=$plan->id_plan?>"><?=$plan->nombre?></option>
                            <?php endforeach ?>
                        </select>
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label class="text-primary"><i class="fa fa-bed"></i> Hotel:</label><br />
                        <input type="text" name="search" v-model="search" class="form-control">
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="price" class="text-primary"><i class="fa fa-dollar-sign"></i> Precio:</label><br>
                        <select v-model="priceFilter" style="width: 100%">
                            <option value="1">Default</option>
                            <option value="2">Menor a Mayor Precio</option>
                            <option value="3">Mayor a Menor Precio</option>
                        </select>
                    </div>
                </div>
                <div class="col-12">
                <?php $estrellas = Categorias::model()->findAll(array('limit'=>5)); ?>
                    <label for="price" class="text-primary"><i class="fa fa-star"></i> Clasificación:</label><br>
                    <?php foreach ($estrellas as $star): ?>
                        <div class="md-checkbox" style="font-size: 12px;"><input id="star_<?=$star->id_categoria?>" v-bind:value="<?=$star->id_categoria?>" type="checkbox" v-model="selectedEstrellas"><?=$star->icon?> </div>
                    <?php endforeach ?>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <br><label for="price" class="text-primary"> Hoteles de:</label><br>
                        <input v-model="radio_proveedor" type="radio" name="all" value="all"> Todos <br>
                        <input v-model="radio_proveedor" type="radio" name="rmt" value="rmt"> Ruta Maya Travel <br>
                        <input v-model="radio_proveedor" type="radio" name="broker" value="broker"> Socio Online <br>
                    </div>
                </div>
            </div>
        </div>
		<div class="col">
			<div style="overflow: auto;">
				<h1>Resultados Cotización</h1>
                <div class="col-12">
                    <span> {{ tarifas_scroll.length }} de {{ Object.keys(this.tarifas).length }} HOTELES</span>
                </div>
				<div v-for="(tarifa, $index) in tarifas_scroll" style="margin-top: 25px;">
					<div class="card">
  						<div class="card-header">
    						<div class="row">
							    <div class="col-2">
                                    <!-- <img src="https://i.ebayimg.com/images/g/p28AAOSwcjharIDm/s-l300.jpg" class="card-img" alt="..."> -->
							      	<img :src="tarifa.foto.rutaImage" class="card-img" alt="...">
							    </div>
							    <div class="col">
		    						<h5 class="card-title">{{ tarifa.nombre_hotel }}</h5> <br>
                                    <!-- <p class="card-title">{{ tarifa.destino.name }} , {{ tarifa.destino.destinationsCode0 }} | <b>{{tarifa.foto.prov}}</b></p> -->
							    </div>
							</div>
  						</div>
  						<!-- <div class="card-body">
                            <ul class="nav nav-tabs card-header-tabs" id="myTab" role="tablist">
                                                          <li class="nav-item">
                                                            <a class="nav-link active" id="home-tab" data-toggle="tab" href="#descripcion" role="tab" aria-controls="home" aria-selected="true">Descripción</a>
                                </li>
                                                          <li class="nav-item">
                                                            <a class="nav-link" id="profile-tab" data-toggle="tab" href="#fotos" role="tab" aria-controls="profile" aria-selected="false">Fotos</a>
                                                          </li>
                                                          <li class="nav-item">
                                                            <a class="nav-link" id="contact-tab" data-toggle="tab" href="#servicios" role="tab" aria-controls="contact" aria-selected="false">Servicio</a>
                                                          </li>
                                                          <li class="nav-item">
                                                            <a class="nav-link" id="contact-tab" data-toggle="tab" href="#mapa" role="tab" aria-controls="contact" aria-selected="false">Mapa</a>
                                                          </li>
                                                    </ul>
                                                    <div class="tab-content" id="myTabContent">
                                                        <div class="tab-pane fade show active" id="descripcion" role="tabpanel" aria-labelledby="home-tab">
                                                            <p>{{ tarifa.observaciones }}</p>
                                                        </div>
                                                        <div class="tab-pane fade" id="fotos" role="tabpanel" aria-labelledby="profile-tab">...</div>
                                                        <div class="tab-pane fade" id="servicios" role="tabpanel" aria-labelledby="contact-tab">...</div>
                                                        <div class="tab-pane fade" id="mapa" role="tabpanel" aria-labelledby="contact-tab">...</div>
                                                    </div>
                        </div>
                        
                        <div class="card-body">
                            <div class="row">
                                <div class="col-8">
                                    <div class="row" v-if="tarifa.proveedor!=3">
                                        <div class="col-12" v-for="habitacion in tarifa.Habitaciones" style="border:1px black solid;">
                                            <div class="row">
                                                <div class="col-12">
                                                    <p>{{habitacion.nombre_hab}}</p><br>
                                                </div>
                                                <div class="col-12" v-for="planesTarifa in habitacion.Planes">
                                                    <div class="row" v-for="plan in planesTarifa.plan">
                                                        <div class="col-6" style="font-weight: bolder;">
                                                            <span>{{plan.tipo_plan}}</span><br>
                                                        </div>
                                                        <div class="col-6">
                                                            <span>$ {{plan.precio}} {{plan.moneda}}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-4" style="border:1px black solid;">
                                    <p>{{tarifa.Desglose.mejorHabitacion}}</p>
                                    <p>{{tarifa.Desglose.mejorPlan}}</p><br>
                                    <p>DESDE</p>
                                    <p>$ {{tarifa.Desglose.menorPrecio}} {{tarifa.Desglose.moneda}}</p>
                                    <p>
                                        <a href="" v-if="tarifa.Desglose.tarifas>1">Ver más tarifas</a>
                                    </p>
                                </div>
                            </div>
                        </div> -->
					</div>
				</div>
				<infinite-loading :identifier="infiniteId" @infinite="infiniteHandler" spinner="bubbles">
                    <span slot="no-more">
                        No hay más tarifas que cargar :(
                    </span>    
                </infinite-loading>
			</div>
		</div>
	</div>
</div>
<?php
$cs=Yii::app()->clientScript;
Yii::app()->clientScript->registerScript('vue', '
    var habitacionesRQ = JSON.stringify('.json_encode($habitacionesRQ).');
    var front_form = JSON.stringify('.json_encode($front_form).');
    var hotelesRQ = JSON.stringify('.json_encode($hotelesRQ).');
    ', CClientScript::POS_HEAD); 
Yii::app()->clientScript->registerScriptFile('https://unpkg.com/vue-infinite-loading@^2/dist/vue-infinite-loading.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/vue/tarifasVue.js?v='. time(), CClientScript::POS_END);
?>