<div class="modal fade" id="modal_cotiz" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Empieza tu viaje aquí</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" style="padding: 1rem 0rem 0rem 0rem;">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="hotels-tab" data-toggle="tab" href="#hotels" role="tab" aria-controls="hotels" aria-selected="true">Hoteles</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="activites-tab" data-toggle="tab" href="#activites" role="tab" aria-controls="activites" aria-selected="false">Actividades</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="tours-tab" data-toggle="tab" href="#tours" role="tab" aria-controls="tours" aria-selected="false">Tours</a>
                    </li>
                </ul>
              
                <div class="tab-content" id="myTabContent" style="margin-bottom: 0rem;">
                    <div class="tab-pane fade show active" id="hotels" role="tabpanel" aria-labelledby="hotels-tab">
                        <h3>Buscar Hoteles / Destinos / Zonas</h3>
                        <form action="<?= Yii::app()->createUrl('site/tarifas'); ?>" method="GET">
                            <input type="hidden" class="idAgencia" v-model="agencia_usuario">
                            <input type="hidden" class="idUsuario" v-model="id_usuario">
                            <input value="1" type="hidden" name="filtro_disponibilidad">
                            <input value="0" type="hidden" name="Hoteles[proveedor][]">
                            <input value="1" type="hidden" name="Hoteles[proveedor][]">
                            <input type="hidden" name="destino" id="destino_hotels">
                            <input type="hidden" name="fecha_entrada" v-model="array_estancia_hotels.fecha_entrada">
                            <input type="hidden" name="fecha_salida" v-model="array_estancia_hotels.fecha_salida">
                            <input type="hidden" name="habs" v-model="num_habs">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Destino</label>
                                        <v-multiselect v-model="model_destino_hotels" :options="options_destinos_hotels" group-label="tipo_destino" group-values="opciones" track-by="Codigo" label="Nombre" placeholder="Escriba 3 letras para comenzar" open-direction="bottom" :searchable="true" :loading="isLoading_hotels" :internal-search="false" :clear-on-select="false" :close-on-select="true" :options-limit="30" :max-height="600" @search-change="loadDestinationsHotels" :preserve-search="true" :show-labels="false" autocomplete="off" @select="setDestinoHotels">
                                            <template slot="option" slot-scope="props">
                                                <span v-if="props.option.$isLabel">{{ props.option.$groupLabel }}</span>
                                                <span v-else style="font-size: 0.8em">
                                                    <i v-if="props.option.Tipo == 'Hotel'" class='fa fa-bed'></i>
                                                    <i v-else-if="props.option.Tipo == 'Destino'" class='fa fa-map-marker'></i>
                                                    <i v-else="props.option.Tipo == 'Zona'" class='fa fa-flag'></i>
                                                    {{ props.option.Nombre }}
                                                </span>
                                            </template>
                                            <span slot="noResult">No hay coincidencias. Pruebe modificar su búsqueda.</span>
                                        </v-multiselect>
                                    </div>
                                    <div class="form-group">
                                        <label><i class="icon-calendar-7"></i> Estancia</label>
                                        <input style="background-color: white;" id="dp_hotels" type="text" class="form-control" autocomplete="off" v-model="rango_estancia_hotels" required readonly @click="toggleInput" />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-row">
                                        <div class="form-group col-4">
                                            <label>Habitaciones</label>
                                            <div class="input-group mb-2">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text btn-calculator" @click="opHab('subs')">-</div>
                                                </div>
                                                <input type="text" class="form-control txt-number" v-model="num_habs" readonly>
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text btn-calculator" @click="opHab('add')">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-8">
                                            <div v-for="hab in array_hab_hotels">
                                                <div class="form-row">
                                                    <div class="form-group col-6">
                                                        <label>Adultos</label>
                                                        <div class="input-group mb-2">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text btn-calculator" @click="opPaxHabs('subs', 'adult', hab)">-</div>
                                                            </div>
                                                            <input type="text" class="form-control txt-number" v-model="hab.num_adultos" :name="'habitacion_' + hab.no_hab + '[adultos]'" readonly>
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text btn-calculator" @click="opPaxHabs('add', 'adult', hab)">+</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-6">
                                                        <label>Menores</label>
                                                        <div class="input-group mb-2">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text btn-calculator" @click="opPaxHabs('subs', 'child', hab)">-</div>
                                                            </div>
                                                            <input type="text" class="form-control txt-number"v-model="hab.num_menores" :name="'habitacion_' + hab.no_hab + '[num_ninios]'" readonly>
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text btn-calculator" @click="opPaxHabs('add', 'child', hab)">+</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-row">
                                                    <div class="form-group col-4" v-for="menor in hab.edad_menores">
                                                        <label>Edad {{ menor.no_menor }}</label>
                                                        <select class="form-control" :name="'habitacion_' + hab.no_hab + '[edad_' + menor.no_menor + ']'" v-model="menor.edad">
                                                            <option :value="edad" v-for="edad in options_edad_menores" v-text="edad"></option>
                                                        </select>
                                                    </div>                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End row -->
                            <hr>
                            <button type="submit" class="btn_1 green"><i class="icon-search"></i>Cotizar</button>
                        </form>
                    </div>
                    <div class="tab-pane fade" id="activites" role="tabpanel" aria-labelledby="activites-tab">
                        <h3>Búsqueda de actividades</h3>
                        <form action="<?= Yii::app()->createUrl('site/activities'); ?>" method="GET">
                            <input type="hidden" class="idAgencia" v-model="agencia_usuario">
                            <input type="hidden" class="idUsuario" v-model="id_usuario">
                            <input type="hidden" name="hb_countriesActivities" v-model="model_code_activities">
                            <input type="hidden" name="hb_destinoActivities" v-model="model_destinationcode_activities">   
                            <input type="hidden" name="fecha_entrada" id="fecha_entrada_activities">
                            <input type="hidden" name="fecha_salida" id="fecha_salida_activities">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Destino</label>
                                        <v-multiselect v-model="model_destino_activities" :options="options_destinos_activities" track-by="destinationcode" label="destino" placeholder="Escriba 3 letras para comenzar" open-direction="bottom" :searchable="true" :loading="isLoading_activities" :internal-search="false" :clear-on-select="false" :close-on-select="true" :options-limit="30" :max-height="600" @search-change="loadDestinationsActivities" :preserve-search="true" :show-labels="false" autocomplete="off" @select="setDestinoActivities">
                                            <span slot="noResult">No hay coincidencias. Pruebe modificar su búsqueda.</span>
                                        </v-multiselect>
                                    </div>
                                    <div class="form-group">
                                        <label><i class="icon-calendar-7"></i> Estancia</label>
                                        <input style="background-color: white;" id="dp_activities" type="text" class="form-control" autocomplete="off" v-model="rango_estancia_activities" required readonly @click="toggleInput" />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-row">
                                        <div class="form-group col-6">
                                            <label>Adultos</label>
                                            <div class="input-group mb-2">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text btn-calculator" @click="opPaxActTour('subs', 'adult', 'act')">-</div>
                                                </div>
                                                <input type="text" class="form-control txt-number" v-model="array_hab_activities.num_adultos" name="num_adultos" readonly>
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text btn-calculator" @click="opPaxActTour('add', 'adult', 'act')">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group col-6">
                                            <label>Menores</label>
                                            <div class="input-group mb-2">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text btn-calculator" @click="opPaxActTour('subs', 'child', 'act')">-</div>
                                                </div>
                                                <input type="text" class="form-control txt-number" v-model="array_hab_activities.num_menores" name="num_ninios" readonly>
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text btn-calculator" @click="opPaxActTour('add', 'child', 'act')">+</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-3" v-for="menor in array_hab_activities.edad_menores">
                                            <label>Edad {{ menor.no_menor }}</label>
                                            <select class="form-control" :name="'num_edad[edad_' + menor.no_menor + ']'">
                                                <option :value="edad" v-for="edad in options_edad_menores" v-text="edad"></option>
                                            </select>
                                        </div>                                                    
                                    </div>
                                </div>
                            </div>
                            <!-- End row -->
                            <hr>
                            <button type="submit" class="btn_1 green"><i class="icon-search"></i>Cotizar</button>
                        </form>
                    </div>
                    <div class="tab-pane fade" id="tours" role="tabpanel" aria-labelledby="tours-tab">
                        <h3>Búsqueda de tours</h3>
                        <form action="<?= Yii::app()->createUrl('site/tours'); ?>" method="GET">
                            <input type="hidden" class="idAgencia" v-model="agencia_usuario">
                            <input type="hidden" class="idUsuario" v-model="id_usuario">
                            <input type="hidden" name="destino" v-model="model_code_tours">   
                            <input type="hidden" name="fecha_entrada" id="fecha_entrada_tours">
                            <input type="hidden" name="fecha_salida" id="fecha_salida_tours">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Destino</label>
                                        <v-multiselect v-model="model_destino_tours" :options="options_destinos_tours" group-label="tipo_destino" group-values="opciones" track-by="id_tour" label="nombre" placeholder="Escriba 3 letras para comenzar" open-direction="bottom" :searchable="true" :loading="isLoading_tours" :clear-on-select="false" :close-on-select="true" :max-height="600" :preserve-search="true" autocomplete="off" @select="setDestinoTours">
                                            <span slot="noResult">No hay coincidencias. Pruebe modificar su búsqueda.</span>
                                        </v-multiselect>
                                    </div>
                                    <div class="form-group">
                                        <label><i class="icon-calendar-7"></i> Estancia</label>
                                        <input class="form-control booking_date" id="bookingdate" type="text" data-lang="es" data-large-mode="false" data-large-default="true" data-min-year="2019" data-max-year="2020" data-format="d/m/Y" data-open="rigth" :data-minDate="min_date" name="fecha_entrada" v-model="estancia_tours">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-row">
                                        <div class="form-group col-6">
                                            <label>Adultos</label>
                                            <div class="input-group mb-2">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text btn-calculator" @click="opPaxActTour('subs', 'adult', 'tour')">-</div>
                                                </div>
                                                <input type="text" class="form-control txt-number" v-model="array_hab_tours.num_adultos" name="num_adultos" readonly>
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text btn-calculator" @click="opPaxActTour('add', 'adult', 'tour')">+</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group col-6">
                                            <label>Menores</label>
                                            <div class="input-group mb-2">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text btn-calculator" @click="opPaxActTour('subs', 'child', 'tour')">-</div>
                                                </div>
                                                <input type="text" class="form-control txt-number" v-model="array_hab_tours.num_menores" name="num_ninios" readonly>
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text btn-calculator" @click="opPaxActTour('add', 'child', 'tour')">+</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-3" v-for="menor in array_hab_tours.edad_menores">
                                            <label>Edad {{ menor.no_menor }}</label>
                                            <select class="form-control" :name="'num_edad[edad_' + menor.no_menor + ']'">
                                                <option :value="edad" v-for="edad in options_edad_menores" v-text="edad"></option>
                                            </select>
                                        </div>                                                    
                                    </div>
                                </div>
                            </div>
                            <!-- End row -->
                            <hr>
                            <button type="submit" class="btn_1 green"><i class="icon-search"></i>Cotizar</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>