var wrapper = document.getElementById("signature-pad");
var clearButton = wrapper.querySelector("[data-action=clear]");
var undoButton = wrapper.querySelector("[data-action=undo]");
/*var savePNGButton = wrapper.querySelector("[data-action=save-png]");
var saveJPGButton = wrapper.querySelector("[data-action=save-jpg]");*/
var saveBDButton = wrapper.querySelector("[data-action=save-bd]");
var canvas = wrapper.querySelector("canvas");

var signaturePad = new SignaturePad(canvas, {
    // It's Necessary to use an opaque color when saving image as JPEG;
    // this option can be omitted if only saving as PNG or SVG
    backgroundColor: 'rgb(255, 255, 255)'
});

// Adjust canvas coordinate space taking into account pixel ratio,
// to make it look crisp on mobile devices.
// This also causes canvas to be cleared.
function resizeCanvas() {
    console.log("resizeCanvas");
    // When zoomed out to less than 100%, for some very strange reason,
    // some browsers report devicePixelRatio as less than 1
    // and only part of the canvas is cleared then.
    var ratio =  Math.max(window.devicePixelRatio || 1, 1);

    // This part causes the canvas to be cleared
    canvas.width = canvas.offsetWidth * ratio;
    canvas.height = canvas.offsetHeight * ratio;
    canvas.getContext("2d").scale(ratio, ratio);

    // This library does not listen for canvas changes, so after the canvas is automatically
    // cleared by the browser, SignaturePad#isEmpty might still return false, even though the
    // canvas looks empty, because the internal data of this library wasn't cleared. To make sure
    // that the state of this library is consistent with visual state of the canvas, you
    // have to clear it manually.
    signaturePad.clear();
}

// On mobile devices it might make more sense to listen to orientation change,
// rather than window resize events.
window.onresize = resizeCanvas;
resizeCanvas();

function download(dataURL, filename) {
    var blob = dataURLToBlob(dataURL);
    var url = window.URL.createObjectURL(blob);

    var a = document.createElement("a");
    a.style = "display: none";
    a.href = url;
    a.download = filename;

    document.body.appendChild(a);
    a.click();

    window.URL.revokeObjectURL(url);
}

// One could simply use Canvas#toBlob method instead, but it's just to show
// that it can be done using result of SignaturePad#toDataURL.
function dataURLToBlob(dataURL) {
    // Code taken from https://github.com/ebidel/filer.js
    var parts = dataURL.split(';base64,');
    var contentType = parts[0].split(":")[1];
    var raw = window.atob(parts[1]);
    var rawLength = raw.length;
    var uInt8Array = new Uint8Array(rawLength);

    for (var i = 0; i < rawLength; ++i) {
    uInt8Array[i] = raw.charCodeAt(i);
    }

    return new Blob([uInt8Array], { type: contentType });
}

clearButton.addEventListener("click", function (event) {
    signaturePad.clear();
});

undoButton.addEventListener("click", function (event) {
    var data = signaturePad.toData();

    if (data) {
        data.pop(); // remove the last dot or line
        signaturePad.fromData(data);
    }
});

/*savePNGButton.addEventListener("click", function (event) {
    if (signaturePad.isEmpty()) {
        alert("Please provide a signature first.");
    } else {
        var dataURL = signaturePad.toDataURL();
        download(dataURL, "signature.png");
    }
});

saveJPGButton.addEventListener("click", function (event) {
    if (signaturePad.isEmpty()) {
        alert("Please provide a signature first.");
    } else {
        var dataURL = signaturePad.toDataURL("image/jpeg");
        download(dataURL, "signature.jpg");
    }
});*/

saveBDButton.addEventListener("click", function (event) {
    if (signaturePad.isEmpty()) {
        alert("Por favor agregue una firma para poder guardarla.");
    } else {
        Swal.fire({
            title: "Espere un momento, por favor",
            onBeforeOpen: () => {
                Swal.showLoading()
            },
            allowOutsideClick: false,
            allowEscapeKey: false, 
        });
        var dataURL = signaturePad.toDataURL();
        var base64signature = signaturePad.toDataURL("image/jpeg");
        $("#base64img").val(base64signature);
        $.ajax({
            url: rmt_url + '/signatures/uploadImgBase64',
            type: 'POST',
            dataType: 'json',
            data: { base64img: dataURL, type: "signature" },
        })
        .done(function(response) {
            Swal.close();
            if(response > 0) {
                Swal.fire({
                    icon: "success",
                    title: "Correcto",
                    html: "Se ha guardado de manera correcta su firma.",
                });
            } else {
                Swal.fire({
                    icon: "error",
                    title: "¡Ops!",
                    text: "Algo salió mal, recarga la página e intente de nuevo, si el problema persiste, comuníquese a Ruta Maya Travel.",
                });
            }
        })
        .fail(function(ex) {
            console.log(ex);
        })
        .always(function() {
            console.log("complete");
        });
        
    }
});


var signature_base64;
$.ajax({
    url: rmt_url + '/signatures/getSignatureBase64',
    type: 'GET',
    //dataType: 'default: Intelligent Guess (Other values: xml, json, script, or html)',
    //data: {param1: 'value1'},
})
.done(function(response) {
    if(response != "not found") {
        signature_base64 = "data:image/png;base64," + response;
    } else {
        signature_base64 = "not found";
    }
    setSignature();
    //console.log(response);
})
.fail(function() {
    //console.log("error");
})
.always(function() {
    //console.log("complete");
});

function setSignature() {
    if(signature_base64 != "not found") {
        signaturePad.fromDataURL(signature_base64);
    }
}