var appCarrito = new Vue({
    el: '#shopping-cart-form',
    data: {
        array_carrito: [],
        rmt_url: rmt_url,
        loaded: false,
    },
    created: function() {
        this.loadCarrito();
    },
    methods: {
        loadCarrito: function() {
            /*var string_json = localStorage.getItem("shoopping_cart");
            this.array_carrito = JSON.parse(string_json);
            if(this.array_carrito == null) {
                this.array_carrito = [];
            }*/

            this.$http.get(this.rmt_url + "/carrito/getCarrito").then(function(response) {
                this.array_carrito = response.body;
                this.loaded = true;
            }, function() {
                console.log('Error');
            });
            $(function () {
                $('[data-toggle="tooltip"]').tooltip();
            });
            this.addClass();
        },
        deleteItemCarrito: function(index) {
            this.array_carrito.splice(index, 1);
            /*localStorage.setItem("shoopping_cart", JSON.stringify(this.array_carrito));*/

            var post_data = { index: index };
            this.$http.post(this.rmt_url + "/carrito/deleteCarrito", post_data).then(function(response) {
                
            }, function() {
                console.log('Error');
            });
        },
        emptyCarrito: function() {
            this.array_carrito = [];
            /*localStorage.clear();*/

            this.$http.post(this.rmt_url + "/carrito/emptyCarrito").then(function(response) {

            }, function() {
                console.log('Error');
            });
        },
        getTotalCotiz: function(item, prov) {
            var total = 0; var moneda = "";
            item.forEach(function(element) {
                if(prov == 3) {
                    var monto = parseFloat(element.precio.replace(',',''));
                    total += monto;
                    moneda = element.moneda;
                } else {
                    Object.values(element.calendario.habitacion).forEach(function(element_hab) {
                        var monto = parseFloat(element_hab.Total.total.replace(',',''));
                        total += monto;
                        moneda = element_hab.Total.moneda;
                    });
                }
            });
            return "$ " + this.round(total, 2) + " " + moneda;
        },
        printPlanCotiz: function(item) {
            var plan = "";
            item.forEach(function(element) {
                plan = element.tipo_plan;
            });
            return plan;
        },
     /*   destino:function(destinos)
        {
            var id_destino, id_cadena, id_hotel, id_zona;
            var destino = destino.split('_');
                if(destino == 'd')
                {
                    id_destino = destino[1];
                }else if(destino == 'c'){
                    id_cadena = destino[1];
                }else if(destino == 'h')
                {
                    id_hotel = destino;

                }else if(destino == 'z'){
                    id_zona = destino[1];
                }
        },*/
        printTotalTour: function (item, info_search) {
            var adults_price, children_price;
            var item_array = Object.values(item);
            var adults_price = item.desglose.filter(function (i) {
                return i.tipo === "Adulto";
            });
            var adult_price = adults_price[0];

            var total = (adult_price.precio * item.tasa_cambio) * parseInt(info_search.num_adultos);

            if (parseInt(info_search.num_ninios) > 0) {
                var that = this;
                var array_menores = Object.values(info_search.num_edad);
                var children_price = item.desglose.filter(function (i) {
                    return i.tipo === "Menor";
                });
                if (children_price.length > 0) {
                    children_price.forEach(function (element, index) {
                        array_menores.forEach(function (element_edad) {
                            if (parseInt(element_edad) >= parseInt(element.edad_min) && parseInt(element_edad) <= parseInt(element.edad_max)) {
                                total += (element.precio * item.tasa_cambio);
                            } else if (parseInt(element_edad) > parseInt(element.edad_max)) {
                                total += (adult_price.precio * item.tasa_cambio);
                            }
                        });
                    });
                } else {
                    array_menores.forEach(function (element) {
                        if (parseInt(element) >= parseInt(adult_price.edad_min) && parseInt(element) <= parseInt(adult_price.edad_max)) {
                            total += (adult_price.precio * item.tasa_cambio);
                        }
                    });
                }
            }
            return this.round(total, 2);
        },
        countItemReserva: function() {
            var array_filter = this.array_carrito.filter(item => {
                return item.tipo.includes("reserva");
            });
            return array_filter.length;
        },
        addClass: function() {
            $(".table-tooltip").addClass("table");
        },
        round: function(value, decimals) {
            return Number(Math.round(value+'e'+decimals)+'e-'+decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
    },
    mounted() {
        this.addClass();
    }
});