var app = new Vue({
    el: '#appGrupos',
    data: {
        hoteles: [],

        rango_precio: {
            min: 0,
            max: 0
        },
        min_range: 0,
        max_range: 100,
        started_range: false,

        hotel_search: "",

        destinos: [],
        id_destino: 'Todos',
        array_cadenas: [],
        id_cadena: "0",

        id_grupos_tipos: '0',
        destinations: [],
        
        evento: evento,
    },
    created: function() {

    },
    mounted: function() {
        this.loadHoteles();

        $("#range").ionRangeSlider({
            hide_min_max: true,
            keyboard: true,
            type: "double",
            step: 1,
            prefix: "$ ",
            min: 0,
            max: 0,
            from: 0,
            to: 0,
            //postfix: " MXN",
            grid: true,
        });

        this.my_range = $("#range").data("ionRangeSlider");

        // this.loadDestinos();
    },
    methods: {
        loadHoteles: function() {
            this.$http.get(baseUrl + '/' + evento + '/getPaquetesGrupos').then(function(response) {
                this.hoteles = response.body;
                this.getDataForFilters();
                this.initRangePrice();
                // console.log(response.body);
            }, function() {
                console.log('Error');
            });

        },
        getDataForFilters: function() {
            var that = this;
            this.hoteles.forEach(function(element, index) {
                //Array para destinos
                var coincedences = that.destinations.filter((destination) => {
                    return destination.code == element.info_destino.code;
                });
                if (coincedences.length == 0) {
                    that.destinations.push(element.info_destino);
                }

                //Array para cadenas
                coincedences = that.array_cadenas.filter((chain) => {
                    if(that.array_cadenas.length > 0 && element.cadena_hotel != null) {
                        return chain.id == element.cadena_hotel.id;
                    }
                });
                if (coincedences.length == 0 && element.cadena_hotel != null) {
                    that.array_cadenas.push(element.cadena_hotel);
                }
            });
        },
        loadDestinos: function() {
            this.$http.get(baseUrl + '/' + evento + '/allDestinos').then(function(response) {
                this.destinos = response.body;
                // console.log(response.body);
            }, function() {
                console.log('Error');
            });
        },
        loadBusquedaDestino: function(destino) {
            this.$http.get(baseUrl + '/' + evento + '/getPaquetesGrupos/destino/' + destino).then(function(response) {
                this.hoteles = response.body;
                // console.log(response.body);
            }, function() {
                console.log('Error');
            });
            if (destino == 'Seleccione...') {
                this.$http.get(baseUrl + '/' + evento + '/getPaquetesGrupos').then(function(response) {
                    this.hoteles = response.body;
                    // console.log(response.body);
                }, function() {
                    console.log('Error');
                });
            } else {
                this.$http.get(baseUrl + '/' + evento + '/getPaquetesGrupos/destino/' + destino).then(function(response) {
                    this.hoteles = response.body;
                    // console.log(response.body);
                }, function() {
                    console.log('Error');
                });
            }
        },
        initRangePrice: function() {
            if(this.started_range == false) {
                this.started_range = true;
                var last = this.hoteles.length;
                // console.log(last);
                var min_range = 0; var max_range = 0;
                min_range = parseFloat(this.hoteles[0].precio);
                max_range = parseFloat(this.hoteles[last - 1].precio);

                // min_range = Math.round(min_range);
                min_range = Math.floor(min_range);
                max_range = Math.ceil(max_range);
                var that = this;
                this.rango_precio = {};
                this.rango_precio = {
                    min: min_range,
                    max: max_range
                }

                this.min_range = this.rango_precio.min;
                this.max_range = this.rango_precio.max;

                that.my_range.update({
                    min: min_range,
                    max: max_range,
                    from: min_range,
                    to: max_range,
                }); 
            }
        },
        formatPrice(value) {
            // var redondear = Math.ceil(value);
            // let val = (redondear / 1).toFixed(2).replace(',', '.')
            // return value.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            return parseFloat(value).toFixed(2).replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,');
        },
    },
    computed: {
        packages: function() {
            var vm = this;
            var paquetes = vm.hoteles;

            return paquetes.filter((tipo) => {
                if (vm.id_grupos_tipos != 0) {
                    if (vm.id_grupos_tipos == tipo.tipo_paquete) {
                        return tipo;
                    }
                } else {
                    return tipo;
                }
            }).filter((destination) => {
                if (this.id_destino == 'Todos') {
                    return destination;
                } else {
                    return destination.info_destino.code == this.id_destino;
                }
            }).filter(chain => {
                if(this.id_cadena == "0") {
                    return chain;
                } else {
                    if(chain.cadena_hotel != null) {
                        return chain.cadena_hotel.id == this.id_cadena;
                    }
                }
            }).filter(precio => {
                var parse_precio = parseFloat(precio.precio);
                if(parse_precio >= this.rango_precio.min && parse_precio <= this.rango_precio.max) {
                    return precio;
                }
            }).filter(nombre_hotel => {
                return nombre_hotel.nom_hotel.toLowerCase().includes(this.hotel_search.toLowerCase());
            });
        },
    }
});

$('#range').on("change", function () {
    var $inp = $(this);
    app.rango_precio = {
        min: $inp.data("from"),
        max: $inp.data("to")
    }
});