Vue.component('v-multiselect', window.VueMultiselect.default);

moment.locale('es');
var start = moment().subtract(1, 'month').startOf('month');
var end = moment().subtract(1, 'month').endOf('month');
var appAgencia = new Vue({
    el: '#info_agencia',
    data: {
        baseUrl: baseUrl,
        rmt_url: rmt_url,
        api_url: rmt_url + baseUrl + '/api/',
        rol: rol,
        idUser: idUser,
        //info agencia
        id_agencia: id_agencia,
        info_agencia: [],
        user: [],
        array_users: [],
        array_states: [],
        array_countries: [],

        //aux imagenes
        error_logo: false,
        img_logo: null,
        img_pie: null,
        file_logo: [],
        file_pie: [],

        //vars mapas
        marker: [],
        uluru: '',
        map: '',
        index: 0,
        //multiselect
        isLoadingState: false,
        isLoadingCountry: false,

        //models aux
        stateLoad: null,
        stateLoadLanding: null,
        countryLoad: null,

        //charts
        num_grupos_vendidos: 0,
        ventas_agencia: [],
        ventas_agencia_chart: [],
        ventas_usuarios: [],
        ventas_usuarios_chart_reserv: [],
        ventas_usuarios_chart_activities: [],
        ventas_usuarios_chart_tours: [],
        ventas_usuarios_chart_bodas: [],
        ventas_usuarios_chart_grupos: [],
        ventas_agencia_chart_labels: [],

        ventas_mes: [],
        ventas_mes_chart_reserv: [],
        ventas_mes_chart_activities: [],
        ventas_mes_chart_tours: [],

        tablaComparativaAgencia: [],
        totalAgencia: '',
        comisionAgencia: '',
        fecha_inicial_ventas: '',
        fecha_final_ventas: '',
        start: start,
        end: end,
        pieflyer_switch: true,
        landing: {
            id_agencia: 0,
            webslug: '',
            correo: '',
            telefono: '',
            ciudad: '',
            estado: '',
            direccion: '',
            webslug2: '',
            facebook: '',
            instagram: '',
            web: ''
        }
    },
    created: function () {
        this.loadSalesMount();
        this.loadInfoAgencia();
        this.loadLandingPage();
        this.loadUsers();
        this.loadStates();
        this.loadCountries();
        this.initComponents();
        this.loadAgencySales();
        this.loadGetComparative();
    },
    methods: {
        loadInfoAgencia: function () {
            this.$http.get(this.api_url + 'agenciasRest/' + this.id_agencia).then(function (response) {
                this.info_agencia = response.body.data.agenciasRest;
                if (this.info_agencia.foto == null || this.info_agencia.foto == "") {
                    this.img_logo = "https://semantic-ui.com/images/wireframe/image.png";

                } else {
                    this.img_logo = this.rmt_url + "/imagenes/" + this.info_agencia.foto;
                }
                if (this.info_agencia.pie_flyer == null || this.info_agencia.pie_flyer == "") {
                    this.img_pie = "https://semantic-ui.com/images/wireframe/image.png";
                    this.pieflyer_switch = false;
                } else {
                    this.img_pie = this.rmt_url + "/medios/flyers/pies_agencias/" + this.info_agencia.pie_flyer;
                    this.pieflyer_switch = true;
                }
                this.initMap();
                var that = this;
                setTimeout(function () {
                    $('input').iCheck({
                        checkboxClass: 'icheckbox_square-grey',
                        radioClass: 'iradio_square-grey'
                    }).on('ifChecked ifUnchecked', function () {
                        $(this)[0].dispatchEvent(new Event("change"));
                    });

                    $('.dropify').dropify({
                        error: {
                            'fileSize': 'El archivo es demasiado pesado, ({{ value }} max).',
                            'imageFormat': 'El formato del archivo no es permitido, ({{ value }} solamente).'
                        }
                    }).on('dropify.errors', function (event, element) {
                        console.log(event);
                        console.log(element);
                        appAgencia.error_logo = true;
                    });
                    Dropify.prototype.onChange = function () {
                        console.log("test");
                    }
                }, 1000);
            }, function (ex) {
                console.log(ex);
            });
        },

        loadUsers: function () {
            var url_usuarios
            if (this.rol != 'agv') {
                url_usuarios = this.api_url + 'usuariosRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=}]';
            } else {
                url_usuarios = this.api_url + 'usuariosRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=},{"property":"id_usuario","value":' + this.idUser + ',"operator":=}]';
            }
            this.$http.get(encodeURI(url_usuarios)).then(function (response) {
                this.array_users = response.body.data.usuariosRest;
            }, function (ex) {
                console.log(ex);
            });
        },
        loadStates: function () {
            this.$http.get(this.api_url + 'estadosmex/').then(function (response) {
                this.array_states = response.body.data.estadosmex;
                this.findState();
                this.findStateLoading();
            }, function (ex) {
                console.log(ex);
            });
        },
        loadCountries: function () {
            this.$http.get(this.api_url + 'paisRest/').then(function (response) {
                this.array_countries = response.body.data.paisRest;
                this.initComponents();
                this.findCountry();
            }, function (ex) {
                console.log(ex);
            });
        },
        updateInfoAgencia: function (tipo) {
            switch (tipo) {
                case 'general':
                    $("btn_general").addClass("disabled");
                    var post_data = { calle_agencia: this.info_agencia.calle_agencia, celular: this.info_agencia.celular, contacto: this.info_agencia.contacto, cp_agencia: this.info_agencia.cp_agencia, cruzamientos_agencia: this.info_agencia.cruzamientos_agencia, email_agencia: this.info_agencia.email_agencia, id_ciudad_agencia: this.info_agencia.id_ciudad_agencia, id_colonia_agencia: this.info_agencia.id_colonia_agencia, id_estado_agencia: this.info_agencia.id_estado_agencia, id_pais_agencia: this.info_agencia.id_pais_agencia, municipo_agencia: this.info_agencia.municipo_agencia, nombre_agencia: this.info_agencia.nombre_agencia, num_exterior_agencia: this.info_agencia.num_exterior_agencia, num_interior_agencia: this.info_agencia.num_interior_agencia, puesto: this.info_agencia.puesto, skype_agencia: this.info_agencia.skype_agencia, tel_agencia: this.info_agencia.tel_agencia, url_agencia: this.info_agencia.url_agencia };
                    this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(post_data)).then(function (response) {
                        var response_var = response.body;
                        $("btn_general").removeClass("disabled");
                        if (response_var.success == "true") {
                            this.loadInfoAgencia();
                            Swal.fire({
                                type: 'success',
                                title: "Correcto",
                                text: "Se han actualizado los datos de su agencia.",
                            });
                        } else {
                            Swal.fire({
                                type: 'error',
                                title: "¡Ops!",
                                html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                            });
                        }
                    }, function (ex) {
                        console.log(ex);
                    });
                    break;

                case 'fiscal':
                    $("btn_fiscal").addClass("disabled");
                    var post_data = { calle_fiscal: this.info_agencia.calle_fiscal, cp_fiscal: this.info_agencia.cp_fiscal, cruzamientos_fiscal: this.info_agencia.cruzamientos_fiscal, id_ciudad_fiscal: this.info_agencia.id_ciudad_fiscal, id_colonia_fiscal: this.info_agencia.id_colonia_fiscal, id_estado_fiscal: this.info_agencia.id_estado_fiscal, id_pais_fiscal: this.info_agencia.id_pais_fiscal, municipio_fiscal: this.info_agencia.municipio_fiscal, num_exterior_fiscal: this.info_agencia.num_exterior_fiscal, num_interior_fiscal: this.info_agencia.num_interior_fiscal, razon_social: this.info_agencia.razon_social, rfc: this.info_agencia.rfc };
                    this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(post_data)).then(function (response) {
                        var response_var = response.body;
                        $("btn_fiscal").removeClass("disabled");
                        if (response_var.success == "true") {
                            this.loadInfoAgencia();
                            Swal.fire({
                                type: 'success',
                                title: "Correcto",
                                text: "Se han actualizado los datos de su agencia.",
                            });
                        } else {
                            Swal.fire({
                                type: 'error',
                                title: "¡Ops!",
                                html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                            });
                        }
                    }, function (ex) {
                        console.log(ex);
                    });
                    break;

                case 'logo':
                    $("btn_logo").addClass("disabled");
                    var post_data = { foto: this.id_agencia + "-" + this.info_agencia.logotipo.replace(/\s/g, "-") };
                    this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(post_data)).then(function (response) {
                        var response_var = response.body;
                        $("btn_logo").removeClass("disabled");
                        if (response_var.success == "true") {
                            this.uploadImage("logo");
                            this.loadInfoAgencia();
                            Swal.fire({
                                type: 'success',
                                title: "Correcto",
                                text: "Se han actualizado los datos de su agencia.",
                            });
                        } else {
                            Swal.fire({
                                type: 'error',
                                title: "¡Ops!",
                                html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                            });
                        }
                    }, function (ex) {
                        console.log(ex);
                    });
                    break;

                case 'pie':
                    $("btn_pie").addClass("disabled");
                    var post_data = { pie_flyer: this.id_agencia + "-" + this.info_agencia.pie_flyer.replace(/\s/g, "-") };
                    this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(post_data)).then(function (response) {
                        var response_var = response.body;
                        $("btn_pie").removeClass("disabled");
                        if (response_var.success == "true") {
                            this.uploadImage("pie");
                            this.loadInfoAgencia();
                            Swal.fire({
                                type: 'success',
                                title: "Correcto",
                                text: "Se han actualizado los datos de su agencia.",
                            });
                        } else {
                            Swal.fire({
                                type: 'error',
                                title: "¡Ops!",
                                html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                            });
                        }
                    }, function (ex) {
                        console.log(ex);
                    });
                    break;

                case 'ubicacion':
                    $("btn_ubicacion").addClass("disabled");
                    this.info_agencia.ubicacion = this.marker.position.toUrlValue();
                    var post_data = { ubicacion: this.info_agencia.ubicacion };
                    this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(post_data)).then(function (response) {
                        var response_var = response.body;
                        $("btn_ubicacion").removeClass("disabled");
                        if (response_var.success == "true") {
                            this.loadInfoAgencia();
                            Swal.fire({
                                type: 'success',
                                title: "Correcto",
                                text: "Se han actualizado los datos de su agencia.",
                            });
                        } else {
                            Swal.fire({
                                type: 'error',
                                title: "¡Ops!",
                                html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                            });
                        }
                    }, function (ex) {
                        console.log(ex);
                    });
                    break;

            }
        },
        loadLandingPage: function () {
            var data = {
                'id_agencia': this.id_agencia,
            }
            this.$http.post(this.rmt_url + baseUrl + '/agencias/landingPage', data).then(function (response) {
                var response_var = response.body;
                if (response_var.outlet != null) {
                    this.landing = response_var.outlet;
                }
                this.landing.webslug = response_var.agencia.webslug;
                // console.log(this.landing);
            }, function (ex) {
                console.log(ex);
            });
        },
        updateLandingPage: function () {
            var re = / /gi;
            var limpioEspacios = this.landing.webslug.toLowerCase().replace(re, "-"); 
            var reg2 = /(\.|\-)/g;
            if (reg2.test(limpioEspacios) == true) {
                Swal.fire({
                    type: 'Error',
                    title: "Error",
                    text: "La url de su landing page tiene caracteres no permitidos.",
                });
                return false;
            }else{
                this.landing.webslug = limpioEspacios;
                var data = {
                    'AgenciasInteresadasOutlet': this.landing,
                    'id_agencia': this.id_agencia,
                }
                this.$http.post(this.rmt_url + baseUrl + '/agencias/landingPage', data).then(function (response) {
                    var response_var = response.body;
                    console.log(response_var.success);
                    if (response_var.success == true) {
                        Swal.fire({
                            type: 'success',
                            title: "Correcto",
                            text: "Se han actualizado los datos de su landing page.",
                        });
                        this.loadLandingPage();
                    } else {
                        Swal.fire({
                            type: 'error',
                            title: "¡Ops!",
                            html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                        });
                    }
                }, function (ex) {
                    console.log(ex);
                });
            }
          
        },
        uploadImage: function (tipo) {
            var data = new FormData();
            switch (tipo) {
                case "logo":
                    data.append("tipo", "logo");
                    data.append("img", this.file_logo);
                    break;

                case "pie":
                    data.append("tipo", "pie");
                    data.append("img", this.file_pie);
                    break;
            }
            data.append("id_agencia", this.id_agencia);
            this.$http.post(this.rmt_url + this.baseUrl + '/agencias/uploadImage/', data).then(function (response) {
                var response_var = response.body;
            }, function (e) {
                $("#btnSaveChanges").removeClass("disabled");
                console.log(e);
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Problema al subir la imagen. <pre><code>" + JSON.stringify(e.body) + "</pre></code>",
                });
            });
        },
        loadAgencySales: function () {
            this.$http.get(this.rmt_url + baseUrl + '/agencias/getVentasAgencia?id_agencia=' + this.id_agencia).then(function (response) {
                var response_var = response.body;
                this.ventas_agencia = response_var;
                this.num_grupos_vendidos = response_var.num_grupos_vendidos;
                this.ventas_agencia_chart.push(response_var.total_reservas);
                this.ventas_agencia_chart.push(response_var.total_activities);
                this.ventas_agencia_chart.push(response_var.total_tours);
                this.ventas_agencia_chart.push(response_var.total_grupos);
                this.ventas_agencia_chart.push(response_var.total_bodas);

                var that = this;
                var array_activities = []; var array_reservas = []; var array_tours = []; var array_bodas = []; var array_grupos = []; var array_labels = [];
                this.ventas_usuarios = response_var.ventasxUsuario;
                this.ventas_usuarios.forEach(function (element) {
                    that.ventas_usuarios_chart_reserv.push(element.total_reservas);
                    that.ventas_usuarios_chart_activities.push(element.total_activities);
                    that.ventas_usuarios_chart_tours.push(element.total_tours);
                    that.ventas_usuarios_chart_bodas.push(element.total_bodas);
                    that.ventas_usuarios_chart_grupos.push(element.total_grupos);
                    that.ventas_agencia_chart_labels.push(that.wordsToCapitalize(element.nombre_usuario));
                });

                this.printCharts();
            }, function () {
                console.log('Error');
            });
        },
        loadSalesMount: function () {
            this.$http.get(this.rmt_url + baseUrl + '/agencias/getVentasMeses?id_agencia=' + this.id_agencia + '&anio=2019').then(function (response) {
                var that = this;
                this.ventas_mes = Object.values(response.body);
                this.ventas_mes.forEach(function (element) {
                    if (element.Reservacion !== undefined) {
                        that.ventas_mes_chart_reserv.push(parseInt(element.Reservacion));
                    } else {
                        that.ventas_mes_chart_reserv.push(0);
                    }

                    if (element.Tours != undefined) {
                        that.ventas_mes_chart_tours.push(parseInt(element.Tours));
                    } else {
                        that.ventas_mes_chart_tours.push(0);
                    }

                    if (element.Activity != undefined) {
                        that.ventas_mes_chart_activities.push(parseInt(element.Activity));
                    } else {
                        that.ventas_mes_chart_activities.push(0);
                    }

                });
                this.printMoreCharts();
            }, function () {

                console.log('Error');
            });
        },
        loadGetComparative: function () {
            var years = $(".select_comparativa").val();
            years.sort(function (a, b) { return a - b });
            var vm = this;
            this.$http.post(this.rmt_url + baseUrl + '/agencias/getComparativas', {
                id_agencia: this.id_agencia, anios: $(".select_comparativa").val()
            }
            ).then(function (response) {
                reporteComparativa = response.body.comparativa_anios;

                var arrayMes_cn = new Array();
                var arrayMes_t = new Array();
                var arrayMes_res = new Array();
                for (var anios = 0; anios < years.length; anios++) {
                    var filter_cn = [];
                    var filter_res = [];
                    var filter_t = [];
                    for (var aux = 0; aux < reporteComparativa.length; aux++) {
                        filter_cn.push(reporteComparativa[aux]['CN_' + years[anios]]);
                        filter_res.push(reporteComparativa[aux]['R_' + years[anios]]);
                        filter_t.push(reporteComparativa[aux]['Total_' + years[anios]]);
                    }
                    arrayMes_cn[anios] = {
                        "name": years[anios],
                        "type": 'bar',
                        "data": filter_cn
                    }

                    arrayMes_res[anios] = {
                        "name": years[anios],
                        "type": 'bar',
                        "data": filter_res
                    }

                    arrayMes_t[anios] = {
                        "name": years[anios],
                        "type": 'bar',
                        "data": filter_t
                    }

                }
                var graphsComparativas = document.getElementById("graphsComparativasR");
                chartsComparativas = echarts.init(graphsComparativas);
                tipoComparativa = "Reservaciones";
                var optionComparativas = getOptionComparativa(years, arrayMes_res, tipoComparativa);
                chartsComparativas.resize({
                    width: 1050,
                    height: 350
                });
                chartsComparativas.setOption(optionComparativas, true);

                //    var graphsComparativasCN = document.getElementById("graphsComparativasCN");
                //    chartsComparativasCN = echarts.init(graphsComparativasCN);
                //    tipoComparativa = "Cuartos/Noches";
                //    var optionComparativasCN = getOptionComparativa(years,arrayMes_cn,tipoComparativa);
                //    chartsComparativasCN.resize({
                //     width: 1050,
                //     height: 350
                // });
                //    chartsComparativasCN.setOption(optionComparativasCN,true);

                var graphsComparativasTotales = document.getElementById("graphsComparativasTotal");
                chartsComparativasTotales = echarts.init(graphsComparativasTotales);
                tipoComparativa = "Importe Total de Reservaciones";
                var optionComparativasTotales = getOptionComparativa(years, arrayMes_t, tipoComparativa);
                chartsComparativasTotales.resize({
                    width: 1050,
                    height: 350
                });
                chartsComparativasTotales.setOption(optionComparativasTotales, true);

            }, function () {
                console.log('Error');
            });
        },
        loadGetVentasAgencia: function () {
            var vm = this;
            this.$http.post(this.rmt_url + baseUrl + '/agencias/balanceAgencia', {
                id_agencia: this.id_agencia, fechaInicial: this.fecha_inicial_ventas, fechaFinal: this.fecha_final_ventas
            }
            ).then(function (response) {
                reportemes_actual = response.body.desglose_actual;
                this.createTableAgencia(reportemes_actual);
            }, function () {
                console.log('Error');
            });
        },
        createTableAgencia: function (reporte) {

            var vm = this;
            var optionDom = "<'dt_colVis_buttons'B><'dt-header'<'row'<'col-6'l><'col-6'f>>>tipr";
            var optionButton = [
                {
                    extend: 'excel',
                    text: 'Excel',
                },
                { extend: 'colvis', text: 'Columnas' }
            ];
            var lenguaje = language();
            var tableOptions = {
                destroy: true,
                sDom: optionDom,
                buttons: optionButton,
                language: lenguaje,
                columnDefs: [
                    { targets: [3, 4], className: 'dt-body-right', width: "11%", render: $.fn.dataTable.render.number(',', '.', 2, '$') },
                    { targets: [7], className: 'dt-body-right', width: "11%" },
                    { targets: [0, 5, 6], className: 'dt-body-right', width: "11%", render: function (data) { return moment(data).format('DD/MM/YYYY'); } },
                    { targets: [0, 1, 3, 4, 7], className: 'dt-body-right' },
                ]
            };

            vm.tablaComparativaAgencia = $('#dt_tablaAgencias').DataTable(tableOptions);
            var tablaDatosAgencias = vm.tablaComparativaAgencia;
            tablaDatosAgencias.clear();
            var comision_total = 0;
            var total = 0;

            if (reporte !== null) {

                Object.keys(reporte).forEach(function (key) {
                    total += parseFloat(reporte[key].total);
                    comision_total += parseFloat(reporte[key].comision_agencia);

                    tablaDatosAgencias.row.add([
                        reporte[key].log,
                        '<a href=' + this.rmt_url + baseUrl + '/reservacion/view/' + reporte[key].id_reservacion + ' target="_blank">' + reporte[key].id_reservacion + '</a>',
                        reporte[key].nombre_hotel,
                        reporte[key].total,
                        reporte[key].comision_agencia,
                        reporte[key].checkint,
                        reporte[key].checkout,
                        reporte[key].cuartos_noches
                    ]).draw(false)
                });
            } else {
                tablaDatosAgencias.clear().draw();
            }

            this.totalAgencia = '$' + parseFloat(total).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + ' MXN';
            this.comisionAgencia = '$' + parseFloat(comision_total).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + ' MXN';

            $('table').removeClass('dataTable');

        },
        saveShowSales: function (estatus) {
            if (estatus == "1") {
                var post_data = { show_sales: 0 };
            } else {
                var post_data = { show_sales: 1 };
            }
            var url_usuarios = this.api_url + 'usuariosRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=}]';
            this.$http.put(this.api_url + "agenciasRest/" + this.info_agencia.id_agencia, JSON.stringify(post_data)).then(function (response) {
                this.info_agencia.show_sales = response.body.data.agenciasRest.show_sales;
                console.log(response);
            }, function (ex) {
                console.log(ex);
            });
        },
        changestatus: function (id, index) {
            this.$http.get(this.rmt_url + baseUrl + '/usuariosRest/delete?id=' + id).then(function (response) {
                console.log(response.body);
                this.array_users[index].estatus = response.body;
                Swal.fire({
                    type: 'success',
                    title: "Correcto",
                    text: "Se han actualizado los datos de su agencia.",
                });

            }, function (ex) {
                Swal.fire({
                    type: 'error',
                    title: "Ops!",
                    text: "No se a podido actualizar el estatus del usuario.",
                });
            });
        },
        modalUser: function (index) {
            this.index = index;

            appUser.loadUser(index);

            $('#modalusuario').modal('show');
        },
        printMoreCharts: function () {
            var labels = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
            var bookingDonut = document.getElementById("barMonthBooking").getContext('2d');
            var bookingChart = new Chart(bookingDonut, {
                type: 'bar',

                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Reservaciones',
                        backgroundColor: 'rgb(75, 192, 192)',//Verde
                        data: this.ventas_mes_chart_reserv,
                    }, {
                        label: 'Activities',
                        backgroundColor: 'rgb(153, 102, 255)',//Morado
                        data: this.ventas_mes_chart_activities,
                    }, {
                        label: 'Tours',
                        backgroundColor: 'rgb(255, 206, 86)',
                        data: this.ventas_mes_chart_tours,
                    }]
                },
                options: {
                    responsive: true,
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: true,
                        padding: 20,
                        fontSize: 20,
                        text: 'Reservaciones, Tours, Activity por Mes'
                    },
                    animation: {
                        animateScale: true,
                        animateRotate: true
                    },
                    tooltips: {
                        mode: 'index',
                        intersect: false,
                    },
                    scales: {
                        xAxes: [{
                            stacked: true,
                        }],
                        yAxes: [{
                            stacked: true
                        }]
                    }
                }
            });

        },
        printCharts: function () {
            var ctxDonut = document.getElementById("donutChart").getContext('2d');
            var donutChart = new Chart(ctxDonut, {
                type: 'doughnut',
                data: {
                    datasets: [{
                        data: this.ventas_agencia_chart,
                        num_grupos_vendidos: this.num_grupos_vendidos,
                        backgroundColor: [
                            'rgb(75, 192, 192)',
                            'rgb(54, 162, 235)',
                            'rgb(255, 206, 86)',
                            'rgb(153, 102, 255)',
                            'rgb(255, 99, 132)',
                        ],
                        label: 'Dataset 1'
                    }],
                    labels: [
                        'Reservaciones ' + '$ ' + this.ventas_agencia.total_reservas.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + ' MXN',
                        'Activities ' + '$ ' + this.ventas_agencia.total_activities.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + ' MXN',
                        'Tours ' + '$ ' + this.ventas_agencia.total_tours.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + ' MXN',
                        'Grupos ' + '$ ' + this.ventas_agencia.total_grupos.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + ' MXN',
                        'Bodas ' + '$ ' + this.ventas_agencia.total_bodas.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + ' MXN'
                    ]
                },
                options: {
                    responsive: true,
                    legend: {
                        position: 'right',
                    },
                    title: {
                        display: true,
                        padding: 20,
                        fontSize: 20,
                        text: 'Distribución de ventas totales'
                    },
                    animation: {
                        animateScale: true,
                        animateRotate: true
                    },
                    tooltips: {
                        callbacks: {
                            label: function (tooltipItem, data) {
                                var label = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];
                                if (tooltipItem.index == 3) {
                                    label = "$ " + label.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + " MXN " + data.datasets[tooltipItem.datasetIndex].num_grupos_vendidos + " grupos"
                                } else {
                                    label = "$ " + label.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + " MXN ";
                                }
                                return label;
                            }
                        }
                    }
                }
            });

            var ctxBar = document.getElementById("barChart").getContext('2d');
            var barChart = new Chart(ctxBar, {
                type: 'bar',
                data: {
                    labels: this.ventas_agencia_chart_labels,
                    datasets: [{
                        label: 'Reservaciones',
                        backgroundColor: 'rgb(75, 192, 192)',//Verde
                        data: this.ventas_usuarios_chart_reserv,
                    }, {
                        label: 'Activities',
                        backgroundColor: 'rgb(54, 162, 235)',
                        data: this.ventas_usuarios_chart_activities,
                    }, {
                        label: 'Tours',
                        backgroundColor: 'rgb(255, 206, 86)',
                        data: this.ventas_usuarios_chart_tours,
                    }, {
                        label: 'Grupos',
                        backgroundColor: 'rgb(153, 102, 255)',//Morado
                        data: this.ventas_usuarios_chart_grupos,
                    }, {
                        label: 'Bodas',
                        backgroundColor: 'rgb(255, 99, 132)',//Rosado
                        data: this.ventas_usuarios_chart_bodas,
                    }]
                },
                options: {
                    title: {
                        display: true,
                        padding: 20,
                        fontSize: 20,
                        text: 'Ventas por usuario'
                    },
                    tooltips: {
                        mode: 'index',
                        intersect: false,
                        callbacks: {
                            label: function (tooltipItem, data) {
                                var label = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];
                                label = "$ " + label.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + " MXN";
                                return label;
                            }
                        }
                    },
                    responsive: true,
                    scales: {
                        xAxes: [{
                            stacked: true,
                        }],
                        yAxes: [{
                            stacked: true
                        }]
                    }
                }
            });
        },
        setState: function (selectedOption, id) {
            this.info_agencia.id_estado_agencia = selectedOption.id_estadosmex;
        },
        setStateLanding: function (selectedOption, id) {
            this.landing.estado = selectedOption.nombreestado;
        },
        setCountry: function (selectedOption, id) {
            this.info_agencia.id_pais_agencia = selectedOption.id_pais;
        },
        findState: function () {
            var that = this;
            var filterState = this.array_states.filter(function (state) {
                return state.id_estadosmex === that.info_agencia.id_estado_agencia;
            });
            this.stateLoad = filterState[0];
        },
        findStateLoading: function () {
            var that = this;
            // console.log(that.landing);
            var filterState = this.array_states.filter(function (state) {
                return state.nombreestado === that.landing.estado;
            });
            this.stateLoadLanding = filterState[0];
        },
        findCountry: function () {
            var that = this;
            var filterCountry = this.array_countries.filter(function (country) {
                return country.id_pais === that.info_agencia.id_pais_agencia;
            });
            this.countryLoad = filterCountry[0];
        },
        initMap: function () {
            if (this.info_agencia.ubicacion == null || this.info_agencia.ubicacion == '') {
                this.uluru = { lat: -25.344, lng: 131.036 };

                var that = this;
                navigator.geolocation.getCurrentPosition(function (position) {
                    this.uluru = { lat: position.coords.latitude, lng: position.coords.longitude };

                    this.map = new google.maps.Map(
                        document.getElementById('map'), {
                        zoom: 13, center: this.uluru
                    });
                    that.marker = new google.maps.Marker({ position: this.uluru, map: this.map, draggable: true, animation: google.maps.Animation.DROP });
                });
            } else {
                var array_ubicacion = this.info_agencia.ubicacion.split(",");
                this.uluru = { lat: parseFloat(array_ubicacion[0]), lng: parseFloat(array_ubicacion[1]) };
                this.map = new google.maps.Map(
                    document.getElementById('map'), {
                    zoom: 13, center: this.uluru
                });
                this.marker = new google.maps.Marker({ position: this.uluru, map: this.map, draggable: true, animation: google.maps.Animation.DROP });
            }
        },
        tipo: function (tipo) {
            var rols = "";
            switch (tipo) {
                case 'agv':
                    rols = 'Agente de venta';
                    break;
                case 'aga':
                    rols = 'Administrador agencia';
                    break;
                default:
                    rols = 'Propietario agencia';
                    break;
            }
            return rols;
        },
        parseDate: function (date, format) {
            return moment(date).format(format);
        },
        wordsToCapitalize: function (str) {
            var splitStr = str.toLowerCase().split(' ');
            for (var i = 0; i < splitStr.length; i++) {
                // You do not need to check if i is larger than splitStr length, as your for does that for you
                // Assign it back to the array
                splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);
            }
            // Directly return the joined string
            return splitStr.join(' ');
        },
        initComponents: function () {
            $(function () {
                $('[data-toggle="tooltip"]').tooltip();
            });

            bsCustomFileInput.init();
        },
        onloadImg: function (img) {
            switch (img) {
                case 'logo':
                    this.file_logo = event.target.files[0];
                    this.img_logo = URL.createObjectURL(this.file_logo);
                    this.info_agencia.logotipo = event.target.files[0].name;
                    if (this.error_logo) this.error_logo = false;
                    break;

                case 'pie':
                    this.file_pie = event.target.files[0];
                    this.img_pie = URL.createObjectURL(this.file_pie);
                    this.info_agencia.pie_flyer = event.target.files[0].name;
                    break;
            }
        },
        test_method: function () {
            console.log(event.target.value);
        },
        eliminarPieFlyer: function () {

            this.$http.get(this.rmt_url + '/sur4/agencias/eliminarPie/' + this.id_agencia).then(function (response) {
                var response_var = response.body;
                this.pieflyer_switch = false;
                this.loadInfoAgencia();
                console.log(response);
            }, function (ex) {
                console.log(ex);
            });
            // this.$http.get(encodeURI('/promociones/tarifa/getPromos?p=agenciasRest?filter=[{"property":"estatus","value":"A","operator":"="},{"property":"verificada","value":"1","operator":"="}]'))
            // .then(function (response) {

            //     this.busqueda_nombre = ''
            //     this.array_agencias = response.body.data.agenciasRest;
            // }, function () {
            //     console.log('Error');
            //     this.msj = "Hubo un problema";
            // });
        }
    },
    watch: {
        error_logo: function (val) {
            if (val) {
                $("#btn_logo").attr('disabled', 'disabled');
            } else {
                $("#btn_logo").prop("disabled", false);
            }
        }
    }
});

$('.select_comparativa').select2();

function getOptionComparativa(years, arrayAnios, tipoComparativa) {
    var optionComparativas = {
        title: {
            text: 'Comparación',
            subtext: tipoComparativa + ' por Mes',
        },
        tooltip: {
            trigger: 'axis',
        },
        legend: {
            data: years,
        },
        toolbox: {
            show: true,
            feature: {
                magicType: { show: true, type: ['line', 'bar'] },
                saveAsImage: { show: true }
            }
        },
        calculable: true,
        xAxis: [
            {
                type: 'category',
                data: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
                axisLabel: {
                    rotate: 90,
                    interval: 0
                },
                splitLine: { show: true },
            }
        ],
        yAxis: [
            {
                type: 'value'
            }
        ],
        series: arrayAnios
    };

    return optionComparativas;
}

function callbackSales(start, end) {
    $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    appAgencia.fecha_inicial_ventas = start.format('YYYY-MM-DD');
    appAgencia.fecha_final_ventas = end.format('YYYY-MM-DD');
    appAgencia.loadGetVentasAgencia();
}

function cb(start, end) {
    $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
}

$('#reportrange').daterangepicker({
    startDate: start,
    endDate: end,
    'showDropdowns': true,
    ranges: {
        'Mes Actual': [moment().startOf('month'), moment()],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment()]
    },
    locale: {
        direction: 'ltr',
        format: 'MM/DD/YYYY HH:mm',
        separator: ' - ',
        applyLabel: 'Aplicar',
        cancelLabel: 'Cancelar',
        fromLabel: 'De',
        toLabel: 'A',
        customRangeLabel: 'Periodo de Fechas',
        daysOfWeek: ['Sa', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sa'],
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        firstDay: 1
    },
    'applyClass': 'btn-button btn-button-success',
    'cancelClass': 'btn-button btn-button-danger'
}, callbackSales);

callbackSales(start, end);
//////modalUser/////
var appUser = new Vue({
    el: '#modalusuario',
    data: {
        rol: rol,
        user: [],
        tipo_usuario: tipo_usuario,
        array_tipos: [],
        aviso: [
            {
                id: 'b',
                name: 'Bloqueos',
            },
            {
                id: 'h',
                name: 'habitaciones',
            },
            {
                id: 'r',
                name: 'Reservaciones',
            }
        ],
        userAviso: [],
        newAviso: [],
        confirma_clave: "",
        index: null,
        fecha_nacimiento: "",

    },
    /*created: function() {
       this.loadUser();

   },*/
    methods: {
        loadUser: function (index) {
            if (index !== null) {
                this.index = index;
                this.user = appAgencia.array_users[this.index];
                this.user.fecha_nacimiento = this.formatDate(this.user.fecha_nacimiento, 'DD/MM/YYYY');
                this.confirma_clave = this.user.clave_usuario;
                console.log(typeof this.user.aviso);
                if (typeof this.user.aviso == 'string') {
                    this.userAviso = this.user.aviso.split(',');
                }
            } else {
                this.user = [];
                this.confirma_clave = "";
                this.userAviso = [];
            }
            if (this.tipo_usuario == "Admon") {
                this.array_tipos = [{ id: 'ag', name: 'Propietario Agencia' }, { id: 'agv', name: 'Agente de Ventas' }, { id: 'vo', name: 'Ventas Ruta Maya' }, { id: 'vgb', name: 'Ventas Grupos Y Bodas' }, { id: 'su', name: 'Super Usuario' }, { id: 'sa', name: 'Super Admin' }];
            } else {
                if (this.rol != "agv") {
                    this.array_tipos = [{ id: 'ag', name: 'Propietario Agencia' }, { id: 'aga', name: 'Administrador de agencia' }, { id: 'agv', name: 'Agente de Ventas' }];
                } else {
                    this.array_tipos = [{ id: 'agv', name: 'Agente de Ventas' }];
                }
            }
        },
        formatDate: function (date, format = false) {
            if (format === false) {
                return moment(date, 'DD.MM.YYYY').format(format);
            }
            return moment(date).format(format);
        },
        findArray: function (letra) {
            return $.inArray(letra, this.userAviso);
        },
        tipo: function (tipo) {
            return appAgencia.tipo(tipo);
        },
        crearUser: function (action) {
            this.user.aviso = this.userAviso;
            if (this.fecha_nacimiento) {
                this.user.fecha_nacimiento = this.fecha_nacimiento;
            } else {

                this.user.fecha_nacimiento = this.formatDate(this.user.fecha_nacimiento);
            }

            if ($("#confirma_clave").val() != $("#Usuarios_clave_usuario").val()) {
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Las contraseñas no coinciden!",
                });
                return false;
            } else if ($("#confirma_clave").val() == "" || !this.user.tipo_usuario || $("#Usuarios_email_usuario").val() == "" || $("#Usuarios_nombre_usuario").val() == "") {
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Completa los Campos obligatorios '*' ",

                });
                return false;
            }

            if (action == "crear") {
                this.$http.post(appAgencia.rmt_url + baseUrl + '/usuarios/create', { Usuarios: this.user, agencia_id: appAgencia.id_agencia }).then(function (response) {
                    this.user = response.body;
                    Swal.fire({
                        type: 'success',
                        title: "¡Ops!",
                        html: "Usuario Creado",
                    });
                }, function () {
                    Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        html: "Problemas al crear usuario",
                    }, function () {
                        this.user = response.body;
                        this.user.fecha_nacimiento = this.formatDate(this.user.fecha_nacimiento, 'DD/MM/YYYY');

                        $('#modalusuario').modal('hide');
                        location.href = appAgencia.rmt_url + baseUrl + '/agencias/perfil?user=1';
                    });

                });
            } else {
                this.$http.post(appAgencia.rmt_url + baseUrl + '/usuarios/update/id/' + this.user.id_usuario, { Usuarios: this.user, agencia_id: appAgencia.id_agencia }).then(function (response) {
                    Swal.fire({
                        type: 'success',
                        title: "¡Correcto!",
                        html: "Info actualizada",
                    }).then((result) => {
                        if (result.value) {
                            //this.user=response.body;
                            //this.user.fecha_nacimiento=this.formatDate(this.user.fecha_nacimiento,'DD/MM/YYYY');

                            $('#modalusuario').modal('hide');
                            //location.href=appAgencia.rmt_url + baseUrl +'/agencias/perfil?user=1';
                            appAgencia.loadUsers();
                        }
                    });

                }, function () {
                    Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        html: "Problemas al crear usuario",
                    });
                });
            }
        },
    }
});