Vue.http.options.emulateJSON = true;

if (typeof tipo==undefined ) {
     var tipo='';
}
var appGrupos = new Vue({
    el: "#group_vue",
    data: {
        tipo:tipo,
        id_agencia: id_agencia,
        rmt_url: rmt_url,
        api_url: rmt_url + "/api/",
        novios:"",
        array_grupos: [],
        vigenteBloqueo: [],
        historialBloqueo: [],
        loading_grupos: true,
        historial_grupos: null,
        length_grupos : 0, 

        nombre_hotel: "",
        tipo_habitacion: "",
        order_start_date: "newest",
        option_order: [
        { text: 'Fechas Próximas', value: 'newest' },
        { text: 'Fechas Futuras', value: 'future' },
        ]
    },
    created: function(){
        this.loadGrupos();
    },
    methods:{
        loadGrupos: function() {
          
            var url = this.rmt_url + "/bloqueos/getGrupos?id_agencia="+this.id_agencia
            if (this.tipo=='BODA') {
                url=url+'&tipo='+tipo;
            }
            this.$http.get(url).then(function(response) {
                this.array_grupos = response.body;
                // console.log(this.array_grupos);
                var vm = this;
                vm.array_grupos.forEach(function(element, index) {
                    if (element.vigente==true) {
                        vm.vigenteBloqueo.push(vm.array_grupos[index]);
                    }else if(element.historial==true){
                        vm.historialBloqueo.push(vm.array_grupos[index]);
                    }
                });
                    // console.log(vm.historialBloqueo);
                    // console.log(vm.vigenteBloqueo);
                this.loading_grupos = false;
                this.initChecks();
            }, function() {
                console.log('Error');
            });
        },
        getImageBoda: function(id_bloqueo) {
            aux_array = this.array_grupos.filter(item => {
                return item.info.id_bloqueo == id_bloqueo;
            });
            if(aux_array[0].hotel.proveedor == 1) {
                url = "https://photos.hotelbeds.com/giata/bigger/";
            } else if(aux_array[0].hotel.proveedor == 3) {
                url = "";
            } else {
                url = "https://rutamayatravel.com/imagenes/";
            }

            img_boda = aux_array[0].fotos.filter(item => {
                return item.boda == 1;
            })
            if(img_boda.length > 0) {
                return url + img_boda[0].foto;
            }
            return url + aux_array[0].fotos[0].foto;
        },
        initChecks: function() {
            $('input').iCheck({
                checkboxClass: 'icheckbox_square-grey',
                radioClass: 'iradio_square-grey'
            }).on('ifChecked ifUnchecked', function(){
                $(this)[0].dispatchEvent(new Event("change"));
            });
        },
        parseDate: function(date) {
            return moment(date).format('DD/MM/YYYY');
        },
    },
    computed: {
    	filteredGroups() {
            var that = this;
            var array_grupos = this.vigenteBloqueo;
            // console.log(array_grupos);
            // console.log(this.historialBloqueo);
            // console.log(this.array_grupos);
            // if (this.tipo=="BODA") {
            //     array_grupos = this.array_grupos;
            // }
            if (this.historial_grupos==true) {
                array_grupos = this.historialBloqueo;
                this.option_order[0].text = 'Más Antiguas';
                this.option_order[1].text = 'Más Recientes';
                // console.log(this.option_order[0].text);
            }else{
                this.option_order[0].text = 'Fechas Próximas';
                this.option_order[1].text = 'Fechas Futuras';
            }

    		if(this.order_start_date == "newest" || this.order_start_date == '') {
    			array_grupos.sort(function(a, b) {
    				a = new Date(a.info.fecha_inicio);
    				b = new Date(b.info.fecha_inicio);
    				return a > b ? 1 : a < b ? -1 : 0;
				});
    		} else {
    			array_grupos.sort(function(a, b) {
    				a = new Date(a.info.fecha_inicio);
    				b = new Date(b.info.fecha_inicio);
    				return a > b ? -1 : a < b ? 1 : 0;
				});
    		}
            this.length_grupos = array_grupos.length;
            
            if (this.tipo!="BODA") {
                return array_grupos.filter(hotel => { 
                    return hotel.hotel.nombre_hotel.toLowerCase().includes(this.nombre_hotel.toLowerCase());
                })
            }else{
                return array_grupos.filter(hotel => { 
                    return hotel.hotel.nombre_hotel.toLowerCase().includes(this.nombre_hotel.toLowerCase());
                }).filter(info=>{
                    return info.info.novios.toLowerCase().includes(this.novios.toLowerCase());
                });
            }


    		
    	},
    },
});