Vue.component('v-multiselect', window.VueMultiselect.default);
Vue.http.options.emulateJSON = true;

var appCotizador = new Vue({
    el: '#modal_cotiz',
    data: {
        rmt_url: rmt_url,
        options_edad_menores: [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17],
        hdp: false,

        //v-multiselect hotels
        options_destinos_hotels: [],
        isLoading_hotels: false,
        model_destino_hotels: '',

        //form hoteles
        num_habs: 1,
        array_hab_hotels: [],
        rango_estancia_hotels: moment().format("DD/MM/YYYY") +  " - " + moment().add(3, 'days').format("DD/MM/YYYY"),
        array_estancia_hotels: {
            fecha_entrada: moment().format("DD/MM/YYYY"),
            fecha_salida: moment().add(3, 'days').format("DD/MM/YYYY"),
        },

        //v-multiselect activities
        options_destinos_activities: [],
        isLoading_activities: false,
        model_destino_activities: '',
        model_code_activities: 0,
        model_destinationcode_activities: 0,

        //form activities
        array_hab_activities: {
            num_adultos: 2,
            num_menores: 0,
            edad_menores: []
        },
        rango_estancia_activities: moment().format("DD/MM/YYYY") +  " - " + moment().add(3, 'days').format("DD/MM/YYYY"),

        //v-multiselect tours
        options_destinos_tours: [],
        isLoading_tours: false,
        model_code_tours: 0,
        model_destino_tours: '',

        //form activities
        array_hab_tours: {
            num_adultos: 2,
            num_menores: 0,
            edad_menores: []
        },
        estancia_tours: moment().add(3, 'days').format("DD/MM/YYYY"),
        min_date: moment().format("DD/MM/YYYY"),

        //------------------------------------------------------------------------------------
        agencia_usuario: agencia_usuario,
        id_usuario: id_usuario,
    },
    created: function() {
        this.initOptions();
        this.loadDestinationsTours();
    },
    methods: {
        opHab: function(op) {
            switch(op) {
                case "add":
                    if(this.num_habs < 5) {
                        this.num_habs++;
                        this.array_hab_hotels.push({
                            no_hab: this.num_habs,
                            num_adultos: 2,
                            num_menores: 0,
                            edad_menores: []
                        });
                    }
                break;

                case "subs":
                    if(this.num_habs > 1) {
                        this.num_habs--;
                        this.array_hab_hotels.pop();
                    }
                break;                
            }
        },
        opPaxHabs: function(op, pax, hab) {
            switch(op) {
                case "add":
                    if(pax == "adult") {
                    	if(hab.num_adultos < 8) {
                        	hab.num_adultos++;
                        }
                    } else {
                        if(hab.num_menores < 5) {
                        	hab.num_menores++;
                        	hab.edad_menores.push({ 
                        		edad: 0,
                        		no_menor: hab.num_menores,
                        	});
                        }
                    }
                    break;

                case "subs":
                    if(pax == "adult") {
                    	if(hab.num_adultos > 1) {
                        	hab.num_adultos--;
                    	}
                    } else {
                        if(hab.num_menores > 0) {
                        	hab.num_menores--;
                        	hab.edad_menores.pop();
                        }
                    }
                    break;
            }
        },
        opPaxActTour: function(op, pax, arr) {
        	if(arr == "tour") {
                if(pax == "adult") {
                    if(op == "add") {
                        if(this.array_hab_tours.num_adultos < 8) {
                            this.array_hab_tours.num_adultos++;
                        }
                    } else {
                        if(this.array_hab_tours.num_adultos > 1) {
                            this.array_hab_tours.num_adultos--;
                        }
                    }
                } else {
                    var that = this;
                    if(op == "add") {
                        if(this.array_hab_tours.num_menores < 5) {
                            this.array_hab_tours.num_menores++;
                            this.array_hab_tours.edad_menores.push({
                                no_menor: that.array_hab_tours.num_menores,
                                edad: 0,
                            });
                        }
                    } else {
                        if(this.array_hab_tours.num_menores > 0) {
                            this.array_hab_tours.num_menores--;
                            this.array_hab_tours.edad_menores.pop();
                        }
                    }
                }
        	} else {
        		if(pax == "adult") {
        			if(op == "add") {
        				if(this.array_hab_activities.num_adultos < 8) {
        					this.array_hab_activities.num_adultos++;
        				}
        			} else {
        				if(this.array_hab_activities.num_adultos > 1) {
        					this.array_hab_activities.num_adultos--;
        				}
        			}
        		} else {
        			var that = this;
        			if(op == "add") {
        				if(this.array_hab_activities.num_menores < 5) {
	        				this.array_hab_activities.num_menores++;
	        				this.array_hab_activities.edad_menores.push({
	        					no_menor: that.array_hab_activities.num_menores,
	        					edad: 0,
	        				});
	        			}
        			} else {
        				if(this.array_hab_activities.num_menores > 0) {
	        				this.array_hab_activities.num_menores--;
	        				this.array_hab_activities.edad_menores.pop();
	        			}
        			}
        		}
        	}
        },
        initOptions: function() {
            this.options_destinos_hotels = JSON.parse(localStorage.getItem("options_hoteles"));
            this.model_destino_hotels = JSON.parse(localStorage.getItem("selected_option_hotel"));

            var front_form_var = JSON.parse(front_form);
            this.num_habs = parseInt(front_form_var.habs)
            var that = this;
            for (var i = 1; i <= parseInt(front_form_var.habs); i++) {
                var item = front_form_var["habitacion_" + i];
                that.array_hab_hotels.push({
                    no_hab: i,
                    num_adultos: parseInt(item.adultos),
                    num_menores: parseInt(item.num_ninios),
                    edad_menores: [],
                });

                if(parseInt(item.num_ninios) > 0) {
                    for (var j = 1; j <= parseInt(item.num_ninios); j++) {
                        that.array_hab_hotels[i - 1].edad_menores.push({
                            edad: item["edad_" + j],
                            no_menor: j,
                        });
                    }
                }
            }
            this.rango_estancia_hotels = front_form_var.fecha_ini + " - " + front_form_var.fecha_fin;
            this.array_estancia_hotels.fecha_entrada = front_form_var.fecha_ini;
            this.array_estancia_hotels.fecha_salida = front_form_var.fecha_fin;

            var destino;
            switch(this.model_destino_hotels.Tipo) {
                case "Hotel":
                    destino = "h_" + this.model_destino_hotels.Codigo;
                    break;

                case "Destino":
                    destino = "d_" + this.model_destino_hotels.Codigo;
                    break;

                case "Zona":
                    destino = "z_" + this.model_destino_hotels.Codigo;
                    break;
            }
            $("#destino_hotels").val(destino);
        },
        toggleInput: function() {
        	element = event.currentTarget;
        	id = element.getAttribute('id');
            if(this.hdp == false) {
                $("#datepicker-dp_estancia_activities_web").toggle();
                $(".datepicker__inner").toggle();
                this.hdp = true;
            }
        },
        initOptionsHotels: function() {
            this.options_destinos_hotels = [];
            this.options_destinos_hotels.push({
                tipo_destino: "Destinos",
                opciones: [],
            });

            this.options_destinos_hotels.push({
                tipo_destino: "Zonas",
                opciones: [],
            });

            this.options_destinos_hotels.push({
                tipo_destino: "Hoteles",
                opciones: [],
            });
        },
        loadDestinationsHotels: function(query) {
            this.initOptionsHotels();
            if(query.length >= 3) {
                this.isLoading_hotels = true;
                this.$http.get(encodeURI(this.rmt_url + '/busqueda/busquedaDestinos?destino=' + query), {
                    before(request) {
                        // abort previous request, if exists
                        if (this.previousRequest) {
                            this.previousRequest.abort();
                        }
                        // set previous request on Vue instance
                        this.previousRequest = request;
                    }
                }).then(function(response) {
                    var response_var = response.body;
                    var array_destinos = response_var;
                    var that = this;
                    array_destinos.forEach(function(element){
                        switch(element.Tipo) {
                            case "Hotel":
                                that.options_destinos_hotels[2].opciones.push(element);
                                break;

                            case "Zona":
                                that.options_destinos_hotels[1].opciones.push(element);
                                break;

                            case "Destino":
                                that.options_destinos_hotels[0].opciones.push(element);
                                break;
                        }
                    });
                    this.isLoading_hotels = false;
                }, function() {
                    console.log('Error');
                });
            }
        },
        setDestinoHotels: function(selectedOption, id) {
            var destino;
            switch(selectedOption.Tipo) {
                case "Hotel":
                    destino = "h_" + selectedOption.Codigo;
                    break;

                case "Destino":
                    destino = "d_" + selectedOption.Codigo;
                    break;

                case "Zona":
                    destino = "z_" + selectedOption.Codigo;
                    break;
            }
            $("#destino_hotels").val(destino);

            sessionStorage.setItem("paisVal", "MX");
            sessionStorage.setItem("paisText", "México");
            sessionStorage.setItem("destinoText", selectedOption.Nombre);
            sessionStorage.setItem("destinoVal", destino);
            sessionStorage.setItem("tituloDestino", selectedOption.Nombre);
            localStorage.setItem("options_hoteles", JSON.stringify(this.options_destinos_hotels));
            localStorage.setItem("selected_option_hotel", JSON.stringify(selectedOption));
        },
        loadDestinationsActivities: function(query) {
        	if(query.length >= 3) {
        		this.isLoading_activities = true;
        		this.$http.get(encodeURI(this.rmt_url + '/busqueda/busquedaDestinosActivities?query=' + query), {
	           		before(request) {
		            	// abort previous request, if exists
		            	if (this.previousRequest) {
		            		this.previousRequest.abort();
		            	}
		            	// set previous request on Vue instance
		            	this.previousRequest = request;
		            }
		        }).then(function(response) {
	                var response_var = response.body;
                    this.options_destinos_activities = response_var;
		            this.isLoading_activities = false;
	            }, function() {
	                console.log('Error');
	            });
        	}
        },
        setDestinoActivities: function(selectedOption, id) {
            this.model_code_activities = selectedOption.code;
            this.model_destinationcode_activities = selectedOption.destinationcode;
        },
        loadDestinationsTours: function() {
            var options = sessionStorage.getItem("opt_tours");
            this.options_destinos_tours = JSON.parse(options);
            /*var that = this;
            this.options_destinos_tours.push({
                tipo_destino: "Tours",
                opciones: [],
            });

            this.options_destinos_tours.push({
                tipo_destino: "Categoría",
                opciones: [],
            });
            this.$http.get(this.rmt_url + '/busqueda/busquedaDestinosTours').then(function(response){
                var response_tours = response.body;
                response_tours.forEach(function(element){
                    switch(element.tipo) {
                        case "tour":
                            that.options_destinos_tours[0].opciones.push(element);
                            break;

                        case "tipo":
                            that.options_destinos_tours[1].opciones.push(element);
                            break;
                    }
                });
            }, function(){
                console.log('Error');
            });*/
        },
        setDestinoTours: function(selectedOption, id) {
            var destino;
            switch(selectedOption.tipo) {
                case "tour":
                    this.model_code_tours = "t_" + selectedOption.codigo;
                    break;

                case "tipo":
                    this.model_code_tours = "c_" + selectedOption.codigo;
                    break;
            }
        },
        setFechaEntradaTours: function() {
            this.estancia_tours = $("#bookingdate").val();
        },
    }
});

var dp_hotels = document.getElementById('dp_hotels');
var dp_activities = document.getElementById('dp_activities');
var settings_dp = {
    format: 'DD/MM/YYYY',
    startOfWeek: 'sunday',
    i18n: {
        night: 'Noche',
        nights: 'Noches',
        button: 'Cerrar',
        'day-names-short': ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab'],
        'day-names': ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        'month-names-short': ['Ene', 'Feb', 'Mar', 'Abr', 'Mar', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        'month-names': ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        'info-more': 'Por favor seleccione la fecha de su estancia'
    },
    moveBothMonths: true
};
var datepicker_hotels = new HotelDatepicker(dp_hotels, settings_dp);
var datepicker_activities = new HotelDatepicker(dp_activities, settings_dp);

dp_hotels.addEventListener('afterClose', function () {
    appCotizador.rango_estancia_hotels = $("#dp_hotels").val();
    var rango = appCotizador.rango_estancia_hotels.split("-");
    appCotizador.array_estancia_hotels.fecha_entrada = rango[0].replace(/\s/g, "");
    appCotizador.array_estancia_hotels.fecha_salida = rango[1].replace(/\s/g, "");
    /*$("#fecha_entrada").val(rango[0].replace(/\s/g, ""));
    $("#fecha_salida").val(rango[1].replace(/\s/g, ""));*/
}, false);

dp_activities.addEventListener('afterClose', function () {
    appCotizador.rango_estancia_activities = $("#dp_activities").val();
    var rango = appCotizador.rango_estancia_activities.split("-");
    $("#fecha_entrada_activities").val(rango[0].replace(/\s/g, ""));
    $("#fecha_salida_activities").val(rango[1].replace(/\s/g, ""));
}, false);

$(document).ready(function() {
    $("#datedropper-0").css("z-index", "999999");
});

$('body').on('change', '#bookingdate', function() {
    appCotizador.estancia_tours = $(this).val();
});