Vue.component('v-multiselect', window.VueMultiselect.default);
Vue.http.options.emulateJSON = true;

var appHoteles = new Vue({
    el: '#hoteles',
    data: {
        num_habs: 1,
        array_habs: [{
            no_hab: 1,
            num_adultos: 2,
            num_menores: 0,
            edad_menores: []
        }],
        options_edad_menores: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17],
        habs_pax: [],
        model_rango_estancia: "",
        rango_estancia: {
            fecha_entrada: "",
            fecha_salida: "",
        },
        model_destino: '',
        info_destino: '',
        model_paises: false,
        limit_options: 20,

        rmt_url: rmt_url,
        api_url: rmt_url + '/api/',

        options: [],
        isLoading: false,

        model_agencia_usuario: agencia_usuario,
        model_id_usuario: id_usuario,

        info_cotiz: [],
        outlet:'',
        total_guests: "2 adultos, 0 menor(es)",
    },
    created: function() {
        this.loadInfoCotiz();
        this.loadSearchHistory();
        this.calculateTotalHabs();
    },
    methods: {
        calculateTotalHabs: function() {
            var total_adults = 0; var total_children = 0;
            this.array_habs.forEach(function (element) {
                total_adults += element.num_adultos;
                if(element.num_menores > 0) {
                    total_children += element.num_menores;
                }
            });
            this.total_guests = total_adults + " adultos, " + total_children + " menor(es).";
        },
        addHabs: function() {
            this.num_habs++;
            this.array_habs.push({
                no_hab: this.num_habs,
                num_adultos: 2,
                num_menores: 0,
                edad_menores: []
            });
            this.calculateTotalHabs();
        },
        removeHabs: function(hab) {
            /*if(this.num_habs > 1) {
                this.array_habs.pop();
                this.num_habs--;
            }*/
            if (this.num_habs > 1) {
                this.num_habs--;
                for (var i = 0; i < this.array_habs.length; i++) {
                    if ((i + 1) >= hab) {
                        this.array_habs[i].no_hab--;
                    }
                }
                this.array_habs.splice((hab - 1), 1);
                this.calculateTotalHabs();
            }
        },
        setPaxHabs: function() {
            element = event.currentTarget;
            op = element.getAttribute('data-op');
            pax = element.getAttribute('data-pax');
            hab = element.getAttribute('data-hab');
            if (pax == "adulto") {
                if (op == "add") {
                    if (this.array_habs[hab - 1].num_adultos < 11) {
                        this.array_habs[hab - 1].num_adultos++;
                         this.calculateTotalHabs();
                    }
                } else {
                    if (this.array_habs[hab - 1].num_adultos > 1) {
                        this.array_habs[hab - 1].num_adultos--;
                        this.calculateTotalHabs();
                    }
                }
            } else {
                this.setMenores(op, hab);
            }
        },
        setMenores: function(op, hab) {
            element = event.currentTarget;
            var edad_menores = [];
            if (op == "add") {
                if (this.array_habs[hab - 1].num_menores < 5) {
                    this.array_habs[hab - 1].num_menores++;
                    this.array_habs[hab - 1].edad_menores.push({
                        no_menor: this.array_habs[hab - 1].num_menores,
                        edad: 0,
                    });
                     this.calculateTotalHabs();
                }
            } else {
                if (this.array_habs[hab - 1].num_menores > 0) {
                    this.array_habs[hab - 1].num_menores--;
                    this.array_habs[hab - 1].edad_menores.pop();
                }
                 this.calculateTotalHabs();
            }
        },
        clearForm: function() {
            this.array_habs = [{
                no_hab: 1,
                num_adultos: 2,
                num_menores: 0,
                edad_menores: ''
            }];
            this.model_rango_estancia = moment().format("DD/MM/YYYY") + " - " + moment().format("DD/MM/YYYY");
            this.model_destino = '';
            this.setSelects();
        },
        loadSearchHistory: function() {
            if(typeof localStorage.search_history != "undefined") {
                this.options.push({
                    tipo_destino: "Historial",
                    opciones: [],
                });

                var that = this;
                json_history = JSON.parse(localStorage.search_history).reverse();
                json_history.forEach(function(element) {
                    that.options[0].opciones.push(element);
                });
            }
        },
        initOptions: function() {
            this.options = [];
            this.options.push({
                tipo_destino: "Destinos",
                opciones: [],
            });

            this.options.push({
                tipo_destino: "Zonas",
                opciones: [],
            });

            this.options.push({
                tipo_destino: "Hoteles",
                opciones: [],
            });

            this.options.push({
                tipo_destino: "Cadenas",
                opciones: [],
            });
        },
        loadDestinations: function(query) {
            this.initOptions();
            if (query.length >= 3) {
                this.isLoading = true;
                this.$http.post(this.rmt_url + '/busqueda/SearchDestinations',{search:query, paises:this.model_paises}, {
                    before(request) {
                        // abort previous request, if exists
                        if (this.previousRequest) {
                            this.previousRequest.abort();
                        }
                        // set previous request on Vue instance
                        this.previousRequest = request;
                    }
                }).then(function(response) {
                    var response_var = response.body;
                    var array_destinos = response_var;
                    var that = this;
                    array_destinos.forEach(function(element) {
                        switch (element.Tipo) {
                            case "Destino":
                                that.options[0].opciones.push(element);
                                break;

                            case "Zona":
                                that.options[1].opciones.push(element);
                                break;
                            
                            case "Hotel":
                                that.options[2].opciones.push(element);
                                break;

                            case "Cadena":
                                that.options[3].opciones.push(element);
                                break;

                            case "Extranet":
                                that.options[0].opciones.push(element);
                                break;
                        }
                    });
                    console.log(that.options);
                    if(this.limit_options == 20) this.limit_options = 30;
                    this.isLoading = false;
                }, function() {
                    console.log('Error');
                });
            }
        },
        ConsultarTarifas: function(){
            if ($("input[name='destino']").val()=="") {
                $(".search-destination .multiselect").css('border','1px #e80707 solid');
            }else{
                $("#formCotizador").submit();
            }
        },
        setDestino: function(selectedOption, id) {
            var destino;
            switch (selectedOption.Tipo) {
                case "Hotel":
                    destino = "h_" + selectedOption.Codigo;
                    break;

                case "Cadena":
                    destino = "c_" + selectedOption.Codigo;
                    break;

                case "Destino":
                    destino = "d_" + selectedOption.Codigo;
                    break;

                case "Zona":
                    destino = "z_" + selectedOption.Codigo;
                    break;

                case "Extranet":
                    destino = "e_" + selectedOption.Codigo;
                    break;
            }
            $(".destino").val(destino);

            sessionStorage.setItem("paisVal", "MX");
            sessionStorage.setItem("paisText", "México");
            sessionStorage.setItem("destinoText", selectedOption.Nombre);
            sessionStorage.setItem("destinoVal", destino);
            sessionStorage.setItem("tituloDestino", selectedOption.Nombre);
            localStorage.setItem("options_hoteles", JSON.stringify(this.options));
            localStorage.setItem("selected_option_hotel", JSON.stringify(selectedOption));

            // historial de búsqueda
            array_to_save = selectedOption;
            array_to_save.historial = true;
            if(typeof localStorage.search_history == "undefined") {
                array_storage = [];
            } else {
                array_storage = JSON.parse(localStorage.search_history);
            }
            coincidences = array_storage.filter(item => {
                return item.Nombre == selectedOption.Nombre;
            })
            if(coincidences.length == 0) {
                array_storage = array_storage.concat(array_to_save);
            }
            localStorage.search_history = JSON.stringify(array_storage);
        },
        loadInfoCotiz: function() {
            var that = this;
            this.$http.get(this.rmt_url + "/carrito/getInfoCotiz?request=hotel").then(function(response) {
                var response_var = response.body;
                this.info_cotiz = response_var.front_form;
                if (response_var.info_search == null || this.info_cotiz.info_search == null) {
                    this.model_rango_estancia = moment().format("DD/MM/YYYY") + " - " + moment().add(3, 'days').format("DD/MM/YYYY");
                    this.rango_estancia = {
                        fecha_entrada: moment().format("DD/MM/YYYY"),
                        fecha_salida: moment().add(3, 'days').format("DD/MM/YYYY"),
                    };
                } else {
                    this.model_rango_estancia = this.info_cotiz.fecha_ini + " - " + this.info_cotiz.fecha_fin;
                    this.rango_estancia = {
                        fecha_entrada: this.info_cotiz.fecha_ini,
                        fecha_salida: this.info_cotiz.fecha_fin,
                    };
                    this.model_destino = JSON.parse(localStorage.getItem("selected_option_hotel"));
                    switch (this.model_destino.Tipo) {
                        case "Hotel":
                            $(".destino").val("h_" + this.model_destino.Codigo);
                            break;

                        case "Cadena":
                            $(".destino").val("c_" + this.model_destino.Codigo);
                            break;

                        case "Destino":
                            $(".destino").val("d_" + this.model_destino.Codigo);
                            break;

                        case "Zona":
                            $(".destino").val("z_" + this.model_destino.Codigo);
                            break;

                        case "Extranet":
                             $(".destino").val("e_" + this.model_destino.Codigo);
                            break;
                    }
                    // this.options = JSON.parse(localStorage.getItem("options_hoteles"));

                    this.num_habs = parseInt(this.info_cotiz.habs);
                    this.array_habs = [];
                    Object.values(this.info_cotiz.info_search).forEach(function(element, index) {
                        var num_menores = parseInt(element.no_menores);
                        that.array_habs.push({
                            no_hab: (index + 1),
                            num_adultos: parseInt(element.adultos),
                            num_menores: num_menores,
                            edad_menores: []
                        });

                        if (num_menores > 0) {
                            element.menores.forEach(function(element_edad, index_edad) {
                                that.array_habs[index].edad_menores.push({
                                    no_menor: (index_edad + 1),
                                    edad: element_edad
                                });
                            });
                        }
                    });
                }
            }, function() {
                console.log('Error');
            });
        },
        test_method: function() {
            console.log(event.target.value);
        }
    }
});

var dp_web = document.getElementById('dp_estancia_web'); //$(".dp_estancia")[0];
//var dp_mobile = document.getElementById('dp_estancia_mobile'); //$(".dp_estancia")[0];
var settings_dp = {
    format: 'DD/MM/YYYY',
    startOfWeek: 'sunday',
    i18n: {
        night: 'Noche',
        nights: 'Noches',
        button: 'Cerrar',
        'day-names-short': ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab'],
        'day-names': ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        'month-names-short': ['Ene', 'Feb', 'Mar', 'Abr', 'Mar', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        'month-names': ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        'info-more': 'Por favor seleccione la fecha de su estancia'
    },
    moveBothMonths: true
};
var datepicker_web = new HotelDatepicker(dp_web, settings_dp);
//var datepicker_mobile = new HotelDatepicker(dp_mobile, settings_dp);

dp_web.addEventListener('afterClose', function() {
    appHoteles.model_rango_estancia = $("#dp_estancia_web").val();
    var rango = appHoteles.model_rango_estancia.split("-");
    appHoteles.rango_estancia.fecha_entrada = rango[0].replace(/\s/g, "");
    appHoteles.rango_estancia.fecha_salida = rango[1].replace(/\s/g, "");

}, false);

/*dp_mobile.addEventListener('afterClose', function () {
    appHoteles.model_rango_estancia = $("#dp_estancia_mobile").val();
    var rango = appHoteles.model_rango_estancia.split("-");
    $(".fecha_entrada").val(rango[0].replace(/\s/g, ""));
    $(".fecha_salida").val(rango[1].replace(/\s/g, ""));
}, false);*/

$('body').on('click', '#btn_clear', function() {
    $("#select_habs").val(1);
    $(".select_adultos").val(1);
    $(".select_menores").val(0);
});

$('body').on('click', '#btn_logout', function() {
    localStorage.removeItem("info_agencia")
});

$('body').on('click', '.habsPax', function() {
    var id_div = ".btnPax" + $(this).attr('data-hab');
    $(id_div).toggle();
});

$('body').on('click', '.remove-hab', function() {
    var id_div = $(this).attr('data-hab');
    $(".btnPax" + id_div).toggle();
    appHoteles.removeHabs(id_div);
});