if (root_url) {
	var rmt_url=root_url;

}
var appBloqueo = new Vue({
	el: '#detalle_bloqueo',
	data: {
		rmt_url: rmt_url,
		id_bloqueo: id_bloqueo,
		roominglist:[],
		habs:0,
		info_bloqueo: [],
		dispo:0,
		aux_array: [],
		id_roominglist: 0,
		index_room:0,
		texto_editar: "",
		pax_array:[],
		disponibles: 0,
		apartadas: 0,
		reservadas: 0,
		recibos:[],
		anticipos:[],
		loading:true,
	},
	created: function () {
		this.loadInfoBloqueo();
		this.loadRoominglist();
		// this.loadChartDonut();
	},
	methods: {
		formatPrice(value) {
			//redondea siempre para arriba
			var redondear = Math.ceil(value);
			let val = (redondear / 1).toFixed(2).replace(',', '.')
			return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
		},
		loadChartDonut: function() {
			this.$http.post(this.rmt_url+'/bloqueos/estatusBloqueo/' + this.id_bloqueo).then(function (response) {
				var response_var = response.body;
				this.disponibles = response_var.disponibles;
				this.reservadas = response_var.reservadas;
				this.apartadas = response_var.apartadas;

				var config = {
					type: 'doughnut',
					data: {
						labels: ['Reservadas', 'Disponibles', 'Apartadas'],
						datasets: [{
							label: '# de habitaciones',
							data: [this.reservadas, this.disponibles, this.apartadas],
							backgroundColor: [
							'rgba(255, 99, 132, 0.2)',
							'rgba(54, 162, 235, 0.2)',
							'rgba(255, 206, 86, 0.2)'
							],
							borderWidth: 1
						}]
					},
					options: {
						rotation: 1 * Math.PI,
						circumference: 1 * Math.PI,
						legend: {
							display: false,
						}
					},
					centerText: {
						display: true,
						text: this.disponibles
					}
				};

				Chart.Chart.pluginService.register({
					beforeDraw: function(chart) {
						if (chart.config.centerText.display !== null &&
							typeof chart.config.centerText.display !== 'undefined' &&
							chart.config.centerText.display) {
							drawTotals(chart);
					}
				},
				});

				var cts = document.getElementById('circulo');
				ctx = cts.getContext('2d');

				window.myDoughnut = new Chart(ctx, config);

				
			}, function () {
				console.log('Error');
			});
		},
		loadInfoBloqueo: function() {
			var that= this;
		   // https://www.rutamayatravel.com/sur4demo/api/roominglist?filter=[%7B%22property%22:%22id_bloqueo%22,%22value%22:1280,%22operator%22:=%7D,%7B%22property%22:%22id_agencia%22,%22value%22:64,%22operator%22:=%7D]
			this.$http.get(encodeURI(this.rmt_url+'/bloqueos/getDetailBloqueo/id/' + this.id_bloqueo+'/id_agencia/'+sesion.id_agencia)).then(function (response) {
				var paxes=[];
				that.info_bloqueo = response.data;
				if (this.info_bloqueo.paquete) {
					 appPax.paquete=this.info_bloqueo.paquete;
				}
				console.log(this.info_bloqueo);
			}, function () {
				console.log('Error');
			});

		},
		loadRoominglist:function(){
			var url='/api/roominglist?filter=[{"property":"id_bloqueo",value:'+this.id_bloqueo+',operator:"="},{"property":"id_agencia","value":'+sesion.id_agencia+',"operator":"="}]';
			if (sesion.id_agencia==9) {
				url='/api/roominglist?filter=[{"property":"id_bloqueo",value:'+this.id_bloqueo+',operator:"="},{"property":"id_agencia",value:"null",operator:"!="}]';
			}
				this.$http.get(encodeURI(this.rmt_url+url)).then(function (response) {

				var roomlist=  response.body;
				this.roominglist = roomlist.data.roominglist;
				this.loading=false;

				this.totalAnticipo();
				this.recibosDetalle();
				this.loadAnticipos();
				//this.loadTable(roomlist.data.roominglist);
				/*that.roominglist.forEach(function(element, index){
					that.$http.get(encodeURI(this.rmt_url+'/bloqueos/getPax/id/' + element.id_roominglist)).then(function (response) {
						that.roominglist[index].paxes=[];
						paxes=response.body;           
						that.roominglist[index].paxes=paxes;
					},function () {
						console.log('Error');
					});

				});*/
				
			},function () {
				console.log('Error');
			});
		},
		totalAnticipo:function(){
			var sumAnticipos=0;
			var that=this;
		/*	console.log(this.roominglist);*/
			this.roominglist.forEach(function(element,index){
					sumAnticipos+=that.anticipo(index);
			});
			return sumAnticipos;
		},
		anticipo:function(index){
		   
			var sumAnticipos=0;
			var id_reservacion=this.roominglist[index].id_reservacion;
			var id_roominglist=this.roominglist[index].id_roominglist;
			if (this.roominglist[index].id_agencia) {
				this.anticipos.forEach(function(element,ind){
					if (element.id_roominglist==id_roominglist) 
					{
						sumAnticipos+=parseFloat(element.importe);
					}
				});
			}
			if (this.roominglist[index].id_reservacion) {
				 this.recibos.forEach( function(element, indx) {
					 if (element.id_reservacion==id_reservacion) {
							sumAnticipos+=parseFloat(element.importe);
					 }
				 });
			}
			
			return sumAnticipos;
		},
		credito:function(){
			var credito=0;
			if (this.info_bloqueo.notasCredito.length>0) {
				this.info_bloqueo.notasCredito.forEach( function(element, index) {
					credito+=parseFloat(element.importe);
				});
			}
			return credito;
		},
		saldo:function(index){
			var saldoTotal=0;
			var element = this.roominglist[index];
			var comision=0;
			var importe=parseFloat(this.importe(index));
		
			if (element.idReservacion) {
					saldoTotal=parseFloat(element.idReservacion.saldo);
				}
			else if(this.anticipo(index)>0) {
				
					saldoTotal=importe-this.anticipo(index);
				
			}else{
				if (element.idBloqueo.comision && element.idBloqueo.comision!==null) {
					comision=importe*(parseFloat(element.idBloqueo.comision)/100);
					saldoTotal=(importe-comision);
				}else{
					if (element.idAgencia!==null) {
						if (element.idAgencia.porcentaje_comision && element.idAgencia.porcentaje_comision!==null) {
							comision=importe*(parseFloat(element.idAgencia.porcentaje_comision)/100);
						}
					}
					
					saldoTotal=(importe-comision);
				}
			}
				return saldoTotal;
		},
		saldoTotal:function(){
			var saldoTotal=0;
			var that=this;
			var comision=0;
			this.roominglist.forEach(function(element,index){
			
				saldoTotal+=parseFloat(that.saldo(index));
			});
			return saldoTotal;
		},
		total:function(){
			var total=0;
			var that=this;
			this.roominglist.forEach(function(element, indx){
				total+=parseFloat(that.importe(indx));
			});
			return total;
		},
		saldoPagarRmt()
		{
			return this.totalAgencia()-this.credito()-this.totalAnticipo();
		},
		noComisionables:function(tipo){
			var noComisionables=this.info_bloqueo.noComisionables;
			var importe=0;
			var comisionAgencia=0
			if (noComisionables.length>0) {
				noComisionables.forEach( function(element, index) {
					if (tipo=="publico") {

						importe+=parseFloat(element.importe);
					}else if(tipo=="comision"){
						 if (element.comisionable=='1') {
						 	 comisionAgencia=element.comision_agencia/100;
						 	 importe+=element.importe*comisionAgencia;
						 }
					}
				});
			}
			
			return importe;
		},
		importe:function(index){
			var importe=0;
			var base = parseInt(this.roominglist[index].id_base_habitacion);
			var noches = parseInt(this.roominglist[index].noches);
			var precio=0;
			
			if (this.roominglist[index].idReservacion) {
				if (this.roominglist[index].cortesia=="1")
				 importe=0.00; 
				else if(this.roominglist[index].idReservacion)
				 importe=this.roominglist[index].idReservacion.total;
			}else if(this.roominglist[index].importe>0){
				importe=this.roominglist[index].importe;
			}else if(this.roominglist[index].cortesia=='1'){
				
			}else{

				this.info_bloqueo.tarifa_desglose.forEach( function(element, index) {
				  
					if ("2"==element.id_base_habitacion){
						precio=element.precio_normal;
					}
				});
				importe=precio*noches;
			}
			return importe;
		},
		totalNeto:function(){
			var paquete=0;
			var total_neto;
			var servicios=0;
			if (this.info_bloqueo.info_bloqueo.tipo=="GRUPAL") {
				servicios=this.noComisionables("publico");
			}
			if (this.info_bloqueo.paquete) {
				paquete=this.info_bloqueo.paquete.precio?this.info_bloqueo.paquete.precio:0;

			}
			total_neto = (this.total()+parseFloat(paquete)+servicios);
			return total_neto
		},
		comisionAgencia:function(){

			var total=this.total();
			var comision=0;
			var servicios=0;

			if (this.info_bloqueo.info_bloqueo.comision) {
						 comision=total*(this.info_bloqueo.info_bloqueo.comision/100);
					   
			}else{
				 
				if (this.info_bloqueo.comisionAgencia>0) {
					comision=total*(this.info_bloqueo.comisionAgencia/100);
				}    
			}
			if (this.noComisionables('comision')>0) {
				servicios=this.noComisionables('comision');
				comision+=parseFloat(servicios);
			}
			if (this.info_bloqueo.paquetes) {
				var pack=this.info_bloqueo.paquetes;
				if (pack.comisionable=="1") {
					var precio = pack.precio>0?pack.precio:0;
					var paquete=parseFloat(precio)*(parseFloat(pack.comision_agencia)/100);
					comision+=paquete;
				}
			}
			return comision;
		},
		totalAgencia:function(){
		  	var totalNeto=this.totalNeto();
		  	var comision_agencia=0;
		
		  	comision_agencia=(totalNeto-this.comisionAgencia());
				   
			return comision_agencia;
		},
		apartarHabitacion: function() {
			this.$http.post(encodeURI(this.rmt_url+'/bloqueos/apartarHabitacion/' + this.id_bloqueo),{habitaciones:this.habs, id_agencia:sesion.id_agencia}).then(function (response) {
				this.loadInfoBloqueo();
				var habdis = this.dispo-this.habs;
				$('#disponibles').val(habdis);
			   
			}, function () {
				console.log('Error');
			});
		},
		recibosDetalle: function(){
			var reservaciones=[];
			this.roominglist.forEach( function(element, index) {
				if (element.id_reservacion) {
					reservaciones.push(element.id_reservacion);
				}
			});
			if (reservaciones.length>0) {
				var reservas = reservaciones.join(',');
				this.$http.post(encodeURI(this.rmt_url+'/bloqueos/recibos'),{habitaciones:reservas}).then(function (response) {
					this.recibos = response.body;
					/*console.log(this.recibos);*/
				   
				}, function () {
					console.log('Error');
				});
			}
		  
		},
		loadAnticipos: function(){
			var habitaciones=[];
			this.roominglist.forEach( function(element, index) {
				if (element.id_reservacion) {
					habitaciones.push(element.id_roominglist);
				}
			});
			if (habitaciones.length>0) {
				habitaciones = habitaciones.join(',');
				this.$http.post(encodeURI(this.rmt_url+'/bloqueos/anticipos'),{habitaciones:habitaciones}).then(function (response) {
					this.anticipos = response.body;
					/*console.log(this.anticipos);*/
				   
				}, function () {
					console.log('Error');
				});
			}
			
		},
		test_method: function() {
			var arreglo = [ 0, 1, 2 ];
			return arreglo;
		},
		getIndexRoom:function(index){
		   /*console.log(index);
		   console.log(this.roominglist);*/
			 this.index_room = index;
			 this.id_roominglist = this.roominglist[index].id_roominglist;
			//$('.modal-hab').attr('id', 'modalPax_'+index);
			console.log(this.roominglist[index].id_roominglist);
			if (this.roominglist[index].Desglose.length>0) {
				this.pax_array=this.roominglist[index].Desglose;
			}else{
				this.oldRoomingList(this.roominglist[index]);
			}
			
			this.texto_editar = "Editar habitación No. " + this.roominglist[index].habitacion;
		   
		   
			if(this.pax_array.length<=0) {
				this.pax_array=[{
					tipo:"Adulto",
					edad:""
				},{
					tipo:"Adulto",
					edad:""
				}]
			}

		   
			/*else if(typeof this.roominglist[this.index_room].menores == "undefined" || this.roominglist[this.index_room].menores.length == 0) {
				this.roominglist[this.index_room].adultos.forEach(function(element){
					element.tipo = "adulto";
					that.aux_array.push(element);
				});
			} else if(this.roominglist[this.index_room].menores.length > 0) {
				this.roominglist[this.index_room].adultos.forEach(function(element){
					element.tipo = "adulto";
					that.aux_array.push(element);
				});
				this.roominglist[this.index_room].menores.forEach(function(element){
					element.tipo = "menor";
					that.aux_array.push(element);
				});

			}*/
			
			if (this.roominglist[index].id_reservacion==null) {
				$('#btn_update').removeAttr("disabled");
			}
			appPax.texto_editar = this.texto_editar;
			appPax.aux_array = this.pax_array;
			appPax.roominglist = this.roominglist;
			appPax.index_room =  this.index_room;
			appPax.loadRoom();
			console.log()
			$('#modalPax').modal('show');
			// modalpax(index, id_roominglist);
			
		},
		getPaquete:function(){
			
			$('#modal-paquetes').modal('show');
		},
		oldRoomingList:function(roominglist){

				var id_roominglist=roominglist.id_roominglist;
				var paxarray=[];
			if (roominglist.nombre) {
				var nombres=roominglist.nombre.split(' / ');
				nombres.forEach( function(element, index) {
					names=element.split(" ");
					paxarray.push({nombre:names[1], apellido:names[0], tipo:"Adulto", id_roominglist:id_roominglist})
				});
			}
		   
			if (roominglist.menor && roominglist.edad) {
				var menores=roominglist.menor.split(' / ');
				var edades=roominglist.edad.split(',');
				menores.forEach( function(element, index) {
					childname=element.split(" ");
					paxarray.push({nombre:childname[1], apellido:childname[0], edad:edades[index], tipo:"Menor",id_roominglist:id_roominglist})
				});
			}
			 this.pax_array=paxarray;   
		},
		titular:function(roominglist){
			var nombre="Nombre Titular";
			if (roominglist.nombre) {
				var nombres=roominglist.nombre.split(' / ');
				return nombres[0];
			}else{

				return nombre
			}
		},
		base:function(roominglist)
		{
			var base="2";
			if (roominglist.menor) {
				var nombres=roominglist.nombre.split(' / ');
				var adults=new String(nombres.length);
				base=adults;
			}
			if (roominglist.menor && roominglist.edad) {
				var menores=roominglist.menor.split(' / ');
				
				var childs=new String(menores.length);
			  	
				base+="."+childs+"("+roominglist.edad+')';
			}else{
				base+=".0";
			}
			return base;
		},
  /*      loadTable: function(roominglist) {
		   
			var that = this;
			var columns = '';
			var idAgencia=false;
		  
			if (id_agencia>0) {
				idAgencia=true;
				pagartodos=true;
			}
			idAgencia=false;
			pagartodos=false;
			var tbl_cuentas = $('#roominglist').DataTable({
				destroy:true,
				paging: false,
				lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
				sDom:"<'dt_colVis_buttons'B><'dt-uikit-header'<'uk-grid'<'uk-width-medium-2-3'l><'uk-width-medium-1-3'f>>>tipr",
				buttons: [
					{
					  
						text:'<i class="uk-icon-file-excel-o" style="color: #FFFFFF"></i> Exportar a Excel',
						className: 'md-btn md-btn-success md-btn-wave-light'
					}
				],
				columnDefs: [
					{
						"targets": [0],
						"visible": idAgencia,
						"searchable": false,
						"orderable": false
					}
				],
				
				
			});
			
	 
			tbl_cuentas.clear();
			
			roominglist.forEach(function(element, index){
				tbl_cuentas.row.add([
				   
				]).draw(false);              
			});
	 
		},*/
		showPictures: function() {
			var html = "";
			this.info_bloqueo.info_adicional.fotos.forEach(function(element) {
				html += "<div class=\"col-3\"><a href=\"https://www.rutamayatravel.com/imagenes/" + element.foto + "\" data-toggle='lightbox' data-gallery='example-gallery' data-max-height='500'><img src=\"https://www.rutamayatravel.com/imagenes/" + element.foto + "\" width='100%' /></a></div>";
			});
			$("#gallery").html(html);
		},
		parseDate: function(date, format) {
			var fecha_limite = '';
			if (date!==null) {
				fecha_limite = moment(date).format(format);
			}
			return fecha_limite;
		},
		dateDiff: function() {
			var diff = moment(this.info_bloqueo.info_bloqueo.fecha_final).diff(moment(this.info_bloqueo.info_bloqueo.fecha_inicio), "days");
			return diff;
		},
		increment: function(that){
			this.dispo = parseInt($('#disponibles').val());
			// console.log('dispo ' + this.dispo);
			if(that == 'menos' && this.habs > 0)
				this.habs--;
			if(that == 'mas' && this.habs < this.dispo && this.habs < 5)
				this.habs++;
		},
		round:function(value) {
			//redondea siempre para arriba
			var redondear = Math.ceil(value);
			let val = (redondear / 1).toFixed(2).replace(',', '.')
			return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
		}
	},
});

	var appPax = new Vue({
		 el: '#bloqueosModales',
		 data:{
			index_room:appBloqueo.index_room,
			id_roominglist:appBloqueo.id_roominglist,
			texto_editar:appBloqueo.texto_editar,
			roominglist:appBloqueo.roominglist,
			aux_array:appBloqueo.aux_array,
			paquetes:[],
			observaciones:"",
			id_reservacion:""
		 },
	  
		mounted:function(){
			//this.loadRoom();
		},
		methods: {
			loadRoom:function(){
			   
				//this.texto_editar = "Editar habitación No. " + (parseInt(this.index_room) + 1);
				//console.log(this.texto_editar)
				//console.log(this.index_room)
			
				this.observaciones=this.roominglist[this.index_room].observaciones;
				this.id_reservacion=this.roominglist[this.index_room].id_reservacion;
				
				if (this.roominglist[this.index_room].id_reservacion==null) {
					 $('#btn_update').removeAttr("disabled");
				}
			   
			},
	  
			validateRoom: function() {

				var total_pax = 0;
				
				if(this.aux_array.length > 0) {
					total_pax = this.aux_array.length;
				}


				return total_pax;
			},
			addPax: function(pax) {

				if(this.validateRoom() < 4) {
					element = event.currentTarget;
				 
					if(pax == "Adulto") {
						this.aux_array.push({
							id_pax:0,
							nombre: "",
							tipo: "Adulto"
						});
					} else {
						this.aux_array.push({
							nombre: "",
							edad: 0,
							tipo: "Menor"
						});
					}
				}
			},
			deletePax: function(index,id) {
				var that = this;
				
				if ((typeof id!="undefined") && id!=0) {
					Swal.fire({
						  title: '¿Estas seguro de eliminar?',
						  text: "No se podràn deshacer los cambios!",
						  type: 'warning',
						  showCancelButton: true,
						  confirmButtonColor: '#3085d6',
						  cancelButtonColor: '#d33',
						  confirmButtonText: 'Si, elimalo!'
						}).then(function(result){
							if (result.value) {
								that.$http.get(encodeURI(appBloqueo.rmt_url+'/bloqueos/deletePax/id/' + id)).then(function (response) {
									that.aux_array.splice(index, 1);
									Swal.fire(
								      'Listo!',
								      'Pasajero eliminado.',
								      'success'
								    );
								    that.pax_array[index]=[{
										tipo:"Adulto",
										edad:""
									},{
										tipo:"Adulto",
										edad:""
									}]
								}, function () {
									Swal.fire(
								      'Ocurrio en error!',
								      'Contacta a soporte.',
								      'danger'
								    )
									console.log('Error');
								});
								    
							}
						});
					
				 }else{
				 	this.aux_array.splice(index, 1);
				 }
				  

			},
			updateRoom: function() {
				/*console.log(this.aux_array);*/
				$('#btn_update').attr("disabled", "disabled");
				appBloqueo.roominglist[appBloqueo.index_room].Desglose=this.aux_array;
				var array_adultos = [], array_menores = [];
				var that = this;
				var nombre="", menor="", edad="";
				var m=0, a=0, aImporte=0, mImporte=0;

				
				this.aux_array.forEach(function(element, ind){
					if(element.tipo == "Adulto" || element.tipo == "A" ) {
						a++
						nombre+=element.nombre+" "+element.apellido+" / ";
						/*array_adultos.push({
							nombre: element.nombre,
							edad: 30
						});*/
					} else {
						m++
						menor+=element.nombre+" "+element.apellido+" / ";
						edad+=element.edad+ " , ";
						/*array_menores.push({
							nombre: element.nombre,
							edad: element.edad
						});*/
					}
				});

				appBloqueo.info_bloqueo.tarifa_desglose.forEach(function(val, key){
					if(val.id_base_habitacion == a){
						aImporte = val.precio_normal * appBloqueo.roominglist[appBloqueo.index_room].noches
						mImporte = val.precio_ninio * appBloqueo.roominglist[appBloqueo.index_room].noches
					}
				});
				nombre = nombre.slice(0,-3);
				menor = menor.slice(0,-3);
				edad = edad.slice(0,-3);
				appBloqueo.roominglist[appBloqueo.index_room].importe=aImporte+mImporte;
				appBloqueo.roominglist[appBloqueo.index_room].nombre=nombre;
				appBloqueo.roominglist[appBloqueo.index_room].edad=edad;
				appBloqueo.roominglist[appBloqueo.index_room].menor=menor;
				appBloqueo.roominglist[appBloqueo.index_room].observaciones=this.observaciones;

				this.$http.post(encodeURI(appBloqueo.rmt_url + "/bloqueos/updateRoomingList/id/"+ appBloqueo.roominglist[appBloqueo.index_room].id_roominglist), {RoomingList:appBloqueo.roominglist[appBloqueo.index_room], aImporte:aImporte, mImporte:mImporte}).then(function(response) {
					var response_boda = response.body;
					if(response_boda== 'ok') {
						appBloqueo.roominglist[appBloqueo.index_room].adultos = [];
					   appBloqueo.roominglist[appBloqueo.index_room].menores = [];
						this.aux_array.forEach(function(element){
							if(element.tipo == "Adulto") {
								appBloqueo.roominglist[appBloqueo.index_room].adultos.push({ nombre: element.nombre });
							} else {
								appBloqueo.roominglist[appBloqueo.index_room].menores.push({ nombre: element.nombre, edad: element.edad });
							}
						});
						appBloqueo.loadRoominglist();
						$('.bd-example-modal-lg').modal('hide');
						$("#btn_update").removeAttr("disabled");
						Swal.fire({
							type: 'success',
							title: 'Correcto',
							text: 'Se ha actualizado el roominglist.'
						}).then(function(){
							if (root_url) {
							   
								location.reload();
							}else{
								$('#modalPax').modal('hide');
							}
						});
					} else {
						 $('#modalPax').modal('hide');
						$("#btn_update").removeAttr("disabled");
						Swal.fire({
							type: 'error',
							title: '¡Ops!',
							html: "Algo salió mal. <pre><code>" + JSON.stringify(response_boda) + "</pre></code>",
						});
					}
				}, function(e) {
				  
					$('#modalPax').modal('hide');
					$("#btn_update").removeAttr("disabled");
					Swal.fire({
						type: 'error',
						title: '¡Ops!',
						html: "Algo salió mal. <pre><code>" + JSON.stringify(e.body) + "</pre></code>",
					});
				});
			},
			parseDate:function(date,format){
				return appBloqueo.parseDate();
			},
		   
	   
		}
	});  

$(document).on('change', '.pax_form', function(event) {
	$("#btn_update").removeAttr('disabled');
});
$(document).on('click', '.cambio-modal', function(event) {

	var index = $(this).attr('data-index');
	appBloqueo.getIndexRoom(index);
});

$(document).on('click', '[data-toggle="lightbox"]', function(event) {
	event.preventDefault();
	$(this).ekkoLightbox();
});


function drawTotals(chart) {
 
	var width = chart.chart.width,
	height = chart.chart.height,
	ctx = chart.chart.ctx;
 
	ctx.restore();
	var fontSize = (height / 80).toFixed(2);
	ctx.font = fontSize + 'em sans-serif';
	ctx.textBaseline = 'middle';
 
	var text = chart.config.centerText.text,
	textX = Math.round((width - ctx.measureText(text).width) / 2),
	textY = height / 2 + 40;
 
	ctx.fillText(text, textX, textY);
	ctx.save();
}