Vue.http.options.emulateJSON = true;
var tbl_guests;

const Toast = Swal.mixin({
    toast: true,
    timer: 3000,
    position: 'bottom-end',
    showConfirmButton: false,
})

var appGuests = new Vue({
    el: '#guests_vue',
    data: {
        rmt_url: rmt_url,
        casate_url: 'https://test.apituristico.com/casateconmigo/WebServiceRMT.asmx',
        url_img: "",
        url_img_1: 'https://www.fotojet.com/template-imgs/social-media-header/facebook-cover/love-wedding-save-the-date-3.jpg',
        url_img_2: 'http://static.myfbcover.com/covers/Love-and-Emo/Unique_Wedding.png',

        loading: true,
        roominglist: [],
        array_invitados: [],
        id_boda: id_boda,
        id_event_wedding: 0,

        loading_info_boda: true,
        info_boda: [],

        error_model: {
            nombre: false,
            apellidos: false,
            email: false
        },
        model_guest: {
            id_guests_weddings: 0,
            nombre: "",
            apellidos: "",
            telefono: "",
            email: "",
            estatus: "I",
            envio_invitacion: 0,
        },
    },
    created: function() {
        this.getRandom();
        this.loadInfoBoda();
        this.getInvitados();
    },
    mounted: function(){
        this.focusTXT();
        options = {
            placeholder: "(000) 000-0000",
            onChange: function(cep){
                console.log('cep changed! ', cep);
            },
        }
        $("#txt_guest_tel").mask("(999) 999-9999", options);
    },
    methods: {
        loadInfoBoda: function() {
            var that = this;
            var url_info = encodeURI(this.rmt_url + '/bloqueos/getDetailBloqueo/id/' + this.id_boda+'/id_agencia/9');
            this.$http.get(encodeURI(url_info)).then(function (response) {
                that.info_boda = response.body;
                that.loading_info_boda = false;
            },function () {
                console.log('Error');
            });
        },
        getInvitados: function() {
            var url_invitados = this.rmt_url + '/api/eventsWeddings?filter=[{"property":"id_bloqueo","value":'+ this.id_boda +',"operator":=}]';
            this.$http.get(encodeURI(url_invitados)).then(function(response) {
                var response_var = response.body.data;
                if(response_var.eventsWeddings.length != 0) {
                    this.array_invitados = response_var.eventsWeddings[0];
                    this.id_event_wedding = this.array_invitados.id_events_weddings;
                } else {
                    this.array_invitados.guestsWeddings = [];
                }
                this.initTableGuests();
                this.loading = false;
            }, function() {
                console.log('Error');
            });
        },
        acceptGuestWeeding: function () {
            this.error_model.nombre = false;
            this.error_model.apellidos = false;
            this.error_model.email = false;

            var that = this;
            this.model_guest.telefono = $("#txt_guest_tel").val().replace(/\D+/g, '');

            object_entries = Object.entries(this.model_guest)
            object_entries.forEach(function(element) {
                if((element[0] == "nombre" || element[0] == "apellidos" || element[0] == "email") && element[1] == "") {
                    that.error_model[element[0]] = true;
                }
            });
            
            if(this.error_model.nombre == false && this.error_model.apellidos == false && this.error_model.email == false) {
                if(this.model_guest.id_guests_weddings == 0) {
                    this.addGuestWedding();
                } else {
                    this.updateGuestWedding();
                }
            }
        },
        addGuestWedding: function() {
            this.model_guest.id_event_wedding = this.id_event_wedding;
            delete this.model_guest.id_guests_weddings;
            aux_model = JSON.stringify(this.model_guest);
            this.clearModelGuest();
            this.focusTXT();
            console.log(aux_model)
            this.$http.post(this.rmt_url + "/api/guestsWeddings", aux_model).then(function(response) {
                var response_var = response.body.data;
                if(response.body.success == "true") {
                    Toast.fire({
                        icon: 'success',
                        title: 'Se ha agregado el invitado.'
                    })
                    delete response_var.guestsWeddings.idEventWedding;
                    this.array_invitados.guestsWeddings.push(response_var.guestsWeddings)
                } else {
                    Swal.fire({
                        type: 'error',
                        title: '¡Ops! else',
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response) + "</pre></code>",
                    });
                }
                this.initTableGuests();
            }, function(e) {
                console.log(e)
                $("#modal_uc_guests").modal("hide");
                Swal.fire({
                    type: 'error',
                    title: '¡Ops! error',
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(e.body) + "</pre></code>",
                });
            });
        },
        updateGuestWedding: function() {
            var that = this;
            var id_guest_wedding = this.model_guest.id_guest_wedding;
            aux = this.model_guest;
            that.clearModelGuest();
            this.$http.put(this.rmt_url + '/api/guestsWeddings/' + id_guest_wedding, JSON.stringify(aux)).then(function(response) {
                var response_var = response.body.data
                
                if(response.body.success == "true") {
                    var index_info = that.array_invitados.guestsWeddings.findIndex(x => x.id_guest_wedding == id_guest_wedding);
                    that.array_invitados.guestsWeddings[index_info].nombre = response_var.guestsWeddings.nombre;
                    that.array_invitados.guestsWeddings[index_info].apellidos = response_var.guestsWeddings.apellidos;
                    that.array_invitados.guestsWeddings[index_info].telefono = response_var.guestsWeddings.telefono;
                    that.array_invitados.guestsWeddings[index_info].email = response_var.guestsWeddings.email;
                    that.array_invitados.guestsWeddings[index_info].estatus = response_var.guestsWeddings.estatus;
                    that.array_invitados.guestsWeddings[index_info].envio_invitacion = response_var.guestsWeddings.envio_invitacion;
                    that.array_invitados.guestsWeddings[index_info].id_event_wedding = response_var.guestsWeddings.id_event_wedding;

                    Toast.fire({
                        icon: 'success',
                        title: 'Se ha actualizado la información del invitado.'
                    })
                } else {
                    Swal.fire({
                        type: 'error',
                        title: '¡Ops! else',
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response) + "</pre></code>",
                    });
                }
                that.focusTXT();
                that.initTableGuests();
            }, function(e) {
                console.log(e)
                $("#modal_uc_guests").modal("hide");
                Swal.fire({
                    type: 'error',
                    title: '¡Ops! error',
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(e.body) + "</pre></code>",
                });
            });
        },
        deleteGuestWedding: function(id_guest_wedding) {
            var that = this;
            Swal.fire({
                title: '¿Seguro?',
                text: "Esta a punto de eliminar este invitado del evento",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    this.$http.delete(this.rmt_url + "/api/guestsWeddings/" + id_guest_wedding).then(function(response) {
                        var response_var = response.body.data;
                        if(response.body.success == "true") {
                            var index_info = this.array_invitados.guestsWeddings.findIndex(x => x.id_guest_wedding == id_guest_wedding);
                            this.array_invitados.guestsWeddings.splice(index_info, 1);
                            Toast.fire({
                                icon: 'success',
                                title: 'Se ha eliminado el invitado.'
                            })
                        } else {
                            Swal.fire({
                                type: 'error',
                                title: '¡Ops! else',
                                html: "Algo salió mal. <pre><code>" + JSON.stringify(response) + "</pre></code>",
                            });
                        }
                        this.initTableGuests();
                    }, function(e) {
                        console.log(e)
                        $("#modal_uc_guests").modal("hide");
                        Swal.fire({
                            type: 'error',
                            title: '¡Ops! error',
                            html: "Algo salió mal. <pre><code>" + JSON.stringify(e.body) + "</pre></code>",
                        });
                    });
                }
            });
        },
        clearModelGuest: function() {
            delete this.model_guest.id_guests_weddings;
            this.model_guest = {
                id_guests_weddings: 0,
                nombre: "",
                apellidos: "",
                telefono: "",
                email: "",
                estatus: "I",
                envio_invitacion: 0,
            }
            $("#txt_guest_tel").val("");
        },
        loadedCSVGuestsWedding: function() {
            var csv_file = event.target.files[0];
            var csv_guests;
            var that = this;

            var reader = new FileReader();
            reader.readAsText(csv_file);
            reader.onload = function(event){
                var csv = event.target.result;
                csv_guests = $.csv.toObjects(csv);
                that.checkCSVGuestsWedding(csv_guests);
            };
        },
        checkCSVGuestsWedding: function(json_guests) {
            var errors = [];
            var table_html = "<p>Se han encontrado los siguientes errores</p>";
            table_html += "<table class='table table-bordered'>";
            table_html += "<thead>";
            table_html += "<tr>";
            table_html += "<th>Invitado</th>";
            table_html += "<th>Errores</th>";
            table_html += "</tr>";
            table_html += "</thead>";
            table_html += "<tbody>";
            var BreakException = {};
            json_guests.some(function(element, index) {
                var has_errors = false;
                array_errors = {
                    campos: "",
                    telefono: "",
                    email: "",
                };
                json_guests[index].estatus = "I";
                json_guests[index].envio_invitacion = 0;
                json_guests[index].id_event_wedding = appGuests.id_event_wedding;

                if(typeof element.nombre == "undefined" || typeof element.apellidos == "undefined" || typeof element.telefono == "undefined" || typeof element.email == "undefined") {
                    console.log("entró")
                    array_errors.errors = "Las columnas no tienen el nombre correcto.";
                    errors.push(array_errors);
                    has_errors = true;
                    table_html += "<tr>";
                    table_html += "<td colspan='2'>Las columnas no tienen el nombre correcto.</td>";
                    table_html += "</tr>";
                    return true;
                } else if(element.nombre == "" || element.apellidos == "" || element.telefono == "" || element.email == "") {
                    array_errors.errors = "No se permiten registros con campos vacíos.";
                    errors.push(array_errors);
                    has_errors = true;
                    table_html += "<tr>";
                    array_errors.nombre = "Fila" + (index + 1);
                    array_errors.campos = "No se permiten registros con campos vacíos.";
                }

                if(typeof element.telefono != "undefined") {
                    if(element.telefono.length == 0) {
                    } else if(element.telefono.length > 10) {
                        has_errors = true;
                        array_errors.nombre = element.nombre + " " + element.apellidos;
                        array_errors.telefono = "El telefono tiene más de 10 caracteres.";
                    } else if(element.telefono.length < 10) {
                        has_errors = true;
                        array_errors.nombre = element.nombre + " " + element.apellidos;
                        array_errors.telefono = "El telefono tiene menos de 10 caracteres.";
                    } else {
                        array_errors.telefono = "";
                    }
                }                

                if(/\s/.test(element.email)) {
                    has_errors = true;
                    array_errors.email = "El email tiene espacios en blanco.";
                } else {
                    array_errors.email = "";
                }

                if(has_errors == true) {
                    array_errors.nombre = element.nombre + " " + element.apellidos;
                    errors.push(array_errors);
                    table_html += "<tr>";
                    table_html += "<td>"+ element.nombre + " " + element.apellidos +"</td>";
                    table_html += "<td>"+ array_errors.telefono + array_errors.email + array_errors.campos +"</td>";
                    table_html += "</tr>";
                }
            });
            table_html += "</tbody>";
            table_html += "</table>";

            if(errors.length > 0) {
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: table_html,
                });
            } else {
                var data = new FormData();
                data.append("guestsWedding_csv", JSON.stringify(json_guests));
                data.append("id_event_wedding", this.id_event);
                this.$http.post(this.rmt_url + "/guestsWeddings/importGuestsFromCSV", data).then(function(response) {
                    var response_var = response.body;
                    if(response.status == 200) {
                        Swal.fire({
                            type: 'success',
                            title: "Correcto",
                            text: "Se han dado de alta correctamente los invitados.",
                        });
                        this.getInvitados();
                    } else {
                        Swal.fire({
                            type: 'error',
                            title: "Correcto",
                            text: "Algo salió mal",
                        });
                    }
                }, function(ex) {
                    console.log(ex);
                    Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        text: "Algo salió mal",
                    });
                });
            }
        },
        sendInvitation: function(id_guest_wedding) {
            var index_info = this.array_invitados.guestsWeddings.findIndex(x => x.id_guest_wedding == id_guest_wedding);
            this.model_guest = this.array_invitados.guestsWeddings[index_info];
            Swal.fire({
                title: '¿Seguro?',
                text: "Esta a punto de enviar la invitación a " + this.model_guest.nombre + " " + this.model_guest.apellidos,
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if(result.value) {
                    this.$http.get(encodeURI(this.rmt_url + "/guestsWeddings/sendInvitation?id_guest_wedding=" + id_guest_wedding)).then(function(response) {
                        if(response.body.success) {
                            Swal.fire({
                                type: 'success',
                                title: 'Correcto',
                                text: 'Se ha enviado la invitación al invitado.'
                            });
                        } else {
                            Swal.fire({
                                type: 'error',
                                title: '¡Ops!',
                                html: "No se pudo enviar la invitación, intente de nuevo, si el problema persiste contacte con soporte.",
                            });
                        }
                    }, function() {
                        console.log('Error');
                    });
                } else {
                    this.clearModelGuest();
                }
            });
        },
        sendWeddingInvitations: function() {
            Swal.fire({
                title: '¿Seguro?',
                text: "¿Desea enviar la invitación a todos los que no se le ha enviado?",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if(result.value) {
                    this.$http.get(encodeURI(this.rmt_url + "/guestsWeddings/sendAllInvitations?id_event_weeding=" + this.id_event_wedding)).then(function(response) {
                        if(response.body.success) {
                            Swal.fire({
                                type: 'success',
                                title: 'Correcto',
                                text: 'Se ha enviado la invitación a todos los invitados de la boda.'
                            });
                        } else {
                            Swal.fire({
                                type: 'error',
                                title: '¡Ops!',
                                html: "No se pudo enviar la invitación, intente de nuevo, si el problema persiste contacte con soporte.",
                            });
                        }
                    }, function() {
                        console.log('Error');
                    });
                }
            });
        },
        initTableGuests: function() {
            tbl_guests = $("#tbl-guests").DataTable({
                destroy:true,
                paging: true,
                lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
                oLanguage: {
                    "sUrl": "https://cdn.datatables.net/plug-ins/1.10.20/i18n/Spanish.json"
                },
                /* sDom:"<'dt_colVis_buttons'B><'dt-uikit-header'<'uk-grid'<'uk-width-medium-2-3'l><'uk-width-medium-1-3'f>>>tipr",
                buttons: [
                    {
                        extend: 'excel',
                        text:'<i class="uk-icon-file-excel-o" style="color: #FFFFFF"></i> Exportar a Excel',
                        className: 'md-btn md-btn-success md-btn-wave-light'
                    },
                ], */
               /*  columns: [
                    null,
                    null,
                    { "orderable": false },
                ], */
                drawCallback: function( settings ) {
                    $('input').iCheck({
                        checkboxClass: 'icheckbox_square-grey',
                        radioClass: 'iradio_square-grey'
                    }).on('ifChecked ifUnchecked', function(){
                        $(this)[0].dispatchEvent(new Event("change"));
                    });
                }
            });
            tbl_guests.clear();
            var that = this;
            this.array_invitados.guestsWeddings.forEach(function(element, index){
                var actions = "<a class='btn_guest_update' data-id_guest_wedding="+ element.id_guest_wedding +"><i class='icon-edit-2'></i></a>"+
                "<a class='btn_guest_delete' data-id_guest_wedding="+ element.id_guest_wedding +"><i class='icon-trash'></i></a>"+
                "<a class='btn_send_invitacion' data-id_guest_wedding="+ element.id_guest_wedding +"><i class='icon-mail'></i></a>";
                var envio_email = ""; var estatus = "";
                if(element.envio_invitacion == "1") {
                    envio_email = "<input class='chk_invitacion' type='checkbox' data-id_guest_wedding="+ element.id_guest_wedding +" checked />";
                } else {
                    envio_email = "<input class='chk_invitacion' type='checkbox' data-id_guest_wedding="+ element.id_guest_wedding +" />";
                }
                switch(element.estatus) {
                    case "I":
                        estatus = "Invitado";
                        break;
                    
                    case "C":
                        estatus = "Confirmó";
                        break;
                    
                    case "R":
                        estatus = "Rechazó";
                        break;
                }

                tbl_guests.row.add([
                    element.nombre,
                    element.apellidos,
                    element.telefono,
                    element.email,
                    envio_email,
                    estatus,
                    actions
                ]).draw(false);
            });
            //$("#th-total-gastos").html("$ " + Intl.NumberFormat("en-IN").format(total));
        },
        focusTXT: function() {
            $("#txt_guest_name").focus();
        },
        getRandom: function() {
            var random = Math.floor(Math.random() * (+3 - +1)) + +1;
            if(random == 1) {
                this.url_img = this.url_img_1;
            } else {
                this.url_img = this.url_img_2;
            }
        },
        parseDate: function(date) {
            return moment(date).format('DD/MM/YYYY');
        },
    },
});

$("body").on("click", ".btn_guest_update", function() {
    var id_guest_wedding = $(this).attr("data-id_guest_wedding");
    var index_info = appGuests.array_invitados.guestsWeddings.findIndex(x => x.id_guest_wedding == id_guest_wedding);
    appGuests.model_guest = appGuests.array_invitados.guestsWeddings[index_info];
    appGuests.focusTXT();
    $("#txt_guest_tel").val(appGuests.model_guest.telefono);
});

$("body").on("click", ".btn_guest_delete", function() {
    var id_guest_wedding = $(this).attr("data-id_guest_wedding");
    appGuests.deleteGuestWedding(id_guest_wedding);
});

$("body").on("click", ".btn_send_invitacion", function() {
    var id_guest_wedding = $(this).attr("data-id_guest_wedding");
    appGuests.sendInvitation(id_guest_wedding);
});

$('#txt_guest_name').keyup(function() {
    var str = $('#txt_guest_name').val();
        
    var spart = str.split(" ");
    for ( var i = 0; i < spart.length; i++ ) {
        var j = spart[i].charAt(0).toUpperCase();
        spart[i] = j + spart[i].substr(1);
    }
    $('#txt_guest_name').val(spart.join(" "));
});

$('#txt_guest_last_name').keyup(function() {
    var str = $('#txt_guest_last_name').val();
        
    var spart = str.split(" ");
    for ( var i = 0; i < spart.length; i++ ) {
        var j = spart[i].charAt(0).toUpperCase();
        spart[i] = j + spart[i].substr(1);
    }
    $('#txt_guest_last_name').val(spart.join(" "));
});