Vue.http.options.emulateJSON = true;
let editor;

var AppInvitacion = new Vue({
    el: '#detalle_vue',
    data: {
        rmt_url: rmt_url,
        url_modulo: rmt_url + "/casateconmigo/bodas/",
        api_url: rmt_url + "/api/",

        model_invitacion: {
            id_events_weddings: 0,
            invitacion_text: "",
            invitacion_img: "",
            id_bloqueo: id_bloqueo,
        },
        img_invitacion: "",

        loading: true,
    },
    created: function() {
        this.loadInfoInvitations();
    },
    methods: {
        loadInfoInvitations: function() {
            var url_invitacion = this.api_url + "eventsWeddings?filter[{'property':'id_bloqueo','value':"+ this.model_invitacion.id_bloqueo +",'operator':=}]";
            this.$http.get(encodeURI(url_invitacion)).then(function(response) {
                var response_var = response.body;
                if(response_var.success == true) {
                    this.model_invitacion = response_var.data.eventsWeddings[0];
                }
                this.loading = false;

                this.initLibraries();
            }, function() {
                console.log('Error');
            });
        },
        saveInvitation: function() {
            this.model_invitacion.invitacion_text = editor.getData();
            var data = new FormData();
            data.append("id_bloqueo", this.model_invitacion.id_bloqueo);
            data.append("invitacion_text", this.model_invitacion.invitacion_text);
            data.append("invitacion_img", this.model_invitacion.invitacion_img);
            data.append("img", this.img_invitacion);

            this.$http.post(this.url_modulo + "saveInvitation", data).then(function(response) {
                var response_var = response.body;
                console.log(response_var)
                //this.model_invitacion = response_var;
                if(response_var.success == true) {
                    Swal.fire({
                        type: 'success',
                        title: 'Correcto',
                        text: 'Se ha guardado la información.'
                    });
                } else {
                    Swal.fire({
                        type: 'success',
                        title: 'Correcto',
                        text: 'Ha ocurrido un error, recargue la página e intente de nuevo.'
                    });
                }
            }, function() {
                console.log('Error');
            });
        },
        updateInvitation: function() {
            this.model_invitacion.invitacion_text = editor.getData();
            var data = new FormData();
            data.append("id_bloqueo", this.model_invitacion.id_bloqueo);
            data.append("invitacion_text", this.model_invitacion.invitacion_text);
            data.append("invitacion_img", this.model_invitacion.invitacion_img);
            data.append("img", this.img_invitacion);

            this.$http.post(this.url_modulo + "updateInvitation", data).then(function(response) {
                var response_var = response.body;
                console.log(response_var)
                //this.model_invitacion = response_var;
                if(response_var.success == true) {
                    Swal.fire({
                        type: 'success',
                        title: 'Correcto',
                        text: 'Se ha actualizado la información.'
                    });
                } else {
                    Swal.fire({
                        type: 'error',
                        title: 'Correcto',
                        text: 'Ha ocurrido un error, recargue la página e intente de nuevo.'
                    });
                }
            }, function() {
                console.log('Error');
            });
        },
        loadedImgInvitation: function(event) {
            this.img_invitacion = event.target.files[0];
            this.model_invitacion.invitacion_img = this.model_invitacion.id_bloqueo + "-" + this.img_invitacion.name.replace(/\s+/g, '-');
        },
        initLibraries: function() {
            setTimeout(function() {
                $('.dropify').dropify();
            }, 1000);

            ClassicEditor
                .create( document.querySelector( '#editor' ) )
                .then( newEditor => {
                    editor = newEditor;
                } )
                .catch( error => {
                    console.error( error );
                } );
        }
    }
});