Vue.http.options.emulateJSON = true;

var appBodas = new Vue({
    el: '#bodas_vue',
    data: {
        rmt_url: rmt_url,
        api_url: rmt_url + "/api/",
        casate_url: 'https://test.apituristico.com/casateconmigo/WebServiceRMT.asmx',
        //rmt_url: 'https://test.apituristico.com/rmt/WebServiceRMT.asmx',
        url_img_1: 'https://www.fotojet.com/template-imgs/social-media-header/facebook-cover/love-wedding-save-the-date-3.jpg',
        url_img_2: 'http://static.myfbcover.com/covers/Love-and-Emo/Unique_Wedding.png',

        loading: true,
        //array_params: JSON.parse(array_params),
        array_bodas: [],
        categorias: [],

        search_novios: "",
    	search_hotel: "",
        selected_estrellas: [],
        order: "newest",
    },
    created: function() {
        this.loadBodas();
        this.loadCategorias();
    },
    methods: {
        loadBodas: function() {
            post_data = { usuario: "reservaciones2@grupoisamx.com", password: "demo", "agencia": btoa(401) };
            this.$http.post(encodeURI(this.casate_url + "/Bodas"), post_data).then(function(response) {
                var response_bodas = response.body;
                this.array_bodas = response_bodas;
                this.loading = false;
            }, function() {
                console.log('Error');
            });
        },
        loadCategorias: function() {
            this.$http.get(this.api_url + 'categorias?limit=5').then(function(response) {
                var response_categorias = response.body;
                this.categorias = response_categorias.data.categorias;

                this.initCheckBox();
            }, function() {
                console.log('Error');
            });
        },
        getRandomImg: function () {
            var random = Math.floor(Math.random() * (+3 - +1)) + +1;
            if(random == 1) {
                return this.url_img_1;
            } else {
                return this.url_img_2;
            }
        },
        initCheckBox: function() {
            setTimeout(function() { 
                $('input').iCheck({
                    checkboxClass: 'icheckbox_square-grey',
                    radioClass: 'iradio_square-grey'
                }).on('ifChecked ifUnchecked', function(){
                    $(this)[0].dispatchEvent(new Event("change"));
                });
            }, 1000);
        },
        parseDate: function(date) {
            return moment(date).format('DD/MM/YYYY');
        },
        round: function(value, decimals) {
            return Number(Math.round(value+'e'+decimals)+'e-'+decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        }
    },
    computed: {
    	filteredBodas() {
            var that = this;
            if(this.order == "newest" || this.order == "first") {
                this.array_bodas.sort(function(a, b) {
                    a = new Date(a.fecha_inicio);
                    b = new Date(b.fecha_inicio);
                    return a > b ? -1 : a < b ? 1 : 0;
                });
            } else {
                this.array_bodas.sort(function(a, b) {
                    a = new Date(a.fecha_inicio);
                    b = new Date(b.fecha_inicio);
                    return a > b ? 1 : a < b ? -1 : 0;
                });
            }

    		return this.array_bodas.filter(novios => {
                return novios.novios.toLowerCase().includes(that.search_novios.toLowerCase());
            }).filter(hotel => {
                return hotel.nombre_hotel.toLowerCase().includes(that.search_hotel.toLowerCase());
            });/*.filter(stars => {
                if (that.selected_estrellas.length > 0) {
                    return that.selected_estrellas.includes(parseInt(stars.estrellas));
                } else {
                    return stars;
                }
            })*/;
    	}
    }
});