// ------------------------------- IMPORTANTE ------------------------------------------
// CHECAR PORQUE NO SE OCULTA EL BOTÓN DE "APLICAR CAMBIOS" CUANDO SE GUARDAN LOS CAMBIOS
// -------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------

Vue.http.options.emulateJSON = true;

var appBodas = new Vue({
    el: '#detalle_vue',
    data: {
        rmt_url: rmt_url,
        url_img: "",
        url_img_1: 'https://www.fotojet.com/template-imgs/social-media-header/facebook-cover/love-wedding-save-the-date-3.jpg',
        url_img_2: 'http://static.myfbcover.com/covers/Love-and-Emo/Unique_Wedding.png',
        
        options_edad: [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17],
        
        // busqueda
        search_guests: "",
        show_rooms: [],
        
        // loadings
        loading_info_boda: true,
        loading_roominglist: true,
        
        id_boda: id_boda,
        key_roominglist: 0,
        room_edited: 999999,
        info_boda: [],
        
        // arrays roominglist
        roominglist: [], //response ws
        aux_array_roominglist: [], //aux array para comparar
        response_roominglist: "", // aux stringify para comparar
    },
    created: function() {
        this.getRandom();
        this.loadRoominglist();
        this.loadInfoBoda();
    },
    methods: {
        loadInfoBoda: function() {
            var that = this;
            var url_info = encodeURI(this.rmt_url + '/bloqueos/getDetailBloqueo/id/' + this.id_boda+'/id_agencia/9');
            this.$http.get(encodeURI(url_info)).then(function (response) {
                that.info_boda = response.body;
                that.loading_info_boda = false;
                setTimeout(function() {
                    //alert("Hello")
                    that.initICheck();
                }, 1000);
            },function () {
                console.log('Error');
            });
        },
        loadRoominglist: function() {
            var that = this;
            var url_info = this.rmt_url + '/api/roominglist?filter=[{"property":"id_bloqueo",value:' + this.id_boda + ',operator:"="}]';
            this.$http.get(encodeURI(url_info)).then(function(response) {
                that.roominglist = response.body.data.roominglist;
                var response_boda = new Array();
                that.roominglist.forEach(function(item, index) {
                    that.aux_array_roominglist.push({
                        no_hab: (index + 1),
                        id_roominglist: item.id_roominglist,
                        adultos: [],
                        menores: [],
                        has_desglose: ((item.Desglose.length > 0) ? true : false),
                        edited: false,
                    });
                    if(item.Desglose.length > 0) {
                        that.addPaxFromDesglose(item, index);
                    } else {
                        that.addPaxFromRoominglist(item, index);
                    }
                });
                that.response_roominglist = JSON.stringify(that.aux_array_roominglist);
            }, function() {
                console.log('Error');
            });
        },
        addPax: function(room, id_roominglist, type) {
            var index_room = this.aux_array_roominglist.findIndex(x => x.id_roominglist === id_roominglist);
            if(this.checkEditedRoom(id_roominglist) == true) {
                return;
            } else {
                this.room_edited = id_roominglist;
            }

            var no_pax = 0;
            if(typeof room.adultos != "undefined") {
                no_pax += room.adultos.length;
            } else {
                room.adultos = [];
            }

            if(typeof room.menores != "undefined") {
                no_pax += room.menores.length;
            } else {
                room.menores = [];
            }

            if(no_pax < 4) {
                if(type == "adulto") {
                    this.aux_array_roominglist[index_room].adultos.push({
                        nombre: "",
                        apellido: "",
                    });

                } else {
                    if(typeof this.aux_array_roominglist[index_room].menores == "undefined") {
                        this.roominglist.RoomingList[index_room].menores = [];
                    }
                    this.aux_array_roominglist[index_room].menores.push({
                        nombre: "",
                        apellido: "",
                        edad: 0,
                    });
                }
                this.aux_array_roominglist[index_room].edited = true;
                this.key_roominglist++;
            }
        },
        deletePax: function(id_roominglist, index_pax, type) {
            var index_room = this.aux_array_roominglist.findIndex(x => x.id_roominglist === id_roominglist);
            if(this.checkEditedRoom(id_roominglist) == true) {
                return;
            }

            this.aux_array_roominglist[index_room][type].splice(index_pax, 1);
            this.aux_array_roominglist[index_room].edited = true;
            this.key_roominglist++;
        },
        addPaxFromDesglose: function(item, index) {
            var that = this;
            item.Desglose.forEach(function (element) {
                if(element.tipo == "A")  {
                    that.aux_array_roominglist[index].adultos.push({
                        id_pax: element.id_pax,
                        nombre: element.nombre,
                        apellido: element.apellido,
                    });
                } else {
                    that.aux_array_roominglist[index].menores.push({
                        id_pax: element.id_pax,
                        nombre: element.nombre,
                        apellido: element.apellido,
                        edad: element.edad,
                    });
                }
            });
        },
        addPaxFromRoominglist: function(item, index) {
            var that = this;
            if(item.nombre == "") var array_adultos = []; else var array_adultos = item.nombre.split(" / ");
            if(item.menor == "" || item.menor == null) var array_menores = []; else var array_menores = item.menor.split(" / ");
            if(item.edad == "" || item.edad == null) var array_edades = []; else var array_edades = item.edad.split(",");
            
            array_adultos.forEach(function (element) {
                var array_nombre = element.split(" ");
                that.aux_array_roominglist[index].adultos.push({
                    nombre: array_nombre[1],
                    apellido: array_nombre[0],
                });
            });
            
            array_menores.forEach(function (element, index_menor) {
                var array_nombre = element.split(" ");
                that.aux_array_roominglist[index].menores.push({
                    nombre: array_nombre[1],
                    apellido: array_nombre[0],
                    edad: array_edades[index_menor],
                });
            });
        },
        confirmChanges: function(id_roominglist) {
            var index_room = this.aux_array_roominglist.findIndex(x => x.id_roominglist === id_roominglist);
            Swal.fire({
                type: "warning",
                title: "Atención",
                text: "¿Esta seguro que desea guardar los cambios?",

                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Si, guardar",
                cancelButtonText: "No, descartar"
            }).then((result) => {
                if (result.value) {
                    this.applyChanges(index_room)
                } else {
                    this.undoChanges(id_roominglist);
                }
            });
        },
        applyChanges: function(index_room) {
            var that = this;
            var aux_array = this.aux_array_roominglist[index_room];
            var original_array = JSON.parse(this.response_roominglist)[index_room];
            // aux_array.edited = false;
            Vue.set(aux_array, "edited", false);
            console.log(aux_array);

            var data = new FormData();
            data.append("roominglist", JSON.stringify(aux_array));
            this.$http.post(encodeURI(this.rmt_url + "/casateconmigo/bodas/saveRoominglist"), data).then(function(response) {
                var response_boda = response.body;
                if(response_boda.success == true) {
                    Swal.fire({
                        type: 'success',
                        title: 'Correcto',
                        text: 'Se ha actualizado el roominglist.'
                    });
                } else {
                    Swal.fire({
                        type: 'error',
                        title: '¡Ops!',
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_boda) + "</pre></code>",
                    });
                }

                console.log("before")
                console.log(index_room)
                that.$set(that.aux_array_roominglist[index_room], "edited", original_array.edited);
                that.aux_array_roominglist[index_room].edited = false;
                console.log(that.aux_array_roominglist[index_room].edited);
                console.log("after")

                that.room_edited = 999999;
                that.key_roominglist++;
            }, function(e) {
                console.log(e);
                that.aux_array_roominglist[index_room].edited = false;
                that.room_edited = 999999;
                that.key_roominglist++;
                Swal.fire({
                    type: 'error',
                    title: '¡Ops!',
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(e.body) + "</pre></code>",
                });
            });
        },
        undoChanges: function(id_roominglist) {
            var index_room = this.aux_array_roominglist.findIndex(x => x.id_roominglist === this.room_edited);
            if(this.room_edited != id_roominglist || this.aux_array_roominglist[index_room].edited == true) {
                var aux = JSON.parse(this.response_roominglist)[index_room];
                this.$set(this.aux_array_roominglist, index_room, aux);
                this.room_edited = 999999;
                this.key_roominglist++;
            }
        },
        checkEditedRoom: function(id_roominglist) {
            var index_room = this.aux_array_roominglist.findIndex(x => x.id_roominglist === id_roominglist);
            if(this.room_edited == 999999) {
                this.room_edited = id_roominglist;
                return false;
            } else if(this.room_edited == id_roominglist) {
                return false;
            } else {
                var index_room = -1;
                var edited = this.aux_array_roominglist.some(room =>{
                    index_room++;
                    return room.edited == true;
                });

                if(index_room >= 0 && edited == true) {
                    $(".form-control-plaintext").blur();
                    $(".form-control-sm").blur();
                    this.showSwalEdited(id_roominglist);
                }

                return edited;
            }
        },
        checkEditedRoomSelect: function(id_roominglist) {
            var index_room = this.aux_array_roominglist.findIndex(x => x.id_roominglist === id_roominglist);
            if(this.room_edited == id_roominglist) {
                return false;
            } else if(this.room_edited == 999999) {
                this.room_edited = id_roominglist;
                this.aux_array_roominglist[index_room].edited = true;
            }
        },
        showSwalEdited: function(id_roominglist) {
            var index_room = this.aux_array_roominglist.findIndex(x => x.id_roominglist === id_roominglist);
            Swal.fire({
                type: "warning",
                title: "Atención",
                text: "Aún tiene cambios sin guardar en la habitación " + this.aux_array_roominglist[index_room].habitacion + ", ¿Desea guardar los cambios?",

                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Si, guardar",
                cancelButtonText: "No, descartar"
            }).then((result) => {
                if (result.value) {
                    Swal.fire({
                        type: "success",
                        title: "Correcto",
                        text: "Se han aplicado los cambios"
                    })
                } else {
                    this.undoChanges(id_roominglist);
                }
            });
        },
        initICheck: function () {
            $('input').iCheck({
                checkboxClass: 'icheckbox_square-grey',
                radioClass: 'iradio_square-grey'
            }).on('ifChecked ifUnchecked', function(){
                $(this)[0].dispatchEvent(new Event("change"));
            });

            $("#chk_empty").iCheck("check");
            $("#chk_pax").iCheck("check");
        },
        getRandom: function() {
            var random = Math.floor(Math.random() * (+3 - +1)) + +1;
            if(random == 1) {
                this.url_img = this.url_img_1;
            } else {
                this.url_img = this.url_img_2;
            }
        },
        parseDate: function(date) {
            return moment(date).format('DD/MM/YYYY');
        },
        round: function(value, decimals) {
            return Number(Math.round(value+'e'+decimals)+'e-'+decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
        test_method: function() {
            console.log("event");
        }
    },
    watch: {
        aux_array_roominglist: {
            handler: function (val, oldVal) {
                if(oldVal != 0) {
                    var that = this;
                    var original = JSON.parse(that.response_roominglist);

                    for (var i = 0; i < val.length; i++) {
                        if(JSON.stringify(val[i]) != JSON.stringify(original[i])) {
                            that.aux_array_roominglist[i].edited = true;
                            return false;
                        }
                    }
                }
            },
            deep: true
        }
    },
    computed: {
        filteredGuests() {
            var that = this;
            return this.aux_array_roominglist.filter(room => {
                var array_adultos = false, array_menores = false;

                if(typeof room.adultos != "undefined") {
                    array_adultos = room.adultos.some(guests => {
                        return guests.nombre.toLowerCase().includes(that.search_guests.toLowerCase());
                    });
                } else if(typeof room.adultos == "undefined") {
                    if(that.search_guests == "") array_adultos = true;
                    else array_adultos = false;
                }

                if(typeof room.menores != "undefined") {
                    array_menores = room.menores.some(guests => {
                        return guests.nombre.toLowerCase().includes(that.search_guests.toLowerCase());
                    });
                } else if(typeof room.menores == "undefined") {
                    if(that.search_guests == "") array_menores = true;
                    else array_menores = false;
                }

                if(array_adultos == true || array_menores == true) return true;
                else return false;
            }).filter(occupancy => {
                if(that.show_rooms != 0 && that.show_rooms.length < 2) {
                    var num_pax = 0;
                    if(typeof occupancy.adultos != "undefined") num_pax += occupancy.adultos.length;
                    if(typeof occupancy.menores != "undefined") num_pax += occupancy.menores.length;
                    if(that.show_rooms[0] == "empty") {
                        if(num_pax == 0) return true;
                        else return false;
                    } else if(that.show_rooms[0] == "pax") {
                        if(num_pax > 0) return true;
                        else return false;
                    }
                } else {
                    return true;
                }
            })
        }

    }

});