var appBookTour = new Vue({
    el: '#booking_tour',
    data: {
        info_tour: info_tour,
        rooming: rooming,
        rate_code: rate_code,
        id_usuario: id_usuario,
        id_agencia: JSON.parse(localStorage.getItem("info_agencia")).id_agencia,
        fecha_reserva: moment().format("YYYY-MM-DD"),
        comision: JSON.parse(localStorage.getItem("info_agencia")).porcentaje_comision,
        array_pax: [],
        importe: 0.00,

        //xcaret descuento
        porc_descuento: 0,
        es_descuento: es_descuento,
    },
    created: function() {
        this.initArrayPax();

        setTimeout(function() { 
            $('input').iCheck({
                checkboxClass: 'icheckbox_square-grey',
                radioClass: 'iradio_square-grey'
            }).on('ifChecked ifUnchecked', function(){
                $(this)[0].dispatchEvent(new Event("change"));
            });
        }, 1000);

        if(this.es_descuento == true) {
            this.porc_descuento = 0.10;
           
        } else {
            this.porc_descuento = 1;
        }
            this.printTotalReserva();
    },
    methods: {
        initArrayPax: function() {
            this.array_pax.adultos = [];
            this.array_pax.menores = [];
            for (var i = 1; i <= this.rooming.num_adultos; i++) {
                this.array_pax.adultos.push({
                    nombre: '',
                    apellido: ''
                });
            }
            for (var i = 1; i <= this.rooming.num_ninios; i++) {
                this.array_pax.menores.push({
                    nombre: '',
                    apellido: '',
                    edad: 0,
                });
            }
        },
        printTotalReserva: function() {
            var adults_price, children_price;
            var adults_price = this.info_tour.tarifas[this.rate_code].desglose.filter(function(i) {
                return i.tipo === "Adulto";
            });
            var adult_price = adults_price[0];

            var total = (adult_price.precio * this.info_tour.tarifas[this.rate_code].tasa_cambio) * this.rooming.num_adultos;

            if(this.rooming.num_ninios > 0) {
                var that = this;
                var array_menores = Object.values(this.rooming.num_edad);
                var children_price = this.info_tour.tarifas[this.rate_code].desglose.filter(function(i) {
                    return i.tipo === "Menor";
                });
                if(children_price.length > 0) {
                    children_price.forEach(function(element, index) {
                        array_menores.forEach(function(element_edad, index_edad) {
                            if(element_edad >= parseInt(element.edad_min) && element_edad <= parseInt(element.edad_max)) {
                                total += (element.precio * that.info_tour.tarifas[that.rate_code].tasa_cambio);
                            } else if(element_edad > parseInt(element.edad_max)) {
                                total += (adult_price.precio * that.info_tour.tarifas[that.rate_code].tasa_cambio);
                            }
                        });
                    });
                } else {
                    array_menores.forEach(function(element) {
                        if(element >= parseInt(adult_price.edad_min) && element <= parseInt(adult_price.edad_max)) {
                            total += (adult_price.precio * this.info_tour.tarifas[this.rate_code].tasa_cambio);
                        }
                    });
                }
            }

            this.importe = total;
            console.log(this.importe);
            if(this.es_descuento == true) {
                var total_discount = total * this.porc_descuento;
                var total_net = total - total_discount;
                this.importe = total_net;
                console.log(total_discount);
                console.log(total_net);
                console.log(this.importe);
            }
            
        },
        printTotalPasajero: function(item, index) {
            var total = item.desglose[index].precio * item.tasa_cambio;
            if(this.es_descuento == true) {
                var total_discount = total * this.porc_descuento;
                var total_net = total - total_discount;
                return this.round(total_net, 2);
            }
            return this.round(total, 2);
        },
        printMonedaTarifa: function(info_tour){

            var tipo_moneda = '';

            if (typeof info_tour.moneda!=undefined) {
                if (info_tour.moneda=='USD' && parseInt(info_tour.tasa_cambio)>1) {
                    tipo_moneda = 'MXN';
                }else{
                    tipo_moneda = info_tour.moneda;
                }
            }else{
                tipo_moneda = info_tour.moneda;
            }

            console.log(tipo_moneda);
            return tipo_moneda;

        },
        parseDate: function(date,format) {
            return moment(date).format(format);
        },
        round: function(value, decimals) {
            return Number(Math.round(value+'e'+decimals)+'e-'+decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
        test_method: function() {
        },
    }
});


$('input').iCheck({
    checkboxClass: 'icheckbox_square-grey',
    radioClass: 'iradio_square-grey'
});

$(".btn_pagar").click(function(e) {
     var form = validateForm();
    if($("#policy_terms").is(":not(:checked)") || form===false){
        alert("Debe aceptar los términos y condiciones para continuar");
    }
    else{
        document.forms["reservacion-form"].submit();
        
    }
});
function validateForm() {
  var x = document.forms["tourBook"]["TourReservacion[id_agente]"].value;
  var a = document.forms["tourBook"]["TourReservacion[id_agencia]"].value;
  var cn = document.forms["tourBook"]["TourReservacion[cliente_nombre]"].value;
  var ca = document.forms["tourBook"]["TourReservacion[cliente_apellido]"].value;

  if (x == "") {
    alert("Debe elegir un Agente");
    return false;
  }
  else if (a == "") {
    alert("Debe elegir un Agencia");
    return false;
  }
  else if (cn == "") {
    alert("Nombre de cliente es obligatorio");
    return false;
  }
  else if (ca=="") {
    alert("Apellido de cliente es obligatorio");
    return false;
  }else{
    return true;
  }
}