var appSuggestions = new Vue({
    el: '#suggestions',
    data: {
        baseUrl: baseUrl,
        info_search: JSON.parse(atob(info_search)),
        info_hotel: JSON.parse(atob(info_hotel)),

        info_destination: [],
        activities_suggestions: [],
        tour_suggestions: [],
        url_activities: "",
        url_tours: "",
        url_tour: "",
        loading_activities: true,
        loading_tours: true,

        num_adultos: 0,
        num_menores: 0,
        array_edades: [],
    },
    mounted: function() {
        this.getDestination();
    },
    methods: {
        getDestination: function() {
            this.$http.get(this.baseUrl + "/busqueda/getDestinationByHotel?id_hotel=" + this.info_hotel.id_hotel).then(function(response) {
                var response_destination = response.body;
                this.info_destination = response_destination;
                var tour = true, activity = true;
                if(this.info_destination.destination_tour == null) {
                    tour = false;
                }

                if(this.info_destination.destination_activity == null) {
                    activity = false;
                }
                //this.setRequestUrls(activity, tour);
            }, function() {
                console.log('Error');
            });
        },
        setRequestUrls: function(activity, tour) {
            // ---------------------------------- ACTIVITIES ---------------------------------------------------
            var that = this;
            if(activity == true) {
                this.url_activities = this.baseUrl + '/activities/index?hb_countriesActivities=' + this.info_destination.destination_activity.countrycode;
                this.url_activities += '&hb_destinoActivities=' + this.info_destination.destination_activity.destinationcode;
            }
            this.url_activities += '&fecha_entrada=' + this.info_search.fecha_ini;
            this.url_activities += '&fecha_salida=' + this.info_search.fecha_fin;

            // ------------------------------------ TOURS -------------------------------------------
            if(tour == true) {
                this.url_tours = this.baseUrl + '/tour/tarifas?destino=d_' + this.info_destination.destination_tour.id_destino;
                
            }
            this.url_tours += '&fecha_entrada=' + this.info_search.fecha_ini;
            this.url_tour += '&fecha_entrada=' + this.info_search.fecha_ini;

            // ----------------------------------- MENORES Y ADULTOS PARA AMBOS ----------------------------------
            for (var i = 1; i <= parseInt(this.info_search.habs); i++) {
                var item = that.info_search["habitacion_" + i];
                that.num_adultos += parseInt(item.adultos);
                var num_ninios = parseInt(item.num_ninios);
                that.num_menores += num_ninios;
                if(num_ninios > 0) {
                    for (var j = 1; j <= num_ninios; j++) {
                        that.array_edades.push(parseInt(item["edad_" + j]));
                    }
                }
            }

            this.url_activities += '&num_adultos=' + this.num_adultos;
            this.url_activities += '&num_ninios=' + this.num_menores;

            this.url_tours += '&num_adultos=' + this.num_adultos;
            this.url_tours += '&num_ninios=' + this.num_menores;
            this.url_tour += '&num_adultos=' + this.num_adultos;
            this.url_tour += '&num_ninios=' + this.num_menores;

            if(this.num_menores > 0) {
                for (var i = 1; i <= this.num_menores; i++) {
                    that.url_activities += '&num_edad[edad_' + i + ']=' + that.array_edades[i - 1];
                    that.url_tours += '&num_edad[edad_' + i + ']=' + that.array_edades[i - 1];
                    that.url_tour += '&num_edad[edad_' + i + ']=' + that.array_edades[i - 1];
                }
            }

            if(activity == true) {
                this.loadActivities();
            } else{
                this.loading_activities = false;
            }

            if(tour == true) {
                this.loadTours();
            } else {
                this.loading_tours = false;
            }
        },
        loadActivities: function() {
            var that = this;
            this.$http.get(encodeURI(this.url_activities)).then(function(response) {
                var response_activities = response.body;
                this.activities_suggestions = response_activities;
                this.activities_suggestions.forEach(function(element,index) {
                    if (typeof element.activity == "undefined" || typeof element.errors != "undefined" ) {
                        
                        delete that.activities_suggestions[index];
                    } else {
                        element.activity.modalities.sort(that.orderTarifasActivities);
                    }

                });
                var nuevoActivities= Object.values(that.activities_suggestions);
                that.activities_suggestions=nuevoActivities;
                this.loading_activities = false;
                console.log(this.activities_suggestions);
                $('.carousel_activities').on('slide.bs.carousel', function (e) {
                    var $e = $(e.relatedTarget);
                    var idx = $e.index();
                    var itemsPerSlide = 3;
                    var totalItems = $('.carousel-item').length;
                    
                    if (idx >= totalItems - (itemsPerSlide - 1)) {
                        var it = itemsPerSlide - (totalItems - idx);
                        for (var i = 0; i < it; i++) {
                            // append slides to end
                            if (e.direction=="left") {
                                $('.carousel-item').eq(i).appendTo('.carousel-inner');
                            }
                            else {
                                $('.carousel-item').eq(0).appendTo('.carousel-inner');
                            }
                        }
                    }
                });
            }, function() {
                console.log('Error');
            });
        },
        loadTours: function() {
            this.$http.get(encodeURI(this.url_tours)).then(function(response) {
                var response_tours = response.body;
                this.tour_suggestions = response_tours;

                var that = this;
                this.tour_suggestions.forEach(function (element, index) {
                    if (element.idTipoCategoria != 2 || element.idTipoCategoria != 7) {
                        element.tarifas.sort(this.orderTarifasTours);
                    }
                });

                this.loading_tours = false;

                $('.carousel_tours').on('slide.bs.carousel', function (e) {
                    var $e = $(e.relatedTarget);
                    var idx = $e.index();
                    var itemsPerSlide = 3;
                    var totalItems = $('.carousel-item').length;
                    
                    if (idx >= totalItems - (itemsPerSlide - 1)) {
                        var it = itemsPerSlide - (totalItems - idx);
                        for (var i = 0; i < it; i++) {
                            // append slides to end
                            if (e.direction=="left") {
                                $('.carousel-item').eq(i).appendTo('.carousel-inner');
                            }
                            else {
                                $('.carousel-item').eq(0).appendTo('.carousel-inner');
                            }
                        }
                    }
                });
            }, function() {
                console.log('Error');
            });
        },

        orderTarifasActivities: function(a, b) {
            if(a.rates[0].rateDetails[0].totalAmount.amount > b.rates[0].rateDetails[0].totalAmount.amount) {
                return 1;
            }

            if(a.rates[0].rateDetails[0].totalAmount.amount < b.rates[0].rateDetails[0].totalAmount.amount) {
                return -1;
            }
            return 0;
        },
        orderTarifasTours: function (a, b) {
            var that = this;
            var total_a = 0; var total_b = 0;
            a.desglose.forEach(function (element) {
                if (element.Tipo == "Adulto") {
                    total_a += that.array_params.num_adultos * (element.precio * a.tasa_cambio);
                } else {
                    total_a += that.array_params.num_ninios * (element.precio * a.tasa_cambio);
                }
            });

            b.desglose.forEach(function (element) {
                if (element.Tipo == "Adulto") {
                    total_a += that.array_params.num_adultos * (element.precio * b.tasa_cambio);
                } else {
                    total_a += that.array_params.num_ninios * (element.precio * b.tasa_cambio);
                }
            });

            if (total_a > total_b) {
                return -1;
            }

            if (total_a < total_b) {
                return 1;
            }
            return 0;
        },
        printTotalActivity: function(modalitity,index) {
            return this.round((modalitity.rates[0].rateDetails[0].totalAmount.amount / this.activities_suggestions[index].markup),2);
        },
        printTotalTour: function (item, form = false) {
            var adults_price, children_price;
            var item_array = Object.values(item);
            var adults_price = item.desglose.filter(function (i) {
                return i.tipo === "Adulto";
            });
            var adult_price = adults_price[0];

            var total = (adult_price.precio * item.tasa_cambio) * this.num_adultos;

            if (this.num_ninios > 0) {
                var that = this;
                var array_menores = Object.values(this.array_edades);
                var children_price = item.desglose.filter(function (i) {
                    return i.tipo === "Menor";
                });
                if (children_price.length > 0) {
                    children_price.forEach(function (element, index) {
                        array_menores.forEach(function (element_edad, index_edad) {
                            if (element_edad >= parseInt(element.edad_min) && element_edad <= parseInt(element.edad_max)) {
                                total += (element.precio * item.tasa_cambio);
                            } else if (element_edad > parseInt(element.edad_max)) {
                                total += (adult_price.precio * item.tasa_cambio);
                            }
                        });
                    });
                } else {
                    array_menores.forEach(function (element) {
                        if (element >= parseInt(adult_price.edad_min) && element <= parseInt(adult_price.edad_max)) {
                            total += (adult_price.precio * item.tasa_cambio);
                        }
                    });
                }
            }
            if (form == true) {
                return total;
            }
            return this.round(total, 2);
        },
        round: function (value, decimals) {
            return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        }
    }
});