Vue.http.options.emulateJSON = true;

var appBookingList = new Vue({
    el: "#booking_list",
    data: { 
        api_url: rmt_url + "/api/",
        rmt_url: rmt_url,
        id_agencia: id_agencia,
        tipo_usuario: tipo_usuario,
        id_usuario: id_usuario,
        info_agencia: JSON.parse(localStorage.getItem("info_agencia")),

        //variables generales
        loading_reservas: true,
        loading_activities: true,
        loading_tours: true,
        loading_recibos_agencia: true,
        loading_proximos_pagos: true,
        show_content: false,
        show_activitiy: false,
        show_tour: false,
        div_active: 'reservas',
        total_mxn: 0,
        total_usd: 0,

        //arreglos
        array_prox_pagos_bookings: [],
        array_prox_pagos_activities: [],
        array_prox_pagos_tours: [],
        days_prox_pagos: 30, // 7
        array_bookings: [],
        array_activities: [],
        array_tours: [],
        array_user:[],

        recibos_agencia:[],

        //filtros
        search_reserva: "",
        search_customer_reserva: "",
        search_pax_reserva: "",
        order_fecha_reserva: "",
        filter_status_reserva: "",

        search_activity: "",
        search_pax_activity: "",
        order_fecha_activity: "",

        search_tour: "",
        search_pax_tour: "",
        order_fecha_tour: "",
        order_fecha_recibo: "",

        search_idRecibo:'',

        //infinite scroll reservaciones
        show   : false, // display content after API request
        offset : 5,     // items to display after scroll
        display: 5,     // initial items
        trigger: 150,   // how far from the bottom to trigger infinite scroll
        end    : false, // no more resources

        // cuentas permitidas para facturar
        cuenta_cfdi: ['1','3','16','17'],
        tipo_pago:'0',
        motivo_cancelacion:['Pasajero no viaja','Cambios en la reserva','Monto sin saldar','Otro'],
        model_id_reserva: 0,
        politicasCancelacion:[],
        cancelar:"SIMULATION",

    },
    created: function(){
        this.loadBookings();
        this.loadActivities();
        this.loadTours();
        this.loadRecibos();
    },
    methods:{
        loadUser:function(){
            var url_usuario="";
            
                url_usuario = this.api_url + 'usuariosRest?filter=[{"property":"id_usuario","value":' + this.id_usuario + ',"operator":=}]';
            
            this.$http.get(encodeURI(url_usuario)).then(function(response){
                this.array_user = response.body.data.usuariosRest[0];
               
                this.loadBookings();
                this.loadActivities();
                this.loadTours();
            }, function(ex){
                console.log(ex);
            });
        },
        loadProxPagos: function() {
            var that = this;
            var now = moment(new Date());
            this.array_bookings.forEach(function(element) {
                var end = moment(element.fecha_limite);
                var duration_after = moment.duration(end.diff(now));
                var duration_before = moment.duration(now.diff(end));
                var days_after = duration_after.asDays();
                var days_before = duration_before.asDays();
                /*console.log(days_after + " después");
                console.log(days_before + " antes");*/

                if(days_after <= that.days_prox_pagos && days_after >= 0 && element.estatus != "C" && parseFloat(element.saldo) > 0) {
                    that.array_prox_pagos_bookings.push(element);
                    if(element.desglose_rate == null || element.desglose_rate == "") {
                        that.total_mxn += parseFloat(element.saldo);
                    } else {
                        that.total_usd += parseFloat(element.saldo);
                    }
                } else if((0 - that.days_prox_pagos) <= days_before && days_after >= (0 - that.days_prox_pagos) && element.estatus != "C" && parseFloat(element.saldo) > 0) {
                    that.array_prox_pagos_bookings.push(element);
                    if(element.desglose_rate == null || element.desglose_rate == "") {
                        that.total_mxn += parseFloat(element.saldo);
                    } else {
                        that.total_usd += parseFloat(element.saldo);
                    }
                }
            });

            this.array_activities.forEach(function(element) {
                var end = moment(element.fecha_limite);
                var duration_after = moment.duration(end.diff(now));
                var duration_before = moment.duration(now.diff(end));
                var days_after = duration_after.asDays();
                var days_before = duration_before.asDays();

                if(days_after <= that.days_prox_pagos && days_after >= 0 && element.estatus != "C" && parseFloat(element.saldo) > 0) {
                    that.array_prox_pagos_activities.push(element);
                    if(JSON.parse(element.Booking).currency == "MXN") {
                        that.total_mxn += parseFloat(element.saldo);
                    } else {
                        that.total_usd += parseFloat(element.saldo);
                    }
                } else if((0 - that.days_prox_pagos) <= days_before && days_after >= (0 - that.days_prox_pagos) && element.estatus != "C" && parseFloat(element.saldo) > 0) {
                    that.array_prox_pagos_activities.push(element);
                    if(JSON.parse(element.Booking).currency == "MXN") {
                        that.total_mxn += parseFloat(element.saldo);
                    } else {
                        that.total_usd += parseFloat(element.saldo);
                    }
                }
            });

            this.array_tours.forEach(function(element) {
                var end = moment(element.fecha_limite);
                var duration_after = moment.duration(end.diff(now));
                var duration_before = moment.duration(now.diff(end));
                var days_after = duration_after.asDays();
                var days_before = duration_before.asDays();
                if(days_after <= that.days_prox_pagos && days_after >= 0 && element.estatus != "C" && parseFloat(element.saldo) > 0) {
                   
                    if(element.idTarifa.moneda == "USD") {
                        that.total_usd += parseFloat(element.saldo);
                    } else {
                        that.total_mxn += parseFloat(element.saldo);
                    }
                    that.array_prox_pagos_tours.push(element);
                } else if((0 - that.days_prox_pagos) <= days_before && days_after >= (0 - that.days_prox_pagos) && element.estatus != "C" && parseFloat(element.saldo) > 0) {
                    that.array_prox_pagos_tours.push(element);
                    if(element.idTarifa.moneda == "USD") {
                        that.total_usd += parseFloat(element.saldo);
                    } else {
                        that.total_mxn += parseFloat(element.saldo);
                    }
                }
            });

            this.loading_proximos_pagos = false;
        },
        loadBookings: function() {
            var url_reservas;
            if (this.id_agencia == 9) {
                var limit = 4000;
                if (this.id_usuario == 1437 || this.id_usuario == 1542) {
                    limit = 100;
                }

                // this.id_usuario = 1445;
                 url_reservas = this.api_url + 'reservacionRest?limit='+limit+'&sort=[{"property":"log", "direction":"DESC"}, {"property":"id_agente","value":' + this.id_usuario + ',"operator":=}]';
             
            } else if(this.info_agencia.show_sales == "1" || this.array_user.tipo_usuario != "agv") {
                url_reservas = this.api_url + 'reservacionRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=}]&sorter=[{"property":"log", "direction":"DESC"}]';
            } else {
                url_reservas = this.api_url + 'reservacionRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=},{"property":"id_usuario","value":' + this.id_usuario + ',"operator":=}]&sorter=[{"property":"log", "direction":"DESC"}]';
            }
            //var url_reservas = this.api_url + 'reservacionRest?filter=[{"property":"id_agencia","value":' + 1293 + ',"operator":=}]';
            this.$http.get(encodeURI(url_reservas)).then(function(response) {
                this.array_bookings = response.body.data.reservacionRest;
                // console.log(this.array_bookings);
                this.loading_reservas = false;
                this.show_content = true;
                this.loadProxPagos();
            }, function() {
                console.log('Error');
            });
        },
        loadActivities: function() {
            var url_activities
            if (this.id_agencia == 9) {
                url_activities = this.api_url + 'activityReservacionRest?limit=50&sort=[{"property":"log", "direction":"DESC"}]';
            } else if(this.info_agencia.show_sales == "1" || this.array_user.tipo_usuario != "agv") {
                url_activities = this.api_url + 'activityReservacionRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=}]&sorter=[{"property":"log", "direction":"DESC"}]';
            } else {
                url_activities = this.api_url + 'activityReservacionRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=},{"property":"id_usuario","value":' + this.id_usuario + ',"operator":=}]&sorter=[{"property":"log", "direction":"DESC"}]';
            }
            this.$http.get(encodeURI(url_activities)).then(function(response) {
                this.array_activities = response.body.data.activityReservacionRest;
                this.loading_activities = false;
                this.show_activitiy = true;
            }, function() {
                console.log('Error');
            });
        },
        loadTours: function() {
            var url_tours
            if (this.id_agencia == 9) {
                 url_tours = this.api_url + 'tourReservacionRest?limit=50&sort=[{"property":"log", "direction":"DESC"}]';
            } else if(this.info_agencia.show_sales == "1" || this.array_user.tipo_usuario != "agv") {
                url_tours = this.api_url + 'tourReservacionRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=}]&sorter=[{"property":"log", "direction":"DESC"}]';
            } else {
                url_tours = this.api_url + 'tourReservacionRest?filter=[{"property":"id_agencia","value":' + this.id_agencia + ',"operator":=},{"property":"id_usuario","value":' + this.id_usuario + ',"operator":=}]&sorter=[{"property":"log", "direction":"DESC"}]';
            }
            this.$http.get(encodeURI(url_tours)).then(function(response) {
                this.array_tours = response.body.data.tourReservacionRest;
                this.loading_tours = false;
                this.show_tour = true;
                //console.log(this.array_tours);
            }, function() {
                console.log('Error');
            });
        },
        loadRecibos: function(){
            this.$http.post(baseUrl + '/reservas/recibosAgencia', {agenciaUsuario:this.id_agencia}).then(function(response) {
                this.recibos_agencia = response.body.row;
                $("a").tooltip();
                this.loading_recibos_agencia = false;
            }, function() {
                console.log('Error');
            });
        },
        addSolicitudCancelacion: function(reserva,cancelar,tipo) {
           
              if (tipo==3) {
                 id_reserva=reserva.id_tourReservacion;
              }else{
                 id_reserva=reserva.id_reservacion;
              }
                var post_data = { id_motivo:$("#txt-motivo").val(), comentario:$("#txt-comentario").val(), id_reserva:id_reserva, id_usuario:this.id_usuario,tipo:tipo };
                    this.$http.post(this.api_url + "solicitudCancelacion",JSON.stringify(post_data)).then(function(response) {
                        if(response.body.success == "true") {
                            $("#modal-solicitud-cancelacion").removeClass("open");
                            if (cancelar==0) {
                                this.sendSolicitudCancelacion(response.body.data.solicitudCancelacion);
                                Swal.fire({
                                    type: 'info',
                                    title: 'Correcto',
                                    text: 'Se ha enviado la solicitud, tendrás una respuesta en un período de 24 a 48 horas.',
                                });    
                            }else if(cancelar==1){
                                post_data = { tipo:tipo,id_reserva:id_reserva,id_usuario:this.id_usuario };
                                this.$http.post(this.rmt_url + "/solicitudCancelacion/cancelarApis?id="+id_reserva, post_data).then(function(response) {
                                    if(response.body.success == "true") {
                                        $("#modal-solicitud-cancelacion").removeClass("open");
                                        Swal.fire({
                                            type: 'info',
                                            title: 'Correcto',
                                            text: 'Se ha enviado la Cancelación, el equipo de reservas de Ruta Maya Travel le dara seguimiento.',
                                        });
                                    } else {
                                        $("#modal-solicitud-cancelacion").removeClass("open");
                                        Swal.fire({
                                            type: 'error',
                                            title: '¡Ops!',
                                            html: "Algo salió mal. <pre><code>" + JSON.stringify(response) + "</pre></code>",
                                        });
                                    }
                                }, function(ex) {
                                    $("#modal-solicitud-cancelacion").removeClass("open");
                                    Swal.fire({
                                        type: 'error',
                                        title: '¡Ops!',
                                        html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
                                    });
                                    console.log(ex);
                                });
                            }
                        } else {
                            $("#modal-solicitud-cancelacion").removeClass("open");
                            Swal.fire({
                                type: 'error',
                                title: '¡Ops!',
                                html: "Algo salió mal. <pre><code>" + JSON.stringify(response) + "</pre></code>",
                            });
                        }
                    }, function(ex) {
                        $("#modal-solicitud-cancelacion").removeClass("open");
                        Swal.fire({
                            type: 'error',
                            title: '¡Ops!',
                            html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
                        });
                        console.log(ex);
                    });

                
          
        },

        sendSolicitudCancelacion: function(response_solicitud) {
            var post_data_email = { id_solicitud: response_solicitud.id_solicitud_cancelacion };
            this.$http.post(this.rmt_url + "/solicitudCancelacion/sendSolicitud", post_data_email).then(function(response) {
                if(response.ok == true) {

                } else {
                    Swal.fire({
                        type: 'error',
                        title: '¡Ops!',
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response) + "</pre></code>",
                    });
                }
            }, function(ex) {
                Swal.fire({
                    type: 'error',
                    title: '¡Ops!',
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
                });
                console.log(ex);
            });
        },
        getMonedaBooking: function(json_string) {
            var json = JSON.parse(json_string);
            return json.currency;
        },
        changeDiv: function() {
            element = event.currentTarget;
            this.div_active = element.getAttribute("data-div");
        },
        parseDate: function(date,format) {
            return moment(date).format(format);
        },
        round: function(value, decimals) {
            return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
        numberNigths: function (first, second) {
            var x=first;
            if (first=="today") {
                var today = new Date();
                first = today.getFullYear()+'-'+(today.getMonth()+1)+'-'+today.getDate();
                
            }
            var diff =  Math.floor(( Date.parse(second) - Date.parse(first) ) / 86400000);
            
            return diff;
        },
        showModal: function(index,tipo) {
            var url="";
            //console.log(this.filteredBookings[index]);
            var reserva;
            var id_hotel;
            var codigo;
            var code;
           
              if (tipo==0) {
                reserva=this.filteredBookings[index];
                codigo=reserva.idHotel.codigo;
                code=reserva.code;
                id_hotel=reserva.id_hotel;
                this.model_id_reserva =reserva.id_reservacion;
                    switch (reserva.idHotel.proveedor) {
                        case "1":
                            url="/reservas/cancelarBooking";
                            break;
                        case "2":
                            url="/omniBees/cancelarBooking";
                            break;
                        case "3":
                            url="/travelSolution/cancelarBooking";
                            break;
                        case "4":
                            url="/riu/cancelarBooking";
                            break;
                        case "5":
                            url="/dingus/cancelarBooking";
                            break;
                        case "6":
                            url="/palace/cancelarBooking?fecha_limite="+reserva.fecha_inicial+"&importe="+reserva.total;
                            break;
                        case "0":
                             url="/reservas/cancelarRmt?id_reservacion="+reserva.id_reservacion;
                            break;
                        default:
                            // statements_def
                            break;
                    }
              }else if(tipo==1){
                reserva=this.filteredActivities[index];
                id_hotel=0;
                codigo='Act';
                code=reserva.code;
                url="/reservas/activityInf";
              }else{
                reserva=this.filteredTours[index];
                url="/reservas/cancelarRmTours?id_reservacion="+reserva.id_tourReservacion;
                id_hotel=reserva.id_tour;
                code=reserva.code;
                codigo='Tour';
                
              }
         
                var post_data={"code":code,cancelar:'SIMULATION','idHotel':id_hotel,"hotel":codigo }
                this.$http.post(this.rmt_url +url, post_data).then(function(response) {
                
                    var politicasCancelacion=response.body;
                    modalCancelacion.loadPoliticas(politicasCancelacion,reserva,tipo);
                
                
                }, function(ex) {
                    Swal.fire({
                        type: 'error',
                        title: '¡Ops!',
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
                    });
                    console.log(ex);
                });
           

        },
        monedaActivity: function(booking){
            var moneda = '';
            if (booking !== '') {
                moneda = JSON.parse(booking).currency;
            }else{
                moneda = 'undefined';
            }
            return moneda;
        },
        puedeFacturarCFDI: function(recibo){
            // recibo.fecha_limite_factura!=null
            
            if (this.cuenta_cfdi.includes(recibo.id_cuenta)==true && 
                recibo.puede_facturar_fecha==1 && recibo.estado!='C' && recibo.fecha_limite_factura!=null && recibo.facturado==0) {

                return true;
            }

            return false;
        },
        scroll() {
            window.onscroll = ev => {
                if (
                    window.innerHeight + window.scrollY >= 
                    ($('#section-2')[0].offsetHeight)
                ) {
                    if(this.div_active == "reservas") {
                        if (this.display < this.array_bookings.length) {
                            this.display = this.display + this.offset;
                        } else {
                            this.end = true;
                        }
                    }
                }
            };
        }
    },
    computed: {
    	filteredBookings() {
            var that = this;
    		if(this.order_fecha_reserva == "newest" || this.order_fecha_reserva == '') {
    			this.array_bookings.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? -1 : a < b ? 1 : 0;
				});
    		} else {
    			this.array_bookings.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? 1 : a < b ? -1 : 0;
				});
    		}
    		return this.array_bookings.filter(booking => { 
                return booking.idHotel.nombre_hotel.toLowerCase().includes(this.search_reserva.toLowerCase());
            }).filter(pax => {
                var array_return = pax.reservacionDesglosePersonas.some(pass => {
                    return pass.nombre.toLowerCase().includes(that.search_pax_reserva.toLowerCase());
                });
                return array_return;
            }).filter(status => {
                if(that.filter_status_reserva == "cancel") {
                    if(status.estatus == "C") {
                        return status;
                    }
                } else {
                    if(status.estatus != "C") {
                        return status;
                    }
                }
            }).slice(0, this.display);
    	},
    	filteredActivities() {
    		if(this.order_fecha_activity == "newest" || this.order_fecha_activity == '') {
    			this.array_activities.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? -1 : a < b ? 1 : 0;
				});
    		} else {
    			this.array_activities.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? 1 : a < b ? -1 : 0;
				});
    		}
    		return this.array_activities.filter(activity => { 
                return activity.actividad.toLowerCase().includes(this.search_activity.toLowerCase());
            }).filter(pax => {
            	var name_pax = pax.nombre_cliente + " " + pax.apellido_cliente;
            	return name_pax.toLowerCase().includes(this.search_pax_activity.toLowerCase());
            });
    	},
    	filteredTours() {
    		if(this.order_fecha_tour == "newest" || this.order_fecha_tour == '') {
    			this.array_tours.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? -1 : a < b ? 1 : 0;
				});
    		} else {
    			this.array_tours.sort(function(a, b) {
    				a = new Date(a.log);
    				b = new Date(b.log);
    				return a > b ? 1 : a < b ? -1 : 0;
				});
    		}
    		return this.array_tours.filter(tour => { 
                return tour.idTour.nombre.toLowerCase().includes(this.search_tour.toLowerCase());
            }).filter(pax => {
            	var name_pax = pax.cliente_nombre + " " + pax.cliente_apellido;
            	return name_pax.toLowerCase().includes(this.search_pax_tour.toLowerCase());
            });
    	},
        filteredReceipt(){

            if(this.order_fecha_recibo == "newest" || this.order_fecha_recibo == '') {
                this.recibos_agencia.sort(function(a, b) {
                    a = new Date(a.log);
                    b = new Date(b.log);
                    return a > b ? -1 : a < b ? 1 : 0;
                });
            } else {
                this.recibos_agencia.sort(function(a, b) {
                    a = new Date(a.log);
                    b = new Date(b.log);
                    return a > b ? 1 : a < b ? -1 : 0;
                });
            }

            return this.recibos_agencia.filter(recibo => { 
                return recibo.id_recibo.toLowerCase().includes(this.search_idRecibo.toLowerCase());
            }).filter(tipoPago => {
                if (this.tipo_pago!=0) {
                    return parseInt(this.tipo_pago) == parseInt(tipoPago.id_tipo_pago) ? true : false;
                } else {
                    return tipoPago;
                }
            });
        }
    },
    mounted() {
        // track scroll event
        this.scroll();
    }
});

var modalCancelacion = new Vue({
    el: "#modal-solicitud-cancelacion",
    data: { 
        politicasCancelacion:[],
        cancel:{motivo:"", comentario:""},
        proveedor:"",
        cancelacionInmediata:"SIMULATION",
        reserva:[],
        tipo:"",
    },
     created: function(){
       
     
    },
    methods:{
        loadPoliticas:function(politicas,reserva,tipo){    
           this.politicasCancelacion=politicas;
           this.reserva=reserva; 
           this.tipo=tipo;
      
           $("#modal-solicitud-cancelacion").addClass("open");
        },
        closed:function(){
           $("#modal-solicitud-cancelacion").removeClass("open");

        },
        permitirCancelacion:function(){
            var arrayBtn= [];
            if (this.politicasCancelacion.btnCancelacion) {

                return this.politicasCancelacion.btnCancelacion.includes("1");
            }
           
        },
        cancellation:function(cancelacion){
            var that=this;
            var textform="Elige un motivo de canelación";
             var textsweet="Se procederá a enviar una solicitud de cancelación";
            if (cancelacion!=0) {
                textsweet="Si se cancela de inmediato no se podrá reinstalar";
            }
            if (this.cancel.motivo=="" || this.cancel.comentario=="") {
                console.log(this.cancelacionInmediata);
                if (this.cancel.comentario=="") {textform="No olvides poner la descripción"}
                Swal.fire({
                  title: 'Completa el formulario',
                  text: textform,
                  type: 'warning',
                  confirmButtonColor: '#3085d6',            
                  confirmButtonText: 'OK'
                }).then((result) => {
                    return false;
                })
            }else{
                Swal.fire({
                  title: '¿Estas seguro de cancelar?',
                  text: textsweet,
                  type: 'warning',
                  showCancelButton: true,
                  confirmButtonColor: '#3085d6',
                  cancelButtonColor: '#d33',
                  confirmButtonText: 'Si, Cancelar reserva!'
                }).then((result) => {
                    if (result.value) {
                        that.closed();
                        appBookingList.addSolicitudCancelacion(that.reserva,cancelacion,that.tipo);

                     }
                })
            }
          
            

          
             
        }
    }
});
