var app = new Vue({
    el: '#vuebloqueo',
    data: {

        datosBloqueos: [],
        bloqueo_apartadas: [],
        nombre_hotel: '',
        vista: false,
        price_sort: 'default',
        estrellas_cant: 0,
        ordenFecha: 'newest',
        NUM_RESULTS: 4,
        pag: 1,        
        cant_datos: '',

        categorias: [],
        api_url: rmt_url + "/api/",
        selected_estrellas: [],
        disponible_valor: null,
        showBloqueosApartadas: false,
        no_show_apartadas: false,
        show_historial: false,

        historial: [],

        title_filter: 'BLOQUEOS DISPONIBLES',

        paginate: ['items']

    },
    created: function () {
        this.javascripts();
    },
    mounted: function () {
       
        this.loadCategorias();
        this.loadBloqueos();
        this.bloqueosApartados();
    },
    methods: {

        formatPrice(value) {
            //redondea siempre para arriba
            var redondear = Math.ceil(value);
            let val = (redondear / 1).toFixed(2).replace(',', '.')
            return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        },
      
        javascripts: function () {
            $('input').iCheck({
                checkboxClass: 'icheckbox_square-grey',
                radioClass: 'iradio_square-grey'
            }).on('ifChecked ifUnchecked', function () {
                $(this)[0].dispatchEvent(new Event("change"));
            });
        },
        loadBloqueos: function () {

            this.$http.get(encodeURI(rmt_url + '/bloqueos/getLista')).then(function (response) {
                var response_bloqueos = response.body;
                this.datosBloqueos = response_bloqueos.item;
                this.historial = response_bloqueos.historial;                
                
                

                // if (vm.bloqueo_apartadas.length==0) {}
                // console.log(vm.bloqueo_apartadas);
                this.javascripts();
               
            }, function () {
                console.log('Error');

            });

        },
        bloqueosApartados: function () {
                   var vm=this; 
           
                this.$http.get(encodeURI(rmt_url + '/bloqueos/habitacionesApartadas')).then(function (response) {
                    var datosBloqueos = response.body;
                    
                   
                this.showBloqueosApartadas = true;
                datosBloqueos.forEach(function(element, index) {
                    if (element.hab_apartadas>0) {
                        vm.bloqueo_apartadas.push(datosBloqueos[index]);
                    }
                });
                }, function () {
                    console.log('Error');

                });
        
        },
        NotShowingHabs: function(){
            // console.log('Not Showing');
            $(".mostrar_bloqueos_apartadas").toggleClass('d-none');
        },
        ValidarNoDisponibles: function () {

            if (this.disponible_valor == false) {
                this.$http.get(encodeURI(rmt_url + '/bloqueos/getNoDisponibles')).then(function (response) {
                    this.datosBloqueos = response.body;
                    this.javascripts();
                }, function () {
                    console.log('Error');

                });
            } else if (this.disponible_valor == true) {
                this.loadBloqueos();
            } else if (this.disponible_valor == null) {
                this.disponible_valor = false;
                this.ValidarNoDisponibles();
            }
        },
        cambiarVistaCuadros() {

            this.vista = true;

        },
        cambiarVistaLista() {

            this.vista = false;

        },
        loadCategorias: function () {
            this.$http.get(this.api_url + 'categorias?limit=5').then(function (response) {
                var response_categorias = response.body;
                this.categorias = response_categorias.data.categorias;
                this.javascripts();
            }, function () {
                console.log('Error');
            });
        },

    },
    computed: {
        //icon_search
        buscar_bloqueo: function () {
            var self = this;
            var array_filter = [];
            // console.log(this.show_historial);
           
            if (this.show_historial==true) {
            	array_filter = this.historial;
            	this.title_filter = 'HISTORIAL DE MIS BLOQUEOS';
            }else{
            	array_filter = this.datosBloqueos;
            	this.title_filter = 'BLOQUEOS DISPONIBLES';
            }

            if (this.price_sort == "lower") {
                array_filter.sort(function (a, b) {
                    return parseFloat(a.precio_doble) > parseFloat(b.precio_doble) ? 1 : parseFloat(a.precio_doble) < parseFloat(b.precio_doble) ? -1 : 0;
                })
            } else if (this.price_sort == "higher") {
                array_filter.sort(function (a, b) {

                    return parseFloat(a.precio_doble) > parseFloat(b.precio_doble) ? -1 : parseFloat(a.precio_doble) < parseFloat(b.precio_doble) ? 1 : 0;
                })
            } else {
                array_filter.sort( ( a, b) => {
                    return new Date(a.fecha_inicio) - new Date(b.fecha_inicio);
                });
            }
            return array_filter.filter(function (tarifa) {
                self.pag = 1;
                if (self.selected_estrellas.length > 0) {
                    return self.selected_estrellas.includes(parseInt(tarifa.Estrellas)) && tarifa.hotel_nombre.toLowerCase().includes(self.nombre_hotel.toLowerCase());
                } else {
                    return tarifa.hotel_nombre.toLowerCase().includes(self.nombre_hotel.toLowerCase());
                }

            });

        },

    }

})
