	var crudServiceBaseUrl=baseUrl;


	var dataSource = new kendo.data.DataSource({
                            transport: {
                                read:  {						        
							        url: crudServiceBaseUrl + "/api/tarifa",
							        dataType: "json"
						    	},
							    update: {
							        url: function(options){								        	
							        	return crudServiceBaseUrl + "/api/tarifa/"+options.models[0].id_tarifa;
							        }, 
							        dataType: "json",
							        type:"PUT"								       
							    },
							    destroy: {
							        url: function(options){							        	
							        	return crudServiceBaseUrl + "/api/tarifa/"+options.models[0].id_tarifa;
							        }, 
							      	dataType: "json",
							        type:"DELETE"
							    },
							    create: {
							        url: crudServiceBaseUrl + "/api/tarifa",
							        dataType: "json",
							        type:"POST"
							    },
                                parameterMap: function(options, operation) {
                                    if (operation !== "read" && options.models) {
                                    	
                                    	return kendo.stringify(options.models[0]);
                                    }
                                }
                            },
                            batch: true,
                            pageSize: 10,
                         	
					schema: {
				        data: "data.tarifa",
				        total: "data.totalCount",				        
				        model: {
				        id: 'id_tarifa',
				          fields: {
				          		'id_tarifa':{type:'string' ,editable: false, nullable: true},
									'id_hotel':{type:'string'},
									'id_tipo_plan':{type:'number'},
									'fecha_promo':{type:'string'},
									'fecha_promo_inicio':{type:'string'},
									'fecha_inicial':{type:'string'},
									'fecha_final':{type:'string'},
									'hora_inicio':{type:'string'},
									'hora_final':{type:'string'},
									'estatus':{type:'number'},
									'log':{type:'string'},
									'min_noches':{type:'number'},
									'num_ninios_gratis':{type:'string'},
									'edad_maxima_ninio':{type:'string'},
									'edad_maxima_jr':{type:'string'},
									'iva':{type:'string'},
									'impuesto_hospedaje':{type:'string'},
									'comision':{type:'string'},
									'tipo_costo':{type:'string'},
									'precio':{type:'string'},
									'promocontigua':{type:'number'},
									'id_combina':{type:'number'},
									'nombre_tarifa':{type:'string'},
									'codigo':{type:'string'},
									'fecha_limite':{type:'string'},
									'fecha_limite_dias':{type:'number'},
									'early_booking':{type:'number'},
									'release':{type:'number'},
									'restricciones':{type:'string'},
									'moneda':{type:'string'},
									'id_logo':{type:'number'},
									'tipo_cambio':{type:'number'},
									'tasa_cambio':{type:'string'},
									'mostrar_conversion':{type:'number'},

					        }           
					      }
				   }
				});


$("#grid_tarifa").kendoGrid({

	dataSource: dataSource,
	toolbar: ["create", "excel"],
    columns:[
			
			{ field: 'id_tarifa', title: 'Id Tarifa', width: '200px'},
			{ field:  'id_hotel', title:  'Id Hotel', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'id_tipo_plan', title:  'Id Tipo Plan', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'fecha_promo', title:  'Fecha Promo', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'fecha_promo_inicio', title:  'Fecha Promo Inicio', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'fecha_inicial', title:  'Fecha Inicial', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'fecha_final', title:  'Fecha Final', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'hora_inicio', title:  'Hora Inicio', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'hora_final', title:  'Hora Final', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'estatus', title:  'Estatus', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'log', title:  'Log', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'min_noches', title:  'Min Noches', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'num_ninios_gratis', title:  'Num Ninios Gratis', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'edad_maxima_ninio', title:  'Edad Maxima Ninio', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'edad_maxima_jr', title:  'Edad Maxima Jr', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'iva', title:  'Iva', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'impuesto_hospedaje', title:  'Impuesto Hospedaje', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'comision', title:  'Comision', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'tipo_costo', title:  'Tipo Costo', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'precio', title:  'Precio', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'promocontigua', title:  'Promocontigua', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'id_combina', title:  'Id Combina', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'nombre_tarifa', title:  'Nombre Tarifa', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'codigo', title:  'Codigo', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'fecha_limite', title:  'Fecha Limite', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'fecha_limite_dias', title:  'Fecha Limite Dias', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'early_booking', title:  'Early Booking', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'release', title:  'Release', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'restricciones', title:  'Restricciones', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'moneda', title:  'Moneda', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'id_logo', title:  'Id Logo', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'tipo_cambio', title:  'Tipo Cambio', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'tasa_cambio', title:  'Tasa Cambio', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'mostrar_conversion', title:  'Mostrar Conversion', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
						

			
            {command: [
			"edit",

	    	"destroy"
            ],
            title: "Opciones", width: "150px"
            }
         ],
			

  	selectable: "multiple",                      
  	pageable: {
	    refresh: true,
	    pageSizes: true
	},
	editable: "popup",
	excel: {
       fileName: "tarifa_report.xlsx",
    },                
  	resizable: true,
  	reorderable: true,
  	//groupable: true | false,
    sortable: true,
  	filterable: {
      mode: "row"
    },
  scrollable: true
  });
