<div style="background: #eee; padding: 5px; margin-bottom: 15px;">
    <div class="form-row align-items-center">
        <label class="col-sm-1 col-form-label col-form-label-sm">Tour</label>
        <div class="col-sm-4">
            <input type="text" class="form-control" placeholder="Filtrar por nombre de tour" autocomplete="off" v-model="search_tour">
        </div>
        <label class="col-sm-1 col-form-label col-form-label-sm">Cliente</label>
        <div class="col-sm-4">
            <input type="text" class="form-control" placeholder="Filtrar por nombre de cliente" autocomplete="off" v-model="search_pax_tour">
        </div>
        <div class="col-sm-2">
            <select v-model="order_fecha_tour" class="form-control">
                <option value="" selected>Ordenar por fecha</option>
                <option value="oldest">Más viejo</option>
                <option value="newest">Más reciente</option>
            </select>
        </div>
    </div>
</div>

<div class="strip_booking" v-for="(tour,index) in filteredTours">
    <div class="row">
        <div class="col-lg-2 col-md-2">
            <div class="date">
                <span class="month" v-if="tour.estatus == 'C'" v-text="parseDate(tour.fecha_inicio, 'MMM')"></span>
                 <span class="month" v-else-if="tour.estatus == 'PC'" style="background-color: #e26a35;" v-text="parseDate(activity.fecha_inicial, 'MMM')"></span>
                <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(tour.fecha_inicio, 'MMM')"></span>
                <span class="day">
                    <strong v-if="tour.estatus == 'C'">{{ parseDate(tour.fecha_inicio, "DD") }}</strong>
                    <strong v-else style="color: #33ad85;">{{ parseDate(tour.fecha_inicio, "DD") }}</strong>
                    {{ parseDate(tour.fecha_inicio, "YYYY") }}
                </span>
            </div>
            <div class="text-center" v-if="tipo_usuario == 'Agencia'">
                <span v-if="tour.estatus == '1'" class="badge badge-success">Liberado</span>
                <span v-else-if="tour.estatus == 'R'" class="badge badge-primary">Reservado</span>
                <span v-else-if="tour.estatus == 'P'" class="badge badge-info">Pagado</span>
                <span v-else class="badge badge-danger">Cancelado</span>
            </div>
            <div class="text-center" v-else>
                <span v-if="tour.estatus == 'C'" class="badge badge-danger">Cancelado</span>
                <span v-else class="badge badge-success">Reservado</span>
            </div>
        </div>
        <div class="col-lg-6 col-md-5">
            <h3 class="tours_booking">{{ tour.idTour.nombre }}
                <span>{{ tour.adultos }} <?= Yii::t("mis_reservas", "Adulto"); ?>(s) - {{ tour.menores }} <?= Yii::t("mis_reservas", "Menor(es)"); ?></span>
                <br>
                <span><strong>Cliente:</strong> {{ tour.cliente_nombre + ' ' + tour.cliente_apellido }}</span>
                <span v-if="tour.idTarifa == null"><strong>Saldo:</strong> $ {{ round(tour.saldo,2) + " " + tour.moneda }}</span>
                <span v-else><strong>Saldo:</strong> $ {{ round(tour.saldo,2) + " " + tour.idTarifa.moneda }}</span>
                <span><strong>Fecha límite pago:</strong> {{ parseDate(tour.fecha_limite,'DD/MM/YYYY') }}</span>
            </h3>
        </div>
        <div class="col-lg-2 col-md-3">
            <ul class="info_booking">
                <li><strong>Cupón</strong> T{{ tour.id_tourReservacion }}</li>
                <li><strong>Reservó</strong> {{ parseDate(tour.log,"DD/MM/YYYY") }}</li>
            </ul>
        </div>
        <div class="col-lg-2 col-md-2">
            <div class="booking_buttons">
                <a :href="'<?= Yii::app()->baseUrl; ?>/tourReservacion/view/' + tour.id_tourReservacion" class="btn_2" target="_blank"><?= Yii::t("mis_reservas", "Ver detalle"); ?></a>
            <!--  && parseInt(tour.saldo)>1 && numberNigths('today',tour.fecha_limite)>=2 -->
                <a v-if="tour.estatus != 'C' && parseInt(tour.saldo)>1 && numberNigths('today',tour.fecha_limite)>=2 " href="#0" class="btn_3" @click="showModal(index,2)"><?= Yii::t("mis_reservas", "Solicitar cancelación"); ?></a>
            </div>
        </div>
    </div>
    <!-- End row -->
</div>