<div id="tools">
    <div class="form-row align-items-center">
        <div class="col-sm-4">
            <input type="text" class="form-control" placeholder="<?= Yii::t("mis_reservas", "Nombre hotel"); ?>" autocomplete="off" v-model="search_reserva">
        </div>
        <div class="col-sm-4">
            <input type="text" class="form-control" placeholder="<?= Yii::t("mis_reservas", "Pasajeros"); ?>" autocomplete="off" v-model="search_pax_reserva">
        </div>
        <div class="col-sm-2">
            <select v-model="filter_status_reserva" class="form-control">
                <option value="" selected><?= Yii::t("mis_reservas", "Filtrar por estatus"); ?></option>
                <option value="active"><?= Yii::t("mis_reservas", "Reservado"); ?></option>
                <option value="cancel"><?= Yii::t("mis_reservas", "Cancelado"); ?></option>
            </select>
        </div>
        <div class="col-sm-2">
            <select v-model="order_fecha_reserva" class="form-control">
                <option value="" selected><?= Yii::t("mis_reservas", "Ordenar por fecha"); ?></option>
                <option value="oldest"><?= Yii::t("mis_reservas", "Más viejo"); ?></option>
                <option value="newest"><?= Yii::t("mis_reservas", "Más reciente"); ?></option>
            </select>
        </div>
    </div>
    <!-- <div class="row">
        <div class="col-lg-2 col-md-3 col-6">
            <div class="styled-select-filters">
                <select name="sort_date" id="sort_date">
                    <option value="" selected>Ordenar por fecha</option>
                    <option value="oldest">Más viejo</option>
                    <option value="recent">Más reciente</option>
                </select>
            </div>
        </div>
    </div> -->
</div>
<!--/tools -->

<div class="strip_booking" v-for="(booking,index) in filteredBookings">
    <div>{{booking.id_reservacion}}</div>
    <div class="row">
        <div class="col-lg-2 col-md-2">
            <div class="date">
                <span class="month" v-if="booking.estatus == 'C'" v-text="parseDate(booking.fecha_inicial, 'MMM')"></span>
                <span class="month" v-else-if="booking.estatus == 'PC'" style="background-color: #e26a35;" v-text="parseDate(activity.fecha_inicial, 'MMM')"></span>
                <span class="month" v-else-if="booking.estatus == 'RI'" style="background-color: #e26a35;" v-text="parseDate(activity.fecha_inicial, 'MMM')"></span>
                <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(booking.fecha_inicial, 'MMM')"></span>
                <span class="day">
                    <strong v-if="booking.estatus == 'C'">{{ parseDate(booking.fecha_inicial, "DD") }}</strong>
                    <strong v-else style="color: #33ad85;">{{ parseDate(booking.fecha_inicial, "DD") }}</strong>
                    {{ parseDate(booking.fecha_inicial, "YYYY") }}
                </span>
            </div>
            <div class="text-center" v-if="tipo_usuario == 'Agencia'">
                 <span v-if="booking.estatus == 'C'" class="badge badge-danger">Cancelado</span>
                 <span v-else-if="booking.estatus == 'R'" class="badge badge-success">Liberado</span>
                 <span v-else-if="booking.estatus == 'RI'" class="badge badge-warning">Incompleta</span>
                 <span v-else-if="booking.estatus == 'PC'" class="badge badge-warning">Pendiente Cancelacion</span>
            </div>
            <div class="text-center" v-else>
                <span v-if="booking.estatus == 'R'" class="badge badge-success">Liberado</span>
                <span v-else-if="booking.estatus == 'PH'" class="badge badge-success">Pagado Hotel</span>
                <span v-else-if="booking.estatus == 'RE'" class="badge badge-info">Reinstalado</span>
                <span v-else-if="booking.estatus == 'PC'" class="badge badge-warning">Pendiente cancelación</span>
                <span v-else-if="booking.estatus == 'C'" class="badge badge-danger">Cancelado</span>
                <span v-else-if="booking.estatus == 'RI'" class="badge badge-warning">Incompleta</span>
            </div>
        </div>
        <div class="col-lg-6 col-md-5">
            <h3 class="hotel_booking">
                {{ booking.idHotel.nombre_hotel }}
                <span v-for="desglose in booking.reservacionDesgloses">
                    {{ desglose.num_adultos }} <?= Yii::t("mis_reservas", "Adulto"); ?>(s) - {{ desglose.num_ninios }} <?= Yii::t("mis_reservas", "Menor(es)"); ?> / {{ numberNigths(booking.fecha_inicial, booking.fecha_final) }} <?= Yii::t("mis_reservas", "Noches"); ?>
                </span>
                <br>
                <!-- <span><strong>Cliente:</strong> {{ booking.nombre_cliente + ' ' + booking.apellido_cliente }}</span> -->
                <span><strong>Saldo:</strong> $ {{ round(booking.saldo,2) }}</span>
                <span><strong>Fecha límite pago:</strong> {{ parseDate(booking.fecha_limite,'DD/MM/YYYY') }}</span>
            </h3>
        </div>
        <div class="col-lg-2 col-md-3">
            <ul class="info_booking">
                <li><h4>{{ booking.id_reservacion }} <br><small><?= Yii::t("mis_reservas", "Cupón"); ?></small></h4> </li>
                <li><h4>{{ booking.code }} <br><small><?= Yii::t("mis_reservas", "Referencia"); ?></small></h4> </li>
                <li><strong>{{ parseDate(booking.log,"DD/MM/YYYY") }}</strong> <?= Yii::t("mis_reservas", "Fecha de Reservación"); ?></li>
            </ul>
        </div>
        <div class="col-lg-2 col-md-2">
            <div class="booking_buttons">
                <a :href="'<?= Yii::app()->baseUrl; ?>/reservacion/view/' + booking.id_reservacion" class="btn_2" target="_blank"><?= Yii::t("mis_reservas", "Ver detalle"); ?></a>
                <span style="font-size: 0.89em; margin-top: 1em;" v-if="booking.solicitudCancelacions.length > 0"><?= Yii::t("mis_reservas", "Pendiente de cancelación"); ?></span>
                <a v-if="booking.estatus != 'C' && parseInt(booking.saldo)>1 && numberNigths('today',booking.fecha_limite)>=2 && booking.id_bloqueo==null && booking.Recibosdetalle.length==0 && booking.OrdenPagoDetalle.length==0" @click="showModal(index,0)" href="#0" class="btn_3"><?= Yii::t("mis_reservas", "Cancelación"); ?></a>
            </div>
        </div>
    </div>
    <!-- End row -->
</div>
<!-- End strip booking -->