<div id="tools">
    <div class="form-row align-items-center">
        <div class="col-sm-2">
            <select v-model="order_tipo_pago" class="form-control" v-on:change="cambiar_prox_pagos">
                <option value="">Filtrar por:</option>
                <option value="bookings">Reservaciones</option>
                <option value="grupos">Grupos</option>
            </select>
        </div>
    </div>
    <!-- <div class="row">
        <div class="col-lg-2 col-md-3 col-6">
            <div class="styled-select-filters">
                <select name="sort_date" id="sort_date">
                    <option value="" selected>Ordenar por fecha</option>
                    <option value="oldest">Más viejo</option>
                    <option value="recent">Más reciente</option>
                </select>
            </div>
        </div>
    </div> -->
</div>
<div id="tipo_bookings">
    <div>
        <h4>Reservaciones</h4>
    </div>
    <div class="row justify-content-end">
        <div class="col-4">
            <table class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <td>Saldo Pendiente MXN</td>
                        <td>Saldo Pendiente USD</td>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td v-text="'$' + round(total_mxn, 2)"></td>
                        <td v-text="'$' + round(total_usd, 2)"></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div v-if="array_prox_pagos_bookings.length == 0 && array_prox_pagos_activities.length == 0 && array_prox_pagos_tours.length == 0">
        <h3>No hay reservaciones próximas a vencer en los siguientes {{ days_prox_pagos }} días.</h3>
    </div>
    <div v-else>
        <div class="strip_booking" v-for="booking in array_prox_pagos_bookings">
            <div class="row">
                <div class="col-lg-2 col-md-2">
                    <div class="date">
                        <span class="month" v-if="booking.estatus == 'C'" v-text="parseDate(booking.fecha_limite, 'MMM')"></span>
                        <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(booking.fecha_limite, 'MMM')"></span>
                        <span class="day">
                            <strong v-if="booking.estatus == 'C'">{{ parseDate(booking.fecha_limite, "DD") }}</strong>
                            <strong v-else style="color: #33ad85;">{{ parseDate(booking.fecha_limite, "DD") }}</strong>
                            {{ parseDate(booking.fecha_limite, "YYYY") }}
                        </span>
                    </div>
                </div>
                <div class="col-lg-6 col-md-5">
                    <h3 class="hotel_booking">
                        {{ booking.idHotel.nombre_hotel }}
                        <span v-for="desglose in booking.reservacionDesgloses">
                            {{ desglose.num_adultos }} <?= Yii::t("mis_reservas", "Adulto"); ?>(s) - {{ desglose.num_ninios }} <?= Yii::t("mis_reservas", "Menor(es)"); ?> / {{ numberNigths(booking.fecha_inicial, booking.fecha_final) }} <?= Yii::t("mis_reservas", "Noches"); ?>
                        </span>
                        <br>
                        <!-- <span><strong>Cliente:</strong> {{ booking.nombre_cliente + ' ' + booking.apellido_cliente }}</span> -->
                        <span v-if="booking.desglose_rate == null || booking.desglose_rate == ''"><strong><?= Yii::t("mis_reservas", "Saldo"); ?>:</strong> $ {{ round(booking.saldo,2) }} MXN</span>
                        <span v-else><strong><?= Yii::t("mis_reservas", "Saldo"); ?>:</strong> $ {{ round(booking.saldo,2) + " " + getMonedaBooking(booking.desglose_rate) }}</span>
                        <span><strong><?= Yii::t("mis_reservas", "Fecha entrada"); ?>:</strong> {{ parseDate(booking.fecha_inicial,'DD/MM/YYYY') }}</span>
                    </h3>
                </div>
                <div class="col-lg-2 col-md-3">
                    <ul class="info_booking">
                        <li>
                            <h4>{{ booking.id_reservacion }} <br><small><?= Yii::t("mis_reservas", "Cupón"); ?></small></h4>
                        </li>
                        <li><strong>{{ parseDate(booking.log,"DD/MM/YYYY") }}</strong> <?= Yii::t("mis_reservas", "Fecha de Reservación"); ?></li>
                    </ul>

                </div>
                <div class="col-lg-2 col-md-2">
                    <div class="booking_buttons">
                        <a :href="'<?= Yii::app()->baseUrl; ?>/reservacion/view/' + booking.id_reservacion" class="btn_2" target="_blank"><?= Yii::t("mis_reservas", "Ver detalle"); ?></a>
                        <span style="font-size: 0.89em; margin-top: 1em;" v-if="booking.solicitudCancelacions.length > 0"><?= Yii::t("mis_reservas", "Pendiente de cancelación"); ?></span>
                        <a v-if="booking.estatus != 'C' && parseInt(booking.saldo)>1 && numberNigths('today',booking.fecha_limite)>=2 && booking.id_bloqueo==null && booking.Recibosdetalle.length==0 && booking.OrdenPagoDetalle.length==0" @click="showModal(index,0)" href="#0" class="btn_3"><?= Yii::t("mis_reservas", "Cancelación"); ?></a>
                    </div>
                </div>
            </div>
            <!-- End row -->
        </div>
        <!-- End strip booking -->
        <div class="strip_booking" v-for="activity in array_prox_pagos_activities">
            <div class="row">
                <div class="col-lg-2 col-md-2">
                    <div class="date">
                        <span class="month" v-if="activity.estatus == 'C'" v-text="parseDate(activity.fecha_limite, 'MMM')"></span>
                        <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(activity.fecha_limite, 'MMM')"></span>
                        <span class="day">
                            <strong v-if="activity.estatus == 'C'">{{ parseDate(activity.fecha_limite, "DD") }}</strong>
                            <strong v-else style="color: #33ad85;">{{ parseDate(activity.fecha_limite, "DD") }}</strong>
                            {{ parseDate(activity.fecha_limite, "YYYY") }}
                        </span>
                    </div>
                </div>
                <div class="col-lg-6 col-md-5">
                    <h3 class="hotel_booking activity_booking">{{ activity.actividad }}
                        <span v-for="desglose in activity.activityReservacionDesgloses">
                            {{ desglose.num_adultos }} <?= Yii::t("mis_reservas", "Adulto") ?>(s) - {{ desglose.num_ninios }} <?= Yii::t("mis_reservas", "Menor(es)") ?>
                        </span>
                        <br>
                        <span><strong>Cliente:</strong> {{ activity.nombre_cliente + ' ' + activity.apellido_cliente }}</span>
                        <span><strong><?= Yii::t("mis_reservas", "Saldo") ?>:</strong> {{ round(activity.saldo,2) + " " + monedaActivity(activity) }}</span>
                        <span><strong><?= Yii::t("mis_reservas", "Fecha entrada") ?>:</strong> {{ parseDate(activity.fecha_inicial,'DD/MM/YYYY') }}</span>
                    </h3>
                </div>
                <div class="col-lg-2 col-md-3">
                    <ul class="info_booking">
                        <li><strong>Cupón</strong> A{{ activity.id_reservacion }}</li>
                        <li><strong>Reservó</strong> {{ parseDate(activity.log,"DD/MM/YYYY") }}</li>
                    </ul>
                </div>
                <div class="col-lg-2 col-md-2">
                    <div class="booking_buttons">
                        <a :href="'<?= Yii::app()->baseUrl; ?>/activities/view/' + activity.id_reservacion" class="btn_2" target="_blank"><?= Yii::t("mis_reservas", "Ver detalle"); ?></a>
                        <a v-if="activity.estatus != 'C' && parseInt(activity.saldo)>1 && numberNigths('today',activity.fecha_limite)>=2 && activity.Recibosdetalle.length==0 && activity.OrdenPagoDetalle.length==0" href="#0" class="btn_3" @click="showModal(index,1)"><?= Yii::t("mis_reservas", "Solicitar cancelación"); ?></a>
                    </div>
                </div>
            </div>
            <!-- End row -->
        </div>
        <div class="strip_booking" v-for="tour in array_prox_pagos_tours">
            <div class="row">
                <div class="col-lg-2 col-md-2">
                    <div class="date">
                        <span class="month" v-if="tour.estatus == 'C'" v-text="parseDate(tour.fecha_limite, 'MMM')"></span>
                        <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(tour.fecha_limite, 'MMM')"></span>
                        <span class="day">
                            <strong v-if="tour.estatus == 'C'">{{ parseDate(tour.fecha_limite, "DD") }}</strong>
                            <strong v-else style="color: #33ad85;">{{ parseDate(tour.fecha_limite, "DD") }}</strong>
                            {{ parseDate(tour.fecha_limite, "YYYY") }}
                        </span>
                    </div>
                </div>
                <div class="col-lg-6 col-md-5">
                    <h3 class="tours_booking">{{ tour.idTour.nombre }}
                        <span>{{ tour.adultos }} <?= Yii::t("mis_reservas", "Adulto"); ?>(s) - {{ tour.menores }} <?= Yii::t("mis_reservas", "Menor(es)"); ?></span>
                        <br>
                        <span><strong>Cliente:</strong> {{ tour.cliente_nombre + ' ' + tour.cliente_apellido }}</span>
                        <span><strong><?= Yii::t("mis_reservas", "Saldo") ?>:</strong> $ {{ round(tour.saldo,2) + " " + tour.idTarifa.moneda }}</span>
                        <span><strong><?= Yii::t("mis_reservas", "Fecha entrada") ?>:</strong> {{ parseDate(tour.fecha_inicio,'DD/MM/YYYY') }}</span>
                    </h3>
                </div>
                <div class="col-lg-2 col-md-3">
                    <ul class="info_booking">
                        <li><strong>Cupón</strong> T{{ tour.id_tourReservacion }}</li>
                        <li><strong>Reservó</strong> {{ parseDate(tour.log,"DD/MM/YYYY") }}</li>
                    </ul>
                </div>
                <div class="col-lg-2 col-md-2">
                    <div class="booking_buttons">
                        <a :href="'<?= Yii::app()->baseUrl; ?>/tourReservacion/view/' + tour.id_tourReservacion" class="btn_2" target="_blank"><?= Yii::t("mis_reservas", "Ver detalle"); ?></a>
                        <a v-if="tour.estatus != 'C' && parseInt(tour.saldo)>1 && numberNigths('today',tour.fecha_limite)>=2 " href="#0" class="btn_3" @click="showModal(index,2)"><?= Yii::t("mis_reservas", "Solicitar cancelación"); ?></a>
                    </div>
                </div>
            </div>
            <!-- End row -->
        </div>
    </div>
</div>

<hr>
<div id="tipo_grupos">
    <div>
        <h4>Grupos</h4>
    </div>
    <div class="row justify-content-end">
        <div class="col-4">
            <table class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <td>Saldo Pendiente MXN</td>
                        <!-- <td>Saldo Pendiente USD</td> -->
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td v-text="'$' + round(array_prox_pagos_bloqueos.saldo_pendiente_mxn, 2)"></td>
                        <!-- <td v-text="'$' + round(total_usd, 2)"></td> -->
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div v-if="array_prox_pagos_bloqueos.length == 0">
        <h3>No hay próximos pagos de Grupos por vencer en los siguientes {{ days_prox_pagos }} días.</h3>
    </div>
    <div v-else>
        <div v-for="bloqueos_pago in array_prox_pagos_bloqueos">
            <div class="strip_booking" v-for="pago in bloqueos_pago.pagos">
                <div class="row">
                    <div class="col-lg-2 col-md-2">
                        <div class="date">
                            <span class="month" style="background-color: #33ad85;" v-text="parseDate(pago.fecha, 'MMM')"></span>
                            <span class="day">
                                <strong v-if="pago.pago_vencido == true">{{ parseDate(pago.fecha, "DD") }}</strong>
                                <strong v-else style="color: #33ad85;">{{ parseDate(pago.fecha, "DD") }}</strong>
                                {{ parseDate(pago.fecha, "YYYY") }}
                            </span>
                        </div>
                        <div class="text-center" v-if="pago.pago_vencido == true">
                            <span class="badge badge-danger">Fecha de Pago Vencida</span>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-5">
                        <h3 class="hotel_booking">
                            {{ bloqueos_pago.nombre_hotel }}
                            <!-- <span>{{bloqueos_pago.bloqueo.titulo}}</span> -->
                            <span><b>Fechas de Pago: </b>{{ parseDate(pago.fecha,'DD/MM/YYYY') }}</span>
                            <span><b>Habitaciones: </b> {{bloqueos_pago.bloqueo.numero_habitaciones}}</span>
                            <br>
                        </h3>
                    </div>
                    <div class="col-lg-2 col-md-3">
                        <ul class="info_booking">
                            <li>
                                <h4>{{ bloqueos_pago.bloqueo.id_bloqueo }} <br><small>Grupo</small></h4>
                            </li>
                            <li><strong>{{ parseDate(bloqueos_pago.bloqueo.fecha_inicio,'DD/MM/YYYY') }} - {{ parseDate(bloqueos_pago.fecha_final,'DD/MM/YYYY') }}</strong> Fechas </li>
                        </ul>

                    </div>
                    <div class="col-lg-2 col-md-2">
                        <div class="booking_buttons">
                            <a :href="'<?= Yii::app()->baseUrl; ?>/bloqueos/view/' + bloqueos_pago.bloqueo.id_bloqueo" class="btn_2" target="_blank">Ver detalle</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>