
<ul class="nav nav-tabs" role="tablist">
  <li class="nav-item">
    <a class="nav-link active" href="#recibos" role="tab" data-toggle="tab">COMPROBANTES DE PAGO</a>
</li>
<li class="nav-item">
    <a class="nav-link" href="#facturas" role="tab" data-toggle="tab">MIS FACTURAS</a>
</li>
</ul>
<div class="tab-content">
    <div role="tabpanel" class="tab-pane active" id="recibos">
        <div style="background: #eee; padding: 5px; margin-bottom: 15px;">
            <div class="form-row align-items-center">
                <div class="col-sm-3">
                    <select v-model="order_fecha_recibo" class="form-control">
                        <option value="" selected>Ordenar por fecha</option>
                        <option value="oldest">Más viejo</option>
                        <option value="newest">Más reciente</option>
                    </select>
                </div>
                <div class="col-sm-2">
                    <input type="text" class="form-control" placeholder="Folio" autocomplete="off" v-model="search_idRecibo">
                </div>
                <?php $tipoPago = TipoPago::model()->findAll('id_tipo not in(12)'); ?>
                <div class="col-sm-2">
                    <select v-model="tipo_pago" class="form-control">
                        <option value="0" selected>Todos</option>
                        <?php foreach ($tipoPago as $key => $pago): ?>
                            <option value="<?=$pago->id_tipo?>"><?=strtoupper($pago->descripcion)?></option>
                        <?php endforeach ?>
                    </select>
                    <!-- <input type="text" class="form-control" placeholder="Folio" autocomplete="off" v-model="search_idRecibo"> -->
                </div>
            </div>
        </div>
        <div class="strip_booking" v-for="recibo in filteredReceipt.slice(0,30)">
            <div class="row">
                <div class="col-lg-2 col-md-2">
                    <div class="date">
                        <span class="month" style="background-color: #33ad85;" v-text="parseDate(recibo.log, 'MMM')"></span>
                        <span class="day">
                            <strong style="color: #33ad85;">{{ parseDate(recibo.log, "DD") }}</strong>
                            {{ parseDate(recibo.log, "YYYY") }}
                        </span>
                    </div>
                    <div class="text-center">
                        <span v-if="recibo.estado == 'AP'" class="badge badge-info">Aplicado</span>
                        <span v-else-if="recibo.estado == 'C'" class="badge badge-danger">Cancelado</span>
                        <span v-else class="badge badge-success">Pagado</span>
                    </div>
                </div>
                <div class="col-lg-6 col-md-5">
                    <h3 class="hotel_booking recibos_cfdi">$ {{ round(recibo.importe,2) }}
                        <span>Agencia: {{ recibo.nombre_agencia }}</span>
                        <br>
                        <span><strong>Forma de Pago:</strong> {{ recibo.descripcion }}</span>
                    </h3>
                </div>
                <div class="col-lg-2 col-md-3">
                    <ul class="info_booking" style="font-size: 12px;">
                        <li><strong>Folio</strong><br> {{ recibo.id_recibo }}</li><br>
                        <li v-if="puedeFacturarCFDI(recibo)===true"><strong>Fecha Límite para facturar:</strong><br> {{ recibo.fecha_limite_factura }}</li>
                    </ul>
                </div>
                <div class="col-lg-2 col-md-2">
                    <div class="booking_buttons">
                        <!-- <a :href="'<?=Yii::app()->baseUrl;?>/pagos/GeneratePdf/idrecibo/' + recibo.id_recibo" class="btn_2" target="_blank">Ver recibo</a><br> -->
                        <a v-if="recibo.tipoFactura=='credito'" :href="'<?=Yii::app()->baseUrl;?>/admin/notaCredito/view/id/' + recibo.id_recibo" class="btn_2" target="_blank">Ver recibo</a>
                        <a v-if="recibo.tipoFactura=='recibo'" :href="'<?=Yii::app()->baseUrl;?>/pagos/GeneratePdf/idrecibo/' + recibo.id_recibo" class="btn_2" target="_blank">Ver recibo</a><br>
                        <a v-if="recibo.tipoFactura=='comprobante'" :href="'<?=Yii::app()->baseUrl;?>/admin/contabilidad/ordenPago/GeneratePdf/idOrden/' + recibo.id_orden_pago + '/formato/orden'" class="btn_2" target="_blank">Ver recibo</a><br>

                        <a v-if="puedeFacturarCFDI(recibo)===true" :href="'<?= Yii::app()->baseUrl; ?>/facturacionCfdi/factura/idrecibo/' + recibo.id_recibo + '/tipo/' + recibo.tipoFactura" class="btn_full">Facturar</a>
                        <!-- <a v-if="recibo.facturado==1" href="#" class="btn btn-success btn-sm" id="btn_descargar_facturas" :data-id_recibo="recibo.id_recibo">Descargar Facturas</a>  -->
                        <a v-if="recibo.facturado==1" href="#" class="btn btn-success btn-sm" :href="'<?= Yii::app()->baseUrl; ?>/facturacionCfdi/factura/idrecibo/' + recibo.id_recibo + '/tipo/' + recibo.tipoFactura" >Descargar Facturas</a>
                        <br>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div role="tabpanel" class="tab-pane fade" id="facturas">
        <div v-if="facturasCfdi.length==0" class="strip_booking">
            <div class="row">
                <h3>No tienes facturas registradas.</h3>
            </div>
        </div>
        <div class="strip_booking" v-for="factura in facturasCfdi">
            <div class="row">
                <div class="col-lg-2 col-md-2">
                    <div class="date">
                        <span class="month" style="background-color: #33ad85;" v-text="parseDate(factura.log, 'MMM')"></span>
                        <span class="day">
                            <strong style="color: #33ad85;">{{ parseDate(factura.log, "DD") }}</strong>
                            {{ parseDate(factura.log, "YYYY") }}
                        </span>
                    </div>
                    <div class="text-center">
                        <span v-if="factura.estatus == 'P'" class="badge badge-info">Pendiente</span>
                        <span v-else-if="factura.estatus == 'C'" class="badge badge-danger">Cancelado</span>
                        <span v-else class="badge badge-success">Facturado</span>
                    </div>
                </div>
                <div class="col-lg-6 col-md-5">
                    <h3 class="hotel_booking recibos_cfdi">$ {{ round(factura.total,2) }}
                        <span>Agencia: {{ factura.nombre_agencia }}</span>
                        <br>
                        <span><strong>RFC:</strong> {{ factura.rfc }}</span>
                        <span><strong>Razón Social:</strong> {{ factura.razon_social }}</span>
                    </h3>
                </div>
                <div class="col-lg-2 col-md-3">
                    <ul class="info_booking" style="font-size: 12px;">
                        <li><strong>Folio</strong><br> <b>{{ factura.folio }}</b></li><br>
                        <li><strong>Recibo</strong><br> {{ factura.recibo }}</li><br>
                    </ul>
                </div>
                <div class="col-lg-2 col-md-2">
                    <div class="booking_buttons">
                        <!-- <a v-if="factura.tipo_nota=='credito'" :href="'<?=Yii::app()->baseUrl;?>/admin/notaCredito/view/id/' + factura.recibo" class="btn_2" target="_blank">Ver recibo</a> -->
                        <!-- <a v-if="factura.tipo_nota=='recibo'" :href="'<?=Yii::app()->baseUrl;?>/pagos/GeneratePdf/idrecibo/' + factura.recibo" class="btn_2" target="_blank">Ver recibo</a><br> -->
                        <!-- <a v-if="puedeFacturarCFDI(recibo)===true" :href="'<?= Yii::app()->baseUrl; ?>/facturacionCfdi/factura/idrecibo/' + recibo.id_recibo + addUrl(recibo.tipoFactura)" class="btn_full">Facturar</a> -->
                        <!-- <a v-if="recibo.facturado==1" href="#" class="btn btn-success btn-sm" id="btn_descargar_facturas" :data-id_recibo="recibo.id_recibo">Descargar Facturas</a>  -->
                        <a v-if="factura.estatus!='P'" href="#" class="btn btn-success btn-sm" :href="'<?= Yii::app()->baseUrl; ?>/facturacionCfdi/factura/idrecibo/' + factura.recibo + '/tipo/' + factura.tipo_nota" >Descargar Facturas</a>
                        <br>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="modal-descargarFacturas" data-backdrop="static" data-keyboard="false" class="modal fade" aria-labelledby="flexModalLabel" aria-hidden="true" tab-index="-1">
    <div class="modal-dialog" style="width:auto; max-width:900px">
        <div class="modal-content">
            <div class="modal-header">
                <h4 id="modal-title">Facturas</h4>
            </div>
            <div class="modal-body" id="desglose_factura">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>