<div style="background: #eee; padding: 5px; margin-bottom: 15px;">
    <div class="form-row align-items-center">
        <label class="col-sm-1 col-form-label col-form-label-sm">Activity</label>
        <div class="col-sm-4">
            <input type="text" class="form-control" placeholder="Filtrar por nombre de activity" autocomplete="off" v-model="search_activity">
        </div>
        <label class="col-sm-1 col-form-label col-form-label-sm">Cliente</label>
        <div class="col-sm-4">
            <input type="text" class="form-control" placeholder="Filtrar por nombre de cliente" autocomplete="off" v-model="search_pax_activity">
        </div>
        <div class="col-sm-2">
            <select v-model="order_fecha_activity" class="form-control">
                <option value="" selected>Ordenar por fecha</option>
                <option value="oldest">Más viejo</option>
                <option value="newest">Más reciente</option>
            </select>
        </div>
    </div>
</div>

<div class="strip_booking" v-for="(activity,index) in filteredActivities">
    <div class="row">
        <div class="col-lg-2 col-md-2">
            <div class="date">
                <span class="month" v-if="activity.estatus == 'C'" v-text="parseDate(activity.fecha_inicial, 'MMM')"></span>
                <span class="month" v-else-if="activity.estatus == 'PC'" style="background-color: #e26a35;" v-text="parseDate(activity.fecha_inicial, 'MMM')"></span>
                <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(activity.fecha_inicial, 'MMM')"></span>
                <span class="day">
                    <strong v-if="activity.estatus == 'C'">{{ parseDate(activity.fecha_inicial, "DD") }}</strong>
                    <strong v-else style="color: #33ad85;">{{ parseDate(activity.fecha_inicial, "DD") }}</strong>
                    {{ parseDate(activity.fecha_inicial, "YYYY") }}
                </span>
            </div>
            <div class="text-center">
                <span v-if="activity.estatus == 'R'" class="badge badge-success">Liberado</span>
                <span v-else-if="activity.estatus == 'C'" class="badge badge-danger">Cancelado</span>
            </div>
        </div>
        <div class="col-lg-6 col-md-5">
            <h3 class="hotel_booking activity_booking">{{ activity.actividad }}
                <span v-for="desglose in activity.activityReservacionDesgloses">
                    {{ desglose.num_adultos }} <?= Yii::t("mis_reservas", "Adulto"); ?>(s) - {{ desglose.num_ninios }} <?= Yii::t("mis_reservas", "Menor(es)"); ?>
                </span>
                <br>
                <span><strong>Cliente:</strong> {{ activity.nombre_cliente + ' ' + activity.apellido_cliente }}</span>
                <span><strong>Saldo: $</strong> {{ round(activity.saldo,2) + " " + monedaActivity(activity) }}</span>
                <span><strong>Fecha límite pago:</strong> {{ parseDate(activity.fecha_limite,'DD/MM/YYYY') }}</span>
            </h3>
        </div>
        <div class="col-lg-2 col-md-3">
            <ul class="info_booking">
                <li><strong>Cupón</strong> A{{ activity.id_reservacion }}</li>
                <li><strong>Reservó</strong> {{ parseDate(activity.log,"DD/MM/YYYY") }}</li>
            </ul>
        </div>
        <div class="col-lg-2 col-md-2">
            <div class="booking_buttons">
                <a :href="'<?= Yii::app()->baseUrl; ?>/activities/view/' + activity.id_reservacion" class="btn_2" target="_blank"><?= Yii::t("mis_reservas", "Ver detalle"); ?></a>
                <a v-if="activity.estatus != 'C' && parseInt(activity.saldo)>1 && numberNigths('today',activity.fecha_limite)>=2 && activity.Recibosdetalle.length==0 && activity.OrdenPagoDetalle.length==0" href="#0" class="btn_3" @click="showModal(index,1)"><?= Yii::t("mis_reservas", "Solicitar cancelación"); ?></a>
            </div>
        </div>
    </div>
    <!-- End row -->
</div>