<?php 
if(!empty($model->tipo_cambio) && $recibo->id_tipo!=13){
    $totalAgencia = round($model->total_tc * $model->tipo_cambio,2);
    $comisionAgencia = $totalAgencia*($model->comision/100);
    $saldoAgencia = $totalAgencia - ($comisionAgencia);
}else{
    $totalAgencia = $model->total;
    $comisionAgencia = $model->total*($model->comision/100);
    $saldoAgencia = $model->total - ($comisionAgencia);
}
?>
<table class="table table-striped table-sm">
    <tbody>
        <tr>
            <th>Tarifa pública</th>
            <td align="right">$ <?=number_format($totalAgencia,2)?></td>
        </tr>
        <tr>
            <th> - Comisión agencia</th>
            <td align="right">$ <?=number_format($comisionAgencia,2)?></td>
        </tr>
        <tr>
            <th> Tarifa agencia</th>
            <td align="right">$ <?=number_format($totalAgencia - $comisionAgencia,2)?></td>
        </tr>
    </tbody>
</table>
<h4>Pagos Realizados</h4>
<table class="table table-striped table-sm">
    <thead>
        <tr>
            <th>Folio</th>
            <th>Fecha</th>
            <th>Importe</th>
            <!-- <th>Comisión</th> -->
            <th>F.P.</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $totalrecibos = 0;
        foreach ($pagos as $row) {
            $recibo = Recibo::model()->findByPk($row->id_recibo);
            if ($recibo->estado != 'C') {
                $totalrecibos += $row->importe; ?>
                <tr>
                    <td><a href="<?= Yii::app()->createUrl('pagos/GeneratePdf', array('idrecibo' => $recibo->id_recibo)) ?>" target="_blank"><i class="fa fa-file-text-o"></i> <?php echo $recibo->id_recibo; ?></a></td>
                    <td><?php echo $recibo->log; ?></td>
                    <td align="right">$<?php echo number_format($row->importe, '2', '.', ','); ?></td>
                    <!-- <td align="right"><?php echo $recibo->comision; ?>%</td> -->
                    <td><?php echo $recibo->idTipo->descripcion; ?></td>
                </tr>
        <?php }
        } ?>
    </tbody>
    <tfoot style="display: none;">
        <tr>
            <td></td>
            <td>Total</td>
            <td align="right">$<?php echo number_format($totalrecibos, '2', '.', ','); ?></span></td>
            <!-- <td align="right"><span id="totalcomisiones"></span></td> -->
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td><strong>Saldo</strong></td>
            <td align="right">
                <?php
                $saldoNuevo = round($saldoAgencia - $totalrecibos, 2);

                if ($saldoNuevo != $model->saldo && $model->saldo != 0) {
                    $model->saldo = $saldoNuevo;
                    $model->save();
                }
                ?>
                $<?php echo $model->saldo; ?>
            </td>
            <td></td>
            <td></td>
        </tr>

    </tfoot>
</table>
<input type="hidden" id="totalimporte" value="<?= $model->saldo ?>" />
<input type="hidden" id="totalimporte_sc" value="<?= empty($model->tipo_cambio) ? $model->total : round($model->total_tc * $model->tipo_cambio, 2) ?>" />
<?php 
$ordenController = Yii::app()->createController('reservas')[0];
$detalles = $ordenController->consultaOrdenDetalles($model->id_reservacion,'Reservacion'); 

$totalComprobante = 0;
// $ordenRooming = 0;

if (!empty($model->id_bloqueo)) {
    $rooming = Roominglist::model()->find('id_reservacion='.$model->id_reservacion);
    if (!empty($rooming)) {
        $id_roominglist = $rooming->id_bloqueo.'-'.$rooming->id_roominglist.'-'.$rooming->habitacion;
        $sqlRoom = "SELECT o.*, op.log FROM tbl_orden_pago_detalles o INNER JOIN tbl_orden_pago op USING(id_orden_pago) WHERE o.identificador='".$id_roominglist."' AND op.estatus='PA' AND op.id_agencia=".$model->id_agencia." AND op.tipo_orden IS NULL";
        $ordenRooming = Yii::app()->db->createCommand($sqlRoom)->queryAll();
        $roomingHab = array();
        $tiene_cancelado = OrdenPagoDetalles::model()->with('idOrdenPago')->findAll('identificador="'.$id_roominglist.'" AND idOrdenPago.estatus="PA" AND idOrdenPago.id_agencia='.$model->id_agencia.' AND idOrdenPago.tipo_orden="movimiento"');
        foreach ($ordenRooming as $val) {
        	if (!empty($tiene_cancelado)) {
	            foreach ($tiene_cancelado as $row) {
	                $importe_cancelado = $row->importe * (-1);
	                if ($importe_cancelado != $val['importe']) {
	                    $roomingHab[] = $val;
	                }
	            }
        	}else{
                $roomingHab[] = $val;
            }
        }

    }
}


$hoy = date('Y-m-d');
$inicio = '2020-06-14';

if (strtotime(date('Y-m-d')) > strtotime($inicio)){ 

?>


<table class="table table-striped table-sm">
    <thead>
        <!-- <tr>
            <th colspan="3"> Abonos</th>
        </tr> -->
        <tr>
            <th>Abonos</th>
            <th style="text-align: center;">Fecha</th>
            <th style="text-align: right;">Importe</th>
        </tr>
    </thead>
    <tbody>
        <?php if (count($detalles) > 0): ?>
            <?php 
            foreach ($detalles as $orden){
                $totalComprobante += $orden['importe'];
                ?>
                <tr>
                    <td> 
                        <a href="<?= Yii::app()->createUrl('admin/contabilidad/ordenPago/GeneratePdf', array('idOrden' => $orden["id_orden_pago"],'formato'=>'orden')) ?>" target="_blank">
                            <i class="fa fa-file-text-o"></i> <?=$orden['id_orden_pago']?>
                        </a>
                    </td>
                    <td align="center"><?=date('d/m/Y', strtotime($orden['log']))?></td>
                    <td align="right">$ <?=number_format($orden['importe'],2)?></td>
                </tr>
                <?php 
            } 
            ?>
        <?php endif ?>
        <?php if (count($roomingHab) > 0): ?>
            <?php 
            foreach ($roomingHab as $orden){
                $totalComprobante += $orden['importe'];
                ?>
                <tr>
                    <td> 
                        <a href="<?= Yii::app()->createUrl('admin/contabilidad/ordenPago/GeneratePdf', array('idOrden' => $orden["id_orden_pago"],'formato'=>'orden')) ?>" target="_blank">
                            <i class="fa fa-file-text-o"></i> <?=$orden['id_orden_pago']?>
                        </a>
                    </td>
                    <td align="center"><?=date('d/m/Y', strtotime($orden['log']))?></td>
                    <td align="right">$ <?=number_format($orden['importe'],2)?></td>
                </tr>
                <?php 
            } 
            ?>
        <?php endif ?>
    </tbody>
    <tfoot>
        <tr>
            <td></td>
            <td align="right">Total de pagos: </td>
            <td align="right">$ <?php echo number_format($totalComprobante + $totalrecibos, '2', '.', ','); ?></span></td>
        </tr>
        <tr></tr>
        <tr>
            <?php 
            $saldo_favor = 0;
            $saldoNuevo = round($saldoNuevo - $totalComprobante, 2);
            if ($saldoNuevo != $model->saldo && $model->saldo != 0) {
                $model->saldo = $saldoNuevo;
                $model->save();
            }
            if ($saldoNuevo < 0) {
                $saldo_favor = $saldoNuevo * (-1);
                $model->saldo = 0;
                $model->save();
            }
            ?>
            <th colspan="2"><strong>Saldo Restante</strong></th>
            <td align="right"><strong>$ <?=number_format($model->saldo,2)?></strong></td>
            <input type="hidden" id="totalimporte" value="<?= $model->saldo ?>" />
            <input type="hidden" id="totalimporte_sc" value="<?= empty($model->tipo_cambio) ? $model->total : round($model->total_tc * $model->tipo_cambio, 2) ?>">
        </tr>
        <tr>
            <?php if ($saldo_favor > 0 && $_SESSION['agenciaUsuario'] == 9): ?>
                <th colspan="2"><strong>Saldo a favor</strong></th>
                <td align="right"><strong>$ <?=number_format($saldo_favor,2)?></strong></td>
            <?php endif ?>
        </tr>
    </tfoot>
</table>

<?php } ?>