	var crudServiceBaseUrl=baseUrl;


	var dataSource = new kendo.data.DataSource({
                            transport: {
                                read:  {						        
							        url: crudServiceBaseUrl + "/api/openpaywebhook",
							        dataType: "json"
						    	},
							    update: {
							        url: function(options){								        	
							        	return crudServiceBaseUrl + "/api/openpaywebhook/"+options.models[0].id;
							        }, 
							        dataType: "json",
							        type:"PUT"								       
							    },
							    destroy: {
							        url: function(options){							        	
							        	return crudServiceBaseUrl + "/api/openpaywebhook/"+options.models[0].id;
							        }, 
							      	dataType: "json",
							        type:"DELETE"
							    },
							    create: {
							        url: crudServiceBaseUrl + "/api/openpaywebhook",
							        dataType: "json",
							        type:"POST"
							    },
                                parameterMap: function(options, operation) {
                                    if (operation !== "read" && options.models) {
                                    	
                                    	return kendo.stringify(options.models[0]);
                                    }
                                }
                            },
                            batch: true,
                            pageSize: 10,
                         	
					schema: {
				        data: "data.openpaywebhook",
				        total: "data.totalCount",				        
				        model: {
				        id: 'id',
				          fields: {
				          		'id':{type:'number' ,editable: false, nullable: true},
									'response':{type:'string'},
									'tipo':{type:'string'},
									'referencia':{type:'number'},
									'log':{type:'string'},

					        }           
					      }
				   }
				});


$("#grid_openpaywebhook").kendoGrid({

	dataSource: dataSource,
	toolbar: ["create", "excel"],
    columns:[
			
			{ field: 'id', title: 'Id', width: '200px'},
			{ field:  'response', title:  'Response', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'tipo', title:  'Tipo', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'referencia', title:  'Referencia', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'log', title:  'Log', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
						

			
            {command: [
			"edit",

	    	"destroy"
            ],
            title: "Opciones", width: "150px"
            }
         ],
			

  	selectable: "multiple",                      
  	pageable: {
	    refresh: true,
	    pageSizes: true
	},
	editable: "popup",
	excel: {
       fileName: "openpaywebhook_report.xlsx",
    },                
  	resizable: true,
  	reorderable: true,
  	//groupable: true | false,
    sortable: true,
  	filterable: {
      mode: "row"
    },
  scrollable: true
  });
