	var crudServiceBaseUrl=baseUrl;


	var dataSource = new kendo.data.DataSource({
                            transport: {
                                read:  {						        
							        url: crudServiceBaseUrl + "/api/logopenpay",
							        dataType: "json"
						    	},
							    update: {
							        url: function(options){								        	
							        	return crudServiceBaseUrl + "/api/logopenpay/"+options.models[0].id;
							        }, 
							        dataType: "json",
							        type:"PUT"								       
							    },
							    destroy: {
							        url: function(options){							        	
							        	return crudServiceBaseUrl + "/api/logopenpay/"+options.models[0].id;
							        }, 
							      	dataType: "json",
							        type:"DELETE"
							    },
							    create: {
							        url: crudServiceBaseUrl + "/api/logopenpay",
							        dataType: "json",
							        type:"POST"
							    },
                                parameterMap: function(options, operation) {
                                    if (operation !== "read" && options.models) {
                                    	
                                    	return kendo.stringify(options.models[0]);
                                    }
                                }
                            },
                            batch: true,
                            pageSize: 10,
                         	
					schema: {
				        data: "data.logopenpay",
				        total: "data.totalCount",				        
				        model: {
				        id: 'id',
				          fields: {
				          		'id':{type:'number' ,editable: false, nullable: true},
									'id_reservacion':{type:'number'},
									'id_recibo':{type:'number'},
									'tipo':{type:'string'},
									'importe':{type:'string'},
									'request':{type:'string'},
									'response_liga':{type:'string'},
									'response_pago':{type:'string'},
									'estatus':{type:'string'},
									'liga_generado':{type:'number'},
									'log':{type:'string'},
									'reference':{type:'string'},
									'id_factura':{type:'string'},

					        }           
					      }
				   }
				});


$("#grid_logopenpay").kendoGrid({

	dataSource: dataSource,
	toolbar: ["create", "excel"],
    columns:[
			
			{ field: 'id', title: 'Id', width: '200px'},
			{ field:  'id_reservacion', title:  'Id Reservacion', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'id_recibo', title:  'Id Recibo', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'tipo', title:  'Tipo', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'importe', title:  'Importe', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'request', title:  'Request', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'response_liga', title:  'Response Liga', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'response_pago', title:  'Response Pago', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'estatus', title:  'Estatus', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'liga_generado', title:  'Liga Generado', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'log', title:  'Log', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'reference', title:  'Reference', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'id_factura', title:  'Id Factura', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
						

			
            {command: [
			"edit",

	    	"destroy"
            ],
            title: "Opciones", width: "150px"
            }
         ],
			

  	selectable: "multiple",                      
  	pageable: {
	    refresh: true,
	    pageSizes: true
	},
	editable: "popup",
	excel: {
       fileName: "logopenpay_report.xlsx",
    },                
  	resizable: true,
  	reorderable: true,
  	//groupable: true | false,
    sortable: true,
  	filterable: {
      mode: "row"
    },
  scrollable: true
  });
