<?php
include('_session_usuario.php');
$assets = Yii::app()->baseUrl . "/template/ansonika/assets";

session_start();
Yii::app()->setLanguage($_SESSION['language']);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Citytours - Premium site template for city tours agencies, transfers and tickets.">
    <meta name="author" content="Ansonika">
    <title>SUR 4 RMT - <?php echo $agencia->nombre_agencia; ?></title>

    <!-- Favicons-->
    <!-- <link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon"> -->
    <link rel="shortcut icon" href="/favicon.png">
    <link rel="apple-touch-icon" type="image/x-icon" href="img/apple-touch-icon-57x57-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="72x72" href="img/apple-touch-icon-72x72-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="114x114" href="img/apple-touch-icon-114x114-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="144x144" href="img/apple-touch-icon-144x144-precomposed.png">

    <!-- GOOGLE WEB FONT -->
    <link href="https://fonts.googleapis.com/css?family=Gochi+Hand|Lato:300,400|Montserrat:400,700" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans&display=swap" rel="stylesheet">

    <!-- COMMON CSS -->
    <link href="<?= $assets; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?= $assets; ?>/css/style.css" rel="stylesheet">
    <link href="<?= $assets; ?>/css/vendors.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?= Yii::app()->baseUrl . '/vue/select2-4/css/select2.min.css' ?>">

    <!-- FONT AWESOME -->
    <link rel="stylesheet" type="text/css" href="https://use.fontawesome.com/releases/v5.8.2/css/all.css">
    <link src="https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/skins/all.css">

    <script src="<?= $assets; ?>/js/jquery-2.2.4.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.js"></script>
    <style>
        #modal-solicitud-cancelacion table th td {
            padding: 3px;
            font-size: 15px;
        }
    </style>
</head>

<body>

    <div id="preloader">
        <div class="sk-spinner sk-spinner-wave">
            <div class="sk-rect1"></div>
            <div class="sk-rect2"></div>
            <div class="sk-rect3"></div>
            <div class="sk-rect4"></div>
            <div class="sk-rect5"></div>
        </div>
    </div>
    <!-- End Preload -->

    <div class="layer"></div>
    <!-- Mobile menu overlay mask -->

    <!-- Header================================================== -->
    <header id="plain">
        <div id="top_line">
            <div class="container">
                <div class="row">
                    <div class="col-6"><i class="icon-phone"></i><strong>(999)925-54-43 | (999) 286-49-90

                        </strong></div>
                    <div class="col-6">
                        <ul id="top_links">
                            <li><?= $uss->nombre_usuario ?></li>
                            <li> <a href="http://www.rutamayatravel.com.mx/blog/" target="_blank"><?= Yii::t("header_layout", "Blog & Noticias"); ?></a></li>
                            <li>
                                <div class="dropdown dropdown-mini">
                                    <?php if (Yii::app()->getLanguage() == "en") { ?>
                                        <a href="#" data-toggle="dropdown" id="lang_link">English</a>
                                    <?php } else { ?>
                                        <a href="#" data-toggle="dropdown" id="lang_link">Español</a>
                                    <?php } ?>
                                    <div class="dropdown-menu">
                                        <ul id="lang_menu">
                                            <li @click="changeLanguage()">
                                                <?php if (Yii::app()->getLanguage() == "en") { ?>
                                                    <a href="<?= Yii::app()->createUrl("site/changeLanguage", array("language" => "es", "origin" => $_SERVER["REQUEST_URI"])); ?>">Spanish</a>
                                                <?php } else { ?>
                                                    <a href="<?= Yii::app()->createUrl("site/changeLanguage", array("language" => "en", "origin" => $_SERVER["REQUEST_URI"])); ?>">Inglés</a>
                                                <?php } ?>
                                            </li>
                                            <!-- <li><a href="#0">French</a></li>
                                            <li><a href="#0">German</a></li>
                                            <li><a href="#0">Italian</a></li>
                                            <li><a href="#0">Japanese</a></li> -->
                                        </ul>
                                    </div>
                                </div>
                                <!-- End Dropdown access -->
                            </li>
                            <li @click="emptyCarrito()"><a href="<?= Yii::app()->createUrl("user/logout"); ?>"><b><i class="icon-logout"></i><?= Yii::t("header_layout", "Cerrar sesión"); ?></a></b></li>
                        </ul>
                    </div>
                </div><!-- End row -->
            </div><!-- End container-->
        </div><!-- End top line-->

        <div class="container">
            <div class="row">
                <div class="col-1">
                    <div id="logo_home">
                        <h1><a href="<?= Yii::app()->createUrl("site/index"); ?>" title="<?= $agencia->nombre_agencia; ?>" style="background-image: url(https://www.rutamayatravel.com/imagenes/<?= str_replace(" ", "%20", $agencia->foto); ?>); background-size: 35%; "><?= $agencia->nombre_agencia; ?></a></h1>
                    </div>
                    <!-- <div id="logo_home">
                        <h1><a href="index.html" title="City tours travel template">City Tours travel template</a></h1>
                    </div> -->
                </div>
                <nav class="col-11">
                    <a class="cmn-toggle-switch cmn-toggle-switch__htx open_close" href="javascript:void(0);"><span>Menu mobile</span></a>
                    <div class="main-menu">
                        <div id="header_menu">
                            <img src="https://www.rutamayatravel.com/imagenes/<?= $agencia->foto; ?>" alt="<?= $agencia->foto; ?>" width="86" height="94" data-retina="true">
                            <!-- <img src="img/logo_sticky.png" width="160" height="34" alt="City tours" data-retina="true"> -->
                        </div>
                        <a href="#" class="open_close" id="close_in"><i class="icon_set_1_icon-77"></i></a>
                        <ul>
                            <li class="submenu">
                                <a href="<?= Yii::app()->createUrl("site/index"); ?>" class="show-submenu pr-4"><?= Yii::t("header_layout", "Inicio"); ?></a>
                            </li>
                            <li class="submenu">
                                <a href="<?= Yii::app()->createUrl("reservas/misReservaciones"); ?>" class="show-submenu pr-4"><?= Yii::t("header_layout", "Mis Reservas"); ?></a>
                            </li>
                            <li class="submenu">
                                <a href="<?= Yii::app()->createUrl("site/promociones"); ?>" class="show-submenu pr-4"><?= Yii::t("header_layout", "Nuestra Sugerencia"); ?></a>
                            </li>
                            <li class="submenu">
                                <a href="<?= Yii::app()->createUrl("site/bloqueos"); ?>" class="show-submenu pr-4"><?= Yii::t("header_layout", "Mis Bloqueos"); ?></a>
                            </li>
                            <li class="submenu">
                                <a href="<?= Yii::app()->createUrl("site/grupos"); ?>" class="show-submenu pr-4"><?= Yii::t("header_layout", "Mis Grupos"); ?></a>
                            </li>
                            <li class="submenu">
                                <a href="<?= Yii::app()->createUrl("site/bodas"); ?>" class="show-submenu pr-4"><?= Yii::t("header_layout", "Mis Bodas"); ?></a>
                            </li>
                            <!-- <li class="submenu">
                                <a href="<?= Yii::app()->createUrl("casateconmigo/bodas"); ?>" class="show-submenu pr-4">Casate Conmigo</a>
                            </li> -->
                            <li class="submenu">
                                <a href="<?= Yii::app()->createUrl("internacionales"); ?>" class="show-submenu pr-4">Internacionales</a>
                            </li>
                            <li class="submenu">
                                <!-- <a href="<?= Yii::app()->createUrl("site/miAgencia"); ?>" class="show-submenu pr-4">Mi Agencia</a> -->


                                <?php if (Yii::app()->user->checkAccess('agenciaMenu')) { ?>
                                    <a href="<?= Yii::app()->createUrl("agencias/perfil"); ?>" class="show-submenu pr-4"><?= Yii::t("header_layout", "Mi Agencia"); ?></a>

                                <?php } else { ?>
                                    <a href="<?= Yii::app()->createUrl("admin/dashboard"); ?>" class="pr-4" target="_blank">Admin</a>
                                <?php  } ?>
                            </li>
                        </ul>
                    </div><!-- End main-menu -->
                    <ul id="top_tools">
                        <li>
                            <a href="javascript:void(0);" @click="showModal()" class="search-overlay-menu-btn"><i class="icon_search"></i></a>
                        </li>
                        <li id="shopping-cart">
                            <div class="dropdown dropdown-cart">
                                <a href="#" data-toggle="dropdown" class="cart_bt"><i class="icon_bag_alt"></i><strong>{{ Object.keys(array_carrito).length }}</strong></a>
                                <ul v-if="loaded == true" class="dropdown-menu" id="cart_items">
                                    <li v-for="(item, index) in array_carrito" v-if="item.tipo == 'reserva'">
                                        <div v-if="item.num_habs > 1">
                                            <strong v-if="item.prov == 3"><a href="#" v-text="item.item.nombre_hotel"></a>{{ getTotalCotiz(item.item[item.item.idHotel].Habitaciones[item.hab].Planes[item.plan_tarifa].plan, item.prov) }} </strong>
                                            <!-- <strong v-else-if="item.prov == 2 || item.prov == 4 || item.prov == 5"><a href="#" v-text="item.item.nombre_hotel"></a>{{ getTotalCotiz(item.item.Habitaciones[item.hab].Planes[item.plan_tarifa].plan, item.prov }} </strong> -->
                                            <strong v-else><a href="#" v-text="item.item.nombre_hotel"></a>{{ getTotalCotiz(item.item.Habitaciones[item.hab].Planes[item.plan_tarifa].plan, item.prov) }} </strong>
                                            <a href="javascript:void();" @click="deleteItemCarrito(index)" class="action"><i class="icon-trash"></i></a>
                                        </div>
                                        <div v-else>
                                            <!-- <div v-if="item.prov == 3" class="image"></div>
                                            <div v-else-if="item.item.foto.prov == 'Ruta Maya Travel'" class="image"><img :src="'https://www.rutamayatravel.com' + item.item.foto.rutaImage" alt="image"></div>
                                            <div v-else class="image"><img :src="item.item.foto.rutaImage" alt="image"></div> -->

                                            <strong v-if="item.prov == 3"><a href="#" v-text="item.item.nombre_hotel"></a>$ {{ item.item[item.item.idHotel].Habitaciones[item.hab].Planes[item.plan_tarifa].plan[item.plan].precio + " " + item.item[item.item.idHotel].Habitaciones[item.hab].Planes[item.plan_tarifa].plan[item.plan].moneda }} </strong>
                                            <strong v-else><a href="#" v-text="item.item.nombre_hotel"></a>$ {{ item.item.Habitaciones[item.hab].Planes[item.plan_tarifa].plan[item.plan].precio + " " + item.item.Habitaciones[item.hab].Planes[item.plan_tarifa].plan[item.plan].moneda }} </strong>
                                            <a href="javascript:void();" @click="deleteItemCarrito(index)" class="action"><i class="icon-trash"></i></a>
                                        </div>
                                    </li>
                                    <li v-else-if="item.tipo == 'activity'">
                                        <strong><a href="#" v-text="item.item.name"></a>$ {{ round((item.item.modalities[item.modality].rates[0].rateDetails[0].totalAmount.amount / parseFloat(item.markup)), 2) + " " + item.item.currency }} </strong>
                                        <a href="javascript:void();" @click="deleteItemCarrito(index)" class="action"><i class="icon-trash"></i></a>
                                    </li>
                                    <li v-else>
                                        <strong><a href="#" v-text="item.item.nombre"></a>$ {{ printTotalTour(item.item.tarifas[item.desglose], item.info_search) + ' ' + item.item.tarifas[item.desglose].moneda }} </strong>
                                        <a href="javascript:void();" @click="deleteItemCarrito(index)" class="action"><i class="icon-trash"></i></a>
                                    </li>
                                    <li>
                                        <!-- <div>Total: <span>$120.00</span></div> -->
                                        <div v-if="array_carrito.length == 0"><?= Yii::t("header_layout", "Tu carrito está vacío"); ?><span></span></div>
                                        <button @click="emptyCarrito" type="button" class="button_drop outline"><?= Yii::t("header_layout", "Vaciar"); ?></button>
                                        <a :href="rmt_url + '/carrito'" class="button_drop outline"><?= Yii::t("header_layout", "Ver detalle"); ?></a>
                                        <a :href="rmt_url + '/carrito/imprimircotizacion'" target="_blank" class="button_drop outline mt-1" style="width: 100%;"><?= Yii::t("header_layout", "Imprimir cotización"); ?></a>
                                        <a :href="rmt_url + '/carrito/imprimircotizacion?fotos=1'" target="_blank" class="button_drop outline mt-1" style="width: 100%;"><?= Yii::t("header_layout", "Imprimir cotización c/Fotos"); ?></a>
                                        <a :href="rmt_url + '/carrito/imprimircotizacion?observacion=1'" target="_blank" class="button_drop outline mt-1" style="width: 100%;"><?= Yii::t("header_layout", "Imprimir cotización c/Descrip"); ?></a>
                                    </li>
                                </ul>
                            </div><!-- End dropdown-cart-->
                        </li>
                    </ul>
                </nav>
            </div>
        </div><!-- container -->
    </header><!-- End Header -->

    <?php echo $content; ?>

    <footer id="footer" class="revealed">
        <div class="container">
            <div class="row">
                <div class="col-md-4">
                    <h3><?= Yii::t("header_layout", "¿Necesitas ayuda?"); ?></h3>
                    <a href="tel://9999255443" id="phone">(999) 925 54 43</a>
                    <a href="mailto:ventas@rutamayatravel.com" id="email_footer">ventas@rutamayatravel.com</a>
                </div>
                <div class="col-md-3">
                    <h3><?= Yii::t("header_layout", "Acerca de"); ?></h3>
                    <ul>
                        <li><a href="https://www.rutamayatravel.com/nosotros.html" target="_blank"><?= Yii::t("header_layout", "Nosotros"); ?></a></li>
                        <li><a href="https://www.rutamayatravel.com/faq.html" target="_blank">FAQ</a></li>
                        <li><a href="http://www.rutamayatravel.com.mx/blog/" target="_blank"><?= Yii::t("header_layout", "Noticias"); ?></a></li>
                        <li><a href="https://www.rutamayatravel.com/contacto.html" target="_blank"><?= Yii::t("header_layout", "Contacto"); ?></a></li>
                        <li><a href="https://www.dropbox.com/s/ehx8jazlc85si86/AvisoPrivacidad-integral.pdf?dl=0" target="_blank"><?= Yii::t("header_layout", "Aviso de privacidad"); ?></a></li>
                    </ul>
                </div>
                <div class="col-md-3">

                </div>
                <div class="col-md-2">
                    <h3><?= Yii::t("header_layout", "Idioma"); ?></h3>
                    <div class="styled-select">
                        <form id="lang" action="<?= Yii::app()->createUrl("site/changeLanguage"); ?>">
                            <select name="language" @change="changeLanguage()">
                                <?php if (Yii::app()->getLanguage() == "es") { ?>
                                    <option value="en">Inglés</option>
                                    <option value="es" selected>Español</option>
                                <?php } else { ?>
                                    <option value="en" selected>English</option>
                                    <option value="es">Spanish</option>
                                <?php } ?>
                            </select>
                            <input type="hidden" name="origin" value="<?= $_SERVER["REQUEST_URI"]; ?>">
                        </form>
                    </div>
                </div>
            </div><!-- End row -->
            <div class="row">
                <div class="col-md-12">
                    <div id="social_footer">
                        <ul>
                            <li><a href="https://www.facebook.com/RutaMayaTravel" target="_blank"><i class="icon-facebook"></i></a></li>

                            <li><a href="https://www.instagram.com/rutamayatravel/" target="_blank"><i class="icon-instagram"></i></a></li>
                            <li><a href="https://www.youtube.com/channel/UCjssE9LVR20ZiCRXBvnqkmA" target="_blank"><i class="icon-youtube-play"></i></a></li>
                        </ul>
                        <p>© Ruta Maya Travel <?= date("Y"); ?></p>
                    </div>
                </div>
            </div><!-- End row -->
        </div><!-- End container -->
    </footer><!-- End footer -->

    <div id="toTop"></div><!-- Back to top button -->

    <!-- Search Menu -->
    <div id="modal-busqueda" class="search-overlay-menu">
        <span class="search-overlay-close"><i class="icon_set_1_icon-77"></i></span>
        <form role="search" id="searchform" action="<?= Yii::app()->createUrl('reservacion/buscar'); ?>" method="POST">
            <input value="" name="search" type="search" placeholder="Buscar..." />
            <button type="submit"><i class="icon_set_1_icon-78"></i>
            </button>
        </form>
    </div><!-- End Search Menu -->

    <div id="modal-solicitud-cancelacion" class="search-overlay-menu">
        <span class="search-overlay-close" @click="closed()"><i class="icon_set_1_icon-77"></i></span>
        <form role="search" action="" method="POST" id="form-motivo-cancelacion" style="top:30%;">
            <!--  <select name="" id="" style="width: 100%; background: 0,0; border-top: solid transparent; border-bottom: 2px solid #909090!important; border-left: solid transparent; border-right: : solid transparent;"> -->
            <?php $motivos = MotivosCancelacion::model()->findAll(); ?>
            <div class="row">
                <div class="form-check text-left col-5" style="font-size: 28px; color:#bdbdbd;">
                    <?php foreach ($motivos as $value) : ?>
                        <div>
                            <input id="txt-motivo" class="form-check-input" v-model="cancel.motivo" type="radio" name="motivo" :value="<?= $value->id_motivo ?>">&nbsp;
                            <label class="form-check-label" for="gridRadios1">
                                <?= $value->motivo ?>
                            </label>
                        </div>

                        <br>

                    <?php endforeach ?>
                </div>
                <div class=" col-7">
                    <div class="row">
                        <div class="col-12">
                            <h3 class="text-left" style="font-size: 28px; color:#bdbdbd; margin-top: 0px;">Politicas de cancelación</h3>
                            <table style=" color:#bdbdbd; padding:3px;" class="table table-sm">

                                <tr v-for="(cancel,index) in politicasCancelacion" v-if="cancel.habitacion > 0">
                                    <th>Habitación:</th>
                                    <td v-text="cancel.habitacion<6? cancel.habitacion:'Estancia completa'"></td>
                                    <th>Apartir de:</th>
                                    <td v-text="appBookingList.parseDate(reserva.fecha_limite,'DD/MM/YYYY')"></td>
                                    <th>Costo:</th>
                                    <td v-text="cancel.importe"></td>
                                </tr>

                            </table>
                        </div>

                    </div>
                </div>
            </div>
            <div class="row " style="margin-top: 3%;">
                <div class="col-12">
                    <input id="txt-comentario" v-model="cancel.comentario" type="search" placeholder="Agrega un comentario" />
                </div>
                <div v-if="permitirCancelacion()" class="col-12 cancelacionInmediata">


                    <!-- <label style="color:#c6c6c6; font-size:32px; margin-top:20px;"><i class="icon-cancel-circled-2"></i>Cancelación Inmediata  
                     </label>
                     <input type="checkbox"  v-model="cancelacionInmediata" value="CANCELLATION"> -->
                    <button type="button" id="send-solicitud" @click="cancellation(1)">Cancelación Inmediata<i class="icon-cancel-circled-2"></i></button>

                </div>
                <div v-else class="col-12">

                    <button type="button" id="send-solicitud" @click="cancellation(0)">Enviar Solicitud de cancelación<i class="icon-play"></i></button>
                </div>
            </div>
        </form>
    </div><!-- End solicitud cancelacion -->

    <!-- Common scripts -->
    <script src="<?= $assets; ?>/js/common_scripts_min.js"></script>
    <script src="<?= $assets; ?>/js/functions.js"></script>
    <script src="<?= $assets; ?>/js/switcher.js"></script>
    <script src="<?= $assets; ?>/js/custom.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/vue"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/vue.resource/1.3.1/vue-resource.min.js"></script>
    <script type="text/javascript" src="<?= Yii::app()->baseUrl . '/vue/select2-4/js/select2.min.js' ?>"></script>
    <script>
        var baseUrl = "<?= Yii::app()->baseUrl; ?>";
        var language = "<?= Yii::app()->getLanguage(); ?>";
        var origin_url = "<?= $_SERVER["REQUEST_URI"]; ?>";
        $('#modal-solicitud-cancelacion .cancelacionInmediata .cancelacionInmediataif input').iCheck({
            checkboxClass: 'icheckbox_futurico',
            radioClass: 'iradio_futurico',
        });
    </script>
    <script type="text/javascript" src="<?= Yii::app()->baseUrl . '/vue/shopping_cart_header.js?v=' . time(); ?>"></script>

    <!-- Cat nav mobile -->
    <!-- <script src="js/cat_nav_mobile.js"></script>
    <script>
        $('#cat_nav').mobileMenu();
    </script> -->
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-44773963-18"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'UA-44773963-18');
    </script>
</body>

</html>