<div class="form row">
	<?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm', array(
		'id' => 'flyers-form',
		'enableAjaxValidation' => false,
		'method' => 'post',
		'type' => 'horizontal',
		'htmlOptions' => array(
			'enctype' => 'multipart/form-data',
			'role' => 'form'
		)
	)); ?>


	<?php echo $form->errorSummary($model, 'Error: ', null, array('class' => 'alert alert-error col-md-12')); ?>
	<div class="col-md-12">
		<div class="card card-success">

			<h3 class="card-header"><?= $model->isNewRecord ? 'Agregar Flyer' : 'Actualizar Flyer' ?></h3>


			<div class="card-body">
				<div class="row">
					<div class=" col-md-6">
						<div class="row">
							<p class="note">Campos con <span class="required">*</span> son requeridos</p>
							<div class=" form-group col-md-12">
								<?php echo $form->labelEx($model, 'nombreimagen'); ?>
								<?php echo $form->fileField($model, 'nombreimagen', array('size' => 60, 'maxlength' => 255, 'class' => 'form-control')); ?>
								<?php echo $form->error($model, 'nombreimagen'); ?>
							</div>

							<div class=" form-group col-md-12">
								<?php echo $form->labelEx($model, 'titulo'); ?>
								<?php echo $form->textField($model, 'titulo', array('size' => 60, 'maxlength' => 150, 'class' => 'form-control')); ?>
								<?php echo $form->error($model, 'titulo'); ?>
							</div>


							<div class=" form-group col-md-12">
								<?php echo $form->labelEx($model, 'id_hotel'); ?>
								<?php echo $form->dropDownList($model, 'id_hotel', CHtml::listData(Hoteles::model()->findAll(array('order' => 'id_hotel', 'condition' => 'proveedor!=1')), 'id_hotel', 'nombre_hotel'), array('size' => 10, 'maxlength' => 10, 'class' => 'form-control select2')); ?>
								<?php echo $form->error($model, 'id_hotel'); ?>
							</div>

							<div class=" form-group col-md-12">
								<?php echo $form->labelEx($model, 'tipo'); ?>
								<?php echo $form->dropDownList($model, 'tipo', array('BLOQUEO' => 'BLOQUEO', 'INDIVIDUALES' => 'INDIVIDUALES', 'GRUPO' => 'GRUPO', 'BODA' => 'BODA'), array('size' => 255,'maxlength' => 255,'class' => 'form-control select2')); ?>
							</div>

							<div class=" form-group col-md-12">
								<?php echo $form->labelEx($model, 'id_tipo_promocion'); ?>
								<?php echo $form->dropDownList($model, 'id_tipo_promocion', CHtml::listData(LogoEventos::model()->findAll(array('order' => 'nombre')), 'id', 'nombre'), array('size' => 10, 'maxlength' => 10, 'class' => 'form-control select2')); ?>
								<?php echo $form->error($model, 'id_tipo_promocion'); ?>
							</div>

							<?php /*echo $form->labelEx($model,'id_cadena_hotel');
						 echo $form->dropDownList($model,'id_cadena_hotel',CHtml::listData(CadenaHotel::model()->findAll(array('limit'=>250, 'order'=>'id_hotel'))), array('class'=>'form-control')); ?>
						 echo $form->error($model,'id_cadena_hotel');*/ ?>


							<div class=" form-group col-md-4 col-md-push-2">
								<?php echo $form->labelEx($model, 'fechainicial'); ?>
								<?php echo $form->dateField($model, 'fechainicial', array('class' => 'form-control')); ?>
								<?php echo $form->error($model, 'fechainicial'); ?>
							</div>

							<div class=" form-group col-md-4 col-md-push-2">
								<?php echo $form->labelEx($model, 'fechafinal'); ?>
								<?php echo $form->dateField($model, 'fechafinal', array('class' => 'form-control')); ?>
								<?php echo $form->error($model, 'fechafinal'); ?>
							</div>

						</div>
					</div> <!-- hola -->
					<div class="col-md-6">

						<?php if (!$model->isNewRecord) { ?>
							<legend>Imagen Actual: <?= $model->nombreimagen ?></legend>
							<div>
								<img src="/../../medios/flyers/<?= $model->id_flyer . "_" . $model->nombreimagen; ?>" width="300">
							</div>

						<?php } ?>

						<div class="col-md-12">
							<legend>Tipo de Template</legend>

							<?php $tipoFlyer = FlyersTipo::model()->findAll(); ?>
							<?php foreach ($tipoFlyer as $template) : ?>
								<div class=" form-group col-md-3 ">
									<img src="/../../medios/whiteflyers/<?= $template->nombre ?>" width="100px" style="margin-right: 3px;">


									<?php echo $form->radioButton($model, 'tipo_flyer', array(
																			'value' => $template->id,
																			'uncheckValue' => null
																		)); ?>

									<?php echo $form->error($model, 'tipo_flyer'); ?>
								</div>
							<?php endforeach ?>
						</div>

					</div>
				</div>
			</div>



			<div class="form-group">
				<div class="col-lg-offset-4 col-lg-8 ">
					<?php $this->widget('bootstrap.widgets.TbButton', array(
																		'buttonType' => 'submit',
																		'type' => 'primary',
																		'icon' => 'ok white',
																		'label' => $model->isNewRecord ? 'Nuevo' : 'Guardar',
																	)); ?>
					<?php $this->widget('bootstrap.widgets.TbButton', array(
																		'buttonType' => 'reset',
																		'icon' => 'remove',
																		'label' => 'Restablecer',
																	)); ?>
					<p class="note">Campos con <span class="required">*</span> son obligatorios.</p>
				</div>
			</div>
		</div>
	</div>
	<?php $this->endWidget(); ?>

</div>