	var crudServiceBaseUrl=baseUrl;


	var dataSource = new kendo.data.DataSource({
                            transport: {
                                read:  {						        
							        url: crudServiceBaseUrl + "/api/fefacturasdetalle",
							        dataType: "json"
						    	},
							    update: {
							        url: function(options){								        	
							        	return crudServiceBaseUrl + "/api/fefacturasdetalle/"+options.models[0].id_factura_detalle;
							        }, 
							        dataType: "json",
							        type:"PUT"								       
							    },
							    destroy: {
							        url: function(options){							        	
							        	return crudServiceBaseUrl + "/api/fefacturasdetalle/"+options.models[0].id_factura_detalle;
							        }, 
							      	dataType: "json",
							        type:"DELETE"
							    },
							    create: {
							        url: crudServiceBaseUrl + "/api/fefacturasdetalle",
							        dataType: "json",
							        type:"POST"
							    },
                                parameterMap: function(options, operation) {
                                    if (operation !== "read" && options.models) {
                                    	
                                    	return kendo.stringify(options.models[0]);
                                    }
                                }
                            },
                            batch: true,
                            pageSize: 10,
                         	
					schema: {
				        data: "data.fefacturasdetalle",
				        total: "data.totalCount",				        
				        model: {
				        id: 'id_factura_detalle',
				          fields: {
				          		'id_factura_detalle':{type:'string' ,editable: false, nullable: true},
									'id_factura':{type:'string'},
									'cantidad':{type:'string'},
									'unidad':{type:'string'},
									'no_identificacion':{type:'string'},
									'cve_prod_serv':{type:'number'},
									'descripcion':{type:'string'},
									'clave_unidad':{type:'string'},
									'valor_unitario':{type:'string'},
									'importe':{type:'string'},
									'id_recibo':{type:'number'},

					        }           
					      }
				   }
				});


$("#grid_fefacturasdetalle").kendoGrid({

	dataSource: dataSource,
	toolbar: ["create", "excel"],
    columns:[
			
			{ field: 'id_factura_detalle', title: 'Id Factura Detalle', width: '200px'},
			{ field:  'id_factura', title:  'Id Factura', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'cantidad', title:  'Cantidad', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'unidad', title:  'Unidad', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'no_identificacion', title:  'No Identificacion', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'cve_prod_serv', title:  'Cve Prod Serv', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'descripcion', title:  'Descripcion', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'clave_unidad', title:  'Clave Unidad', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'valor_unitario', title:  'Valor Unitario', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'importe', title:  'Importe', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'contains'
			                    }
			                } 
						},
			{ field:  'id_recibo', title:  'Id Recibo', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
						

			
            {command: [
			"edit",

	    	"destroy"
            ],
            title: "Opciones", width: "150px"
            }
         ],
			

  	selectable: "multiple",                      
  	pageable: {
	    refresh: true,
	    pageSizes: true
	},
	editable: "popup",
	excel: {
       fileName: "fefacturasdetalle_report.xlsx",
    },                
  	resizable: true,
  	reorderable: true,
  	//groupable: true | false,
    sortable: true,
  	filterable: {
      mode: "row"
    },
  scrollable: true
  });
