<?php

class FeFacturasDetalleController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		$rules = AuthFuncion::model()->findAll('controlador="'.Yii::app()->controller->id.'"');
		$array = array();
		foreach($rules as $row){

			$rule = array('allow',
						'actions'=>array($row->funcion),
						'roles'=>array($row->operacion),
					);
			array_push($array,$rule);
		}

		array_push($array,
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('*'),
			)
		);

		array_push($array,
			array('deny',  // deny all users
				'users'=>array('*'),
			)
		);

		return $array;

	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new FeFacturasDetalle;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['FeFacturasDetalle']))
		{
			$model->attributes=$_POST['FeFacturasDetalle'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_factura_detalle));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['FeFacturasDetalle']))
		{
			$model->attributes=$_POST['FeFacturasDetalle'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_factura_detalle));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new FeFacturasDetalle('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['FeFacturasDetalle']))
		{
                        $model->attributes=$_GET['FeFacturasDetalle'];
			
			
                   	
                       if (!empty($model->id_factura_detalle)) $criteria->addCondition("id_factura_detalle = '".$model->id_factura_detalle."'");
                     
                    	
                       if (!empty($model->id_factura)) $criteria->addCondition("id_factura = '".$model->id_factura."'");
                     
                    	
                       if (!empty($model->cantidad)) $criteria->addCondition("cantidad = '".$model->cantidad."'");
                     
                    	
                       if (!empty($model->unidad)) $criteria->addCondition("unidad = '".$model->unidad."'");
                     
                    	
                       if (!empty($model->no_identificacion)) $criteria->addCondition("no_identificacion = '".$model->no_identificacion."'");
                     
                    	
                       if (!empty($model->cve_prod_serv)) $criteria->addCondition("cve_prod_serv = '".$model->cve_prod_serv."'");
                     
                    	
                       if (!empty($model->descripcion)) $criteria->addCondition("descripcion = '".$model->descripcion."'");
                     
                    	
                       if (!empty($model->clave_unidad)) $criteria->addCondition("clave_unidad = '".$model->clave_unidad."'");
                     
                    	
                       if (!empty($model->valor_unitario)) $criteria->addCondition("valor_unitario = '".$model->valor_unitario."'");
                     
                    	
                       if (!empty($model->importe)) $criteria->addCondition("importe = '".$model->importe."'");
                     
                    	
                       if (!empty($model->id_recibo)) $criteria->addCondition("id_recibo = '".$model->id_recibo."'");
                     
                    			
                    $session['FeFacturasDetalle_records']=FeFacturasDetalle::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new FeFacturasDetalle('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['FeFacturasDetalle']))
			$model->attributes=$_GET['FeFacturasDetalle'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=FeFacturasDetalle::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='fe-facturas-detalle-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['FeFacturasDetalle_records']))
               {
                $model=$session['FeFacturasDetalle_records'];
               }
               else
                 $model = FeFacturasDetalle::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['FeFacturasDetalle_records']))
               {
                $model=$session['FeFacturasDetalle_records'];
               }
               else
                 $model = FeFacturasDetalle::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('FeFacturasDetalle Report');
		$pdf->SetSubject('FeFacturasDetalle Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("FeFacturasDetalle_002.pdf", "I");
	}
}
