<?php

	$ceremonia=BloqueosCeremonias::model()->find('id_bloqueo='.$model_bloqueo->id_bloqueo);
	function dateDifference($date_1 , $date_2 , $differenceFormat = '%a') {
	    $datetime1 = date_create($date_1);
	    $datetime2 = date_create($date_2);
	   
	    $interval = date_diff($datetime1, $datetime2);
	   
	    return $interval->format($differenceFormat); 
	}

	$no_noches = dateDifference($model_bloqueo->fecha_inicio, $model_bloqueo->fecha_final) + 1;

	function getParseDate($od) {
		$months = array(1=>"ENERO", 2=>"FEBRERO", 3=>"MARZO", 4=>"ABRIL", 5=>"MAYO", 6=>"JUNIO", 7=>"JULIO", 8=>"AGOSTO", 9=>"SEPTIEMBRE", 10=>"OCTUBRE", 11=>"NOVIEMBRE", 12=>"DICIEMBRE");
		$original_date = date_parse($od);
		$date_parse = $original_date["day"] ." ". $months[$original_date["month"]] ." ". $original_date["year"];
		return $date_parse;
	}

	function getDayOfWeek($date) {
		$days = array(1 => "lunes", 2 => "martes", 3 => "miércoles", 4 => "jueves", 5 => "viernes", 6 => "sábado", 7 => "domingo");
		$day_of_week = date('w', strtotime($date));
		return $days[$day_of_week];
	}

	function getStayRange($start, $end) {
		$start_date = date_parse($start);
		$end_date = date_parse($end);
		$date_result = "";

		$months = array(1=>"ENERO", 2=>"FEBRERO", 3=>"MARZO", 4=>"ABRIL", 5=>"MAYO", 6=>"JUNIO", 7=>"JULIO", 8=>"AGOSTO", 9=>"SEPTIEMBRE", 10=>"OCTUBRE", 11=>"NOVIEMBRE", 12=>"DICIEMBRE");

		if($start_date["month"] == $end_date["month"]) {
			$date_result = $start_date["day"] ." AL ". $end_date["day"] ." DE ". $months[$start_date["month"]] ." DE ". $start_date["year"];
		}

		return $date_result;
	}

	function getTotalCN($desglose, $noches, $no_habs) {
		$total = (($noches - 1) * intval($no_habs)) * floatval($desglose->precio_normal);
		//$total = $no_habs;
		//return $total;
		return number_format($total, 2, ".", ",");
	}

	function getTotalRooms($noches, $no_habs) {
		$total = intval($no_habs) * ($noches - 1);
		return $total;
	}

	function getNoMenor($num) {
		$no_menor = "";
		switch ($num) {
			case "1":
				$no_menor ="1ER MENOR";
				break;
			
			case "2":
				$no_menor = "2DO MENOR";
				break;

			case "3":
				$no_menor = "3ER MENOR";
				break;
		}
		return $no_menor; 
	}

	function getBaseHab($id_hab) {
		$tipo_base = "";
		switch ($id_hab) {
			case 1:
				$tipo_base = "SGL";
				break;
			
			case 2:
				$tipo_base = "DBL";
				break;

			case 3:
				$tipo_base = "TPL";
				break;

			case 4:
				$tipo_base = "QPL";
				break;
		}
		return $tipo_base;
	}

	function direccion($agencia){
		  return $agencia->calle_agencia." ".$agencia->cruzamientos_agencia." ".$agencia->num_exterior_agencia." ".$agencia->cp_agencia." ".$agencia->id_colonia_agencia." ".$agencia->id_ciudad_agencia;
	}

	$no_cotesias = count($model_cortesias);
	$contacto=$model_agencia->representante_legal;
	if (!$contacto) {
		$contacto=$model_agencia->contacto;
	}
?>

<style>
	p {
		text-align: justify;
	}
	.list-roman {
  		list-style-type: upper-roman;
	}
	.list-decimal {
		list-style-type: decimal;
	}
	.title {
		text-align: center;
	}
	table {
		border-collapse: collapse;
	}
	table, td {
		border: 0.5px solid black;
		
	}
	.no-brdr-tbl {
		border: none;
	}
	.header {
		background-color: #C2D69B;
		font-weight: bold;
	}
	.highlighted {
		background-color: #DAEEF3;
	}
	#descripcionTabla tr td{
		font-size: 9px;
	}
</style>

<section id="convenio">
	<h2 class="title">CONVENIO DE PRESTACIÓN DE SERVICIOS</h2>
	<p>
		Contrato de Evento Grupal celebrado el día <b><?= strtolower(getParseDate($model_contract->created)); ?></b> por una parte, <b>CONSORCIO PROMOTOR DE VIAJES S.A DE C.V,</b> representada en este acto por el ING. NESTOR DANIEL RUIZ SERRANO en su carácter de Director General y a quien en lo sucesivo y para los efectos del presente contrato se le denomina <b>“EL OPERADOR”</b>  y por la otra parte la agencia de viajes <b><?= strtoupper($model_agencia->nombre_agencia); ?></b> representada por el/la C. <b><?= strtoupper($contacto); ?></b> y a quien en lo sucesivo y para los efectos del presente instrumento se le denominara <b>“EL CLIENTE”</b> y que sujetan al tenor de las siguientes declaraciones políticas y condiciones de pago.
		
	</p>
</section>

<section id="declaraciones">
	<h2 class="title">DECLARACIONES</h2>
	<ol class="list-roman">
		<li>
			DE “EL OPERADOR”
			<ol class="list-decimal">
				<li>Ser una persona moral, constituida conforme a las leyes del país como se acredita con la escritura pública No. 76, pasada ante la fe del licenciado Jorge Alberto Heredia Trujillo, Notario Público No. 71 en esta ciudad.</li>
				<li>Estar representada en la firma del presente contrato por el Ing. Néstor Daniel Ruiz Serrano en su carácter de representante legal de la compañía y de nacionalidad mexicana.</li>
				<li>Tener su domicilio en Av. Cupúles No. 236 Depto. 1 x 20 y 22 García Ginerés C.P. 97070 en la Ciudad de Mérida, Yucatán, México.</li>
			</ol>
		</li>

		<li>
			EL “CLIENTE”
			<ol class="list-decimal">
				<li>Llamarse como ha quedado escrito C. <?= strtoupper($contacto); ?>, ser de nacionalidad mexicana; con dirección en <?=direccion($model_agencia)?>.</li>
				<li>Que tiene la capacidad y las aptitudes para solventar este contrato.</li>
				<li>Estar de acuerdo en las actividades, políticas, condiciones establecidas en el presente documento. Por lo anterior, las partes han convenido celebrar el presente contrato al tenor de las siguientes.</li>
			</ol>
		</li>
	</ol>
</section>

<section id="acuerdos">
	<h2 class="title">ACUERDOS</h2>
	<p>
		Siendo enteradas ambas partes del acuerdo el día <b><?= getDayOfWeek($model_contract->created) ." ". getParseDate($model_contract->created); ?></b> mismo donde se especificarán las condiciones y servicios que se proveerán al grupo en el <b>Hotel <?= strtoupper($model_hotel->nombre_hotel); ?> DEL <?= getStayRange($model_bloqueo->fecha_inicio, $model_bloqueo->fecha_final); ?>.</b>
	</p>
</section>

<section id="descripcion_grupo">
	<h2 class="title">DESCRIPCIÓN DEL GRUPO</h2>

	<div>
		<table nobr=true id="descripcionTabla">
			<?php if ($model_bloqueo->idTarifa->precio=="BODA"): ?>
				<tr>
					<td colspan="2"><b>Nombre de los novios:</b></td>
					<td colspan="2"><?=strtoupper($model_bloqueo->novios)?></td>
				</tr>
				<tr>
					<td colspan="2"><b>Nombre del grupo</b></td>
					<td colspan="2"><?= strtoupper($model_bloqueo->titulo_evento); ?></td>
					
				</tr>
				<tr>
					<td colspan="2"><b>Hotel</b></td>
					<td colspan="2"><?= strtoupper($model_hotel->nombre_hotel); ?></td>
					
				</tr>
				<tr>
					<td><b>Día de llegada</b></td>
					<td><?= getParseDate($model_bloqueo->fecha_inicio); ?></td>
					<td><b>Día de salida</b></td>
					<td><?= getParseDate($model_bloqueo->fecha_final); ?></td>
				</tr>
				<tr>
					<td><b>% de comisión</b></td>
					<td><?= is_null($model_bloqueo->comision) ? $model_agencia->porcentaje_comision : $model_bloqueo->comision; ?> %</td>
					<td><b>Tipo de plan</b></td>
					<td><?= strtoupper($model_plan->nombre); ?></td>
				</tr>
				<?php if ($ceremonia): ?>
					<tr>
						<?php if ($ceremonia->ceremonia_primera): ?>
							<td colspan="2"><b><?=$ceremonia->ceremonia_primera?></b></td>
							<td colspan="2"><?=date('d/m/Y H:i', strtotime($ceremonia->fecha_primera))?></td>
						<?php else: ?>
							<td colspan="2"><b>No. de noches</b></td>
							<td colspan="2"><?= $no_noches - 1; ?> NOCHES</td>			
						<?php endif ?>
							
						<?php if ($ceremonia->ceremonia_segunda): ?>		
							<td colspan="2"><b><?=$ceremonia->ceremonia_segunda?></b></td>
							<td colspan="2"><?=date('d/m/Y H:i', strtotime($ceremonia->fecha_segunda))?></td>
						<?php else: ?>
							<td colspan="4"></td>
						<?php endif ?>
					</tr>
				<?php endif ?>
				<?php if ($ceremonia->ceremonia_primera && $ceremonia->ceremonia_segunda): ?>
					<tr>
						<td><b>No. de noches</b></td>
						<td><?= $no_noches - 1; ?> NOCHES</td>
						<td><b>No. de habs.</b></td>
						<td><?= $model_bloqueo->numero_habitaciones; ?></td>
					</tr>
				<?php endif ?>
			<?php else: ?>
				<tr>
					<td><b>Nombre del grupo</b></td>
					<td><?= strtoupper($model_bloqueo->titulo_evento); ?></td>
					<td><b>% de comisión</b></td>
					<td><?= is_null($model_bloqueo->comision) ? $model_agencia->porcentaje_comision : $model_bloqueo->comision; ?> %</td>
				</tr>
				<tr>
					<td><b>Hotel</b></td>
					<td><?= strtoupper($model_hotel->nombre_hotel); ?></td>
					<td><b>Tipo de plan</b></td>
					<td><?= strtoupper($model_plan->nombre); ?></td>
				</tr>
				<tr>
					<td><b>Día de llegada</b></td>
					<td><?= getParseDate($model_bloqueo->fecha_inicio); ?></td>
					<td><b>Día de salida</b></td>
					<td><?= getParseDate($model_bloqueo->fecha_final); ?></td>
				</tr>
				<tr>
					<td><b>No. de habs.</b></td>
					<td><?= $model_bloqueo->numero_habitaciones; ?></td>
					<td><b>No. de noches</b></td>
					<td><?= $no_noches - 1; ?> NOCHES</td>
				</tr>
			<?php endif ?>
		</table>
	</div>
</section>
<br pagebreak="true"/>
<section id="politicas_condiciones">
	
	<h2 class="title">POLÍTICAS Y CONDICIONES DE PAGOS</h2>
	<?php
	 	$sinoches=$no_noches-1; 
	 	$desglose[0][$sinoches][0][1]["fecha"]=date('d M y',strtotime($desglose[0][$sinoches-1][0][1]["fecha"].' + 1 days'));
	?>
	<table nobr="true">
		<tr>
			<td colspan="2"><b>TIPO DE HABITACIÓN</b></td>
			<td colspan="<?= (4 + $no_noches) - 3; ?>"><?= strtoupper($model_tipo_hab->tipo_habitacion); ?></td>
		</tr>
		<tr class="header">
			<td colspan="2"><b>Fecha de estancia</b></td>

			<?php for ($i = 0; $i < $no_noches; $i++) : ?>

				<td><b><?= $desglose[0][$i][0][1]["fecha"]?></b></td>
			<?php endfor; ?>
			<td><b>CN</b></td>
		</tr>
		<tr>
			<td colspan="2">Tarifa base doble</td>
			<?php for ($i = 0; $i < $no_noches; $i++) : ?>
				<td> <?= $desglose[0][$i][0][1]["adultos"]? '$'.$desglose[0][$i][0][1]["adultos"]:'OUT'; ?></td>
			<?php endfor; ?>
			
			<td><?=  $sinoches* $model_bloqueo->numero_habitaciones?></td>
		</tr>
		
		<tr>
			<td class="header" colspan="2">Habitaciones</td>
			<?php $habitacionesNc=$model_bloqueo->numero_habitaciones-count($model_cortesias); ?>
			<?php for ($i = 0; $i < $no_noches; $i++) : ?>		
				<td>
					<?php
						if ($i==$no_noches-1) {
							echo "OUT";
						}else{

							echo $habitacionesNc;
						}
					?>
				</td>				
			<?php endfor; ?>
		
			<td><?=  $sinoches * $habitacionesNc ?></td>
		</tr>
		
		<tr>
			<td colspan="2">Cortesías</td>
			<?php $cortesia= count($model_cortesias); ?>
			<?php for ($i=0; $i < $no_noches; $i++) : ?>
				<td>
					<?php
						if ($i==$no_noches-1) {
							echo "OUT";
						}else{

							echo $cortesia;
						}
					?>
					
						
				</td>
			<?php endfor; ?>
			<td><?= $cortesia * $sinoches?></td>
		</tr>
		<!-- <tr>
			<td class="header" colspan="<?= (4 + $no_noches) - 3; ?>" align="right"><b>TOTAL CUARTOS NOCHES</b></td>
			<td colspan="2" align="right"> <?= getTotalRooms($no_noches, $model_bloqueo->numero_habitaciones); ?></td>
			<td></td>
		</tr> -->



		<tr>
			<td colspan="<?= (4 + $no_noches) - 3; ?>" align="right"><b>MONTO TOTAL DEL GRUPO</b></td>

			<td colspan="2" align="right"><b>$ <?= getTotalCN($model_tarifa_desglose[1], $no_noches, ($model_bloqueo->numero_habitaciones - $cortesia)); ?>**</b></td>
		</tr>
	</table>

	<p>
		**Precio basado en ocupación máxima de dos adultos por habitación en el periodo de fechas
		especificado. Este importe no contempla el hospedaje de ningún menor, en caso de tener costo,
		deberá ser considerado en las cuentas finales.
	</p>
	
	<p></p>

	<h2 class="title">TARIFAS DEL EVENTO</h2>

	<table nobr="true">
		<tr>
			<td>SGL</td>
			<td>DBL</td>
			<td>TPL</td>
			<td>QPL</td>
			
			<?php foreach($model_desglose_menores as $row){ ?>
            <?php if($row->num_evaluar > $model_tarifa_desglose[2]->max_menores)continue; ?>
            <td><?=$row->es_junior != 1 ? $row->num_evaluar.'MNR':'JR'?><?="(". $row->edad_min_menor ." a ". $row->edad_max_menor .")"?></td>
            <?php } ?>
		</tr>
		<tr>
			<td><?= "$ ". number_format(floatval($model_tarifa_desglose[0]->precio_normal), 2, ".", ","); ?></td>
			<td><?= "$ ". number_format(floatval($model_tarifa_desglose[1]->precio_normal), 2, ".", ","); ?></td>
			<td><?= $model_tarifa_desglose[2] ? "$ ". number_format(floatval($model_tarifa_desglose[2]->precio_normal), 2, ".", ",") : "No aplica"; ?></td>
			<td><?= $model_tarifa_desglose[3] ? "$ ". number_format(floatval($model_tarifa_desglose[3]->precio_normal), 2, ".", ",") : "No aplica"; ?></td>
			<?php foreach($model_desglose_menores as $row){ ?>
                    <?php if($row->num_evaluar > $model_tarifa_desglose[2]->max_menores)continue; ?>
                    <td><?php if($row->precio == 0)echo "Gratis"; else echo "$ ".number_format($row->precio,2); ?> </td>
                    <?php } ?>
		</tr>
	</table>

	<ul>
		<li>Tarifas por habitación por noche en pesos mexicanos, impuestos (IVA/ISH) y propinas incluidas.</li>
		<li>Máximo 4 personas por habitación entre adultos y menores, el tipo de cama puede ser king size o dos camas hoteleras según la ocupación y asignación del hotel.</li>
		<li>Los precios son comisionables en base a los acuerdos y porcentaje establecidos para la agencia.</li>
		<li>Las tarifas pueden sufrir modificaciones en función a la normativa de la zona.</li>
		<li>Tarifa de menor solo aplica compartiendo habitación con adultos. <b>Todos los menores deben presentar identificación que acredite su edad al momento de hacer check in (copia acta de nacimiento, CURP)</b></li>
		<li><u><i>El impuesto de Ecotasa no está incluido (se pagan en el hotel al momento del check in).</i></u></li>
		
	</ul>
	<p>
		<b>OBSERVACIONES: </b><?= $model_bloqueo->observaciones; ?>
	</p>
</section>

<section id="descripciones">
	<?php echo $model_bloqueo->descripcion_hotel; ?>
	<br>
	<?php echo $model_bloqueo->descripcion_evento; ?>
</section>

<section id="condiciones_grupo">
	<h2 class="title">CONDICIONES DEL GRUPO</h2>
	<p>
		Favor de leer detalladamente las condiciones descritas, ya que se indican puntos importantes para la organización de su evento en el hotel.
	</p>

	<ol>
		<li>
			REGISTRO
			<p>
				<b>Check In</b> - 15:00 hrs.
				<br>
				<b>Check Out</b> - <?=$model_politica_pago->checkOut? date('H:i',strtotime($model_politica_pago->checkOut)):"12:00"?> hrs.
				<br>
				Si el grupo desea llegar antes o salir después del horario establecido, favor de considerar un cargo adicional que pudiera requerir el hotel.
			</p>
		</li>
		<li>
			HABITACIONES Y LISTA DE ACOMODO
			<p>
				<p>La asignación de habitaciones en el hotel está sujeta a disponibilidad, no garantiza áreas específicas o tipos de camas.</p>
				


				<p>La lista de acomodo de pasajeros debe ser ingresada en letras mayúsculas en nuestra página www.rutamayatravel.com máximo <?=$model_politica_pago->maximo_dias?> días antes de la llegada y debe indicar nombre-apellido del titular / acompañantes, así como de los menores especificando su edad, fechas de estancia, nombre del tour líder, si el grupo llega junto o de manera individual, hora de llegada y observaciones especiales en caso de requerirlo, con la finalidad de evitar inconvenientes al momento del check in.
				</p>
				<p>
				<?php if ($model_bloqueo->idTarifa->precio!="BODA"): ?>




					Por convenio se permitirán dos cambios en el rooming list, los cuales deberán ser solicitados por mail a grupos1@rutamayatravel.com con copia a grupos@rutamayatravel.com,  grupos2@rutamayatravel.com y bloqueos@rutamayatravel.com en forma escrita a más tardar  <?=($model_politica_pago->maximo_dias)-5?> días antes de la entrada de los pasajeros,  posterior ello queda sujeto a la aprobación del hotel y se penalizara según la cantidad que indique el hotel.


				<?php else: ?>
					Por convenio se permitirán dos cambios en el rooming list, los cuales deberán ser solicitados por mail a bodas@rutamayatravel.com con copia a bodas1@rutamayatravel.com, bodas2@rutamayatravel.com, en forma escrita a más tardar  <?=($model_politica_pago->maximo_dias)-5?> días antes de la entrada de los pasajeros,  posterior ello queda sujeto a la aprobación del hotel y se penalizara según la cantidad que indique el hotel.
				<?php endif ?>
				</p>
			
				<p>
					El Operador se deslinda de responsabilidades por cualquier tipo de cambio o discrepancia no reportada en tiempo y forma, por tal no se acepta ningún cambio durante el check in o estancia del grupo. 
				</p>


				<p>
					
					Las noches adicionales son bajo solicitud a los correos mencionados anteriormente y estan sujetas a disponibilidad y tarifas por parte del hotel.
				</p>

			</p>

		</li>
		<li>
			POLÍTICAS DE PAGO Y GARANTÍAS
			<p>Sobre el total de habitaciones reservadas se desglosa lo siguiente:</p>
			<table nobr="true">
				<tr class="header">
					<td>PAGOS</td>
					<td>FECHAS</td>
					<td>IMPORTE</td>
					<td>OBSERVACIONES</td>
				</tr>
				<?php foreach ($model_pagos_desglose as $key => $pago) : ?>
					<tr>
						<td style="white-space:nowrap;"><b><?= $pago->descripcion_pago; ?></b></td>
						<td><?= getParseDate($pago->fecha); ?></td>
						<?php $string_to_show = $model_tarifa->precio == "GRUPAL" ? "SALDO" : "$ ". number_format($pago->importe, 2, ".", ","); ?>
						<td align="right"><?= $key == (count($model_pagos_desglose) - 1) ? $string_to_show : "$ ". number_format($pago->importe, 2, ".", ","); ?></td>
						<td><?= $key == (count($model_pagos_desglose) - 1) ? "DE ACUERDO A LA LISTA FINAL" : $pago->observaciones; ?></td>
					</tr>
				<?php endforeach; ?>
			</table>

			<ul>
				<li>La garantía grupal solicitada deberá cubrirse en la fecha indicada en las políticas de pago.</li>
				<li>Los consumos extras no pactados del grupo deberán liquidarse a la salida del grupo.</li>
				<li>En caso de no cumplir con las fechas de pago anteriormente establecidas, el operador se reserva el derecho de rescindir este convenio y aplicar las políticas correspondientes de cancelación.</li>
				<li>La cuenta final del grupo será revisada de acuerdo al cierre final y se aplicarán los cargos por diferencia necesarios.</li>
			</ul>
			<br>
		</li>

		<li>
			FORMA DE PAGO
			<p>Todos los pagos deberán realizarse por medio de depósitos o transferencias referenciadas utilizando la ficha de pago que se genera desde el evento en nuestra plataforma. Para cada pago se deberá generar una nueva ficha la cual únicamente podrá ser usada para pagar el monto especificado. Cada ficha tiene vigencia de 8 días naturales. En caso de querer pagar un monto diferente al inicialmente especificado en la ficha, deberá ser necesario cancelar la ficha de pago y generar una nueva.</p>
			<?php if ($model_bloqueo->idTarifa->precio!="BODA"): ?>
				<p>El “Cliente“ deberá enviar una copia del depósito a: contablebodasgrupos@rutamayatravel.com, con copia al ejecutivo de Grupos a cargo del evento, grupos@rutamayatravel.com, grupos1@rutamayatravel.com, grupos2@rutamayatravel.com y bloqueos@rutamayatravel.com.</p>
				<?php else: ?>
				<p>El “Cliente“ deberá enviar una copia del depósito a: contablebodasgrupos@rutamayatravel.com, con copia al ejecutivo de Grupos a cargo del evento, bodas@rutamayatravel.com, bodas1@rutamayatravel.com, bodas2@rutamayatravel.com.</p>
			<?php endif ?>
		</li>

		<li>
			POLÍTICAS DE CANCELACIÓN Y/O REDUCCIÓN DE HABITACIONES

			<?php
				$diasAntesLlegada=130;
				if ($model_politica_pago->dias_antes) {
					$diasAntesLlegada=$model_politica_pago->dias_antes;
				 	
				} 
				$reduccionBloqueo=10;
				if ($model_politica_pago->reduccion) {
					$reduccionBloqueo=$model_politica_pago->reduccion;
				}
			 ?>
			<p>

				<?php if ($model_politica_pago->dias_antes!=999) { ?>
				<p>
					
					A partir de la firma del contrato y hasta <?=$diasAntesLlegada?> días antes de la llegada del grupo, el operador podrá aceptar una reducción del <?=$reduccionBloqueo?>% del bloqueo total de las habitaciones contratadas sin cargo, cualquier cantidad superior a este porcentaje tendrá que entrar a revisión previa y podría aplicar cargo y/o penalidad parcial o completas de estancias por habitación cancelada.
				</p>
				<p>
					Con menos días a lo anterior mencionado el cliente deberá pagar un 100 % de las habitaciones contratadas en el presente contrato.
				</p>
			<?php } ?>
				<p>
					
					Las reservas que causen NO SHOW tendrán cargo total de la estancia.<br>
				</p>
				<p>
					
					Para tener derecho a cualquier tipo de cancelaciones de habitaciones y servicios establecidos en este contrato, se deberá haber cubierto los pagos convenidos en tiempo y forma según lo estipulado, de lo contrario el cliente tendrá una penalidad por concepto de incumplimiento el cual causará la reducción del número de habitaciones al valor de lo garantizado.
				</p>
				<p>
					Las habitaciones quedaran asignadas para la comercialización por parte del cliente una vez que se tenga firmado el presente acuerdo que deberá ser respaldado con los Pagos y Garantías correspondientes, las tarifas no podrán ser modificadas en caso de existir alguna promoción posterior a la firma.
					
				</p>
				<?php if ($model_politica_pago->condiciones_cancelacion): ?>
					<p>
						<?=$model_politica_pago->condiciones_cancelacion?>
					</p>
				<?php endif ?>
			</p>
		</li>
		<li>
			IMPOSIBILIDAD DE EJECUCIÓN
			<p>
				Queda expresamente acordado que cada parte será liberada de sus obligaciones, en el caso en que los términos de ejecución de este contrato sean dilatados o impedidos por cualquier causa razonable fuera del control, incluyendo sin limitaciones fuerzas naturales, ordenes gubernamentales, fuego, inundación, explosión, venta o procesamiento legal, huelga, paro laboral o cualquier limitación de trabajo o condición que retrase o impida dicha ejecución.<br>
				Sera obligación de hotel según el caso, corregir la falla tan pronto cese cualquier limitación ocurrida.<br>
			</p>
		</li>
	</ol>
</section>

<section id="acuerdo_entendimiento">
	<h2 class="title">ACUERDO Y ENTENDIMIENTO TOTAL</h2>
	<p>
		Esta carta comprende el total acuerdo de nuestro convenio y cancela cualquier acuerdo verbal y / o escrito realizado con anterioridad.<br>
		Este contrato deberá ser firmado en cada una de sus hojas y devuelto antes del <b> <?= getDayOfWeek(date("Y-m-d", strtotime($model_contract->created ." + 3 days"))) ." ". getParseDate(date("Y-m-d", strtotime($model_contract->created ." + 3 days"))); ?></b> fecha a partir de la cual los precios podrán ser renegociados y los espacios quedarán sujetos a disponibilidad.<br>
		Favor de tomar nota que este acuerdo se considera válido y forzoso si todos los términos y condiciones en él marcados son cubiertos.<br>
	</p>

	<?php if($model_tarifa->precio == "GRUPAL"): ?>
		<h2 class="title">CONDICIONES ADICIONALES DE CONVENIO GRUPAL</h2>
		<p>
			Para cualquier acuerdo adicional a lo establecido en la condiciones de contrato inicial, es necesario estar al día con todos los pagos, dejando en claro que la petición se someterá a valoración y queda sujeto a las decisiones de las partes involucradas y no por ello se garantiza el cumplimiento de lo solicitado.<br>
			En caso de cancelarse el grupo en su totalidad por razones imputables del cliente cuales quiera que estas fueran, se aplicará un cargo administrativo de $5,000 MXN, esto es independientemente a lo especificado en el punto 3 (Política de pago y garantía) del apartado condiciones de grupo por concepto no reembolsable.
		</p>
	<?php endif; ?>
		
	<p style="margin: 0 auto;" class="title"><i>Ruta Maya Travel Agradece su preferencia</i></p>

	<table style="border: none;">
		<?php if( $model_user_created->id_usuario!=51) : ?>
			<tr>
				<td style="border: none; height: 90px;  border-bottom: 1px solid #000000;  width: 49%" >
					<?php if($model_contract->status == "S") : ?>
						<img src="<?= $_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/firmas/". $model_signature_rmt->signature; ?>" height="100">
					<?php endif; ?>	
				</td>
				<td style="border: none; height: 90px; width: 2%"></td>
				<td style="border: none; height: 90px; border-bottom: 1px solid #000000; width: 49%" >
					<?php if($model_contract->status == "S") : ?>
						<img src="<?= $_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/firmas/". $model_signature_signed->signature; ?>" height="100">
					<?php endif; ?>	
				</td>
			</tr>
			<tr>
				<td style="border: none; width: 49%">
					LT. <?= $model_user_created->nombre_usuario; ?>
					<br>

					<?=$model_bloqueo->idTarifa->precio=="BODA"? 'Ejecutivo de Bodas':'Ejecutivo de Grupos'?>	
					<br>
					Operadora Mayorista Ruta Maya Travel<br>
				</td>
				<td style="border: none; width: 2%"></td>
				<td style="border: none; width: 49%">
					Nombre: <?= strtoupper($contacto); ?><br>
					Agencia: <?= $model_agencia->nombre_agencia; ?><br>
					<?php if($model_contract->status == "S") : ?>
					Fecha: <?=date('d/m/Y', strtotime($model_contract->created))?>
					<?php endif ?>
					
				</td>
			</tr>
		<?php else: ?>
			<tr>
				<td style="border: none; height: 90px; width: 24%"></td>
				<td style="border: none; height: 90px; border-bottom: 1px solid #000000; width: 49%" >
					<?php if($model_contract->status == "S") : ?>
						<img src="<?= $_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/firmas/". $model_signature_signed->signature; ?>" height="100">
					<?php endif; ?>	
				</td>
				<td style="border: none; height: 90px; width: 24%" >
					
				</td>
			</tr>
			<tr>
				<td style="border: none; width: 24%"></td>
				<td style="border: none; width: 49%">
					Nombre: <?= strtoupper($contacto); ?><br>
					Agencia: <?= $model_agencia->nombre_agencia; ?><br>
					<?php if($model_contract->status == "S") : ?>
					Fecha: <?=date('d/m/Y', strtotime($model_contract->created))?>
					<?php endif ?>
					
				</td>
				<td style="border: none; width: 24%">
					
				</td>
			</tr>
		<?php endif ?>
		
		
		<tr>
			<br>
			<td style="border: none;  border-bottom: 1px solid #000000; width: 49%; padding-top: 20px; " height="100" align="left">
				<?php if($model_contract->status == "S") : ?>
					<?php $signature_daniel = Signatures::model()->find("id_user = 31"); ?>
					<img src="<?= $_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/firmas/". $signature_daniel->signature; ?>">
				<?php endif; ?>	
			</td>
			<td style="border: none; width: 2%;"></td>
			<td style="border: none;  border-bottom: 1px solid #000000; width: 49%; " align="left">
				<?php if($model_contract->status == "S") : ?>
					<?php 
						$consulta_firma = "id_user = 32";
						if ($model_bloqueo->idTarifa->precio=="BODA") {
							$consulta_firma = "id_user = 51";
						}
							$signature_lety = Signatures::model()->find($consulta_firma); 
					?>
					<br><br>
					<img src="<?= $_SERVER['DOCUMENT_ROOT'] ."/archivos/contratos/firmas/". $signature_lety->signature; ?>" height="100" >
				<?php endif; ?>
			</td>
		</tr>
		<tr>
			<td style="border: none; width: 49%;">
				C.C.P. Ing. Daniel Ruiz Serrano<br>
				Director General
			</td>
			<td style="border: none; width: 2%;"></td>
			<td style="border: none; width: 49%;">
				<?=$model_bloqueo->idTarifa->precio=="BODA"? 'CC. LC. Sugely Lizama':'CC. LT. Leticia Varguez'?>
				<br>
				<?=$model_bloqueo->idTarifa->precio=="BODA"? 'Ventas de Bodas':'Gerente de Reservaciones, grupos y bloqueos'?>
			</td>
		</tr>
	</table>
</section>
