<?php $assets = Yii::app()->baseUrl . "/template/ansonika/assets"; ?>
<?php $id = Yii::app()->user->id;
$userRol = Usuarios::model()->findByPk($id)->tipo_usuario; ?>
<link rel="stylesheet" href="<?= $assets . '/css/admin.css'; ?>">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.3/css/responsive.bootstrap4.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/fixedheader/3.1.5/css/fixedHeader.bootstrap4.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.5.6/css/buttons.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<style>
	.dt-body-right {
		text-align: right;
	}

	@media (max-width: 767px) {
		.margin_60 {
			padding-top: 70px;
		}
	}

	@media (min-width: 768px) {
		.margin_60 {
			padding-top: 120px;
			padding-bottom: 60px;
		}
	}

	#footer {
		width: 100% !important;
	}

	.custom-file-input:lang(en)~.custom-file-label::after {
		content: "Buscar...";
	}

	.img-fluid.styled {
		margin-top: 0;
	}

	.input-group input:focus {
		border: 1px solid #ced4da;
	}

	.input-group input {
		height: initial;
		border: 1px solid #ced4da;
	}
</style>
<?php
// if ($_SESSION['agenciaUsuario']) {
$existe_cupones = CuponesAgencias::model()->findAll('id_agencia=' . $_SESSION['agenciaUsuario']);
// if (empty($existe_cupones)) {
// 	$hidden='d-none';
// }else{
// 	$hidden='';
// }
// }

?>
<main style="margin-bottom: 355px;">
	<div id="info_agencia" class="margin_60 container">
		<div id="tabs" class="tabs">
			<nav>
				<ul>
					<li><a href="#section-1" class="icon-profile"><span>General</span></a></li>
					<li><a href="#section-2" class="icon-docs-1"><span>Fiscal</span></a></li>
					<li><a href="#section-3" class="icon-share"><span>Marketing</span></a></li>
					<li><a href="#section-4" class="icon-users"><span>Usuarios</span></a></li>
					<li><a href="#section-5" class="icon-tag <?= $hidden ?>"><span>Código de Promoción</span></a></li>
					<li><a href="#section-6" class="icon-doc"><span>Reporte ventas</span></a></li>
					<li><a href="#section-7" class="icon-doc"><span>Outlet Verano</span></a></li>
				</ul>
			</nav>
			<div class="content">
				<section id="section-1">
					<h4>Información general agencia</h4>
					<div class="form-group">
						<label>Nombre</label>
						<input class="form-control" type="text" v-model="info_agencia.nombre_agencia">
					</div>
					<div class="form-row">
						<div class="form-group col-md-6">
							<label>Contacto</label>
							<input type="text" class="form-control" v-model="info_agencia.contacto">
						</div>
						<div class="form-group col-md-6">
							<label>Puesto</label>
							<input type="text" class="form-control" v-model="info_agencia.puesto">
						</div>
					</div>
					<div class="form-row">
						<div class="form-group col-md-4">
							<label>Teléfono</label>
							<input type="text" class="form-control" v-model="info_agencia.tel_agencia">
						</div>
						<div class="form-group col-md-4">
							<label>Celular</label>
							<input type="text" class="form-control" v-model="info_agencia.celular">
						</div>
						<div class="form-group col-md-4">
							<label>Email</label>
							<input type="text" class="form-control" v-model="info_agencia.email_agencia">
						</div>
					</div>
					<div class="form-row">
						<div class="form-group col-md-8">
							<label>Página web</label>
							<input type="text" class="form-control" v-model="info_agencia.url_agencia">
						</div>
						<div class="form-group col-md-4">
							<label>Skype</label>
							<input type="text" class="form-control" v-model="info_agencia.skype_agencia">
						</div>
					</div>

					<hr>
					<br>

					<h4>Dirección</h4>
					<div class="form-row">
						<div class="form-group col-md-3">
							<label>Calle</label>
							<input type="text" class="form-control" v-model="info_agencia.calle_agencia">
						</div>
						<div class="form-group col-md-3">
							<label>No. Ext.</label>
							<input type="text" class="form-control" v-model="info_agencia.num_exterior_agencia">
						</div>
						<div class="form-group col-md-3">
							<label>No. Int.</label>
							<input type="text" class="form-control" v-model="info_agencia.num_interior_agencia">
						</div>
						<div class="form-group col-md-3">
							<label>Cruzamientos</label>
							<input type="text" class="form-control" v-model="info_agencia.cruzamientos_agencia">
						</div>
					</div>
					<div class="form-row">
						<div class="form-group col-md-3">
							<label>C.P.</label>
							<input type="text" class="form-control" v-model="info_agencia.cp_agencia">
						</div>
						<div class="form-group col-md-5">
							<label>Colonia</label>
							<input type="text" class="form-control" v-model="info_agencia.id_colonia_agencia">
						</div>
						<div class="form-group col-md-4">
							<label>Municipio</label>
							<input type="text" class="form-control" v-model="info_agencia.municipio_agencia">
						</div>
					</div>
					<div class="form-row">
						<div class="form-group col-md-4">
							<label>Ciudad</label>
							<input type="text" class="form-control" v-model="info_agencia.id_ciudad_agencia">
						</div>
						<div class="form-group col-md-4">
							<label>Estado</label>
							<v-multiselect v-model="stateLoad" :options="array_states" track-by="id_estadosmex" label="nombreestado" open-direction="bottom" :searchable="true" :loading="isLoadingState" :clear-on-select="true" :close-on-select="true" :max-height="150" :preserve-search="true" autocomplete="off" @select="setState">
								<span slot="noResult">No hay coincidencias. Pruebe modificar su búsqueda.</span>
							</v-multiselect>
							<input type="hidden" v-model="info_agencia.id_estado_agencia">
						</div>
						<div class="form-group col-md-4">
							<label>País</label>
							<v-multiselect v-model="countryLoad" :options="array_countries" track-by="id_pais" label="nombre_pais" open-direction="bottom" :searchable="true" :loading="isLoadingCountry" :clear-on-select="true" :close-on-select="true" :max-height="150" :preserve-search="true" autocomplete="off" @select="setCountry">
								<span slot="noResult">No hay coincidencias. Pruebe modificar su búsqueda.</span>
							</v-multiselect>
							<input type="hidden" v-model="info_agencia.id_pais_agencia">
						</div>
					</div>
					<hr>
					<button class="btn_full" id="btn_general" @click="updateInfoAgencia('general')">Guardar cambios</button>
				</section>
				<!-- End section 1 -->

				<section id="section-2">
					<h4>Información fiscal agencia</h4>
					<div class="form-row">
						<div class="form-group col-md-4">
							<label>R.F.C.</label>
							<input type="text" class="form-control" v-model="info_agencia.rfc">
						</div>
						<div class="form-group col-md-8">
							<label>Razón social</label>
							<input type="text" class="form-control" v-model="info_agencia.razon_social">
						</div>
					</div>
					<div class="form-row">
						<div class="form-group col-md-3">
							<label>Calle</label>
							<input type="text" class="form-control" v-model="info_agencia.calle_fiscal">
						</div>
						<div class="form-group col-md-3">
							<label>No. Ext.</label>
							<input type="text" class="form-control" v-model="info_agencia.num_exterior_fiscal">
						</div>
						<div class="form-group col-md-3">
							<label>No. Int.</label>
							<input type="text" class="form-control" v-model="info_agencia.num_interior_fiscal">
						</div>
						<div class="form-group col-md-3">
							<label>Cruzamientos</label>
							<input type="text" class="form-control" v-model="info_agencia.cruzamientos_fiscal">
						</div>
					</div>
					<div class="form-row">
						<div class="form-group col-md-3">
							<label>C.P.</label>
							<input type="text" class="form-control" v-model="info_agencia.cp_fiscal">
						</div>
						<div class="form-group col-md-5">
							<label>Colonia</label>
							<input type="text" class="form-control" v-model="info_agencia.id_ciudad_fiscal">
						</div>
						<div class="form-group col-md-4">
							<label>Municipio</label>
							<input type="text" class="form-control" v-model="info_agencia.municipio_fiscal">
						</div>
					</div>
					<div class="form-row">
						<div class="form-group col-md-4">
							<label>Ciudad</label>
							<input type="text" class="form-control" v-model="info_agencia.id_ciudad_fiscal">
						</div>
						<div class="form-group col-md-4">
							<label>Estado</label>
							<input type="text" class="form-control" v-model="info_agencia.id_estado_fiscal">
						</div>
						<div class="form-group col-md-4">
							<label>País</label>
							<input type="text" class="form-control" v-model="info_agencia.id_pais_fiscal">
						</div>
					</div>
					<hr>
					<button class="btn_full" id="btn_fiscal" @click="updateInfoAgencia('fiscal')">Guardar cambios</button>
				</section>
				<!-- End section 2 -->

				<section id="section-3">
					<div class="row">
						<div class="col-4">
							<h4>Logo agencia</h4>
							<hr>

							<input type="file" class="dropify" accept="image/*" :data-default-file="img_logo" data-allowed-file-extensions="png jpg" data-height="200" data-max-file-size="500K" @change="onloadImg('logo')" />

							<!-- <div style="height: 400px">
								<img :src="img_logo" alt="Image" class="img-fluid profile_pic styled">
								<div class="form-group">
									<div class="custom-file">
										<input type="file" class="custom-file-input" @change="onloadImg('logo')">
										<label class="custom-file-label"></label>
									</div>
								</div>
							</div> -->
							<button id="btn_logo" class="btn_full mt-1" id="btn_logo" @click="updateInfoAgencia('logo')">Cambiar logotipo</button>
						</div>
						<div class="col-4">
							<h4>Pie flyer</h4>
							<hr>

							<input type="file" class="dropify" accept="image/*" :data-default-file="img_pie" data-height="200" @change="onloadImg('pie')" />
							<!-- {{img_pie}} -->
							<!-- <div style="height: 400px">
								<img :src="img_pie" alt="Image" class="img-fluid profile_pic styled">
								<div class="form-group">
									<div class="custom-file">
										<input type="file" class="custom-file-input" @change="onloadImg('pie')">
										<label class="custom-file-label"></label>
									</div>
									<a @click="eliminarPieFlyer()" style="cursor: pointer; color:#E04F67;">Eliminar pie de flyer</a>
								</div>	
							</div> -->

							<button class="btn_full mt-1" id="btn_pie" @click="updateInfoAgencia('pie')">Cambiar pie de flyer</button>
						</div>
						<div class="col-4">
							<h4>Ubicación agencia</h4>
							<hr>
							<div style="height: 400px">
								<div id="map" style="width: 100%; height: 350px; margin-top: 20px; padding-top: 20px"></div>
							</div>

							<button class="btn_full" id="btn_ubicacion" @click="updateInfoAgencia('ubicacion')">Cambiar ubicación</button>


						</div>
					</div>


				</section>
				<!-- End section 3 -->

				<section id="section-4">
					<?php if ($_SESSION['tipo_usuario'] == "Admon") : ?>
						<button class="btn btn-success btn-md" @click="modalUser(null)">Agregar usuario</button>
					<?php endif; ?>
					<table class="table table-striped">
						<thead>
							<tr>
								<th>Nombre</th>
								<th>Email</th>
								<th>Cumpleaños</th>
								<th>Tipo</th>
								<!-- <th>Último acceso</th> -->
								<th>Estatus</th>
								<th>Opciones</th>
							</tr>
						</thead>
						<tbody>
							<tr v-for="(user,index) in array_users">
								<td v-text="user.nombre_usuario"></td>
								<td v-text="user.email_usuario"></td>
								<td v-text="parseDate(user.fecha_nacimiento, 'DD/MM/YYYY')"></td>
								<td v-text="tipo(user.tipo_usuario)"></td>
								<td>
									<span v-if="user.estatus == 'A'" class="badge badge-success">Activo</span>
									<span v-else class="badge badge-danger">Inactivo</span>
								</td>
								<td>
									<button class="btn btn-info btn-sm" data-toggle="tooltip" data-placement="top" title="Editar" @click="modalUser(index)">
										<span class="icon-edit"></span>
									</button>
									<button v-if="user.estatus == 'A'" class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="top" title="Dar baja" @click="changestatus(user.id_usuario, index)"><span class="icon-cancel-2"></span>
									</button>

									<button v-else class="btn btn-success btn-sm" data-toggle="tooltip" data-placement="top" title="Dar Alta" @click="changestatus(user.id_usuario, index)">
										<span class="icon-check-2"></span>
									</button>
								</td>
							</tr>
						</tbody>
					</table>
					<div class="form-group form-check">
						<input type="checkbox" class="form-check-input" v-if="info_agencia.show_sales == '1'" checked @change="saveShowSales(info_agencia.show_sales)">
						<input type="checkbox" class="form-check-input" v-else @change="saveShowSales(info_agencia.show_sales)">
						<label class="form-check-label">Permitir a los usuarios ver todas las ventas</label>
					</div>
				</section>
				<!-- End section 4 -->
				<section id="section-5" class="<?= $hidden ?>">
					<h4>Cupones</h4>
					<table class="table table-striped">
						<thead>
							<tr>
								<th>Código</th>
								<th>Fecha de Vencimiento</th>
								<th>Estatus</th>
								<th>Reservación aplicado</th>
								<th>Descripción</th>
							</tr>
						</thead>
						<tbody>
							<?php

							$fecha_actual = date('Y-m-d');

							?>
							<?php if (!empty($existe_cupones)) : ?>
								<?php foreach ($existe_cupones as $code => $codeCupon) : ?>
									<tr>
										<td><?= $codeCupon->codigo ?></td>
										<td style="text-align: center;"><?= date('d/m/Y H:i:s', strtotime($codeCupon->fecha_limite)) ?></td>
										<td>
											<?php if ($codeCupon->estatus == 0 && strtotime($fecha_actual) < strtotime($codeCupon->fecha_limite)) { ?>

												<span class="badge badge-success">Sin aplicar</span>

											<?php } else if ($codeCupon->estatus == 0 && strtotime($fecha_actual) > strtotime($codeCupon->fecha_limite)) { ?>

												<span class="badge badge-danger">Vencido</span>

											<?php } else { ?>

												<span class="badge badge-warning">Aplicado</span>

											<?php } ?>
										</td>
										<td style="text-align: right;">
											<?php if ($codeCupon->id_reservacion != NULL) : ?>
												<span><a href="<?= Yii::app()->createUrl('reservacion/view', array('id' => $codeCupon->id_reservacion)) ?>" target="_blank"><?= $codeCupon->id_reservacion ?></a></span>
											<?php endif ?>
										</td>
										<td>
											<?php if ($codeCupon->comision == NULL) : ?>
												<span>Aplica el total de la comisión (Tarifa Neta)</span>
											<?php else : ?>
												<span>La comisión por aplicar al momento de hacer una reserva es de <?= empty($codeCupon->comision) ? 20 : $codeCupon->comision ?>%</span>
											<?php endif ?>
										</td>
									</tr>
								<?php endforeach ?>
							<?php endif ?>
						</tbody>
					</table>
				</section>
				<section id="section-6">
					<h4>Información de ventas de agencia</h4>
					<?php $this->renderPartial('_graficasErpAgencia'); ?>
					<div class="row" style="padding-top: 3%;">
						<div class="col-12">
							<h3>Ventas</h3>
						</div>
						<div class="col-4" id="reportrange" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc; width: 100%;margin-bottom: 2%;">
							<i class="fa fa-calendar"></i>&nbsp;
							<span></span> <i class="fa fa-caret-down"></i>
						</div>
						<div class="col-12">
							<div class="dt_colVis_buttons"></div>
							<table id="dt_tablaAgencias" class="table table-striped table-bordered nowrap" cellspacing="0" width="100%">
								<thead>
									<tr>
										<th>Fecha Realizada</th>
										<th>Cupón</th>
										<th>Hotel</th>
										<th>Importe</th>
										<th>Ganancia</th>
										<th>Fecha Entrada</th>
										<th>Fecha Salida</th>
										<th>Cuartos/Noches</th>
									</tr>
								</thead>
							</table>
						</div>
						<div class="col-4">
							<table class="table table-bordered table-sm">
								<thead>
									<tr>
										<th>Ventas</th>
										<th>Ganancia</th>
									</tr>
								</thead>
								<tbody>
									<tr>
										<th class="text-right" v-html="totalAgencia"></th>
										<th class="text-right" v-html="comisionAgencia"></th>
									</tr>
								</tbody>
							</table>
						</div>
					</div>
				</section>
				<!-- End section 7 -->
				<section id="section-7">
					<div v-if="landing.id_agencia==0" class="row">
						<div class="col-md-12">
							<div class="alert alert-danger" role="alert">
								Tu agencia no esta registrada como participante del outlet, <a target="_blank" href="https://outletverano.com.mx/registro?key=<?= $_SESSION['agenciaUsuario'] ?>">registrarme</a>.
							</div>
						</div>
					</div>
					<div v-if="landing.id_agencia!=0">
						<h4>Información</h4>
						<div class="form-row">
							<div class="form-group col-md-12">
								<label for="url">Landing page</label>
								<div class="input-group mb-3">
									<div class="input-group-prepend">
										<span class="input-group-text" id="basic-addon3">https://www.outletverano.com.mx/</span>
									</div>
									<input class="form-control" type="text" v-model="landing.webslug">
									<div class="input-group-prepend">
										<a :href="'https://outletverano.com.mx/' + landing.webslug" target="_blank"><span class="input-group-text" id="basic-addon4">Ir a web</span></a>
									</div>
								</div>
							</div>

						</div>
						<div class="form-row">
							<div class="form-group col-md-3">
								<label>Correo</label>
								<input type="text" class="form-control" v-model="landing.correo">
							</div>
							<div class="form-group col-md-3">
								<label>Teléfono</label>
								<input type="text" class="form-control" v-model="landing.telefono">
							</div>
							<div class="form-group col-md-3">
								<label>Ciudad</label>
								<input type="text" class="form-control" v-model="landing.ciudad">
							</div>
							<div class="form-group col-md-3">
								<label>Estado</label>
								<v-multiselect v-model="stateLoadLanding" :options="array_states" track-by="nombreestado" label="nombreestado" open-direction="bottom" :searchable="true" :loading="isLoadingState" :clear-on-select="true" :close-on-select="true" :max-height="150" :preserve-search="true" autocomplete="off" @select="setStateLanding">
									<span slot="noResult">No hay coincidencias. Pruebe modificar su búsqueda.</span>
								</v-multiselect>
								<input type="hidden" v-model="landing.estado">
							</div>
						</div>
						<div class="form-row">
							<div class="form-group col-md-12">
								<label>Ubicación (google maps)</label>
								<input type="text" class="form-control" v-model="landing.direccion">
							</div>
						</div>
						<div class="form-row">
							<div class="form-group col-md-4">
								<label for="url-facebook">Facebook</label>
								<div class="input-group mb-3">
									<div class="input-group-prepend">
										<span class="input-group-text" id="basic-addon3">facebook.com/</span>
									</div>
									<input class="form-control" aria-describedby="basic-addon1" type="text" v-model="landing.facebook">
								</div>
							</div>
							<div class="form-group col-md-4">
								<label for="url-instagram">Instagram</label>
								<div class="input-group mb-3">
									<div class="input-group-prepend">
										<span class="input-group-text" id="basic-addon3">instagram.com/</span>
									</div>
									<input class="form-control" aria-describedby="basic-addon1" type="text" v-model="landing.instagram">
								</div>
							</div>
							<div class="form-group col-md-4">
								<label>Página web</label>
								<input type="text" class="form-control" v-model="landing.web">
							</div>
						</div>
						<hr>
						<button class="btn_full" id="btn_general" @click="updateLandingPage()">Guardar cambios</button>
					</div>
				</section>
			</div>
			<!-- End content -->
		</div>
		<!-- End tabs -->

		<!-- Sign In Popup -->
		<div id="sign-in-dialog" class="zoom-anim-dialog mfp-hide">
			<div class="small-dialog-header">
				<h3>Sign In</h3>
			</div>
			<form>
				<div class="sign-in-wrapper">
					<a href="#0" class="social_bt facebook">Login with Facebook</a>
					<a href="#0" class="social_bt google">Login with Google</a>
					<div class="divider"><span>Or</span></div>
					<div class="form-group">
						<label>Email</label>
						<input type="email" class="form-control" name="email" id="email">
						<i class="icon_mail_alt"></i>
					</div>
					<div class="form-group">
						<label>Password</label>
						<input type="password" class="form-control" name="password" id="password" value="">
						<i class="icon_lock_alt"></i>
					</div>
					<div class="clearfix add_bottom_15">
						<div class="checkboxes float-left">
							<input id="remember-me" type="checkbox" name="check">
							<label for="remember-me">Remember Me</label>
						</div>
						<div class="float-right"><a id="forgot" href="javascript:void(0);">Forgot Password?</a></div>
					</div>
					<div class="text-center"><input type="submit" value="Log In" class="btn_login"></div>
					<div class="text-center">
						Don’t have an account? <a href="javascript:void(0);">Sign up</a>
					</div>
					<div id="forgot_pw">
						<div class="form-group">
							<label>Please confirm login email below</label>
							<input type="email" class="form-control" name="email_forgot" id="email_forgot">
							<i class="icon_mail_alt"></i>
						</div>
						<p>You will receive an email containing a link allowing you to reset your password to a new preferred one.</p>
						<div class="text-center"><input type="submit" value="Reset Password" class="btn_1"></div>
					</div>
				</div>
			</form>
			<!--form -->
		</div>
		<!-- /Sign In Popup -->
	</div>
	<!-- end container -->
</main>
<?php
echo $this->renderPartial('modalusuario', array('modeluser' => $modeluser));
$currentab = $_GET['user'] ? 1 : 0;
?>



<script>

</script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<?php

Yii::app()->clientScript->registerScript('url', '
	
	var tabc="";
	if (document.location.hash != "") 
	{    
		var currentTab = document.location.hash; 
		if(currentTab=="#reporte"){
			var tabc = "4";
		}
	}
	var baseUrl = "' . Yii::app()->baseUrl . '";
	var rmt_url = "https://' . $_SERVER['SERVER_NAME'] . '";
	var tipo_usuario="' . $_SESSION["tipoUsuario"] . '";
	var rol="' . $userRol . '";
	var idUser=' . $id . ';
	var tabUser=' . $currentab . ';
	var id_agencia = ' . $_SESSION["agencia"]["id_agencia"] . ';', CClientScript::POS_HEAD);
Yii::app()->clientScript->registerScriptFile($assets . '/js/tabs.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScript('tabs', 'new CBPFWTabs(document.getElementById("tabs"));', CClientScript::POS_READY);
Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/bs-custom-file-input/dist/bs-custom-file-input.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/sweetalert2@8', CClientScript::POS_END);

Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.3/Chart.bundle.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.3/Chart.min.js', CClientScript::POS_END);

Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/echarts@4.1.0/dist/echarts.common.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/echarts@4.1.0/dist/echarts.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/echarts@4.1.0/dist/echarts.simple.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/echarts@4.1.0/dist/echarts-en.common.min.js', CClientScript::POS_END);

Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js', CClientScript::POS_END);

Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap4.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/responsive/2.2.3/js/responsive.bootstrap4.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/fixedheader/3.1.5/js/dataTables.fixedHeader.min.js', CClientScript::POS_END);


Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/buttons/1.5.6/js/dataTables.buttons.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/buttons/1.5.6/js/buttons.colVis.min.js', CClientScript::POS_END);


Yii::app()->clientScript->registerCssFile('https://unpkg.com/vue-multiselect@2.1.0/dist/vue-multiselect.min.css');
Yii::app()->clientScript->registerScriptFile('https://unpkg.com/vue-multiselect@2.1.0', CClientScript::POS_END);

Yii::app()->clientScript->registerCssFile("https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.css");
Yii::app()->clientScript->registerScriptFile("https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.js", CClientScript::POS_END);

Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/vue/mi_agencia_vue.js?v=' . time(), CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://maps.googleapis.com/maps/api/js?key=AIzaSyCF_fvJUWC4iQueGPKPyTNzJ_JLmY8nC4w', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/vue/Datatables_languaje.js', CClientScript::POS_END);



Yii::app()->clientScript->registerScript('url333', '
$("#webslugId").keyup(function(){              
        var ta      =   $("#nombre");
        letras      =   ta.val().replace(/ /g, "");
        ta.val(letras)
}); 
', CClientScript::POS_END);




?>