<style>
    .cursor {
        cursor: pointer;
    }
    .form-cotiz {
        background-color: #fff;
        padding: 15px 10px 15px 15px;
        border: 1px solid #ddd;
        border-radius: 3px;
        margin-bottom: 25px;
    }
    .tab-content{
        padding: 0px;
    }
</style>
<main>
    <div id="activities_vue" style="margin-top: 5rem;">

        <div class="container margin_60">
            <div class="row">
                <aside class="col-lg-3">
                    <div style="background-color: #fff; padding: 15px 10px 15px 15px; border: 1px solid #ddd; border-radius: 3px; margin-bottom: 25px;">
                        <a data-toggle="collapse" href="#collapse_cotizador" aria-expanded="false" aria-controls="collapse_cotizador" style="display: block; color: #888;"><i class="icon_set_1_icon-42" style="font-size: 20px; position: relative; top: 0; margin-right: 5px;"></i>Cotizador</a>
                        <div class="collapse" id="collapse_cotizador">
                            <form action="<?= Yii::app()->createUrl('site/activities'); ?>" method="GET">
                                <input type="hidden" name="hb_countriesActivities" v-model="model_code">
                                <input type="hidden" name="hb_destinoActivities" v-model="model_destinationcode">
                                <input type="hidden" name="fecha_entrada" v-model="array_estancia.fecha_entrada">
                                <input type="hidden" name="fecha_salida" v-model="array_estancia.fecha_salida">
                                <div class="filter_type">
                                    <h6>Seleccione un destino</h6>
                                    <!-- <input type="text" class="form-control"> -->
                                    <v-multiselect v-model="model_destino" :options="options_activities" track-by="destinationcode" label="destino" placeholder="Escriba 3 letras para comenzar" open-direction="bottom" :searchable="true" :loading="isLoading" :internal-search="false" :clear-on-select="false" :close-on-select="true" :options-limit="30" :max-height="600" @search-change="loadDestinations" :preserve-search="true" :show-labels="false" autocomplete="off" @select="setDestino">
                                        <span slot="noResult">No hay coincidencias. Pruebe modificar su búsqueda.</span>
                                    </v-multiselect>
                                </div>
                                <div class="filter_type">
                                    <h6>Estancia</h6>
                                    <input id="dp_estancia_activities_web" v-model="model_rango_estancia" type="text" class="form-control" @click="toggleInput" autocomplete="off" required />
                                </div>
                                <div class="filter_type">
                                    <h6>Pasajeros</h6>
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-group">
                                                <label>Adultos</label>
                                                <div>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend cursor" @click="editPax('adulto','del')">
                                                            <div class="input-group-text">-</div>
                                                        </div>
                                                        <input type="text" class="form-control" v-model="cotiz_params.num_adultos" name="num_adultos">
                                                        <div class="input-group-prepend cursor" @click="editPax('adulto','add')">
                                                            <div class="input-group-text">+</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group">
                                                <label>Menores</label>
                                                <div>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend cursor" @click="editPax('menor','del')">
                                                            <div class="input-group-text">-</div>
                                                        </div>
                                                        <input type="text" class="form-control" v-model="cotiz_params.num_ninios" name="num_ninios">
                                                        <div class="input-group-prepend cursor" @click="editPax('menor','add')">
                                                            <div class="input-group-text">+</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <h6 v-if="cotiz_params.num_ninios > 0">Edad de los menores</h6>
                                    <div class="row" v-if="cotiz_params.num_ninios > 0">
                                        <div class="col-4" v-for="menor in cotiz_params.edad_menores">
                                            <div class="form-group">
                                                <label v-text="'Menor ' + menor.no_menor"></label>
                                                <select class="form-control" v-model="menor.edad" :name="'num_edad[edad_' + menor.no_menor + ']'">
                                                    <option :value="op" v-for="op in options_edad_menores" v-text="op"></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <button class="btn_full" style="margin-top: 15px;">Buscar</button>
                            </form>
                        </div>
                        <!--End collapse -->
                    </div>

                    <div id="filters_col">
                        <a data-toggle="collapse" href="#collapseFilters" aria-expanded="false" aria-controls="collapseFilters" id="filters_col_bt"><i class="icon_set_1_icon-65"></i>Filtros</a>
                        <div class="collapse show" id="collapseFilters">
                            <div class="filter_type">
                                <h6>Tour</h6>
                                <input type="text" class="form-control" v-model="search">
                            </div>
                        </div>
                        <!--End collapse -->
                    </div>

                    <!--End filters col-->
                   <?php $this->renderPartial("/site/helper"); ?>
                </aside>
                <!--End aside -->
                <div id="activities_result" class="col-lg-9" >
                    <div v-show="loading" class="the-icons m-3" style="font-size: 2em;">
                        <i class="icon-spin6 animate-spin"></i>
                        <span class="i-name">Cargando resultados...</span>
                    </div>
                    <div v-show="show" class="strip_all_tour_list wow fadeIn" data-wow-delay="0.1s" v-for="(activity, index) in filteredActivities">
                        <div class="row">
                            <div class="col-lg-4 col-md-4">
                                <div class="img_list">
                                    <a href="single_tour.html">
                                        <img :src="activity.activity.content.media.images[0].urls[3].resource" alt="Image">
                                        <div class="short_info"><i class="icon_set_1_icon-39"></i>{{ activity.activity.country.destinations[0].name + ', ' + activity.activity.country.name }} </div>
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="tour_list_desc">
                                    <h3><strong><a :href="baseUrl+'/activities/details?codeActivity='+activity.activity.code+'&dates='+array_estancia.fecha_entrada+'_'+array_estancia.fecha_salida">{{ activity.activity.name }}</a></strong></h3>
                                    
                                    <ul class="nav nav-tabs pt-3" :id="'navs'+activity.activity.code" role="tablist">
                                        <li  class="nav-item cursor" >
                                            <a id="Descripcion" class="nav-link" data-toggle="tab" :data-target="'#collapseDescripcion' + activity.activity.code" :aria-controls="'#collapseDescripcion' + activity.activity.code" role="tab" > <i class="icon_set_1_icon-93" aria-expanded="true"></i> Descripción</a>
                                        </li>
                                        <li  class="nav-item cursor" >
                                            <a id="Fotos" class="nav-link" data-toggle="tab" :data-target="'#collapseFotos' + activity.activity.code" role="tab" :aria-controls="'#collapseFotos' + activity.activity.code" aria-expanded="true" ><i class="icon_set_1_icon-32"></i> Fotos</a>
                                        </li>
                                        <li  class="nav-item cursor" >
                                            <a id="Info" class="nav-link" data-toggle="tab" :data-target="'#collapseInfo' + activity.activity.code"  role="tab" :aria-controls="'#collapseInfo' + activity.activity.code" aria-expanded="true" ><i class="icon_set_1_icon-54"></i> Info. Adicional</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-2">
                                <div class="price_list">
                                    <div>
                                        <small>Desde</small>
                                        <sup>$</sup><span style="font-size:1.6rem;">{{ printMenorTarifa(activity.activity.modalities, index) }}</span>
                                        <small class="pt-2" v-text="activity.activity.currency"></small>
                                        <p class="pt-3">
                                            <button class="btn_1 vermas" data-toggle="collapse" :data-target="'#collapseTarifas' + activity.activity.code" aria-expanded="true" :data-iditem="activity.activity.code" :aria-controls="'#collapseTarifas' + activity.activity.code" onclick="hidecontent(this)">Ver más</button>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                          <div class="tab-content" :id="'nav-tabContent' + activity.activity.code">
                            <div :id="'collapseDescripcion' + activity.activity.code" class="tab-pane fade" role="tabpanel" aria-labelledby="collapseDescripcion-tab">
                                <div class="card-body">
                                    <div v-html="activity.activity.content.description"></div>
                                </div>
                            </div>
                            <div :id="'collapseFotos' + activity.activity.code" class="tab-pane fade" role="tabpanel" aria-labelledby="collapseFotos-tab">
                                <div class="card-body">
                                    <div v-if="activity.fotos!=null" class="row magnific-gallery add_bottom_60 ">
                                        <div  class="col-md-3 col-sm-6" v-for="image in activity.fotos.activitiesContent[0].media.images">
                                            <div class="img_wrapper_gallery">
                                                <div class="img_container_gallery">
                                                    <a :href="image.urls[3].resource" title="Photo title"data-toggle="lightbox" data-gallery="example-gallery" data-max-height="500">
                                                        <img :src="image.urls[3].resource" alt="Image" class="img-fluid">
                                                     
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div v-else></div>
                                </div>
                            </div>
                            <div :id="'collapseInfo' + activity.activity.code" class="tab-pane fade" role="tabpanel" aria-labelledby="collapseInfo-tab">
                                <div class="card-body">
                                    <ul>
                                        <li v-for="info in activity.activity.content.segmentationGroups">{{ info.name }}
                                            <ul>
                                                <li v-for="item in info.segments" v-text="item.name"></li>
                                            </ul>
                                        </li>
                                        <li v-if="typeof activity.activity.content.featureGroups != 'undefined'">No incluye
                                            <ul v-if="activity.activity.content.featureGroups.length > 0">
                                                <li v-for="info in activity.activity.content.featureGroups">
                                                    <span v-for="item in info.excluded" v-text="item.description"></span>
                                                </li>
                                            </ul>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div :id="'collapseTarifas' + activity.activity.code" class="collapse">
                            <div class="card-body">
                                <table class="table table-sm">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th scope="col">Modalidad</th>
                                            <th scope="col">Precio / persona</th>
                                            <th scope="col">Fecha</th>
                                            <th scope="col">Días</th>
                                            <th scope="col">Precio</th>
                                            <th scope="col"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(modalidad, index_modality) in activity.activity.modalities">
                                            <td v-text="modalidad.name"></td>
                                            <td>
                                                <table class="table table-sm table-borderless">
                                                    <tr v-for="pax_cost in modalidad.rates[0].rateDetails[0].paxAmounts">
                                                        <td v-if="pax_cost.paxType == 'ADULT'" v-text="'Adulto (Mayor a ' + pax_cost.ageFrom + ' años)'"></td>
                                                        <td v-else v-text="'Menor (De ' + pax_cost.ageFrom + ' a ' + pax_cost.ageTo  + ' años)'"></td>
                                                        <td v-text="'$' + round((pax_cost.amount / activity.markup),2) + ' ' + activity.activity.currency"></td>
                                                    </tr>
                                                </table>
                                            </td>
                                            <td>
                                                <select :id="'sel_' + activity.activity.code" class="form-control" @change="onChange($event)" >
                                                    <option v-for="date in modalidad.rates[0].rateDetails[0].operationDates" :value="date.from"  v-text="parseDate(date.from)" ></option>
                                                </select>
                                            </td>
                                            <td v-text="modalidad.duration.value + ' ' + modalidad.duration.metric"></td>
                                            <td v-text="'$' + round((modalidad.rates[0].rateDetails[0].totalAmount.amount / activity.markup),2) + ' ' + activity.activity.currency"></td>
                                            <td>
                                                <!-- <input type="text" :value="modalidad.rates[0].rateDetails[0].rateKey" name="ratekey">
                                                      <textarea name="" id="" cols="30" rows="10" v-text="JSON.stringify(activity)"></textarea>
                                                  -->

                                                <form action="<?=Yii::app()->createURl('activities/create')?>" method="post" :id="'form_'+modalidad.rates[0].rateDetails[0].rateKey">
                                                    <input type="hidden" :value="modalidad.name" name="modalidad"> 
                                                    <input type="hidden" :value="convertToJsonApi(modalidad.duration)" name="duration"> 
                                                    <input type="hidden" :value="JSON.stringify(modalidad.questions)" name="questions">
                                                    <input type="hidden" :value="convertToJsonApi(modalidad.amountsFrom)" name="amountsFrom"> 
                                                    <input type="hidden" :value="modalidad.rates[0].rateDetails[0].totalAmount.amount / activity.markup" name="total">
                                                     <input type="hidden" :value="modalidad.rates[0].rateDetails[0].rateKey" name="ratekey">
                                                    <input type="hidden" :value="activity.activity.currency" name="currency">
                                                    <input type="hidden" :value="activity.activity.name" name="name">
                                                     <input type="hidden" :value="convertToJsonApi(modalidad.rates[0].rateDetails[0].operationDates)" name="operationDates">
                                                    <input type="hidden" :value="selectDate" name="selectDate">
                                                    <input type="hidden" :value="convertToJsonApi(array_params)" name="general">
                                                    <input type="hidden" :value="activity.activity.content.media.images[0].urls[3].resource" name="foto">
                                                    <input name="comments" :value="JSON.stringify(modalidad.comments)" type="hidden">
                                                    <input type="hidden" name="startProcess" value="<?=date('H:i:s')?>">
                                                </form>

                                                <div>
                                                    <button type="button" class="btn btn-info btn-sm" @click="enviar(modalidad.rates[0].rateDetails[0].rateKey)">Reservar</button>
                                                </div>
                                                <div class="mt-1">
                                                    <button type="button" class="btn btn-info btn-sm" @click="addItemCarrito(activity.activity, activity.markup, activity.activity.code, index_modality)">Carrito</button>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!--End strip -->
                    <div v-show="loading_more" class="the-icons" style="font-size: 2em;">
                        <i class="icon-spin6 animate-spin"></i>
                        <span class="i-name">Cargando más opciones para tu viaje...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php 
    $assets = Yii::app()->baseUrl."/template/ansonika/assets";
    Yii::app()->clientScript->registerScript('vue', "
        var rmt_url = 'https://". $_SERVER['SERVER_NAME'] . Yii::app()->baseUrl ."';
        var array_params = '". json_encode($_GET) ."';
    ", CClientScript::POS_HEAD);

    Yii::app()->clientScript->registerScript('dateDropper', "
        $('#bookingdate').dateDropper();
    ", CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile('https://unpkg.com/vue-multiselect@2.1.0', CClientScript::POS_END);
    Yii::app()->clientScript->registerCssFile('https://unpkg.com/vue-multiselect@2.1.0/dist/vue-multiselect.min.css');
    Yii::app()->clientScript->registerCssFile('https://cdn.jsdelivr.net/npm/hotel-datepicker@3.6.4/dist/css/hotel-datepicker.min.css');
    Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/hotel-datepicker@3.6.4/dist/js/hotel-datepicker.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/fecha@3.0.2/lib/fecha.umd.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/vue/converter.js?v='. time(), CClientScript::POS_HEAD);
    Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/sweetalert2@8', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/vue/activities_vue.js?v='. time(), CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile("https://cdnjs.cloudflare.com/ajax/libs/ekko-lightbox/5.3.0/ekko-lightbox.js
    ",CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/funcionescotizacion.js?v='. time(),CClientScript::POS_END);
    Yii::app()->clientScript->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/ekko-lightbox/5.3.0/ekko-lightbox.css');
?>