<main class="mt-5">
	<div id="guests_vue" class="container margin_60">
		<div class="row">
			<aside class="col-lg-3 add_bottom_30">
                <a class="btn btn-outline-info btn-sm mb-3" href="">Regresar</a>
				<?php $this->renderPartial("//site/helper"); ?>
			</aside>
			<div class="col-lg-9">
				<span v-if="loading == true">Cargando datos...</span>
				<div v-else class="box_style_1">
                    <?php $this->renderPartial("_info_boda") ?>
				</div>
			</div>
		</div>
        <div class="card">
            <div class="card-body">
				<div class="row">
					<h1 class="col-6 mt-0">Invitados</h1>
					<div class="col text-right">
						<!-- <button type="button" class="btn btn-sm btn-outline-dark" data-toggle="modal" data-target="#modal_uc_guests">Agregar</button> -->
						<input style="display: none;" type="file" id="myFileInput" accept=".csv" @change="loadedCSVGuests()" />
						<button type="button" class="btn btn-sm btn-outline-dark" onclick="document.getElementById('myFileInput').click()">Importar .CSV</button>
						<button type="button" class="btn btn-sm btn-outline-dark" @click="sendWeddingInvitations()">Enviar invitaciones</button>
					</div>
				</div>
				<div class="form-row" @keyup.enter="acceptGuestWeeding()">
					<div class="form-group col">
						<label>Nombre(s)</label>
						<input type="text" :class="[error_model.nombre ? 'is-invalid' : '', 'form-control']" v-model="model_guest.nombre">
						<div class="invalid-feedback">El campo es obligatorio.</div>
					</div>
					<div class="form-group col">
						<label>Apellidos</label>
						<input type="text" class="form-control" v-model="model_guest.apellidos">
						<div class="invalid-feedback">El campo es obligatorio.</div>
					</div>
					<div class="form-group col">
						<label>Teléfono</label>
						<input id="txt_guest_tel" type="text" class="form-control" v-model="model_guest.telefono">
					</div>
					<div class="form-group col">
						<label>Correo electrónico</label>
						<input type="text" class="form-control" v-model="model_guest.email">
						<div class="invalid-feedback">El campo es obligatorio.</div>
					</div>
					<div class="col" style="margin-top: 2.3em">
						<button class="btn btn-danger btn-block" @click="clearModelGuest()">Cancelar</button>
					</div>
				</div>
                <table id="tbl-guests" class="table table-striped">
                    <thead>
                        <tr>
                            <th>Nombre</th>
                            <th>Apellidos</th>
                            <th>Teléfono</th>
                            <th>Correo electrónico</th>
                            <th>Invitación</th>
                            <th>Estatus</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
	</div>
</main>

<div class="modal fade" id="modal_uc_guests" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  	<div class="modal-dialog" role="document">
    	<div class="modal-content">
      		<div class="modal-header">
        		<h5 class="modal-title" id="exampleModalLabel" v-if="model_guest.id_guests_weddings > 0">Actualizar invitado</h5>
        		<h5 class="modal-title" id="exampleModalLabel" v-else>Nuevo invitado</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
          			<span aria-hidden="true">&times;</span>
        		</button>
      		</div>
			<div class="modal-body">
				<div class="row">
					<div class="form-group col">
						<label class="col-form-label">Nombre:</label>
						<input type="text" :class="[error_model.nombre == true ? 'is-invalid' : '', 'form-control']" v-model="model_guest.nombre">
						<div v-show="error_model.nombre" class="valid-feedback">El campo es obligatorio.</div>
					</div>
					<div class="form-group col">
						<label class="col-form-label">Apellidos:</label>
						<input type="text" :class="[error_model.apellidos == true ? 'is-invalid' : '', 'form-control']" v-model="model_guest.apellidos">
						<div v-show="error_model.apellidos" class="valid-feedback">El campo es obligatorio.</div>
					</div>
				</div>
				<div class="form-group">
					<label class="col-form-label">Teléfono:</label>
					<input type="text" class="form-control" v-model="model_guest.telefono">
				</div>
				<div class="form-group">
					<label class="col-form-label">Correo eléctronico:</label>
					<input type="text" :class="[error_model.email == true ? 'is-invalid' : '', 'form-control']" v-model="model_guest.email">
					<div v-show="error_model.email" class="valid-feedback">El campo es obligatorio.</div>
				</div>
      		</div>
      		<div class="modal-footer">
        		<button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        		<button type="button" class="btn btn-primary" v-if="model_guest.id_guests_weddings > 0" @click="updateGuestWedding()">Aplicar cambios</button>
        		<button type="button" class="btn btn-primary" v-else @click="addGuestWedding()">Guardar invitado</button>
      		</div>
		</div>
  	</div>
</div>

<?php
	$assets = Yii::app()->baseUrl."/template/ansonika/assets";
	Yii::app()->clientScript->registerCssFile($assets ."/css/blog.css");
	Yii::app()->clientScript->registerCssFile("https://use.fontawesome.com/releases/v5.8.2/css/all.css");

	Yii::app()->clientScript->registerScript('id', '
		var id_boda = '. $_GET["boda"] .';
		var rmt_url = "https://'. $_SERVER["SERVER_NAME"] . Yii::app()->baseUrl .'";'
    , CClientScript::POS_HEAD); 
    
    Yii::app()->clientScript->registerCssFile("https://cdn.datatables.net/1.10.18/css/dataTables.bootstrap4.min.css");
	Yii::app()->clientScript->registerScriptFile("https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js", CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile("https://cdn.datatables.net/1.10.18/js/dataTables.bootstrap4.min.js", CClientScript::POS_END);

    Yii::app()->clientScript->registerCssFile("https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/skins/all.css");
	Yii::app()->clientScript->registerScriptFile("https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js", CClientScript::POS_END);

    Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/jquery-csv/1.0.5/jquery.csv.js', CClientScript::POS_END);

	Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/sweetalert2@8', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/vue/casateconmigo/invitados.js?v='. time(), CClientScript::POS_END);
?>