<main class="mt-5">
	<div id="detalle_vue" class="container margin_60">
		<h2 v-if="loading_info_boda">Cargando información...</h2>
		<div v-else class="row">
			<aside class="col-lg-3 add_bottom_30">
				<a class="btn btn-outline-info btn-sm mb-3" :href="rmt_url + '/casateconmigo/bodas'">Regresar</a>
				<?php $this->renderPartial("_filtro_roominglist"); ?>
				<hr>
				<?php $this->renderPartial("//site/helper"); ?>
			</aside>
			<div class="col-lg-9">
				<div class="box_style_1" :key="key_roominglist">
					<?php $this->renderPartial("_info_boda") ?>

                    <!-- start roominglist -->
					<div class="post" v-for="(room, index_room) in filteredGuests">
						<div class="row">
							<div class="col-10">
								<h2 v-text="'Habitación ' + room.no_hab"></h2>
							</div>
							<div class="col">
								<div class="btn-group">
									<button type="button" class="btn btn-outline-info dropdown-toggle btn-sm mt-3" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Agregar</button>
								  	<div class="dropdown-menu">
								  		<a class="dropdown-item" @click="addPax(room, room.id_roominglist, 'adulto')">Adulto</a>
								  		<a class="dropdown-item" @click="addPax(room, room.id_roominglist, 'menor')">Menor</a>
								  	</div>
								</div>
							</div>
						</div>
						<table class="table table-striped table-sm">
							<thead>
								<tr>
									<th>Nombre</th>
									<th>Apellido</th>
									<th>Tipo</th>
									<th>Acciones</th>
								</tr>
							</thead>
							<tbody>
								<tr v-for="(adulto, index_pax) in room.adultos">
									<td>
										<input type="text" class="form-control-plaintext" placeholder="Agregar nombre" v-model="adulto.nombre" @focus="checkEditedRoom(room.id_roominglist)">
									</td>
									<td>
										<input type="text" class="form-control-plaintext" placeholder="Agregar apellido" v-model="adulto.apellido" @focus="checkEditedRoom(room.id_roominglist)">
									</td>
									<td>Adulto</td>
									<td>
										<button class="btn btn-outline-danger btn-sm" type="button" @click="deletePax(room.id_roominglist, index_pax, 'adultos')"><span class="fa fa-trash-alt"></span></button>
									</td>
								</tr>
								<tr v-for="(menor, index_pax) in room.menores">
									<td>
										<input type="text" class="form-control-plaintext" placeholder="Agregar nombre" v-model="menor.nombre" @focus="checkEditedRoom(room.id_roominglist)">
									</td>
									<td>
										<input type="text" class="form-control-plaintext" placeholder="Agregar apellido" v-model="menor.apellido" @focus="checkEditedRoom(room.id_roominglist)">
									</td>
									<td>
										Menor de 
										<select v-if="room.edited == true || room_edited == 999999" class="form-control-sm" v-model="menor.edad" @change="checkEditedRoomSelect(room.id_roominglist)">
											<option v-for="edad in options_edad" :value="edad" v-text="edad"></option>
										</select> 
										<select v-else class="form-control-sm" v-model="menor.edad" disabled>
											<option v-for="edad in options_edad" :value="edad" v-text="edad"></option>
										</select> 
										años
									</td>
									<td>
										<button class="btn btn-outline-danger btn-sm" type="button" @click="deletePax(room.id_roominglist, index_pax, 'menores')"><span class="fa fa-trash-alt"></span></button>
									</td>
								</tr>
							</tbody>
						</table>
						<button v-if="room.edited == true" class="btn btn-success btn-sm" @click="confirmChanges(room.id_roominglist)">Aplicar cambios</button>
						<hr>
					</div>
					<!-- end roominglist -->
				</div>
			</div>
		</div>
	</div>
</main>

<?php
	$assets = Yii::app()->baseUrl."/template/ansonika/assets";
	Yii::app()->clientScript->registerCssFile($assets ."/css/blog.css");
	Yii::app()->clientScript->registerCssFile("https://use.fontawesome.com/releases/v5.8.2/css/all.css");

	Yii::app()->clientScript->registerScript('id', '
		id_boda = '. $_GET["boda"] .';
		rmt_url = "https://'. $_SERVER["SERVER_NAME"] . Yii::app()->baseUrl .'";'
	, CClientScript::POS_HEAD); 

	Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/sweetalert2@8', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/vue/casateconmigo/detalleboda.js?v='. time(), CClientScript::POS_END);
?>