<?php

class BodasController extends Controller {
	//public $layout = '//layouts/bootstrap_layout';
	public $layout = '//layouts/ansonika_site';

	public function accessRules() {
		return array(
			array('allow',
				'actions'=>array('landing_page'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index', 'detalle', 'pagos', 'contabilidad', 'documentos', 'website', 'landingPage', 'saveInvitation', 'updateInvitation', 'saveRoominglist'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionIndex() {
		$this->render("index");
	}

	public function actionDetalle($boda) {
		$this->render("detalle");
	}

	public function actionPagos($boda) {
		$model=Bloqueos::model()->findByPk($boda);
		$this->render("pagos",array('model'=>$model));
	}

	private function noches($fecha_inicio,$fecha_final)
	{
		$datetime1 = new DateTime($fecha_inicio);
		$datetime2 = new DateTime($fecha_final);
		$interval = $datetime1->diff($datetime2);
		$noches= $interval->format('%a');
		return $noches;
	}

	public function comisionAgencia($paquete,$servicios,$comisionAgencia)
	{
		

		$comisionPaquete=0;
		$comisionServicios=$servicios;
		if ($paquete->comisionable==1) {
			$comisionPaquete= $paquete->precio*($paquete->comision_agencia/100);
		}
		// echo $comisionAgencia."+".$comisionServicios."+".$comisionPaquete;
		return $comisionAgencia+$comisionServicios+$comisionPaquete;
	}	
	public function actionContabilidad($boda) {
		$model=Bloqueos::model()->findByPk($boda);
		$notacredito = new NotaCredito;
		$notacredito->id_ref = $id;
		$notacredito->tipo_ref = "BLOQUEO";
		$notacredito->id_agencia = $model->id_agencia;
		if($_SESSION["tipoUsuario"] == "Agencia")
			$condAgencia = "and id_agencia=".$_SESSION["agenciaUsuario"];
		$notas = NotaCredito::model()->findAll('id_ref='.$boda.' and tipo_ref="BLOQUEO" '.$condAgencia.' and estatus="A"');
		$credito = 0;
		foreach($notas as $row){
			$credito += $row->importe;
		}

		$dataPoliticas=GruposPoliticasPagos::model()->find('id_bloqueo='.$boda);
		if(!empty($dataPoliticas->id_politicas_pagos)) $dataPoliticasDesglose=GruposPoliticasPagosDesglose::model()->findAll('id_politicas_pagos='.$dataPoliticas->id_politicas_pagos);

		$this->render("contabilidad",array('notacredito'=>$notacredito,'notas'=>$notas,'credito'=>$credito,'dataPoliticasDesglose'=>$dataPoliticasDesglose));
	}

	public function actionDocumentos($boda) {
		$model=Bloqueos::model()->findByPk($boda);
		$this->render("documentos",array('model'=>$model));
	}

	public function actionWebsite($boda) {
		$this->render("website");
	}

	public function actionInvitaciones($boda) {
		$this->render("invitaciones");
	}

	public function actionInvitados($boda) {
		$this->render("invitados");
	}

	public function actionSaveRoominglist() {
		$array_roominglist = json_decode($_POST["roominglist"], true);
		$id_roominglist = $array_roominglist["id_roominglist"];

		$nombres_adultos = null;
		foreach ($array_roominglist["adultos"] as $key => $value) {
			$nombres_adultos .= $value["apellido"] ." ". $value["nombre"] ." / ";

			if($array_roominglist["has_desglose"]) {
				$model_roominglist_desglose = RoominglistDesglose::model()->findByPk($value["id_pax"]);
				$model_roominglist_desglose->nombre = $value["nombre"];
				$model_roominglist_desglose->apellido = $value["apellido"];
				$model_roominglist_desglose->save();
			}
		}
		if($nombres_adultos != null) $nombres_adultos = substr($nombres_adultos, 0, -3);

		$nombres_menores = null; $edad_menores = null;
		foreach ($array_roominglist["menor"] as $key => $value) {
			$nombres_menores .= $value["apellido"] ." ". $value["nombre"] ." / ";
			$edad_menores .= $value["edad"] .",";

			if($array_roominglist["has_desglose"]) {
				$model_roominglist_desglose = RoominglistDesglose::model()->findByPk($value["id_pax"]);
				$model_roominglist_desglose->nombre = $value["nombre"];
				$model_roominglist_desglose->apellido = $value["apellido"];
				$model_roominglist_desglose->edad = $value["edad"];
				$model_roominglist_desglose->save();
			}
		}
		if($nombres_menores != null) $nombres_menores = substr($nombres_menores, 0, -3);
		if($edad_menores != null) $edad_menores = substr($edad_menores, 0, -3);

		$model_roominglist = Roominglist::model()->findByPk($id_roominglist);
		$model_roominglist->nombre = $nombres_adultos;
		$model_roominglist->menor = $nombres_menores;
		$model_roominglist->edad = $edad_menores;
		if($model_roominglist->save()) {
			echo json_encode(array(
				success => true
			));
		} else {
			echo json_encode(array(
				success => false,
				error => $model_roominglist->getErrors()
			));
		}
	}

	public function actionSaveInvitation() {
		$model_events_weddings = new EventsWeddings;
		$model_events_weddings->invitacion_text = $_POST["invitacion_text"];
		$model_events_weddings->invitacion_img = $_POST["invitacion_img"];
		$model_events_weddings->id_bloqueo = $_POST["id_bloqueo"];
		$response = array(
			"model" => CJSON::encode($model_events_weddings),
			"upload" => false,
			"copy" => false,
			"success" => false
		);
		if($model_events_weddings->save()) {
			if(is_uploaded_file($_FILES['img']['tmp_name'])) {
				$file_name = $_POST['id_bloqueo'] .'-'. str_replace(" ", "-", $_FILES['img']['name']);
				$url_img = $_SERVER['DOCUMENT_ROOT'] .'/medios/bodas/';
				$file_url = $url_img . $file_name;
				$response = array();
				if(move_uploaded_file($_FILES['img']['tmp_name'], $file_url)) {
					$response["upload"] = true;
					// /public_html/sur4demo/protected/extensions/bootstrap/gii/bootstrap/tcpdf/examples/images
					$path_tcpdf = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->baseUrl ."/protected/extensions/bootstrap/gii/bootstrap/tcpdf/examples/images/". str_replace(' ', '-', $file_name);
					if(copy($file_url, $path_tcpdf)) {
						$response["copy"] = true;
						$response["success"] = true;
					}
				}
			}
		}
		echo CJSON::encode($response);
	}

	public function actionUpdateInvitation() {
		$model_events_weddings = EventsWeddings::model()->find("id_bloqueo = ". $_POST["id_bloqueo"]);
		$model_events_weddings->invitacion_text = $_POST["invitacion_text"];
		$model_events_weddings->invitacion_img = $_POST["invitacion_img"];
		$response = array(
			"model" => CJSON::encode($model_events_weddings),
			"upload" => false,
			"copy" => false,
			"success" => false
		);
		if($model_events_weddings->save()) {
			if(is_uploaded_file($_FILES['img']['tmp_name'])) {
				$file_name = $_POST['id_bloqueo'] .'-'. str_replace(" ", "-", $_FILES['img']['name']);
				$url_img = $_SERVER['DOCUMENT_ROOT'] .'/medios/bodas/';
				$file_url = $url_img . $file_name;
				$response = array();
				if(move_uploaded_file($_FILES['img']['tmp_name'], $file_url)) {
					$response["upload"] = true;
					// /public_html/sur4demo/protected/extensions/bootstrap/gii/bootstrap/tcpdf/examples/images
					$path_tcpdf = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->baseUrl ."/protected/extensions/bootstrap/gii/bootstrap/tcpdf/examples/images/". str_replace(' ', '-', $file_name);
					if(copy($file_url, $path_tcpdf)) {
						$response["copy"] = true;
						$response["success"] = true;
					}
				}
			}
		}
		echo CJSON::encode($response);
	}

	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/
}