<?php

/**
 * This is the model class for table "{{tour_tarifa_fechas}}".
 *
 * The followings are the available columns in table '{{tour_tarifa_fechas}}':
 * @property integer $id_tarifa_fecha
 * @property string $fecha_ini
 * @property string $fecha_fin
 * @property string $Tour_nombre
 * @property string $Tour_descripcion
 * @property string Tour_destino
 * @property integer $id_tarifa
 *
 * The followings are the available model relations:
 * @property TourTarifa $idTarifa
 */
class TourTarifaFechas extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TourTarifaFechas the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tour_tarifa_fechas}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fecha_ini, fecha_fin, id_tarifa', 'required'),
			array('id_tarifa, id_tour', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_tarifa_fecha, fecha_ini, fecha_fin, id_tarifa, id_tour, Tour_destino, Tour_nombre, Tour_descripcion', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTarifa' => array(self::BELONGS_TO, 'TourTarifa', 'id_tarifa'),
			'idTour' => array(self::BELONGS_TO, 'Tour', 'id_tour'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_tarifa_fecha' => 'Id Tarifa Fecha',
			'fecha_ini' => 'Fecha Ini',
			'fecha_fin' => 'Fecha Fin',
			'id_tarifa' => 'Id Tarifa',

		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;
		$criteria->with = array( 'idTour' );
		$criteria->compare('id_tarifa_fecha',$this->id_tarifa_fecha);
		$criteria->compare('fecha_ini',$this->fecha_ini,true);
		$criteria->compare('fecha_fin',$this->fecha_fin,true);
		$criteria->compare('id_tarifa',$this->id_tarifa);
		$criteria->compare('id_tour',$this->id_tour);
		$criteria->compare('idTour.nombre', $this->Tour_nombre,true);
		$criteria->compare('idTour.descripcion_corta', $this->Tour_descripcion,true);
		$criteria->compare('idTour.id_destino', $this->Tour_destino,true);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}