<?php



/**

 * This is the model class for table "{{tour_reservacion}}".

 *

 * The followings are the available columns in table '{{tour_reservacion}}':

 * @property integer $id_tourReservacion

 * @property integer $id_tour

 * @property string $fecha_inicio

 * @property string $fecha_fin

 * @property string $importe

 * @property integer $estatus

 * @property integer $id_agencia

 * @property integer $id_usuario

 * @property integer $id_agente

 * @property string $fecha_reserva

 * @property string $log

 * @property integer $comision

 * @property string $fecha_limite

 * @property integer $liberado

 * @property string $cliente_nombre

 * @property string $cliente_apellido

 * @property string $cliente_tel

 * @property integer $adultos

 * @property integer $menores

 * @property integer $id_tarifa

 * @property string $cancelacion_fecha

 * @property string $cancelacion_motivo

 * @property string $observaciones

 * @property integer $manual

 *

 * The followings are the available model relations:

 * @property Tour $idTour

 * @property Agencias $idAgencia

 * @property Usuarios $idUsuario

 * @property TourTarifa $idTarifa

 */

class TourReservacion extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return TourReservacion the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{tour_reservacion}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('id_tour, fecha_inicio, importe, id_agencia, id_usuario, id_agente, fecha_reserva, comision, fecha_limite, cliente_nombre,cliente_apellido, adultos, menores', 'required'),

			array('id_tour, id_agencia, id_usuario, id_agente, libera_cupon, adultos, menores, id_tarifa, manual', 'numerical', 'integerOnly'=>true),
			array(' comision, importe', 'numerical'),

			array(' descuento', 'length', 'max'=>12),
			array('cliente_nombre, cliente_apellido', 'length', 'max'=>100),
			array('estatus', 'length', 'max'=>2),

			array('cliente_tel', 'length', 'max'=>20),

			array('cancelacion_motivo', 'length', 'max'=>255),

			array('fecha_fin, cancelacion_fecha', 'safe'),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_tourReservacion, id_tour, descuento, fecha_inicio, fecha_fin, importe, estatus, id_agencia, id_usuario, id_agente, fecha_reserva, log, comision, fecha_limite, liberado, cliente_nombre, cliente_apellido, cliente_tel, adultos, menores, id_tarifa, cancelacion_fecha, cancelacion_motivo, observaciones, manual', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'idTour' => array(self::BELONGS_TO, 'Tour', 'id_tour'),

			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),

			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),

			'idAgente' => array(self::BELONGS_TO, 'Usuarios', 'id_agente'),

			'idTarifa' => array(self::BELONGS_TO, 'TourTarifa', 'id_tarifa'),

			'idDesglosePersona' => array(self::HAS_MANY, 'TourReservacionDesglosePersona', 'id_reservacion'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_tourReservacion' => 'Id Tour Reservacion',

			'id_tour' => 'Id Tour',

			'fecha_inicio' => 'Fecha Inicio',

			'fecha_fin' => 'Fecha Fin',

			'importe' => 'Importe',

			'estatus' => 'Estatus',

			'id_agencia' => 'Id Agencia',

			'id_usuario' => 'Id Usuario',

			'id_agente' => 'Id Agente',

			'fecha_reserva' => 'Fecha Reserva',

			'log' => 'Log',

			'comision' => 'Comision',

			'fecha_limite' => 'Fecha Limite',

			'liberado' => 'Liberado',

			'cliente_nombre' => 'Cliente Nombre',

			'cliente_apellido' => 'Cliente Apellido',

			'cliente_tel' => 'Cliente Tel',

			'adultos' => 'Adultos',

			'menores' => 'Menores',

			'id_tarifa' => 'Id Tarifa',

			'cancelacion_fecha' => 'Cancelacion Fecha',

			'cancelacion_motivo' => 'Cancelacion Motivo',

			'observaciones' => 'Observaciones',

			'manual' => 'Tipo',

			'descuento' => 'Descuento'

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_tourReservacion',$this->id_tourReservacion);

		$criteria->compare('id_tour',$this->id_tour);

		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);

		$criteria->compare('fecha_fin',$this->fecha_fin,true);

		$criteria->compare('importe',$this->importe,true);

		$criteria->compare('estatus',$this->estatus);

		$criteria->compare('id_agencia',$this->id_agencia);

		$criteria->compare('id_usuario',$this->id_usuario);

		$criteria->compare('id_agente',$this->id_agente);

		$criteria->compare('fecha_reserva',$this->fecha_reserva,true);

		$criteria->compare('log',$this->log,true);

		$criteria->compare('comision',$this->comision);

		$criteria->compare('fecha_limite',$this->fecha_limite,true);

		$criteria->compare('liberado',$this->liberado);

		$criteria->compare('cliente_nombre',$this->cliente_nombre,true);

		$criteria->compare('cliente_apellido',$this->cliente_nombre,true);

		$criteria->compare('cliente_tel',$this->cliente_tel,true);

		$criteria->compare('adultos',$this->adultos);

		$criteria->compare('menores',$this->menores);

		$criteria->compare('id_tarifa',$this->id_tarifa);

		$criteria->compare('cancelacion_fecha',$this->cancelacion_fecha,true);

		$criteria->compare('cancelacion_motivo',$this->cancelacion_motivo,true);

		$criteria->compare('observaciones',$this->observaciones,true);

		$criteria->compare('manual',$this->manual,true);
		
		$criteria->compare('descuento',$this->descuento,true);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}