<?php



/**

 * This is the model class for table "{{tour_fotos}}".

 *

 * The followings are the available columns in table '{{tour_fotos}}':

 * @property integer $id_tour_foto

 * @property string $imagen

 * @property integer $id_tour

 * @property integer $principal

 * @property string $caption

 */

class TourFotos extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return TourFotos the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{tour_fotos}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('imagen, id_tour, principal', 'required'),

			array('id_tour, principal', 'numerical', 'integerOnly'=>true),

			array('imagen, caption', 'length', 'max'=>150),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_tour_foto, imagen, id_tour, principal, caption', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_tour_foto' => 'Id Tour Foto',

			'imagen' => 'Imagen',

			'id_tour' => 'Id Tour',

			'principal' => 'Principal',

			'caption' => 'Caption',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_tour_foto',$this->id_tour_foto);

		$criteria->compare('imagen',$this->imagen,true);

		$criteria->compare('id_tour',$this->id_tour);

		$criteria->compare('principal',$this->principal);

		$criteria->compare('caption',$this->caption,true);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}