<?php



/**

 * This is the model class for table "{{tipo_categoria}}".

 *

 * The followings are the available columns in table '{{tipo_categoria}}':

 * @property integer $idTipoCategoria

 * @property string $nombre

 * @property string $nombre_en

 * @property string $imagen

 * @property string $imagen_en

 * @property string $descripcion

 * @property string $descripcion_en

 * @property integer $depende_de

 * @property integer $estatus

 */

class TipoCategoria extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return TipoCategoria the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{tipo_categoria}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('nombre', 'required'),

			array('depende_de, estatus', 'numerical', 'integerOnly'=>true),

			array('nombre, nombre_en', 'length', 'max'=>255),

			array('imagen, imagen_en', 'length', 'max'=>100),

			array('descripcion, descripcion_en', 'safe'),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('idTipoCategoria, nombre, nombre_en, imagen, imagen_en, descripcion, descripcion_en, depende_de, estatus', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'tours' => array(self::HAS_MANY, 'Tour', 'id_destino', 'joinType'=>'INNER JOIN'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'idTipoCategoria' => 'Categoria',

			'nombre' => 'Nombre',

			'nombre_en' => 'Nombre en Ingles',

			'imagen' => 'Imagen',

			'imagen_en' => 'Imagen En',

			'descripcion' => 'Descripcion',

			'descripcion_en' => 'Descripcion En',

			'depende_de' => 'Depende De',

			'estatus' => 'Estatus',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('idTipoCategoria',$this->idTipoCategoria);

		$criteria->compare('nombre',$this->nombre,true);

		$criteria->compare('nombre_en',$this->nombre_en,true);

		$criteria->compare('imagen',$this->imagen,true);

		$criteria->compare('imagen_en',$this->imagen_en,true);

		$criteria->compare('descripcion',$this->descripcion,true);

		$criteria->compare('descripcion_en',$this->descripcion_en,true);

		$criteria->compare('depende_de',$this->depende_de);

		$criteria->compare('estatus',$this->estatus);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}