<?php

/**
 * This is the model class for table "{{sucursales_agente}}".
 *
 * The followings are the available columns in table '{{sucursales_agente}}':
 * @property integer $id_suc_agente
 * @property string $id_sucursal
 * @property integer $id_user
 *
 * The followings are the available model relations:
 * @property Users $idUser
 * @property Sucursales $idSucursal
 */
class SucursalesAgente extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SucursalesAgente the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{sucursales_agente}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_sucursal, id_user', 'required'),
			array('id_user', 'numerical', 'integerOnly'=>true),
			array('id_sucursal', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_suc_agente, id_sucursal, id_user', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
			'idUsuario'=> array(self::BELONGS_TO, 'Usuarios', 'id_user'),
			'idSucursal' => array(self::BELONGS_TO, 'Sucursales', 'id_sucursal'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_suc_agente' => 'Id Suc Agente',
			'id_sucursal' => 'Id Sucursal',
			'id_user' => 'Id User',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_suc_agente',$this->id_suc_agente);
		$criteria->compare('id_sucursal',$this->id_sucursal,true);
		$criteria->compare('id_user',$this->id_user);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}